/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.OmniGridScreen;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class NumberTextBox
extends EditBox {
    OmniGridScreen screen;
    private boolean rightAligned = true;
    private Font font;

    public NumberTextBox(OmniGridScreen screen, Font font, int x, int y, int width, int height, Component message) {
        super(font, x, y, width, height, message);
        this.font = font;
        this.screen = screen;
        this.setFilter(s -> s.matches("-?\\d*"));
    }

    public int getNumber() {
        String text = this.getValue().trim();
        if (text.isEmpty() || text.equals("-")) {
            return -1;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setNumber(int number) {
        if (number == -1) {
            this.setValue("");
        } else {
            this.setValue(String.valueOf(number));
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        String text;
        if (!this.screen.isTransferPanel() || ((AbstractOmniGridContainerMenu)this.screen.getMenu()).tabPage != 0) {
            return;
        }
        if (this.screen.getCommand() != null && this.screen.isTransferPanel()) {
            Set<Integer> valid = Set.of(Integer.valueOf(8), Integer.valueOf(9));
            if (!valid.contains(this.screen.getCommand().getAction())) {
                return;
            }
            if (this.screen.getCommand().getAction() == 8 && this.screen.getCommand().getTargetConfig() != 5) {
                return;
            }
        }
        if (this.isBordered()) {
            ResourceLocation sprite = ResourceLocation.withDefaultNamespace((String)"widget/text_field");
            graphics.blitSprite(sprite, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (!(text = this.getValue()).isEmpty()) {
            int textWidth = this.font.width(text);
            int x = this.getX() + this.getWidth() - 4 - textWidth;
            int y = this.getY() + (this.getHeight() - 8) / 2;
            graphics.drawString(this.font, text, x, y, 0xFFFFFF, false);
        }
        if (this.isFocused()) {
            int caretX = this.getX() + this.getWidth() - 4;
            graphics.fill(RenderType.guiOverlay(), caretX, this.getY() + 2, caretX + 1, this.getY() + this.getHeight() - 2, -1);
        }
    }

    public void setFocused(boolean focused) {
        boolean wasFocused = this.isFocused();
        super.setFocused(focused);
        if (wasFocused && !focused && this.screen != null) {
            this.screen.updateCommandSlot();
        }
    }

    @Nullable
    public Tooltip getTooltip() {
        if (!this.screen.isTransferPanel() || ((AbstractOmniGridContainerMenu)this.screen.getMenu()).tabPage != 0) {
            return null;
        }
        if (this.screen.getCommand() != null) {
            if (this.screen.getCommand().getAction() == 9) {
                return Tooltip.create((Component)Component.literal((String)"Regulate Target").append((Component)Component.literal((String)"\nSet number or scroll to change").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\nShift: \u00d710").withStyle(ChatFormatting.DARK_GRAY)));
            }
            if (this.screen.getCommand().getAction() == 8 && this.screen.getCommand().getTargetConfig() == 5) {
                return Tooltip.create((Component)Component.literal((String)"Stop autocrafting once this many of the item are in storage. Leave blank to ignore").append((Component)Component.literal((String)"\nSet number or scroll to change").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\nShift: \u00d710").withStyle(ChatFormatting.DARK_GRAY)));
            }
        }
        return null;
    }
}

