/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.google.common.util.concurrent.RateLimiter;
import com.omnigrid.Regulator.OmniRegulator;
import com.omnigrid.StorageProxy.DispenserSyncPacket;
import com.omnigrid.StorageProxy.OmniDispenser;
import com.omnigrid.StorageProxy.OmniPort;
import com.omnigrid.StorageProxy.OmniPortContainerMenu;
import com.omnigrid.StorageProxy.OmniProxyBlockItem;
import com.omnigrid.StorageProxy.OmniProxyRemoteItem;
import com.omnigrid.StorageProxy.OmniStorageProxyBlockEntity;
import com.omnigrid.StorageProxy.ResourceChestBlockEntity;
import com.omnigrid.StorageProxy.ResourceChestContainerMenu;
import com.omnigrid.StorageProxy.ResourceFilterContainerMenu;
import com.omnigrid.StorageProxy.ToolTippedSimpleItem;
import com.omnigrid.Utils.CoreCartridgeRecipeSerializer;
import com.omnigrid.Utils.CurioStats;
import com.omnigrid.Utils.CurioStatsPacket;
import com.omnigrid.Utils.LootBundleItem;
import com.omnigrid.Utils.ModUtil;
import com.omnigrid.Utils.OmniBackupKey;
import com.omnigrid.Utils.OmniOverclockerItem;
import com.omnigrid.Utils.OmniOverclockerPlusItem;
import com.omnigrid.Utils.OmniProxyDisk;
import com.omnigrid.Utils.OmniUtilityItem;
import com.omnigrid.Utils.OmniVoider;
import com.omnigrid.Utils.PresetItem;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.Utils.UtilityBundle;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.Utils.VirtualContainerUtil;
import com.omnigrid.customRender.OmniClientBlockPacket;
import com.omnigrid.neoforge.AbstractModInitializer;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.AutocraftingInfoPacket;
import com.omnigrid.neoforge.BlockEntities;
import com.omnigrid.neoforge.BlockEntityProvider;
import com.omnigrid.neoforge.BlockEntityProviders;
import com.omnigrid.neoforge.BlockEntityTypeFactory;
import com.omnigrid.neoforge.Blocks;
import com.omnigrid.neoforge.ClearTargetData;
import com.omnigrid.neoforge.ClientModInitializer;
import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.ConfigImpl;
import com.omnigrid.neoforge.ContentIds;
import com.omnigrid.neoforge.CoreItem;
import com.omnigrid.neoforge.CoreStatePacket;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.CraftingGridBalancePacket;
import com.omnigrid.neoforge.CraftingGridClearPacket;
import com.omnigrid.neoforge.CraftingGridRecipeTransferPacket;
import com.omnigrid.neoforge.CraftingGridSpreadPacket;
import com.omnigrid.neoforge.CreativeModeTabItems;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.DisableCommandPacket;
import com.omnigrid.neoforge.EnergyUpgrade;
import com.omnigrid.neoforge.InteractionUtils;
import com.omnigrid.neoforge.ItemTransferPacket;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.Menus;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniEffectPacket;
import com.omnigrid.neoforge.OmniGridBlock;
import com.omnigrid.neoforge.OmniGridBlockContainerMenu;
import com.omnigrid.neoforge.OmniGridBlockEntity;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridItemContainerMenu;
import com.omnigrid.neoforge.OmniGridMenuData;
import com.omnigrid.neoforge.OmniGridRecipeSerializer;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.PickBlockRequest;
import com.omnigrid.neoforge.Platform;
import com.omnigrid.neoforge.RequestOmniDataSync;
import com.omnigrid.neoforge.StopServerMenuPacket;
import com.omnigrid.neoforge.SyncTabPacket;
import com.omnigrid.neoforge.UpdateCommand;
import com.omnigrid.neoforge.UpdateCommandData;
import com.omnigrid.neoforge.UpdateCrafterPatternsPacket;
import com.omnigrid.neoforge.UpdateFurnace;
import com.omnigrid.neoforge.UpdateTracker;
import com.omnigrid.neoforge.UpdateUpgrades;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.DirectRegistryCallback;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.SimpleItem;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import com.refinedmods.refinedstorage.neoforge.support.energy.EnergyStorageAdapter;
import com.refinedmods.refinedstorage.neoforge.support.resource.ResourceContainerFluidHandlerAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;

@Mod(value="omnigrid")
public class ModInitializer
extends AbstractModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModInitializer.class);
    private final DeferredRegister<Item> itemRegistry = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"omnigrid");
    private final DeferredRegister<MenuType<?>> menuTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"omnigrid");
    private final DeferredRegister<Block> blockRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"omnigrid");
    private final DeferredRegister<RecipeSerializer<?>> recipeSerializerRegistry = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"omnigrid");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"omnigrid");
    public static final DeferredHolder<Attribute, Attribute> HEALTH_REGEN = ATTRIBUTES.register("health_regen", () -> new RangedAttribute("attribute.omnigrid.health_regen", 0.0, 0.0, 1024.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> ORE_LUCK = ATTRIBUTES.register("ore_luck", () -> new RangedAttribute("attribute.omnigrid.ore_luck", 0.0, 0.0, 1024.0).setSyncable(true));
    private final RateLimiter rateLimiter = RateLimiter.create((double)0.4);
    private final DeferredRegister<BlockEntityType<?>> blockEntityTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"omnigrid");
    private static final Map<Item, ChatFormatting> DYE_COLORS = Map.ofEntries(Map.entry(net.minecraft.world.item.Items.WHITE_DYE, ChatFormatting.WHITE), Map.entry(net.minecraft.world.item.Items.LIGHT_GRAY_DYE, ChatFormatting.GRAY), Map.entry(net.minecraft.world.item.Items.GRAY_DYE, ChatFormatting.DARK_GRAY), Map.entry(net.minecraft.world.item.Items.BLACK_DYE, ChatFormatting.BLACK), Map.entry(net.minecraft.world.item.Items.RED_DYE, ChatFormatting.RED), Map.entry(net.minecraft.world.item.Items.ORANGE_DYE, ChatFormatting.GOLD), Map.entry(net.minecraft.world.item.Items.YELLOW_DYE, ChatFormatting.YELLOW), Map.entry(net.minecraft.world.item.Items.BROWN_DYE, ChatFormatting.DARK_RED), Map.entry(net.minecraft.world.item.Items.LIME_DYE, ChatFormatting.GREEN), Map.entry(net.minecraft.world.item.Items.GREEN_DYE, ChatFormatting.DARK_GREEN), Map.entry(net.minecraft.world.item.Items.LIGHT_BLUE_DYE, ChatFormatting.AQUA), Map.entry(net.minecraft.world.item.Items.CYAN_DYE, ChatFormatting.DARK_AQUA), Map.entry(net.minecraft.world.item.Items.BLUE_DYE, ChatFormatting.BLUE), Map.entry(net.minecraft.world.item.Items.PURPLE_DYE, ChatFormatting.DARK_PURPLE), Map.entry(net.minecraft.world.item.Items.MAGENTA_DYE, ChatFormatting.LIGHT_PURPLE), Map.entry(net.minecraft.world.item.Items.PINK_DYE, ChatFormatting.LIGHT_PURPLE));
    private final DeferredRegister<DataComponentType<?>> dataComponentTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"omnigrid");
    private static final BlockEntityProviders BLOCK_ENTITY_PROVIDERS = new BlockEntityProviders(OmniGridBlockEntity::createNormal, OmniStorageProxyBlockEntity::createNormal, OmniPort::createNormal, OmniDispenser::create, ResourceChestBlockEntity::new);
    private static int TICK_COUNTER = 0;
    private static final TagKey<Block> ORES_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"ores"));
    private static final Map<Integer, List<Runnable>> delayedTasks = new HashMap<Integer, List<Runnable>>();
    private static int currentTick = 0;
    private static final List<Scheduled> TASKS = new ArrayList<Scheduled>();

    public ModInitializer(IEventBus eventBus, ModContainer modContainer) {
        ConfigImpl config = new ConfigImpl();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getSpec());
        Platform.setConfigProvider(() -> config);
        NeoForge.EVENT_BUS.addListener(this::onLeftClickBlock);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.addListener(ClientModInitializer::onRegisterMenuScreens);
            eventBus.addListener(ClientModInitializer::onRegisterKeyMappings);
            eventBus.addListener(ClientModInitializer::onRegisterCustomModels);
            eventBus.addListener(ClientModInitializer::registerLoaders);
            eventBus.addListener(ClientModInitializer::onClientSetup);
            eventBus.addListener(ClientModInitializer::onRegisterClientExtensions);
            NeoForge.EVENT_BUS.addListener(ClientModInitializer::onRenderWorld);
            NeoForge.EVENT_BUS.addListener(ClientModInitializer::onScreenOpening);
            NeoForge.EVENT_BUS.addListener(ClientModInitializer::onRenderHud);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientModInitializer::registerTooltipExtensions);
            NeoForge.EVENT_BUS.addListener(ClientModInitializer::onMouseInput);
            NeoForge.EVENT_BUS.addListener(ClientModInitializer::onKeyInput);
            NeoForge.EVENT_BUS.addListener(ClientModInitializer::onClientTick);
        }
        if (ModList.get().isLoaded("curios")) {
            NeoForge.EVENT_BUS.addListener(this::onCurioAttributes);
            NeoForge.EVENT_BUS.addListener(this::onBlockBreakWithCurios);
            eventBus.addListener(this::onEntityAttributeModify);
            ATTRIBUTES.register(eventBus);
        }
        NeoForge.EVENT_BUS.addListener(this::onPlayerLogout);
        NeoForge.EVENT_BUS.addListener(this::onServerStarted);
        this.registerContent(eventBus);
        this.registerRecipeSerializers(eventBus);
        NeoForge.EVENT_BUS.addListener(ModInitializer::onAnvilUpdate);
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
        eventBus.addListener(this::onRegister);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::registerCreativeModeTabListener);
        NeoForge.EVENT_BUS.addListener(this::onServerStopping);
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        NeoForge.EVENT_BUS.addListener(this::onCrafted);
        NeoForge.EVENT_BUS.addListener(this::onBlockBreak);
        NeoForge.EVENT_BUS.addListener(this::onMobDrops);
        NeoForge.EVENT_BUS.addListener(this::onItemSpawn);
        NeoForge.EVENT_BUS.addListener(this::onExplosionDetonate);
        eventBus.addListener(this::registerPackets);
    }

    @SubscribeEvent
    public void onEntityAttributeModify(EntityAttributeModificationEvent event) {
        if (event.getTypes().contains(EntityType.PLAYER)) {
            event.add(EntityType.PLAYER, ORE_LUCK);
            event.add(EntityType.PLAYER, HEALTH_REGEN);
        }
    }

    private void registerContent(IEventBus eventBus) {
        this.registerBlocks(eventBus);
        this.registerItems(eventBus);
        this.registerBlockEntities(eventBus);
        this.registerMenus(eventBus);
        this.registerDataComponents(eventBus);
    }

    private void registerRecipeSerializers(IEventBus eventBus) {
        this.registerRecipeSerializers(new ForgeRegistryCallback(this.recipeSerializerRegistry));
        this.recipeSerializerRegistry.register(eventBus);
    }

    protected final void registerRecipeSerializers(RegistryCallback<RecipeSerializer<?>> callback) {
        callback.register(ModUtil.OmniIdentifier("omni_grid_assemble"), OmniGridRecipeSerializer::new);
        callback.register(ModUtil.OmniIdentifier("core_cartridge_assemble"), CoreCartridgeRecipeSerializer::new);
    }

    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack crafted = event.getCrafting();
        Player player = event.getEntity();
        if (crafted.getItem() instanceof OmniGridBlockItem) {
            for (int i = 0; i < event.getInventory().getContainerSize(); ++i) {
                ItemStack item = event.getInventory().getItem(i);
                if (!(item.getItem() instanceof OmniGridBlockItem)) continue;
                crafted.set(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference(), (Object)((UUID)item.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference())));
                crafted.set(net.minecraft.core.component.DataComponents.CUSTOM_NAME, (Object)((Component)item.get(net.minecraft.core.component.DataComponents.CUSTOM_NAME)));
                crafted.set(net.minecraft.core.component.DataComponents.BLOCK_ENTITY_DATA, (Object)((CustomData)item.get(net.minecraft.core.component.DataComponents.BLOCK_ENTITY_DATA)));
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        VirtualContainerUtil.disabledSaving = false;
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        ServerLevel level = event.getServer().overworld();
        for (OmniItemProxxy prox : OmniGridBlockItem.GLOBAL_STORAGES.values()) {
            ModInitializer.SaveProxxyInfo(prox.uuid, (Level)level);
        }
        VirtualContainerUtil.disabledSaving = true;
    }

    @Nullable
    public static AbstractOmniGridBlockEntity<?> validateRemote(OmniItemProxxy proxy, Player player) {
        if (proxy == null || !(player instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        MinecraftServer server = serverPlayer.getServer();
        if (server == null) {
            return null;
        }
        ServerLevel targetLevel = server.getLevel(proxy.levelKey);
        if (targetLevel == null) {
            return null;
        }
        BlockEntity be = targetLevel.getBlockEntity(proxy.blockPos);
        if (!(be instanceof AbstractOmniGridBlockEntity)) {
            return null;
        }
        AbstractOmniGridBlockEntity grid = (AbstractOmniGridBlockEntity)be;
        if (proxy.utilityTypes.contains((Object)UtilityType.PROXY_ACCESSOR)) {
            return grid;
        }
        if (player.level() != targetLevel) {
            return null;
        }
        int baseRange = Platform.getConfig().getOmniGrid().getProxyBaseRange();
        int bonusRange = Platform.getConfig().getOmniGrid().getProxyExtraRangePerUpgrade() * proxy.getRange();
        int maxRange = baseRange + bonusRange;
        double maxDistanceSq = (double)maxRange * (double)maxRange;
        double playerDistanceSq = player.distanceToSqr((double)proxy.blockPos.getX() + 0.5, (double)proxy.blockPos.getY() + 0.5, (double)proxy.blockPos.getZ() + 0.5);
        if (playerDistanceSq > maxDistanceSq) {
            return null;
        }
        return grid;
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        int i;
        if (event.getLevel().isClientSide) {
            return;
        }
        Player player = event.getEntity();
        if (!player.isShiftKeyDown()) {
            return;
        }
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockState state = event.getLevel().getBlockState(pos);
        if (!InteractionUtils.canInteractWithBlock(player, player.level(), pos, face)) {
            return;
        }
        ItemStack serverHeld = player.getInventory().getSelected();
        if (!(serverHeld.getItem() instanceof OmniGridBlockItem || serverHeld.getItem() instanceof OmniProxyRemoteItem || serverHeld.getItem() instanceof UtilityBundle)) {
            return;
        }
        event.setCanceled(true);
        BlockEntity be = event.getLevel().getBlockEntity(pos);
        if (be == null) {
            return;
        }
        ItemStack held = serverHeld;
        if (held.getItem() instanceof UtilityBundle) {
            DataComponentType<OmniBlockTarget> comp = DataComponents.INSTANCE.getLink();
            OmniBlockTarget existing = (OmniBlockTarget)held.get(comp);
            OmniBlockTarget clicked = new OmniBlockTarget(state.getBlock().asItem(), pos, face);
            if (existing != null) {
                boolean sameFace;
                boolean samePos = existing.getPosition().equals((Object)pos);
                boolean bl = sameFace = existing.getDirection() == face;
                if (samePos && sameFace) {
                    held.remove(comp);
                    player.displayClientMessage((Component)Component.literal((String)"Removed stored block target.").withStyle(ChatFormatting.YELLOW), true);
                } else {
                    held.set(comp, (Object)clicked);
                    player.displayClientMessage((Component)Component.literal((String)("Replaced stored target: " + pos.toShortString())).withStyle(ChatFormatting.GREEN), true);
                }
            } else {
                held.set(comp, (Object)clicked);
                player.displayClientMessage((Component)Component.literal((String)("Stored block target: " + pos.toShortString())).withStyle(ChatFormatting.GREEN), true);
            }
            event.setCanceled(true);
            return;
        }
        OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(serverHeld.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()));
        AbstractOmniGridBlockEntity<?> abs = null;
        if (serverHeld.getItem() instanceof OmniProxyRemoteItem && (abs = ModInitializer.validateRemote(proxxy, player)) == null) {
            player.displayClientMessage((Component)Component.literal((String)"Omni Grid out of range!").withStyle(ChatFormatting.RED), true);
            return;
        }
        OmniCommandData data = proxxy.getCachedData();
        if (data == null) {
            return;
        }
        int max = 8;
        if (proxxy.utilityTypes.contains((Object)UtilityType.REMOTE_BOOSTER)) {
            max = 12;
        }
        if (!this.rateLimiter.tryAcquire()) {
            return;
        }
        if (!data.isCoreInstalled(CoreTypes.REMOTE)) {
            player.displayClientMessage((Component)Component.literal((String)"Missing Omni Remote Core!").withStyle(ChatFormatting.RED), true);
            return;
        }
        for (i = 0; i < max; ++i) {
            OmniBlockTarget existing = data.blockTargets[i];
            if (existing == null || !existing.getPosition().equals((Object)pos) || existing.getDirection() != face) continue;
            data.blockTargets[i] = null;
            player.displayClientMessage((Component)Component.literal((String)("Removed block target [" + String.valueOf(pos) + " " + String.valueOf(face) + "]")).withStyle(ChatFormatting.YELLOW), false);
            UUID uuid = (UUID)serverHeld.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference());
            if (serverHeld.getItem() instanceof OmniProxyRemoteItem) {
                if (abs != null) {
                    com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient((ServerPlayer)player, (CustomPacketPayload)new OmniClientBlockPacket(proxxy.uuid, proxxy.getCachedData().blockTargets));
                    abs.updateOmniController(data);
                    abs.markDataDirty();
                }
            } else {
                com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient((ServerPlayer)player, (CustomPacketPayload)new OmniClientBlockPacket(uuid, data.blockTargets));
                VirtualContainerUtil.saveOmniDataToVirtual(data, serverHeld, event.getLevel());
                player.getInventory().setItem(player.getInventory().selected, serverHeld);
                ModInitializer.syncHeldSlotNow((ServerPlayer)player);
            }
            event.setCanceled(true);
            return;
        }
        for (i = 0; i < max; ++i) {
            if (data.blockTargets[i] != null) continue;
            data.blockTargets[i] = new OmniBlockTarget(state.getBlock().asItem(), pos, face);
            player.displayClientMessage((Component)Component.literal((String)("Added " + state.getBlock().asItem().getName(serverHeld).getString() + " at " + String.valueOf(pos) + " " + String.valueOf(face) + " to block target slot " + (i + 1))).withStyle(ChatFormatting.GREEN), false);
            UUID uuid = (UUID)serverHeld.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference());
            if (serverHeld.getItem() instanceof OmniProxyRemoteItem) {
                if (abs != null) {
                    com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient((ServerPlayer)player, (CustomPacketPayload)new OmniClientBlockPacket(proxxy.uuid, proxxy.getCachedData().blockTargets));
                    abs.updateOmniController(data);
                    abs.markDataDirty();
                }
                return;
            }
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient((ServerPlayer)player, (CustomPacketPayload)new OmniClientBlockPacket(uuid, data.blockTargets));
            VirtualContainerUtil.saveOmniDataToVirtual(data, serverHeld, event.getLevel());
            player.getInventory().setItem(player.getInventory().selected, serverHeld);
            player.getInventory().setChanged();
            player.inventoryMenu.broadcastChanges();
            ModInitializer.syncHeldSlotNow((ServerPlayer)player);
            proxxy.setDirty(true);
            event.setCanceled(true);
            return;
        }
        player.displayClientMessage((Component)Component.literal((String)"No empty block target slots available!").withStyle(ChatFormatting.RED), false);
    }

    private static void syncHeldSlotNow(ServerPlayer sp) {
        int containerId = sp.inventoryMenu.containerId;
        int stateId = sp.inventoryMenu.getStateId();
        int slotInContainer = sp.getInventory().selected + 36;
        ItemStack held = sp.getMainHandItem();
        sp.connection.send((Packet)new ClientboundContainerSetSlotPacket(containerId, stateId, slotInContainer, held));
    }

    public static int toNumber(Direction dir) {
        return dir.get3DDataValue();
    }

    public static boolean isPatchouliInstalled() {
        return ModList.get().isLoaded("patchouli");
    }

    private void registerItems(IEventBus eventBus) {
        ForgeRegistryCallback<Item> callback = new ForgeRegistryCallback<Item>(this.itemRegistry);
        this.registerCustomItems(callback);
        this.itemRegistry.register(eventBus);
    }

    private void registerCustomItems(RegistryCallback<Item> callback) {
        Items.INSTANCE.setOmniGrid(callback.register(ContentIds.omni_grid, () -> new OmniGridBlockItem(this, (Block)Blocks.INSTANCE.getOmniGridBlock()){}));
        Items.INSTANCE.setOmniProxyBlock(callback.register(ModUtil.OmniIdentifier("omni_storage_proxy"), () -> new OmniProxyBlockItem((Block)Blocks.INSTANCE.getStorageProxyBlock(), new Item.Properties(), BlockEntities.INSTANCE::getOmniProxxy, (Component)Component.literal((String)"Grants a RS2 network access to an Omni Grids storage. Right-click this with an Omni Grid to link."))));
        Items.INSTANCE.setProxyController(callback.register(ModUtil.OmniIdentifier("omni_controller_proxy"), () -> new OmniProxyBlockItem((Block)Blocks.INSTANCE.getStorageProxyController(), new Item.Properties(), BlockEntities.INSTANCE::getOmniProxxy, (Component)Component.literal((String)"Creates a RS2 network with access to an Omni Grids storage. Energy is drained from linked Omni Grid. Right-click this with an Omni Grid to link."))));
        Items.INSTANCE.setProxyDepositItem(callback.register(ModUtil.OmniIdentifier("omni_deposit_proxy"), () -> new OmniProxyBlockItem((Block)Blocks.INSTANCE.getProxyDepositBlock(), new Item.Properties(), BlockEntities.INSTANCE::getProxyDeposit, (Component)Component.literal((String)"Items and fluids inserted into this are deposited into the linked Omni Grid. Right-click this with an Omni Grid to link."))));
        Items.INSTANCE.setOmniPort(callback.register(ModUtil.OmniIdentifier("omni_port_proxy"), () -> new OmniProxyBlockItem((Block)Blocks.INSTANCE.getOmniPort(), new Item.Properties(), BlockEntities.INSTANCE::getOmniPort, (Component)Component.literal((String)"Configured items and fluid can be extracted from the linked Omni Grid. Right-click this with an Omni Grid to link."))));
        Items.INSTANCE.setOmniPortAdvanced(callback.register(ModUtil.OmniIdentifier("omni_port_proxy_advanced"), () -> new OmniProxyBlockItem((Block)Blocks.INSTANCE.getOmniPortAdvanced(), new Item.Properties(), BlockEntities.INSTANCE::getOmniPort, (Component)Component.literal((String)"An upgraded Omni Port variant that can be configured independently on each side."))));
        Items.INSTANCE.setOmniHub(callback.register(ModUtil.OmniIdentifier("omni_hub_proxy"), () -> new OmniProxyBlockItem((Block)Blocks.INSTANCE.getOmniHub(), new Item.Properties(), BlockEntities.INSTANCE::getOmniPort, (Component)Component.literal((String)"Combines the functions of an Omni Port and Omni Deposit"))));
        Items.INSTANCE.setOmniHubAdvanced(callback.register(ModUtil.OmniIdentifier("omni_hub_proxy_advanced"), () -> new OmniProxyBlockItem((Block)Blocks.INSTANCE.getOmniHubAdvanced(), new Item.Properties(), BlockEntities.INSTANCE::getOmniPort, (Component)Component.literal((String)"Combines the functions of an Advanced Omni Port and Omni Deposit"))));
        Items.INSTANCE.setFakeOmniGrid(callback.register(ModUtil.OmniIdentifier("fake_omni_grid"), SimpleItem::new));
        Items.INSTANCE.setOmniRegulator(callback.register(ModUtil.OmniIdentifier("omni_regulator"), () -> new OmniRegulator(this, RefinedStorageApi.INSTANCE.getUpgradeRegistry()){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return false;
            }
        }));
        Items.INSTANCE.setOmniDeco(callback.register(ModUtil.OmniIdentifier("omni_decoration"), SimpleItem::new));
        Items.INSTANCE.setOmniEnergy(callback.register(ContentIds.OMNI_ENERGY_UPGRADE, EnergyUpgrade::new));
        Items.INSTANCE.setRawCommandProcessor(callback.register(ModUtil.OmniIdentifier("raw_command_processor"), SimpleItem::new));
        Items.INSTANCE.setCommandProcessor(callback.register(ModUtil.OmniIdentifier("command_processor"), SimpleItem::new));
        Items.INSTANCE.setPrecisionCore(callback.register(ModUtil.OmniIdentifier("precision_core"), SimpleItem::new));
        Items.INSTANCE.setOmniBackupCard(callback.register(ModUtil.OmniIdentifier("omni_backup_card"), OmniBackupKey::new));
        Items.INSTANCE.setRawAuxiliaryProcessor(callback.register(ModUtil.OmniIdentifier("raw_auxiliary_processor"), SimpleItem::new));
        Items.INSTANCE.setAuxiliaryProcessor(callback.register(ModUtil.OmniIdentifier("auxiliary_processor"), SimpleItem::new));
        Items.INSTANCE.setOmniOverclocker(callback.register(ModUtil.OmniIdentifier("omni_overclocker"), OmniOverclockerItem::new));
        Items.INSTANCE.setOmniOverclockerPlus(callback.register(ModUtil.OmniIdentifier("omni_overclocker_plus"), OmniOverclockerPlusItem::new));
        Items.INSTANCE.setOmniPresetItem(callback.register(ModUtil.OmniIdentifier("omni_preset"), PresetItem::new));
        Items.INSTANCE.setOmniProxyDisk(callback.register(ModUtil.OmniIdentifier("omni_proxy_disk"), OmniProxyDisk::new));
        Items.INSTANCE.setOmniProxyRemote(callback.register(ModUtil.OmniIdentifier("omni_proxy_remote"), OmniProxyRemoteItem::new));
        Items.INSTANCE.setOmniVoider(callback.register(ModUtil.OmniIdentifier("omni_void_core"), OmniVoider::new));
        Items.INSTANCE.setOmniProxy(callback.register(ModUtil.OmniIdentifier("omni_proxy"), () -> new ToolTippedSimpleItem((Component)Component.literal((String)"Crafting component for Omni Proxy blocks and items.\n\nOmni Proxys are used to grant automation and RS2 networks access to an Omni Grids storage remotely."))));
        Items.INSTANCE.setUtilityBundleTier1(callback.register(ModUtil.OmniIdentifier("core_cartridge_1"), () -> new UtilityBundle(3)));
        Items.INSTANCE.setUtilityBundleTier2(callback.register(ModUtil.OmniIdentifier("core_cartridge_2"), () -> new UtilityBundle(6)));
        Items.INSTANCE.setUtilityBundleTier3(callback.register(ModUtil.OmniIdentifier("core_cartridge_3"), () -> new UtilityBundle(10)));
        Items.INSTANCE.setUtilityBundleTier4(callback.register(ModUtil.OmniIdentifier("core_cartridge_4"), () -> new UtilityBundle(15)));
        Items.INSTANCE.setUtilityBundleTier5(callback.register(ModUtil.OmniIdentifier("core_cartridge_5"), () -> new UtilityBundle(30)));
        this.registerCoreItem(callback, CoreTypes.NONE, "precision_core_housing", "Omni Core Component", "Crafting component for specialized Omni Cores", Items.INSTANCE::setPrecisionCoreHousing);
        this.registerCoreItem(callback, CoreTypes.NONE, "command_core_housing", "Omni Core Component", "Crafting component for Command Omni Cores", Items.INSTANCE::setCommandCoreHousing);
        this.registerCoreItem(callback, CoreTypes.NONE, "operation_core_housing", "Omni Core Component", "Crafting component for Advanced Omni Cores", Items.INSTANCE::setOperationCoreHousing);
        this.registerCoreItem(callback, CoreTypes.REMOTE, "omni_remote_core", "Enables use of Remote Block Targets", "Allows you to shift left-click containers with the Omni Grid, adding an option to push/pull items remotely between the Omni Grid storage and the container. Chunk claim protected, cannot take from containers the user does not have permission to take from.", Items.INSTANCE::setOmniRemoteCore);
        this.registerCoreItem(callback, CoreTypes.PROVIDE, "omni_provide_core", "Enables use of the Provide Action", "While placed, allows automation to pull the configured item/fluid from the Omni Grid at the selected side.", Items.INSTANCE::setOmniProvideCore);
        this.registerCoreItem(callback, CoreTypes.DEPOSITING, "omni_deposit_core", "Allows automations to insert items/fluid", "While placed, other automation can insert/fluid into the Omni Grids storage directly.", Items.INSTANCE::setOmniInterfacerCore);
        this.registerCoreItem(callback, CoreTypes.DISK_DRIVE, "omni_disk_core", "Greatly improves Omni Grid storage capabilities", "Increases the maximum disk slots to 8 and can connect to RS2 networks while placed or via Omni Storage Proxy.", Items.INSTANCE::setOmniDiskDriveCore);
        this.registerCoreItem(callback, CoreTypes.INVERTED, "omni_inverted_core", "Enables inverting filter.", "Omni Grid command filters can now have filtering logic inverted, affecting resources that do not meet the criteria instead.", Items.INSTANCE::setInvertedCore);
        this.registerCoreItem(callback, CoreTypes.PUSH, "omni_push_core", "Enables use of the Push Action", "Moves items from the Omni Grid\u2019s storage to the target.", Items.INSTANCE::setOmniPushCore);
        this.registerCoreItem(callback, CoreTypes.NONE, "omni_utility_housing", "Crafting component for Omni Utility items and cores", "Utility items can be placed in an Omni Grids Utility slots to add useful effects. Additionally, utility cores can be bundled together in a Core Cartridge", Items.INSTANCE::setOmniUtilityShell);
        this.registerCoreItem(callback, CoreTypes.PULL, "omni_pull_core", "Enables use of the Pull Action", "Takes items from the target and places them in the Omni Grid\u2019s storage.", Items.INSTANCE::setOmniPullCore);
        this.registerCoreItem(callback, CoreTypes.LINK, "omni_link_core", "Enables use of link mode when using block targets", "When enabled, block targets can transfer between all connected blocks of the same type, rather than just the target block.", Items.INSTANCE::setLinkCore);
        this.registerCoreItem(callback, CoreTypes.COLLECT, "omni_collect_core", "Enables use of the Collect Action", "Picks up nearby dropped items automatically.", Items.INSTANCE::setOmniCollectCore);
        this.registerCoreItem(callback, CoreTypes.SEARCH, "omni_search_core", "Enables use of the Search Action", "Searches nearby containers for items and inserts them into storage. Chunk claim protected; cannot take from containers the user lacks permission for.", Items.INSTANCE::setOmniSearchCore);
        this.registerCoreItem(callback, CoreTypes.PLAYER, "omni_player_core", "Enables use of Player Targeting", "When configured with a pull/push action and in the player\u2019s inventory or Curios slot, the Omni Grid can automatically move items to and from the player\u2019s inventory. You can choose between different parts of your inventory, or a container item in your inventory or curios slot such as a backpack", Items.INSTANCE::setOmniPlayerCore);
        this.registerCoreItem(callback, CoreTypes.FURNACE, "omni_furnace_core", "Digital Furnace", "Adds a Digital Furnace to the Omni Grid \n\u2022 The Digital Furnace can be configured to automatically take and smelt items from storage\n\u2022 Requires burnable items for fuel. Utility slots also accept smelting processing patterns and use the Digital Furnace when needed", Items.INSTANCE::setOmniFurnaceCore);
        this.registerCoreItem(callback, CoreTypes.LOOTING, "omni_looting_core", "Enables use of auto-looting", "When a command is configured to auto-loot, automatically transfers items from any vanilla or Lootr chest the player opens to the Omni Grids storage. Filters can restrict what is taken from the chest. Excellent for looting.", Items.INSTANCE::setOmniLootingCore);
        this.registerCoreItem(callback, CoreTypes.BLACKLIST, "omni_blacklist_core", "Enables use of the Blacklist Action", "While the Omni Grid is placed, prevents automation from inserting the filtered item in the target direction.", Items.INSTANCE::setOmniBlacklistCore);
        this.registerCoreItem(callback, CoreTypes.EXTERNAL_STORAGE, "omni_external_core", "Enables use of the External Storage Action", "While the Omni Grid is placed, treats the container or fluid tank in the configured direction as external storage \u2014 its contents become part of the grid and can be used for push commands.", Items.INSTANCE::setOmniExternalCore);
        this.registerCoreItem(callback, CoreTypes.BASIC_CRAFTING, "omni_craft_core", "Enables use of the Simple Crafting Action", "Perform basic crafting operations such as 3x3/2x2 compression. \n If the autocrafting core is installed, can request autocrafting the configured resource whenever possible and block items from being used by brute-force crafting", Items.INSTANCE::setOmniCraftCore);
        this.registerCoreItem(callback, CoreTypes.REGULATE, "omni_regulate_core", "Enables use of the Regulate Action", "Keeps the target\u2019s item count equal to the selected value. Pulls items when above the limit and pushes items when below it.", Items.INSTANCE::setOmniRegulateCore);
        this.registerCoreItem(callback, CoreTypes.AUTOCRAFTING, "omni_autocrafting_core", "Adds Autocrafting functionality", "Allows the Omni Grid to use Refined Storage 2 crafting and stonecutter patterns. Insert patterns into utility slots and request crafting tasks. \n\nEnables Brute-force Crafting, which autocrafts missing ingredients when using JEI/EMI", Items.INSTANCE::setOmniAutocraftingCore);
        this.registerCoreItem(callback, CoreTypes.FILTER, "omni_precision_core", "Allows advanced filtering options", "Actions can be configured to affect not just specific items but all items from the same mod, tag, or with similar components.", Items.INSTANCE::setOmniPrecisionCore);
        this.registerCoreItem(callback, CoreTypes.MONITOR, "omni_monitor_core", "Enables resource monitoring", "Drag up to four different resources into the slots right of the utility slots. The Omni Grid will display their counts on screen.", Items.INSTANCE::setOmniMonitorCore);
        this.registerOptionalCustomItems(callback);
    }

    public static List<ItemStack> createLootBundleContents() {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        loot.add(Items.INSTANCE.getModifiedIndicator().getDefaultInstance());
        loot.add(Items.INSTANCE.getOmniDeco().getDefaultInstance());
        loot.add(Items.INSTANCE.getCommandCoreHousing().getDefaultInstance());
        loot.add(Items.INSTANCE.getOmniUtilityHousing().getDefaultInstance());
        loot.add(Items.INSTANCE.getPrecisionCoreHousing().getDefaultInstance());
        loot.add(Items.INSTANCE.getOmniPresetItem().getDefaultInstance());
        return loot;
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        for (Map.Entry<UUID, OmniItemProxxy> entry : OmniGridBlockItem.GLOBAL_STORAGES.entrySet()) {
            ModInitializer.SaveProxxyInfo(entry.getKey(), sp.level());
        }
    }

    public static void dumpKeyThreads() {
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : all.entrySet()) {
            boolean key;
            Thread t = e.getKey();
            String name = t.getName();
            boolean bl = key = name.equals("Render thread") || name.equals("Server thread") || name.startsWith("OmniGrid-") || name.contains("ForkJoinPool") || name.contains("Netty") || name.contains("Client thread");
            if (!key) continue;
            LOGGER.error("=== THREAD {} | {} | {} ===", new Object[]{name, t.getState(), t.isDaemon() ? "daemon" : "user"});
            for (StackTraceElement el : e.getValue()) {
                LOGGER.error("  at {}", (Object)el);
            }
        }
    }

    public static void SaveProxxyInventory(UUID uuid, Level level, FilteredContainer fc) {
        OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(uuid);
        if (proxxy == null || !(level instanceof ServerLevel)) {
            return;
        }
        VirtualContainerUtil.saveVirtualInventoryAndOmniData((Container)fc, proxxy.getCachedData(), proxxy.uuid, level);
        proxxy.setDirty(true);
    }

    public static void SaveProxxyInfo(UUID uuid, Level level) {
        OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(uuid);
        if (proxxy == null || !(level instanceof ServerLevel)) {
            return;
        }
        VirtualContainerUtil.saveVirtualInventoryAndOmniData((Container)proxxy.getInventory(), proxxy.getCachedData(), proxxy.uuid, level);
        proxxy.setDirty(true);
    }

    private void registerOptionalCustomItems(RegistryCallback<Item> callback) {
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        this.registerUtilityItem(callback, UtilityType.XP_HANLDER, "omni_xp_handler", "Adds special XP handling logic to commands when configured with a fluid XP", "Collect - Picks up XP orbs and deposits them as the configured XP fluid. \nPush/Pull - Targeting the player can transfer XP between the player and storage when configured to a XP fluid. \nRegulate - Targeting the player keeps them at a specific level\nXP fluid can be withdrawn from storage as XP directly", Items.INSTANCE::setOmniXpHandlerCore);
        this.registerUtilityItem(callback, UtilityType.ENERGY_BREAKER, "omni_energy_breaker", "Slows processes if the system is stressed rather than consuming more energy", "If the Omni Grids system stress surpasses 20%, slows processes rather than increasing energy consumption", Items.INSTANCE::setEnergyBreaker);
        this.registerUtilityItem(callback, UtilityType.PROXY_ACCESSOR, "omni_proxy_accessor", "Removes the range limit on storage proxy's", "Omni Proxy Blocks and Items linked to this Omni Grid ignore range limits and across dimensions as long as both ends are loaded", Items.INSTANCE::setProxyAccessor);
        this.registerUtilityItem(callback, UtilityType.XP_LIQUIFIER, "omni_xp_liquifier", "Liquifies furnace XP it would have given to the player", "When the Digital Furnace smelts an item and would award XP, it deposits fluid XP into storage instead. Requires a fluid disk installed and atleast one mod with fluid XP", Items.INSTANCE::setXpCore);
        this.registerUtilityItem(callback, UtilityType.BLOCK_PICKER, "omni_block_picker", "Block picker can interact with Omni Grids storage", "Pick block inserts the selected item into storage.\nTakes picked block from storage.\nIf picked block is already held, gives a full stack.", Items.INSTANCE::setPickBlockCore);
        this.registerUtilityItem(callback, UtilityType.LIMITER, "omni_utility_limiter", "Restricts task execution to only when the Omni Grid is equipped.", "While the Omni Grid is in item form, only runs commands if the Omni Grid equipped in either the main-hand or off-hand slot.", Items.INSTANCE::setOmniLimiterUtility);
        this.registerUtilityItem(callback, UtilityType.LIMITER_INVERTED, "omni_utility_limiter_inverted", "Restricts task execution to only when the Omni Grid is not equipped.", "While the Omni Grid is in item form, only runs commands if the Omni Grid not equipped in the main-hand or off-hand slot.", Items.INSTANCE::setOmniLimiterInverted);
        this.registerUtilityItem(callback, UtilityType.COBBLE_GENERATOR, "omni_cobble_generator", "Provides infinite cobblestone", "Cobblestone taken from the grid will never run out.\nUses cobblestone from disks first.\nConsumes FE when digitally generating cobblestone.", Items.INSTANCE::setOmniCobbleGenerator);
        this.registerUtilityItem(callback, UtilityType.BULK_SMELTING, "omni_bulk_core", "Digital Furnace smelts in bulk", "When the Digital Furnace is smelting large quantities\neach operation smelts four times as\nmany items but takes twice as long.", Items.INSTANCE::setOmniBulkSmeltingCore);
        this.registerUtilityItem(callback, UtilityType.WATER_SOURCE, "omni_water_generator", "Provides infinite water", "Water pulled from the grid never depletes.\nUses stored water from fluid disks first.\nConsumes FE when synthesizing additional water.", Items.INSTANCE::setOmniWaterSource);
        this.registerUtilityItem(callback, UtilityType.MOB_DEPOSIT, "omni_loot_deposit", "Deposits mob drops automatically", "Any mob drops collected by the player are automatically routed into Omni Grid storage.\nConsumes FE for every item deposited.\nItem form only.", Items.INSTANCE::setOmniLootDepositor);
        this.registerUtilityItem(callback, UtilityType.NOTIFIER, "omni_modified", "Pretty Colors!", "Resources in the Omni Grids storage are highlighted if they were modified by a command since the last time you opened it. The color varies command.", Items.INSTANCE::setModifiedIndicator);
        this.registerUtilityItem(callback, UtilityType.DURABLE, "omni_shield", "Makes the Omni Grid extremely durable", "Block form is nearly immune to explosions. Dropped item cant be destroyed by lava, fire, or explosions.", Items.INSTANCE::setOmniProtectionModule);
        this.registerUtilityItem(callback, UtilityType.ORE_DEPOSIT, "omni_quarry_deposit", "Deposits mined blocks automatically", "Blocks broken by the player are sent directly into Omni Grid storage. \nConsumes FE per deposited block.\nItem form only.", Items.INSTANCE::setOmniOreDepositor);
        this.registerUtilityItem(callback, UtilityType.ENERGY_HANDLER, "omni_energy_handler", "Enables Energy Disks to extend the Omni Grid\u2019s energy usage", "When the Omni Grid\u2019s internal energy buffer is full, excess energy is redirected into Energy Disks.\nWhen performing tasks, energy stored in Energy Disks is consumed before internal energy.", Items.INSTANCE::setOmniEnergyHandler);
        this.registerUtilityItem(callback, UtilityType.CAMP_FIRE, "omni_campfire", "Campfire-style cooking", "Digital Furnace cooks food with no fuel cost, but grants no experience.", Items.INSTANCE::setOmniCampfireModule);
        this.registerUtilityItem(callback, UtilityType.FIRE_EXTINGUISHER, "omni_fire_extinguisher", "Automatically extinguishes fire", "Uses stored water to extinguish the player.\nConverts lava to obsidian or cobblestone. Costs FE per activation and converted block", Items.INSTANCE::setOmniFireExtinguisher);
        this.registerUtilityItem(callback, UtilityType.CONSTRUCTOR, "omni_constructor_utility", "Automatically place blocks next to you", "While in item form, configuring a push action with a block item and direction will automatically place blocks next to you relative to the configured direction.", Items.INSTANCE::setOmniConstructorUtility);
        this.registerUtilityItem(callback, UtilityType.REMOTE_BOOSTER, "omni_remote_utility", "Increases remote block target slots", "Allows the Omni Grid to remember up to an additional 4 remote block target locations and increases the range when handling remote block targets", Items.INSTANCE::setRemoteBooster);
        this.registerUtilityItem(callback, UtilityType.SPONGE, "omni_sponge", "Absorbs nearby fluids when placed", "Pulls 1000mb per source block into storage.\nRadius increases with range upgrades.\nConsumes FE per absorbed block.", Items.INSTANCE::setOmniSpongeSimulator);
        this.registerUtilityItem(callback, UtilityType.CREATIVE, "omni_creative", "Creative", "Omni Grid has infinite energy, furnace fuel, and maximum processing speed \nActs as Durable, Cobble and Water Printer, and every Curios Core", Items.INSTANCE::setCreativeCore);
        if (ModList.get().isLoaded("curios")) {
            String desc = "Provides bonuses while in a Curios slot.\nPower scales with installed cores and upgrades.\nOmni Grids can only benefit from one Curios core at a time.";
            this.registerUtilityItem(callback, UtilityType.CURIOS_1, "omni_curios_1", "Armor Boost", desc, Items.INSTANCE::setOmniCuriosCore1);
            this.registerUtilityItem(callback, UtilityType.CURIOS_2, "omni_curios_2", "Mining Boost", desc, Items.INSTANCE::setOmniCuriosCore2);
            this.registerUtilityItem(callback, UtilityType.CURIOS_3, "omni_curios_3", "Attack Boost", desc, Items.INSTANCE::setOmniCuriosCore3);
            this.registerUtilityItem(callback, UtilityType.CURIOS_4, "omni_curios_4", "Movement Boost", desc, Items.INSTANCE::setOmniCuriosCore4);
            this.registerUtilityItem(callback, UtilityType.CURIOS_5, "omni_curios_5", "Health Boost", desc, Items.INSTANCE::setOmniCuriosCore5);
        }
        Items.INSTANCE.setLootBundle(callback.register(ModUtil.OmniIdentifier("loot_bundle"), LootBundleItem::new));
    }

    public static short getHighestCuriosTier(List<UtilityType> utilities) {
        short tier = 0;
        if (utilities.contains((Object)UtilityType.CREATIVE)) {
            return 6;
        }
        if (utilities.contains((Object)UtilityType.CURIOS_5)) {
            return 5;
        }
        if (utilities.contains((Object)UtilityType.CURIOS_4)) {
            return 4;
        }
        if (utilities.contains((Object)UtilityType.CURIOS_3)) {
            return 3;
        }
        if (utilities.contains((Object)UtilityType.CURIOS_2)) {
            return 2;
        }
        if (utilities.contains((Object)UtilityType.CURIOS_1)) {
            return 1;
        }
        return tier;
    }

    @SubscribeEvent
    public void onCurioAttributes(CurioAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.has(DataComponents.INSTANCE.getCuriosData())) {
            return;
        }
        CurioStats stats = (CurioStats)stack.get(DataComponents.INSTANCE.getCuriosData());
        if (stats == null) {
            return;
        }
        short tier = stats.type();
        if (tier <= 0) {
            return;
        }
        boolean creative = tier == 6;
        double total = stats.t();
        double totalStrong = stats.s();
        double upgrades = stats.u();
        double scale = Platform.getConfig().getOmniGrid().curiosPowerMultiplier();
        total *= scale;
        totalStrong *= scale;
        upgrades *= scale;
        if (tier == 1 || creative) {
            event.addModifier(Attributes.ARMOR, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_armor"), total * (double)0.1f, AttributeModifier.Operation.ADD_VALUE));
            event.addModifier(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_armor"), totalStrong * (double)0.1f, AttributeModifier.Operation.ADD_VALUE));
        }
        if (tier == 2 || creative) {
            event.addModifier(Attributes.MINING_EFFICIENCY, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_efficiency"), total * (double)0.2f, AttributeModifier.Operation.ADD_VALUE));
            event.addModifier(ORE_LUCK, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_ore"), totalStrong * 2.0 + upgrades / 6.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (tier == 3 || creative) {
            event.addModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_damage"), total * (double)0.005f + upgrades * (double)0.005f / 4.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            event.addModifier(Attributes.ATTACK_SPEED, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_speed"), totalStrong * (double)0.025f, AttributeModifier.Operation.ADD_VALUE));
        }
        if (tier == 4 || creative) {
            event.addModifier(Attributes.MOVEMENT_SPEED, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_speed"), totalStrong * (double)0.0025f, AttributeModifier.Operation.ADD_VALUE));
            event.addModifier(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_speed"), -upgrades * (double)0.0125f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            event.addModifier(Attributes.JUMP_STRENGTH, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_speed"), total * (double)0.0125f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if (tier == 5 || creative) {
            double bonus = upgrades + total * 2.0;
            event.addModifier(HEALTH_REGEN, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_regen"), bonus / 10.0, AttributeModifier.Operation.ADD_VALUE));
            event.addModifier(Attributes.MAX_HEALTH, new AttributeModifier(ModUtil.OmniIdentifier("curio_bonus_health"), totalStrong, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        Iterator it = event.getAffectedBlocks().iterator();
        while (it.hasNext()) {
            BlockEntity be;
            BlockPos pos = (BlockPos)it.next();
            BlockState state = level.getBlockState(pos);
            if (!(state.getBlock() instanceof OmniGridBlock) || !((be = level.getBlockEntity(pos)) instanceof AbstractOmniGridBlockEntity)) continue;
            AbstractOmniGridBlockEntity omni = (AbstractOmniGridBlockEntity)be;
            OmniItemProxxy prox = omni.proxxy;
            if (prox == null || !prox.utilityTypes.contains((Object)UtilityType.DURABLE) && !prox.utilityTypes.contains((Object)UtilityType.CREATIVE)) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    public void onItemSpawn(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        ItemStack stack;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && (stack = (itemEntity = (ItemEntity)entity).getItem()).getItem() instanceof OmniGridBlockItem && stack.has(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()) && OmniGridBlockItem.GLOBAL_STORAGES.containsKey(stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()))) {
            OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()));
            if (proxxy.utilityTypes.contains((Object)UtilityType.DURABLE)) {
                itemEntity.setInvulnerable(true);
                itemEntity.setRemainingFireTicks(0);
                itemEntity.extinguishFire();
            }
            proxxy.setDirty(true);
        }
    }

    public void registerCoreItem(RegistryCallback<Item> callback, CoreTypes coreType, String id, String title, String description, Consumer<Supplier<Item>> acceptor) {
        acceptor.accept(callback.register(ModUtil.OmniIdentifier(id), () -> new CoreItem(coreType, title, description)));
    }

    public void registerUtilityItem(RegistryCallback<Item> callback, UtilityType utilityType, String id, String title, String description, Consumer<Supplier<Item>> acceptor) {
        acceptor.accept(callback.register(ModUtil.OmniIdentifier(id), () -> new OmniUtilityItem(utilityType, title, description)));
    }

    @SubscribeEvent
    public void onBlockBreakWithCurios(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        BlockState state = event.getState();
        Level level = (Level)event.getLevel();
        if (!state.is(ORES_TAG)) {
            return;
        }
        double oreLuck = player.getAttributeValue(ORE_LUCK);
        if (oreLuck <= 0.0) {
            return;
        }
        double chance = Math.min(100.0, Math.max(0.0, oreLuck)) / 100.0;
        ItemStack tool = player.getMainHandItem();
        List baseDrops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)event.getPos(), null, (Entity)player, (ItemStack)tool);
        if (baseDrops.isEmpty()) {
            return;
        }
        for (ItemStack drop : baseDrops) {
            if (drop.isEmpty() || !(level.random.nextDouble() < chance)) continue;
            ItemStack extra = new ItemStack((ItemLike)drop.getItem(), drop.getCount());
            Block.popResource((Level)level, (BlockPos)event.getPos(), (ItemStack)extra);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player == null || player.level().isClientSide()) {
            return;
        }
        if (player instanceof FakePlayer) {
            return;
        }
        boolean hasOreDeposit = OmniGridBlockItem.GLOBAL_STORAGES.values().stream().anyMatch(prox -> prox != null && prox.player != null && prox.player.equals(player.getUUID()) && !prox.isDirty() && TransferUtils.checkifOwned(player, prox.uuid) && prox.utilityTypes.contains((Object)UtilityType.ORE_DEPOSIT));
        if (!hasOreDeposit) {
            return;
        }
        Level level = player.level();
        BlockPos pos = event.getPos();
        this.scheduleDelayedDeposit(level, pos, player.getUUID());
    }

    private void scheduleDelayedDeposit(Level level, BlockPos pos, UUID playerId) {
        int runAt = currentTick + 2;
        delayedTasks.computeIfAbsent(runAt, k -> new ArrayList()).add(() -> this.runDeposit(level, pos, playerId));
    }

    @SubscribeEvent
    public void onServerTick(LevelTickEvent.Post event) {
        ModInitializer.clearStaleTasks(++currentTick);
        List<Runnable> tasks = delayedTasks.remove(currentTick);
        if (tasks != null) {
            for (Runnable r : tasks) {
                r.run();
            }
        }
    }

    private static void clearStaleTasks(int currentTick) {
        delayedTasks.entrySet().removeIf(entry -> (Integer)entry.getKey() < currentTick - 10);
    }

    private void runDeposit(Level level, BlockPos pos, UUID playerId) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        List items = server.getEntitiesOfClass(ItemEntity.class, new AABB(pos).inflate(1.5));
        if (items.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemEntity ent : items) {
            stacks.add(ent.getItem().copy());
        }
        ServerPlayer player = (ServerPlayer)server.getPlayerByUUID(playerId);
        if (player == null) {
            return;
        }
        List<ItemStack> leftovers = TransferUtils.depositToPlayerOmniGrids((Player)player, stacks, UtilityType.ORE_DEPOSIT);
        for (ItemEntity ent : items) {
            ent.discard();
        }
        for (ItemStack left : leftovers) {
            if (left.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)left);
        }
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        Entity source = event.getSource().getEntity();
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        if (player instanceof FakePlayer) {
            return;
        }
        Level level = entity.level();
        if (level.isClientSide) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (ItemEntity itemEntity : event.getDrops()) {
            drops.add(itemEntity.getItem());
        }
        event.getDrops().clear();
        List<ItemStack> leftovers = TransferUtils.depositToPlayerOmniGrids(player, drops, UtilityType.MOB_DEPOSIT);
        if (leftovers != drops) {
            // empty if block
        }
        BlockPos pos = entity.blockPosition();
        for (ItemStack stack : leftovers) {
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
    }

    private void registerMenus(IEventBus eventBus) {
        Menus.INSTANCE.setPortableCraftingGridBlock(new ForgeRegistryCallback(this.menuTypeRegistry).register(ModUtil.OmniIdentifier("omni_grid_block"), () -> IMenuTypeExtension.create((syncId, inv, buf) -> {
            OmniGridMenuData data = (OmniGridMenuData)OmniGridMenuData.STREAM_CODEC.decode((Object)buf);
            return new OmniGridBlockContainerMenu(syncId, inv, data);
        })));
        Menus.INSTANCE.setPortableCraftingGridItem(new ForgeRegistryCallback(this.menuTypeRegistry).register(ModUtil.OmniIdentifier("omni_grid_item"), () -> IMenuTypeExtension.create((syncId, inv, buf) -> {
            OmniGridMenuData data = (OmniGridMenuData)OmniGridMenuData.STREAM_CODEC.decode((Object)buf);
            return new OmniGridItemContainerMenu(syncId, inv, data);
        })));
        Menus.INSTANCE.setOmniProxyRemote(new ForgeRegistryCallback(this.menuTypeRegistry).register(ModUtil.OmniIdentifier("omni_port_proxy"), () -> IMenuTypeExtension.create((syncId, inv, buf) -> {
            ResourceContainerData data = (ResourceContainerData)ResourceContainerData.STREAM_CODEC.decode((Object)buf);
            return new OmniPortContainerMenu(syncId, inv, data);
        })));
        Menus.INSTANCE.setResourceChestContainerMenu(new ForgeRegistryCallback(this.menuTypeRegistry).register(ModUtil.OmniIdentifier("omni_resource_chest"), () -> IMenuTypeExtension.create((syncId, inv, buf) -> {
            ResourceContainerData data = (ResourceContainerData)ResourceContainerData.STREAM_CODEC.decode((Object)buf);
            return new ResourceChestContainerMenu(syncId, inv, data);
        })));
        Menus.INSTANCE.setOmniFilterData(new ForgeRegistryCallback(this.menuTypeRegistry).register(ModUtil.OmniIdentifier("omni_filter_data"), () -> IMenuTypeExtension.create((syncId, inv, buf) -> {
            ResourceContainerData data = (ResourceContainerData)ResourceContainerData.STREAM_CODEC.decode((Object)buf);
            return new ResourceFilterContainerMenu(syncId, inv, data);
        })));
        this.menuTypeRegistry.register(eventBus);
    }

    public static ResourceContainerData empty9() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < 9; ++i) {
            list.add(Optional.empty());
        }
        return new ResourceContainerData(list);
    }

    private void registerCreativeModeTabListener(BuildCreativeModeTabContentsEvent e) {
        ResourceKey creativeModeTab = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)RefinedStorageApi.INSTANCE.getCreativeModeTabId());
        if (!e.getTabKey().equals(creativeModeTab)) {
            return;
        }
        CreativeModeTabItems.addItems((arg_0, arg_1) -> ((BuildCreativeModeTabContentsEvent)e).accept(arg_0, arg_1));
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        RecipeManager rm = event.getServer().getRecipeManager();
        ModInitializer.disable(rm, "cobble_utility", !cfg.cobblePrinterEnabled());
        ModInitializer.disable(rm, "water_utility", !cfg.waterPrinterEnabled());
        ModInitializer.disable(rm, "loot_utility", !cfg.lootEnabled());
        ModInitializer.disable(rm, "quarry_utility", !cfg.depositEnabled());
        ModInitializer.disable(rm, "fire_utility", !cfg.fireExtEnabled());
        ModInitializer.disable(rm, "sponge_utility", !cfg.spongeEnabled());
        ModInitializer.disable(rm, "omni_limiter_utility", !cfg.constructorCoreEnabled());
        ModInitializer.disable(rm, "omni_overclocker", !cfg.overclockerEnabled());
        ModInitializer.disable(rm, "omni_overclocker_plus", !cfg.overclockerPlusEnabled());
        ModInitializer.disable(rm, "omni_proxy_accessor", !cfg.getProxyAccessor());
        boolean curiosEnabled = ModList.get().isLoaded("curios") && cfg.curiosEnabled();
        ModInitializer.disable(rm, "curios_armor", !curiosEnabled);
        ModInitializer.disable(rm, "curios_mining", !curiosEnabled);
        ModInitializer.disable(rm, "curios_damage", !curiosEnabled);
        ModInitializer.disable(rm, "curios_health", !curiosEnabled);
        ModInitializer.disable(rm, "curios_boots", !curiosEnabled);
    }

    private static void disable(RecipeManager rm, String name, boolean disabled) {
        if (!disabled) {
            return;
        }
        ResourceLocation id = ModUtil.OmniIdentifier(name);
        if (!rm.byKey(id).isPresent()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ((RecipeHolder)rm.byKey(id).get()).value().getIngredients().set(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{ItemStack.EMPTY}));
        }
        Collection all = rm.getRecipes();
        ArrayList<RecipeHolder> filtered = new ArrayList<RecipeHolder>();
        for (RecipeHolder holder : all) {
            if (holder.id().equals((Object)id)) continue;
            filtered.add(holder);
        }
        rm.replaceRecipes(filtered);
    }

    private static RecipeHolder<?> makeDisabled(ResourceLocation id) {
        NonNullList ingredients = NonNullList.create();
        ShapelessRecipe empty = new ShapelessRecipe("none", CraftingBookCategory.MISC, ItemStack.EMPTY, ingredients);
        return new RecipeHolder(id, (Recipe)empty);
    }

    private void registerBlockEntities(IEventBus eventBus) {
        this.registerBlockEntities(new ForgeRegistryCallback(this.blockEntityTypeRegistry), new BlockEntityTypeFactory(this){

            @Override
            public <T extends BlockEntity> BlockEntityType<T> create(BlockEntityProvider<T> factory, Block ... allowedBlocks) {
                return new BlockEntityType(factory::create, new HashSet<Block>(Arrays.asList(allowedBlocks)), null);
            }
        }, BLOCK_ENTITY_PROVIDERS);
        this.blockEntityTypeRegistry.register(eventBus);
    }

    @SubscribeEvent
    private void registerDataComponents(IEventBus eventBus) {
        ForgeRegistryCallback callback = new ForgeRegistryCallback(this.dataComponentTypeRegistry);
        this.registerDataComponents(callback);
        this.dataComponentTypeRegistry.register(eventBus);
    }

    @SubscribeEvent
    public void onRegister(RegisterEvent e) {
        e.register(Registries.LOOT_FUNCTION_TYPE, helper -> this.registerLootFunctions((RegistryCallback<LootItemFunctionType<?>>)new DirectRegistryCallback(BuiltInRegistries.LOOT_FUNCTION_TYPE)));
    }

    public static IItemHandler getProxxy(ItemStack itemStack) {
        UUID id = OmniGridBlockItem.getOrCreate(itemStack);
        return OmniGridBlockItem.GLOBAL_STORAGES.get(id);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        RefinedStorageApi.INSTANCE.getUpgradeRegistry().forDestination((UpgradeDestination)Items.INSTANCE.getOmniGrid()).add((Item)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade(), 3);
        RefinedStorageApi.INSTANCE.getUpgradeRegistry().forDestination((UpgradeDestination)Items.INSTANCE.getOmniGrid()).add((Item)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStackUpgrade(), 3);
        RefinedStorageApi.INSTANCE.getUpgradeRegistry().forDestination((UpgradeDestination)Items.INSTANCE.getOmniGrid()).add((Item)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getRangeUpgrade(), 3);
        RefinedStorageApi.INSTANCE.getUpgradeRegistry().forDestination((UpgradeDestination)Items.INSTANCE.getOmniGrid()).add((Item)Items.INSTANCE.getOmniEnergy(), 3);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getOmniGrid(), AbstractOmniGridBlockEntity::getItemHandler);
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> ModInitializer.getProxxy(stack), new ItemLike[]{Items.INSTANCE.getOmniGrid()});
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, BlockEntities.INSTANCE.getOmniGrid(), (be, side) -> new EnergyStorageAdapter(be.getEnergyStorage()));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntities.INSTANCE.getOmniGrid(), AbstractOmniGridBlockEntity::getFluidHandler);
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new EnergyStorageAdapter(OmniGridBlockItem.createEnergyStorage(stack)), new ItemLike[]{Items.INSTANCE.getOmniGrid()});
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getProxyDeposit(), OmniPort::getHandler);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntities.INSTANCE.getProxyDeposit(), OmniPort::getHandler);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, BlockEntities.INSTANCE.getProxyDeposit(), OmniPort::getHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getOmniPort(), OmniDispenser::getSuper);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntities.INSTANCE.getOmniPort(), OmniDispenser::getSuper);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, BlockEntities.INSTANCE.getOmniPort(), OmniDispenser::getSuper);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getResourceChest(), (be, side) -> new InvWrapper(be.getExportedResourcesAsContainer()));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntities.INSTANCE.getResourceChest(), (be, side) -> new ResourceContainerFluidHandlerAdapter((ResourceContainer)be.resourceContainer));
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getOmniGrid());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getOmniProxxy());
    }

    private void registerNetworkNodeContainerProvider(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractNetworkNodeContainerBlockEntity<?>> type) {
        event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), type, (be, side) -> be.getContainerProvider());
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!(left.getItem() instanceof OmniGridBlockItem) || right.isEmpty()) {
            return;
        }
        ChatFormatting color = DYE_COLORS.get(right.getItem());
        if (color == null) {
            return;
        }
        ItemStack output = left.copy();
        String rename = event.getName();
        MutableComponent base = rename != null && !rename.isEmpty() ? Component.literal((String)rename) : left.getHoverName().copy();
        MutableComponent colored = base.withStyle(color).withStyle(style -> style.withItalic(Boolean.valueOf(false)));
        output.set(net.minecraft.core.component.DataComponents.CUSTOM_NAME, (Object)colored);
        event.setOutput(output);
        event.setCost(1L);
        event.setMaterialCost(1);
    }

    @SubscribeEvent
    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("refinedstorage");
        ModInitializer.registerClientToServerPackets(registrar);
    }

    private static void registerClientToServerPackets(PayloadRegistrar registrar) {
        registrar.playToServer(ItemTransferPacket.PACKET_TYPE, ItemTransferPacket.STREAM_CODEC, ModInitializer.wrapHandler(ItemTransferPacket::handle));
        registrar.playToServer(SyncTabPacket.PACKET_TYPE, SyncTabPacket.STREAM_CODEC, (packet, ctx) -> packet.handle((SyncTabPacket)packet, ctx));
        registrar.playToServer(CraftingGridRecipeTransferPacket.PACKET_TYPE, CraftingGridRecipeTransferPacket.STREAM_CODEC, ModInitializer.wrapHandler(CraftingGridRecipeTransferPacket::handle));
        registrar.playToServer(StopServerMenuPacket.PACKET_TYPE, StopServerMenuPacket.STREAM_CODEC, ModInitializer.wrapHandler(StopServerMenuPacket::handle));
        registrar.playToServer(CraftingGridClearPacket.PACKET_TYPE, CraftingGridClearPacket.STREAM_CODEC, ModInitializer.wrapHandler(CraftingGridClearPacket::handle));
        registrar.playToServer(CoreStatePacket.PACKET_TYPE, CoreStatePacket.STREAM_CODEC, (packet, ctx) -> packet.handle((CoreStatePacket)packet, ctx));
        registrar.playToServer(ClearTargetData.PACKET_TYPE, ClearTargetData.STREAM_CODEC, (packet, context) -> packet.handle((ClearTargetData)packet, context));
        registrar.playToServer(UpdateCrafterPatternsPacket.PACKET_TYPE, UpdateCrafterPatternsPacket.STREAM_CODEC, ModInitializer.wrapHandler(UpdateCrafterPatternsPacket::handle));
        registrar.playToServer(DisableCommandPacket.PACKET_TYPE, DisableCommandPacket.STREAM_CODEC, (packet, ctx) -> packet.handle((DisableCommandPacket)packet, ctx));
        registrar.playToServer(CraftingGridSpreadPacket.PACKET_TYPE, CraftingGridSpreadPacket.STREAM_CODEC, ModInitializer.wrapHandler(CraftingGridSpreadPacket::handle));
        registrar.playToServer(CraftingGridBalancePacket.PACKET_TYPE, CraftingGridBalancePacket.STREAM_CODEC, ModInitializer.wrapHandler(CraftingGridBalancePacket::handle));
        registrar.playToServer(RequestOmniDataSync.PACKET_TYPE, RequestOmniDataSync.STREAM_CODEC, ModInitializer.wrapHandler(RequestOmniDataSync::handle));
        registrar.playToClient(OmniClientBlockPacket.PACKET_TYPE, OmniClientBlockPacket.STREAM_CODEC, ModInitializer.wrapHandler(OmniClientBlockPacket::handle));
        registrar.playToClient(UpdateCommandData.PACKET_TYPE, UpdateCommandData.STREAM_CODEC, ModInitializer.wrapHandler(UpdateCommandData::handle));
        registrar.playToServer(UpdateUpgrades.PACKET_TYPE, UpdateUpgrades.STREAM_CODEC, (packet, context) -> packet.handle((UpdateUpgrades)packet, context));
        registrar.playToServer(UpdateFurnace.PACKET_TYPE, UpdateFurnace.STREAM_CODEC, (packet, context) -> packet.handle((UpdateFurnace)packet, context));
        registrar.playToServer(UpdateCommand.PACKET_TYPE, UpdateCommand.STREAM_CODEC, (packet, context) -> packet.handle((UpdateCommand)packet, context));
        registrar.playToServer(PickBlockRequest.PACKET_TYPE, PickBlockRequest.STREAM_CODEC, (packet, context) -> packet.handle((PickBlockRequest)packet, context));
        registrar.playToClient(CurioStatsPacket.PACKET_TYPE, CurioStatsPacket.STREAM_CODEC, ModInitializer.wrapHandler(CurioStatsPacket::handle));
        registrar.playToClient(OmniEffectPacket.PACKET_TYPE, OmniEffectPacket.STREAM_CODEC, ModInitializer.wrapHandler(OmniEffectPacket::handle));
        registrar.playToClient(UpdateTracker.PACKET_TYPE, UpdateTracker.STREAM_CODEC, ModInitializer.wrapHandler(UpdateTracker::handle));
        registrar.playToClient(DispenserSyncPacket.PACKET_TYPE, DispenserSyncPacket.STREAM_CODEC, ModInitializer.wrapHandler(DispenserSyncPacket::handle));
        registrar.playToClient(AutocraftingInfoPacket.PACKET_TYPE, AutocraftingInfoPacket.STREAM_CODEC, (packet, context) -> packet.handle((AutocraftingInfoPacket)packet, context));
    }

    public static BlockHitResult getLookedAtBlock(Player player, double range) {
        Vec3 eye = player.getEyePosition(1.0f);
        Vec3 look = player.getLookAngle();
        Vec3 end = eye.add(look.scale(range));
        return player.level().clip(new ClipContext(eye, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    private void registerBlocks(IEventBus eventBus) {
        this.registerBlocks(new ForgeRegistryCallback<Block>(this.blockRegistry), BLOCK_ENTITY_PROVIDERS);
        this.blockRegistry.register(eventBus);
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle((Object)packet, () -> ((IPayloadContext)ctx).player());
    }

    private record ForgeRegistryCallback<T>(DeferredRegister<T> registry) implements RegistryCallback<T>
    {
        public <R extends T> Supplier<R> register(ResourceLocation id, Supplier<R> value) {
            return this.registry.register(id.getPath(), value);
        }
    }

    private record Scheduled(ServerPlayer player, int remainingTicks, Runnable action) {
    }
}

