/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class InteractionUtils {
    public static boolean canInteractWithBlock(@Nullable Player player, Level level, BlockPos pos, Direction face) {
        if (level.isClientSide) {
            return false;
        }
        if (player != null && player.getGameProfile().getName().equals("[OmniGridFake]")) {
            return true;
        }
        if (player == null) {
            return true;
        }
        Vec3 hit = InteractionUtils.faceCenter(pos, face);
        BlockHitResult hitResult = new BlockHitResult(hit, face, pos, false);
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, InteractionHand.MAIN_HAND, pos, hitResult);
        NeoForge.EVENT_BUS.post((Event)evt);
        if (evt.isCanceled()) {
            return false;
        }
        if (evt.getUseBlock() == TriState.FALSE) {
            return false;
        }
        if (evt.getUseItem() == TriState.FALSE) {
            return false;
        }
        return evt.getCancellationResult() != InteractionResult.FAIL;
    }

    private static Vec3 faceCenter(BlockPos pos, Direction face) {
        double x = (double)pos.getX() + 0.5 + 0.5 * (double)face.getStepX();
        double y = (double)pos.getY() + 0.5 + 0.5 * (double)face.getStepY();
        double z = (double)pos.getZ() + 0.5 + 0.5 * (double)face.getStepZ();
        return new Vec3(x, y, z);
    }
}

