/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IntButton
extends Button {
    private final int value;
    private final Consumer<IntButton> onPressHandler;
    private final ResourceLocation[] sprites;
    private final List<Button> dropdownButtons = new ArrayList<Button>();
    private boolean dropdownVisible = false;
    private int index = 0;

    public IntButton(int x, int y, int width, int height, int value, Component text, Consumer<IntButton> onPressHandler, ResourceLocation[] sprites, int index) {
        super(x, y, width, height, text, b -> {}, DEFAULT_NARRATION);
        this.value = value;
        this.onPressHandler = onPressHandler;
        this.sprites = sprites;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getValue() {
        return this.value;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.dropdownVisible) {
            for (Button btn : this.dropdownButtons) {
                btn.render(guiGraphics, mouseX, mouseY, partialTicks);
            }
        }
        if (this.dropdownVisible) {
            ResourceLocation location = this.sprites[this.value];
            guiGraphics.blitSprite(location, this.getX(), this.getY(), this.width, this.height);
        }
    }

    public void onPress() {
        if (this.onPressHandler != null) {
            this.onPressHandler.accept(this);
        }
    }
}

