/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.StorageProxy.OmniProxyRemoteItem;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.OmniGrid;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.ModList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.CuriosApi;

public class InWorldOmniGrid
extends OmniGrid {
    private final AbstractOmniGridBlockEntity blockEntity;
    private static final Logger LOGGER = LoggerFactory.getLogger(InWorldOmniGrid.class);
    private long lastRemoteCheckTick = -1L;
    private boolean cachedHasRemote = false;

    public AbstractOmniGridBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    InWorldOmniGrid(EnergyStorage energyStorage, StateTrackedStorage.Listener diskListener, AbstractOmniGridBlockEntity blockEntity) {
        super(energyStorage, diskListener, blockEntity.getLevel());
        this.blockEntity = blockEntity;
    }

    @Override
    public boolean canMenuStayOpen(Player player) {
        if (Container.stillValidBlockEntity((BlockEntity)this.blockEntity, (Player)player)) {
            return true;
        }
        long gameTime = player.level().getGameTime();
        if (gameTime - this.lastRemoteCheckTick >= 10L) {
            this.cachedHasRemote = this.playerHasMatchingRemote(player, this.blockEntity.getStorageReference());
            this.lastRemoteCheckTick = gameTime;
        }
        return this.cachedHasRemote;
    }

    @Override
    public boolean isGridActive() {
        Level level = this.blockEntity.getLevel();
        BlockPos worldPosition = this.blockEntity.getBlockPos();
        return super.isGridActive() && level != null && this.blockEntity.getRedstoneMode().isActive(level.hasNeighborSignal(worldPosition));
    }

    private boolean playerHasMatchingRemote(Player player, UUID gridId) {
        if (gridId == null) {
            return false;
        }
        for (ItemStack stack : player.getInventory().items) {
            if (!this.isMatchingRemote(stack, gridId)) continue;
            return true;
        }
        if (this.isMatchingRemote(player.getOffhandItem(), gridId)) {
            return true;
        }
        for (ItemStack stack : player.getInventory().armor) {
            if (!this.isMatchingRemote(stack, gridId)) continue;
            return true;
        }
        if (ModList.get().isLoaded("curios")) {
            return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.getEquippedCurios()).map(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (!this.isMatchingRemote(handler.getStackInSlot(i), gridId)) continue;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean isMatchingRemote(ItemStack stack, UUID gridId) {
        if (stack.isEmpty()) {
            return false;
        }
        if (!(stack.getItem() instanceof OmniProxyRemoteItem)) {
            return false;
        }
        UUID ref = (UUID)stack.get(DataComponents.INSTANCE.getStorageReference());
        return gridId.equals(ref);
    }
}

