/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;

public class ImageRowTooltipComponent
implements ClientTooltipComponent {
    private final List<ResourceLocation> images;
    private final int imageWidth;
    private final int imageHeight;
    private final int spacing;

    public ImageRowTooltipComponent(List<ResourceLocation> images, int imageWidth, int imageHeight, int spacing) {
        ArrayList<ResourceLocation> imgs = new ArrayList<ResourceLocation>();
        for (ResourceLocation loc : images) {
            imgs.add(loc.withPath("textures/gui/sprites/" + loc.getPath() + ".png"));
        }
        this.images = imgs;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.spacing = spacing;
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public int getWidth(Font font) {
        return this.images.size() * this.imageWidth + (this.images.size() - 1) * this.spacing;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int currentX = x;
        for (ResourceLocation texture : this.images) {
            guiGraphics.blit(texture, currentX, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
            currentX += this.imageWidth + this.spacing;
        }
    }
}

