/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.OmniGridScreen;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class HoveredImageButton
extends Button {
    protected WidgetSprites sprites;
    public boolean useAlt = false;
    public int type;
    public OmniGridScreen screen;

    public HoveredImageButton(int x, int y, int width, int height, WidgetSprites sprites, Consumer<HoveredImageButton> onPress, Component component, OmniGridScreen screen, int type) {
        super(x, y, width, height, component, button -> onPress.accept((HoveredImageButton)button), DEFAULT_NARRATION);
        this.sprites = sprites;
        this.screen = screen;
        this.type = type;
    }

    public void onPress() {
        if (this.isActive()) {
            super.onPress();
        }
    }

    public void setSprites(WidgetSprites sprites) {
        this.sprites = sprites;
    }

    public void renderWidget(GuiGraphics graphics, int x, int y, float partialTicks) {
        if (this.isActive()) {
            ResourceLocation location = this.sprites.get(this.active, this.isHovered());
            if (this.type == 3 && !((AbstractOmniGridContainerMenu)this.screen.getMenu()).getDataClient().isCoreInstalled(CoreTypes.AUTOCRAFTING)) {
                return;
            }
            if (this.screen.isTransferPanel() && ((AbstractOmniGridContainerMenu)this.screen.getMenu()).tabPage == 0) {
                location = this.sprites.get(Minecraft.getInstance().player.isShiftKeyDown(), this.isHovered());
            }
            if (this.useAlt || this.type == 3 && ((AbstractOmniGridContainerMenu)this.screen.getMenu()).containerData.get(3) > 0) {
                location = this.sprites.get(false, this.isHovered);
            }
            graphics.blitSprite(location, this.getX(), this.getY(), this.width, this.height);
        }
    }

    public boolean isActive() {
        if (this.type == 0) {
            return !this.screen.isTransferPanel();
        }
        if (this.type == 1 || this.type == 3) {
            return ((AbstractOmniGridContainerMenu)this.screen.getMenu()).tabPage == 0 && !this.screen.isTransferPanel();
        }
        if (this.type == 2) {
            return this.screen.isTransferPanel();
        }
        return false;
    }

    public boolean isHoveredOrFocused() {
        if (this.type == 3 && !((AbstractOmniGridContainerMenu)this.screen.getMenu()).getDataClient().isCoreInstalled(CoreTypes.AUTOCRAFTING)) {
            return false;
        }
        return this.active && super.isHoveredOrFocused();
    }

    public boolean isHovered() {
        if (this.type == 3 && !((AbstractOmniGridContainerMenu)this.screen.getMenu()).getDataClient().isCoreInstalled(CoreTypes.AUTOCRAFTING)) {
            return false;
        }
        return this.isActive() && super.isHovered();
    }

    @Nullable
    public Tooltip getTooltip() {
        if (this.type == 3 && !((AbstractOmniGridContainerMenu)this.screen.getMenu()).getDataClient().isCoreInstalled(CoreTypes.AUTOCRAFTING)) {
            return null;
        }
        if (!this.isActive()) {
            return null;
        }
        return super.getTooltip();
    }
}

