/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.refinedmods.refinedstorage.common.grid.GridSearchBox;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.query.lexer.Lexer;
import com.refinedmods.refinedstorage.query.lexer.LexerException;
import com.refinedmods.refinedstorage.query.lexer.LexerTokenMappings;
import com.refinedmods.refinedstorage.query.lexer.Source;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlightedCharacter;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

class GridSearchBoxWidget
extends SearchFieldWidget
implements GridSearchBox {
    private final Set<Consumer<String>> listeners = new HashSet<Consumer<String>>();
    private boolean valid = true;

    GridSearchBoxWidget(Font textRenderer, int x, int y, int width, SyntaxHighlighter syntaxHighlighter, History history) {
        super(textRenderer, x, y, width, history);
        this.setFormatter((text, firstCharacterIndex) -> this.format(syntaxHighlighter, (String)text));
        this.setResponder(text -> this.listeners.forEach(l -> l.accept(text)));
    }

    private FormattedCharSequence format(SyntaxHighlighter syntaxHighlighter, String text) {
        if (!this.valid) {
            return this.invalidText(text);
        }
        Lexer lexer = this.createLexer(text);
        try {
            lexer.scan();
        }
        catch (LexerException e) {
            return this.invalidText(text);
        }
        List characters = syntaxHighlighter.highlight(text, lexer.getTokens());
        return this.convertCharactersToOrderedText(characters);
    }

    private FormattedCharSequence invalidText(String text) {
        return FormattedCharSequence.forward((String)text, (Style)Style.EMPTY.applyFormat(ChatFormatting.RED));
    }

    private FormattedCharSequence convertCharactersToOrderedText(List<SyntaxHighlightedCharacter> characters) {
        FormattedCharSequence orderedText = FormattedCharSequence.EMPTY;
        for (SyntaxHighlightedCharacter character : characters) {
            orderedText = FormattedCharSequence.composite((FormattedCharSequence)orderedText, (FormattedCharSequence)this.convertCharacterToOrderedText(character));
        }
        return orderedText;
    }

    private FormattedCharSequence convertCharacterToOrderedText(SyntaxHighlightedCharacter character) {
        ChatFormatting color = ChatFormatting.getByName((String)character.getColor());
        return FormattedCharSequence.forward((String)character.getCharacter(), (Style)Style.EMPTY.withColor(color));
    }

    private Lexer createLexer(String text) {
        return new Lexer(new Source("Grid search box syntax highlighting", text), LexerTokenMappings.DEFAULT_MAPPINGS);
    }

    public void addListener(Consumer<String> listener) {
        this.listeners.add(listener);
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.setTextColor(valid ? 0xFFFFFF : 0xFF5555);
    }
}

