/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public class FurnaceData {
    public long[] toSmelt = new long[9];
    public PlatformResourceKey[] smeltItems = new PlatformResourceKey[9];
    public PlatformResourceKey[] fuelItems = new PlatformResourceKey[4];
    public int fuel;
    public float accumulatedXp;
    public static final Codec<FurnaceData> FURNACE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.listOf().fieldOf("progress").forGetter(fd -> Arrays.stream(fd.toSmelt).boxed().toList()), (App)ResourceCodecs.CODEC.optionalFieldOf("sm0").forGetter(fd -> Optional.ofNullable(fd.smeltItems[0])), (App)ResourceCodecs.CODEC.optionalFieldOf("sm1").forGetter(fd -> Optional.ofNullable(fd.smeltItems[1])), (App)ResourceCodecs.CODEC.optionalFieldOf("sm2").forGetter(fd -> Optional.ofNullable(fd.smeltItems[2])), (App)ResourceCodecs.CODEC.optionalFieldOf("sm3").forGetter(fd -> Optional.ofNullable(fd.smeltItems[3])), (App)ResourceCodecs.CODEC.optionalFieldOf("fu0").forGetter(fd -> Optional.ofNullable(fd.fuelItems[0])), (App)ResourceCodecs.CODEC.optionalFieldOf("fu1").forGetter(fd -> Optional.ofNullable(fd.fuelItems[1])), (App)ResourceCodecs.CODEC.optionalFieldOf("fu2").forGetter(fd -> Optional.ofNullable(fd.fuelItems[2])), (App)ResourceCodecs.CODEC.optionalFieldOf("fu3").forGetter(fd -> Optional.ofNullable(fd.fuelItems[3])), (App)Codec.INT.fieldOf("burn").forGetter(fd -> fd.fuel), (App)Codec.FLOAT.fieldOf("accXp").forGetter(fd -> Float.valueOf(fd.accumulatedXp))).apply((Applicative)instance, (progressList, sm0, sm1, sm2, sm3, fu0, fu1, fu2, fu3, burn, accXp) -> {
        FurnaceData fd = new FurnaceData();
        for (int i = 0; i < 4; ++i) {
            fd.toSmelt[i] = i < progressList.size() ? (Long)progressList.get(i) : 0L;
        }
        fd.smeltItems[0] = sm0.orElse(null);
        fd.smeltItems[1] = sm1.orElse(null);
        fd.smeltItems[2] = sm2.orElse(null);
        fd.smeltItems[3] = sm3.orElse(null);
        fd.fuelItems[0] = fu0.orElse(null);
        fd.fuelItems[1] = fu1.orElse(null);
        fd.fuelItems[2] = fu2.orElse(null);
        fd.fuelItems[3] = fu3.orElse(null);
        fd.fuel = burn;
        fd.accumulatedXp = accXp.floatValue();
        return fd;
    }));

    public FurnaceData() {
        Arrays.fill(this.toSmelt, 0L);
        Arrays.fill(this.smeltItems, null);
        Arrays.fill(this.fuelItems, null);
        this.fuel = 0;
        this.accumulatedXp = 0.0f;
    }

    public CompoundTag toNbt(HolderLookup.Provider provider) {
        int i;
        CompoundTag tag = new CompoundTag();
        for (i = 0; i < 8; ++i) {
            tag.putLong("p" + i, this.toSmelt[i]);
        }
        for (i = 0; i < 8; ++i) {
            if (this.smeltItems[i] == null) continue;
            tag.put("sm" + i, (Tag)ResourceCodecs.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.smeltItems[i]).getOrThrow());
        }
        for (i = 0; i < 4; ++i) {
            if (this.fuelItems[i] == null) continue;
            tag.put("fu" + i, (Tag)ResourceCodecs.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.fuelItems[i]).getOrThrow());
        }
        tag.putInt("burn", this.fuel);
        tag.putFloat("accXp", this.accumulatedXp);
        return tag;
    }

    public static FurnaceData fromNbt(CompoundTag tag, HolderLookup.Provider provider) {
        int i;
        FurnaceData fd = new FurnaceData();
        for (i = 0; i < 8; ++i) {
            fd.toSmelt[i] = tag.getLong("p" + i);
        }
        for (i = 0; i < 8; ++i) {
            if (!tag.contains("sm" + i, 10)) continue;
            fd.smeltItems[i] = (PlatformResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("sm" + i)).getOrThrow();
        }
        for (i = 0; i < 4; ++i) {
            if (!tag.contains("fu" + i, 10)) continue;
            fd.fuelItems[i] = (PlatformResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("fu" + i)).getOrThrow();
        }
        fd.fuel = tag.getInt("burn");
        fd.accumulatedXp = tag.contains("accXp") ? tag.getFloat("accXp") : 0.0f;
        return fd;
    }
}

