/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.ButtonCategory;
import com.omnigrid.Utils.ModUtil;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.CoreItem;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.OmniGridScreen;
import com.omnigrid.neoforge.ToggleableCoreSlot;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FilterTextButton
extends AbstractWidget {
    private int value = 0;
    public int filterIndex = 0;
    public int filterPage = 0;
    public boolean disabled = false;
    private static final int LINE_HEIGHT = 9;
    private static final int ENTRY_HEIGHT = 17;
    private static final int VISIBLE_OPTIONS = 3;
    private static final int ENTRY_GAP = 1;
    private static final int MAX_ROWS = 32;
    private int type = 0;
    private static final int WIDTH = 160;
    private static final int HEIGHT = 75;
    private static final int TEXT_WIDTH = 140;
    private static final int BUTTON_SIZE = 24;
    private static final int TOP_PADDING = 2;
    private static final int BOTTOM_PADDING = 2;
    private static final int OPTIONS_Y = 20;
    private static final int ROW_HEIGHT = 9;
    private static final int VISIBLE_ROWS = 8;
    private static final int HEADER_Y = 2;
    private static final int MAX_FILTERS = 32;
    public boolean rightClick = false;
    public ButtonCategory category;
    public ItemStack ghost;
    public OmniGridScreen screen;
    public AbstractOmniGridContainerMenu menu;
    private int scrollOffset = 0;
    @Nullable
    public CoreTypes requiredCore;
    private int identifier = 0;

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    @Nullable
    public CoreTypes getRequiredCore() {
        return this.requiredCore;
    }

    public void setRequiredCore(@Nullable CoreTypes requiredCore) {
        this.requiredCore = requiredCore;
    }

    public FilterTextButton(int x, int y, OmniGridScreen screen) {
        super(x, y, 160, 75, (Component)Component.empty());
        this.screen = screen;
        this.menu = (AbstractOmniGridContainerMenu)this.screen.getMenu();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int row;
        int index;
        if (!this.screen.isTransferPanel() || this.screen.buttonCategory != ButtonCategory.FILTER) {
            return false;
        }
        if (!this.active || !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        int lx = (int)mouseX - this.getX();
        int ly = (int)mouseY - this.getY();
        ItemStack stack = this.getResource();
        if (stack.isEmpty()) {
            return true;
        }
        List<String> descriptors = OmniGridScreen.getDescriptorsAsStringList(stack);
        int maxPage = Math.max(0, (descriptors.size() - 1) / 3);
        if (lx >= 140 && ly < 24) {
            if (this.screen.filterPage > 0) {
                --this.screen.filterPage;
            }
            return true;
        }
        if (lx >= 140 && ly >= 51) {
            if (this.screen.filterPage < maxPage) {
                ++this.screen.filterPage;
            }
            return true;
        }
        if (lx < 140 && ly >= 20 && ly < 71 && (index = this.screen.filterPage * 3 + (row = (ly - 20) / 17)) >= 0 && index < descriptors.size()) {
            this.screen.filterIndex = index;
            this.screen.typeConfig();
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @Nullable
    public ItemStack getResource() {
        PlatformResourceKey res = this.screen.getCommand().getResource();
        if (res instanceof ItemResource) {
            ItemResource ir = (ItemResource)res;
            return ir.toItemStack();
        }
        return ItemStack.EMPTY;
    }

    public boolean coreInstalled() {
        if (this.requiredCore == null) {
            return true;
        }
        for (ToggleableCoreSlot coreSlot : this.menu.coreSlots) {
            CoreItem coreItem;
            Item item = coreSlot.getItem().getItem();
            if (!(item instanceof CoreItem) || (coreItem = (CoreItem)item).getCoreType() != this.requiredCore) continue;
            return true;
        }
        return false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int index;
        if (!this.screen.isTransferPanel() || this.screen.buttonCategory != ButtonCategory.FILTER) {
            return;
        }
        ItemStack stack = this.getResource();
        if (stack.isEmpty() || !this.menu.getDataClient().isCoreInstalled(CoreTypes.FILTER)) {
            guiGraphics.blitSprite(ModUtil.OmniIdentifier("widget/textbutton_unactive"), this.getX(), this.getY(), 160, 74);
            return;
        }
        guiGraphics.blitSprite(ModUtil.OmniIdentifier("widget/textbutton"), this.getX(), this.getY(), 160, 74);
        List<String> descriptors = OmniGridScreen.getDescriptorsAsStringList(stack);
        float scale = 0.66f;
        float inv = 1.0f / scale;
        if (this.screen.filterIndex >= 0 && this.screen.filterIndex < descriptors.size()) {
            this.drawTwoLineTextClamped(guiGraphics, descriptors.get(this.screen.filterIndex), this.getX(), this.getY() + 2, scale, inv);
        }
        int pageStart = this.screen.filterPage * 3;
        for (int i = 0; i < 3 && (index = pageStart + i) < descriptors.size(); ++i) {
            int yBase = this.getY() + 20 + i * 18;
            if (this.screen.filterIndex == index) {
                guiGraphics.fill(this.getX(), yBase, this.getX() + 140, yBase + 17, 0x55FF0000);
            }
            this.drawTwoLineTextClamped(guiGraphics, descriptors.get(index), this.getX(), yBase, scale, inv);
        }
    }

    private void drawTwoLineTextClamped(GuiGraphics gg, String text, int x, int yBase, float scale, float inv) {
        int maxWidth = (int)(140.0f / scale) - 6;
        Font font = Minecraft.getInstance().font;
        text = text.replace("=>", "   ");
        String[] rawWords = text.split(" ");
        ArrayList<String> words = new ArrayList<String>();
        for (String w : rawWords) {
            if (w.isEmpty()) continue;
            words.add(w);
        }
        StringBuilder[] lines = new StringBuilder[]{new StringBuilder(), new StringBuilder()};
        int lineIndex = 0;
        for (String word : words) {
            String candidate;
            if (lineIndex >= 2) break;
            StringBuilder current = lines[lineIndex];
            String string = candidate = current.length() == 0 ? word : String.valueOf(current) + " " + word;
            if (font.width(candidate) <= maxWidth) {
                if (current.length() > 0) {
                    current.append(" ");
                }
                current.append(word);
                continue;
            }
            if (++lineIndex >= 2) break;
            if (font.width(word) > maxWidth) {
                lines[lineIndex].append(font.plainSubstrByWidth(word, maxWidth));
                continue;
            }
            lines[lineIndex].append(word);
        }
        gg.pose().pushPose();
        gg.pose().scale(scale, scale, 1.0f);
        for (int i = 0; i < 2; ++i) {
            if (lines[i].length() == 0) continue;
            gg.drawString(font, lines[i].toString(), (int)((float)(x + 4) * inv), (int)(((float)(yBase + 2) + 6.0f * (float)i) * inv), -16777216, false);
        }
        gg.pose().popPose();
    }
}

