/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.omnigrid.Regulator.RestrictionMode;
import com.omnigrid.Utils.CurioStats;
import com.omnigrid.Utils.OmniBlockTargetPair;
import com.omnigrid.Utils.OmniFilterData;
import com.omnigrid.Utils.OmniPresetData;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniCommand;
import com.omnigrid.neoforge.OmniCommandData;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public class DataComponents {
    public static final DataComponents INSTANCE = new DataComponents();
    @Nullable
    private Supplier<DataComponentType<OmniCommandData>> omniCommandData;
    @Nullable
    private Supplier<DataComponentType<OmniCommand>> omniCommand;
    @Nullable
    private Supplier<DataComponentType<OmniBlockTarget>> blockTarget;
    @Nullable
    private Supplier<DataComponentType<CurioStats>> curiosData;
    @Nullable
    private Supplier<DataComponentType<RestrictionMode>> restrictionMode;
    @Nullable
    private Supplier<DataComponentType<OmniBlockTargetPair>> blockTargetPair;
    @Nullable
    private Supplier<DataComponentType<OmniFilterData>> filterData;
    @Nullable
    private Supplier<DataComponentType<List<Boolean>>> upgradeCores;
    @Nullable
    private Supplier<DataComponentType<OmniPresetData>> presetData;
    public static final Codec<List<Boolean>> UPGRADE_CORES_CODEC = Codec.BOOL.listOf().validate(list -> list.size() == 16 ? DataResult.success((Object)list) : DataResult.error(() -> "Expected exactly 16 core flags, got " + list.size()));
    public static final StreamCodec<ByteBuf, List<Boolean>> UPGRADE_CORES_STREAM_CODEC = new StreamCodec<ByteBuf, List<Boolean>>(){

        public List<Boolean> decode(ByteBuf buf) {
            int size = buf.readInt();
            if (size != 16) {
                throw new DecoderException("Expected exactly 16 core flags, got " + size);
            }
            ArrayList<Boolean> result = new ArrayList<Boolean>(16);
            for (int i = 0; i < 16; ++i) {
                result.add(buf.readBoolean());
            }
            return result;
        }

        public void encode(ByteBuf buf, List<Boolean> list) {
            if (list.size() != 16) {
                throw new EncoderException("Expected exactly 16 core flags, got " + list.size());
            }
            buf.writeInt(16);
            for (boolean b : list) {
                buf.writeBoolean(b);
            }
        }
    };
    public static final Codec<RestrictionMode> RESTRICTION_MODE_CODEC = Codec.INT.xmap(RestrictionMode::fromId, RestrictionMode::id);
    public static final StreamCodec<RegistryFriendlyByteBuf, RestrictionMode> RESTRICTION_MODE_STREAM_CODEC = StreamCodec.of((buf, value) -> buf.writeVarInt(value.ordinal()), buf -> RestrictionMode.values()[buf.readVarInt()]);
    @Nullable
    private Supplier<DataComponentType<Integer>> omniMode;

    public void setOmni(@Nullable Supplier<DataComponentType<OmniCommand>> supplier) {
        this.omniCommand = supplier;
    }

    public DataComponentType<OmniCommand> getOmni() {
        return Objects.requireNonNull(this.omniCommand).get();
    }

    public void setRestrictionMode(@Nullable Supplier<DataComponentType<RestrictionMode>> supplier) {
        this.restrictionMode = supplier;
    }

    public DataComponentType<RestrictionMode> getRestrictionMode() {
        return Objects.requireNonNull(this.restrictionMode).get();
    }

    public void setCuriosData(@Nullable Supplier<DataComponentType<CurioStats>> supplier) {
        this.curiosData = supplier;
    }

    public DataComponentType<CurioStats> getCuriosData() {
        return Objects.requireNonNull(this.curiosData).get();
    }

    public void setOmniData(@Nullable Supplier<DataComponentType<OmniCommandData>> supplier) {
        this.omniCommandData = supplier;
    }

    public DataComponentType<OmniCommandData> CData() {
        return Objects.requireNonNull(this.omniCommandData).get();
    }

    public void setLink(@Nullable Supplier<DataComponentType<OmniBlockTarget>> supplier) {
        this.blockTarget = supplier;
    }

    public DataComponentType<OmniBlockTarget> getLink() {
        return Objects.requireNonNull(this.blockTarget).get();
    }

    public void setFilterData(@Nullable Supplier<DataComponentType<OmniFilterData>> supplier) {
        this.filterData = supplier;
    }

    public DataComponentType<OmniFilterData> getFilterData() {
        return Objects.requireNonNull(this.filterData).get();
    }

    public void setPresetData(@Nullable Supplier<DataComponentType<OmniPresetData>> supplier) {
        this.presetData = supplier;
    }

    public DataComponentType<OmniPresetData> getPresetData() {
        return Objects.requireNonNull(this.presetData).get();
    }

    public void setUpgradeCores(@Nullable Supplier<DataComponentType<List<Boolean>>> supplier) {
        this.upgradeCores = supplier;
    }

    public DataComponentType<List<Boolean>> getUpgradeCores() {
        return Objects.requireNonNull(this.upgradeCores, "Upgrade cores not set").get();
    }

    public void setLinkPair(@Nullable Supplier<DataComponentType<OmniBlockTargetPair>> supplier) {
        this.blockTargetPair = supplier;
    }

    public DataComponentType<OmniBlockTargetPair> getLinkPair() {
        return Objects.requireNonNull(this.blockTargetPair).get();
    }

    public void setOmniMode(Supplier<DataComponentType<Integer>> supplier) {
        this.omniMode = supplier;
    }

    public DataComponentType<Integer> getOmniMode() {
        return Objects.requireNonNull(this.omniMode).get();
    }
}

