/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import java.util.Map;

public enum CoreTypes {
    PROVIDE,
    PULL,
    COLLECT,
    PUSH,
    BLACKLIST,
    SEARCH,
    EXTERNAL_STORAGE,
    BASIC_CRAFTING,
    REGULATE,
    LOOTING,
    PLAYER,
    LINK,
    FILTER,
    MONITOR,
    DEPOSITING,
    INVERTED,
    FURNACE,
    DISK_DRIVE,
    REMOTE,
    AUTOCRAFTING,
    NONE;

    public static final CoreTypes[] V1_BY_ID;
    public static final Map<CoreTypes, CoreTypes> V1_TO_V2_MAP;

    public static CoreTypes fromId(int id) {
        return CoreTypes.values()[id];
    }

    public int getId() {
        return this.ordinal();
    }

    public String toString() {
        String formatted = this.name().toLowerCase().replace("_", " ");
        StringBuilder sb = new StringBuilder("Omni ");
        for (String word : formatted.split(" ")) {
            if (word.isEmpty()) continue;
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        sb.append("Core");
        return sb.toString().trim();
    }

    static {
        V1_BY_ID = new CoreTypes[]{PULL, COLLECT, PUSH, BLACKLIST, SEARCH, EXTERNAL_STORAGE, BASIC_CRAFTING, REGULATE, PLAYER, LINK, FILTER, MONITOR, FURNACE, LOOTING, REMOTE, AUTOCRAFTING};
        V1_TO_V2_MAP = Map.ofEntries(Map.entry(PULL, PULL), Map.entry(COLLECT, COLLECT), Map.entry(PUSH, PUSH), Map.entry(BLACKLIST, BLACKLIST), Map.entry(SEARCH, SEARCH), Map.entry(EXTERNAL_STORAGE, EXTERNAL_STORAGE), Map.entry(BASIC_CRAFTING, BASIC_CRAFTING), Map.entry(REGULATE, REGULATE), Map.entry(PLAYER, PLAYER), Map.entry(LINK, LINK), Map.entry(FILTER, FILTER), Map.entry(MONITOR, MONITOR), Map.entry(FURNACE, FURNACE), Map.entry(LOOTING, LOOTING), Map.entry(REMOTE, REMOTE), Map.entry(AUTOCRAFTING, AUTOCRAFTING));
    }
}

