/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.ModUtil;
import com.omnigrid.neoforge.Config;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigImpl
implements Config {
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec spec;
    private final Config.OmniGridEntry omniGrid = new PortableCraftingGridEntryImpl();

    public ConfigImpl() {
        this.spec = this.builder.build();
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public Config.OmniGridEntry getOmniGrid() {
        return this.omniGrid;
    }

    private static String translationKey(String value) {
        return ModUtil.PCGTranslationKey("text.autoconfig", "option." + value);
    }

    private class PortableCraftingGridEntryImpl
    implements Config.OmniGridEntry {
        private final ModConfigSpec.LongValue energyCapacity;
        private final ModConfigSpec.LongValue openEnergyUsage;
        private final ModConfigSpec.IntValue omniRechargeNetworkRate;
        private final ModConfigSpec.IntValue itemsPerFE;
        private final ModConfigSpec.IntValue fluidPerFE;
        private final ModConfigSpec.IntValue searchPerFE;
        private final ModConfigSpec.IntValue vacuumPerFE;
        private final ModConfigSpec.IntValue compressPerFE;
        private final ModConfigSpec.BooleanValue overclockerEnabled;
        private final ModConfigSpec.DoubleValue overclockEnergyMultiplier;
        private final ModConfigSpec.IntValue overclockActivationCost;
        public ModConfigSpec.IntValue autoCraftFECost;
        public ModConfigSpec.IntValue processingFECost;
        public ModConfigSpec.BooleanValue cobblePrinterEnabled;
        public ModConfigSpec.IntValue cobbleCost;
        public ModConfigSpec.BooleanValue overclockerPlusEnabled;
        public ModConfigSpec.DoubleValue overclockerPlusEnergyMultiplier;
        public ModConfigSpec.IntValue overclockerPlusActivationCost;
        public ModConfigSpec.BooleanValue waterPrinterEnabled;
        public ModConfigSpec.IntValue waterPerFE;
        public ModConfigSpec.BooleanValue fireExtEnabled;
        public ModConfigSpec.IntValue fireExtFECost;
        public ModConfigSpec.IntValue fireExtCostPlayer;
        public ModConfigSpec.IntValue fireExtCostLavaSrc;
        public ModConfigSpec.IntValue fireExtCostFire;
        public ModConfigSpec.IntValue fireExtCostFlowing;
        public ModConfigSpec.BooleanValue spongeEnabled;
        public ModConfigSpec.IntValue spongeFECost;
        public ModConfigSpec.IntValue spongeMaxAbsorb;
        public ModConfigSpec.IntValue spongeExtraPerStack;
        public ModConfigSpec.BooleanValue curiosEnabled;
        public ModConfigSpec.DoubleValue curiosPowerMultiplier;
        public ModConfigSpec.BooleanValue depositEnabled;
        public ModConfigSpec.IntValue depositFECost;
        public ModConfigSpec.BooleanValue lootEnabled;
        public ModConfigSpec.IntValue lootFECost;
        public ModConfigSpec.IntValue monitorUpdateRate;
        public ModConfigSpec.DoubleValue monitorPenalty;
        public ModConfigSpec.IntValue monitorEnergyCost;
        public ModConfigSpec.IntValue energyPerTask;
        public ModConfigSpec.BooleanValue constructorCoreEnabled;
        public ModConfigSpec.IntValue constructorCoreFECost;
        public ModConfigSpec.IntValue proxyEnergyUsage;
        public ModConfigSpec.IntValue proxyBaseRange;
        public ModConfigSpec.IntValue proxyExtraRangePerUpgrade;
        public ModConfigSpec.BooleanValue proxyEnergyUpgrade;
        public ModConfigSpec.BooleanValue proxyRangeUpgrade;
        public ModConfigSpec.BooleanValue proxyAccessor;
        public ModConfigSpec.BooleanValue furnaceCost;
        public ModConfigSpec.DoubleValue furnacePenalty;

        PortableCraftingGridEntryImpl() {
            ConfigImpl.this.builder.translation(ConfigImpl.translationKey("omniGrid")).push("omniGrid");
            this.energyCapacity = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("omniGrid.energyCapacity")).defineInRange("energyCapacity", 10000L, 0L, Long.MAX_VALUE);
            this.openEnergyUsage = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("omniGrid.openEnergyUsage")).defineInRange("openEnergyUsage", 10L, 0L, Long.MAX_VALUE);
            this.omniRechargeNetworkRate = this.simpleInteger("The Omni Grid recharges itself off adjacent networks while placed. How much FE per tick should it take from the network?", 1000);
            ConfigImpl.this.builder.push("Energy Penalties");
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("CommandCosts");
            this.itemsPerFE = this.simpleInteger("Items moved per 1 FE (Push/Pull)", 8);
            this.fluidPerFE = this.simpleInteger("mB moved per 1 FE (Push/Pull)", 250);
            this.compressPerFE = this.simpleInteger("Compressions per 1 FE", 8);
            this.vacuumPerFE = this.simpleInteger("Items extracted per 1 FE (Collect)", 4);
            this.searchPerFE = this.simpleInteger("Items picked up per 1 FE (Search)", 4);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Monitor");
            this.monitorUpdateRate = this.simpleInteger("Monitor update interval in ticks (20 = 1s)", 60);
            this.monitorPenalty = this.simpleDouble("Energy consumption increased per monitored resource", 0.2);
            this.monitorEnergyCost = this.simpleInteger("Updating a monitors resource drains this much energy", 10);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Crafting");
            ConfigImpl.this.builder.push("Autocrafting");
            this.autoCraftFECost = this.simpleInteger("FE cost per autocraft operation", 10);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Processing");
            this.processingFECost = this.simpleInteger("FE cost per processing operation", 2);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Energy Penalties");
            this.furnaceCost = this.simpleBoolean("Drain FE when running the furnace ontop of fuel cost?", true);
            this.furnacePenalty = this.simpleDouble("Increase energy consumption while furnace is active by", 0.2);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Utility Cores");
            ConfigImpl.this.builder.push("CobblePrinter");
            this.cobblePrinterEnabled = this.simpleBoolean("Enable Cobble Printer utility item?", true);
            this.cobbleCost = this.simpleInteger("FE cost to print 1 cobblestone", 5);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("WaterPrinter");
            this.waterPrinterEnabled = this.simpleBoolean("Enable Water Source utility item?", true);
            this.waterPerFE = this.simpleInteger("How many mB of water are produced per 1 FE?", 100);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("FireExtinguisher");
            this.fireExtEnabled = this.simpleBoolean("Enable Fire Extinguisher utility item?", true);
            this.fireExtFECost = this.simpleInteger("FE cost per extinguish action", 25);
            this.fireExtCostPlayer = this.simpleInteger("Water cost to extinguish burning player", 100);
            this.fireExtCostLavaSrc = this.simpleInteger("Water cost to extinguish a lava source block", 500);
            this.fireExtCostFire = this.simpleInteger("Water cost to extinguish regular fire", 50);
            this.fireExtCostFlowing = this.simpleInteger("Water cost to extinguish flowing lava", 250);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Sponge");
            this.spongeEnabled = this.simpleBoolean("Enable Sponge utility item?", true);
            this.spongeFECost = this.simpleInteger("FE cost per block absorbed", 100);
            this.spongeMaxAbsorb = this.simpleInteger("Maximum blocks absorbed per activation", 16);
            this.spongeExtraPerStack = this.simpleInteger("Extra absorbable blocks per stack upgrade", 8);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Curios");
            this.curiosEnabled = this.simpleBoolean("Enable Curios utility item?", true);
            this.curiosPowerMultiplier = this.simpleDouble("Multiplier applied to curios effects (decimal)", 1.0);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("DepositUtility");
            this.depositEnabled = this.simpleBoolean("Enable Deposit utility?", true);
            this.depositFECost = this.simpleInteger("FE cost per deposit action", 10);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("LootUtility");
            this.lootEnabled = this.simpleBoolean("Enable Loot utility?", true);
            this.lootFECost = this.simpleInteger("FE cost per loot pickup", 10);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("ConstructorCore");
            this.constructorCoreEnabled = this.simpleBoolean("Enable Constructor Core utility item?", true);
            this.constructorCoreFECost = this.simpleInteger("FE cost per block placement by Constructor Core", 40);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Monitor");
            this.monitorUpdateRate = this.simpleInteger("Monitor update rate in ticks (20 = 1 second)", 100);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("Overclocker");
            this.overclockerEnabled = this.simpleBoolean("Enable the Omni Overclocker item?", true);
            this.overclockerPlusEnabled = this.simpleBoolean("Enable the Omni-Potent Overclocker? (Permanent version)", true);
            this.overclockEnergyMultiplier = this.simpleDouble("While overclocked, multiply all FE consumption by this value", 4.0);
            this.overclockActivationCost = this.simpleInteger("Initial FE cost when activating the overclocker", 500);
            ConfigImpl.this.builder.pop();
            this.energyPerTask = this.simpleInteger("When transferring energy to and from the Omni Grid via Refined Types Energy disks, max energy transfer per task cycle before stack/energy upgrades.", 1000);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("OmniStorageProxy");
            this.proxyEnergyUsage = this.simpleInteger("FE used per tick while connected to a network", 10);
            this.proxyBaseRange = this.simpleInteger("Omni Grid can provide storage within this many blocks", 16);
            this.proxyExtraRangePerUpgrade = this.simpleInteger("Extra range in blocks per range upgrade in the Omni Grid", 16);
            this.proxyEnergyUpgrade = this.simpleBoolean("Energy consumption affected by linked Omni Grid's energy upgrades?", true);
            this.proxyRangeUpgrade = this.simpleBoolean("Energy consumption affected by linked Omni Grid's range upgrades?", true);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.push("OmniProxyAccessor");
            this.proxyAccessor = this.simpleBoolean("Enable the Universal Proxy Accessor Core?", true);
            ConfigImpl.this.builder.pop();
            ConfigImpl.this.builder.pop();
        }

        public ModConfigSpec.IntValue simpleInteger(String name, int def) {
            return ConfigImpl.this.builder.defineInRange(name, def, 0, Integer.MAX_VALUE);
        }

        public ModConfigSpec.DoubleValue simpleDouble(String name, double def) {
            return ConfigImpl.this.builder.defineInRange(name, def, 0.0, Double.MAX_VALUE);
        }

        public ModConfigSpec.BooleanValue simpleBoolean(String name, boolean def) {
            return ConfigImpl.this.builder.define(name, def);
        }

        @Override
        public long getEnergyCapacity() {
            return (Long)this.energyCapacity.get();
        }

        @Override
        public long getOpenEnergyUsage() {
            return (Long)this.openEnergyUsage.get();
        }

        @Override
        public long omniNetworkChargeRate() {
            return ((Integer)this.omniRechargeNetworkRate.get()).intValue();
        }

        @Override
        public int itemsPerFE() {
            return (Integer)this.itemsPerFE.get();
        }

        @Override
        public int fluidPerFE() {
            return (Integer)this.fluidPerFE.get();
        }

        @Override
        public int vacuumPerFE() {
            return (Integer)this.vacuumPerFE.get();
        }

        @Override
        public int searchPerFE() {
            return (Integer)this.searchPerFE.get();
        }

        @Override
        public int compressPerFE() {
            return (Integer)this.compressPerFE.get();
        }

        @Override
        public boolean cobblePrinterEnabled() {
            return (Boolean)this.cobblePrinterEnabled.get();
        }

        @Override
        public int cobbleCost() {
            return (Integer)this.cobbleCost.get();
        }

        @Override
        public boolean waterPrinterEnabled() {
            return (Boolean)this.waterPrinterEnabled.get();
        }

        @Override
        public int waterPerFE() {
            return (Integer)this.waterPerFE.get();
        }

        @Override
        public boolean fireExtEnabled() {
            return (Boolean)this.fireExtEnabled.get();
        }

        @Override
        public int fireExtFECost() {
            return (Integer)this.fireExtFECost.get();
        }

        @Override
        public int fireExtCostPlayer() {
            return (Integer)this.fireExtCostPlayer.get();
        }

        @Override
        public int fireExtCostLavaSrc() {
            return (Integer)this.fireExtCostLavaSrc.get();
        }

        @Override
        public int fireExtCostFire() {
            return (Integer)this.fireExtCostFire.get();
        }

        @Override
        public int fireExtCostFlowing() {
            return (Integer)this.fireExtCostFlowing.get();
        }

        @Override
        public boolean spongeEnabled() {
            return (Boolean)this.spongeEnabled.get();
        }

        @Override
        public int spongeFECost() {
            return (Integer)this.spongeFECost.get();
        }

        @Override
        public int spongeMaxAbsorb() {
            return (Integer)this.spongeMaxAbsorb.get();
        }

        @Override
        public int spongeExtraPerStack() {
            return (Integer)this.spongeExtraPerStack.get();
        }

        @Override
        public boolean curiosEnabled() {
            return (Boolean)this.curiosEnabled.get();
        }

        @Override
        public double curiosPowerMultiplier() {
            return (Double)this.curiosPowerMultiplier.get();
        }

        @Override
        public boolean depositEnabled() {
            return (Boolean)this.depositEnabled.get();
        }

        @Override
        public int quarryDepositFE() {
            return (Integer)this.depositFECost.get();
        }

        @Override
        public boolean lootEnabled() {
            return (Boolean)this.lootEnabled.get();
        }

        @Override
        public int mobDepositFE() {
            return (Integer)this.lootFECost.get();
        }

        @Override
        public int autoCraftFECost() {
            return (Integer)this.autoCraftFECost.get();
        }

        @Override
        public int processingFECost() {
            return (Integer)this.processingFECost.get();
        }

        @Override
        public int monitorUpdateRate() {
            return (Integer)this.monitorUpdateRate.get();
        }

        @Override
        public boolean constructorCoreEnabled() {
            return (Boolean)this.constructorCoreEnabled.get();
        }

        @Override
        public int constructorCoreFECost() {
            return (Integer)this.constructorCoreFECost.get();
        }

        @Override
        public boolean overclockerEnabled() {
            return (Boolean)this.overclockerEnabled.get();
        }

        @Override
        public double overclockEnergyMultiplier() {
            return (Double)this.overclockEnergyMultiplier.get();
        }

        @Override
        public int overclockActivationCost() {
            return (Integer)this.overclockActivationCost.get();
        }

        @Override
        public boolean overclockerPlusEnabled() {
            return (Boolean)this.overclockerPlusEnabled.get();
        }

        @Override
        public int getProxyEnergyUsage() {
            return (Integer)this.proxyEnergyUsage.get();
        }

        @Override
        public int getProxyBaseRange() {
            return (Integer)this.proxyBaseRange.get();
        }

        @Override
        public int getProxyExtraRangePerUpgrade() {
            return (Integer)this.proxyExtraRangePerUpgrade.get();
        }

        @Override
        public boolean getProxyAccessor() {
            return (Boolean)this.proxyAccessor.get();
        }

        @Override
        public int getMonitorCost() {
            return (Integer)this.monitorEnergyCost.get();
        }
    }
}

