/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeGroup;

public class ComplexBaker
extends SimpleBakedModel {
    public ComplexBaker(List<BakedQuad> unculledFaces, Map<Direction, List<BakedQuad>> culledFaces, boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, TextureAtlasSprite particleIcon, ItemTransforms transforms, ItemOverrides overrides) {
        super(unculledFaces, culledFaces, hasAmbientOcclusion, usesBlockLight, isGui3d, particleIcon, transforms, overrides);
    }

    public boolean isCustomRenderer() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<BakedQuad> unculledFaces = Lists.newArrayList();
        private final Map<Direction, List<BakedQuad>> culledFaces = Maps.newEnumMap(Direction.class);
        private final ItemOverrides overrides;
        private final boolean hasAmbientOcclusion;
        private TextureAtlasSprite particleIcon;
        private final boolean usesBlockLight;
        private final boolean isGui3d;
        private final ItemTransforms transforms;

        public Builder(BlockModel blockModel, ItemOverrides overrides, boolean isGui3d) {
            this(blockModel.hasAmbientOcclusion(), blockModel.getGuiLight().lightLikeBlock(), isGui3d, blockModel.getTransforms(), overrides);
        }

        public Builder(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, ItemOverrides overrides) {
            for (Direction direction : Direction.values()) {
                this.culledFaces.put(direction, Lists.newArrayList());
            }
            this.overrides = overrides;
            this.hasAmbientOcclusion = hasAmbientOcclusion;
            this.usesBlockLight = usesBlockLight;
            this.isGui3d = isGui3d;
            this.transforms = transforms;
        }

        public Builder addCulledFace(Direction facing, BakedQuad quad) {
            this.culledFaces.get(facing).add(quad);
            return this;
        }

        public Builder addUnculledFace(BakedQuad quad) {
            this.unculledFaces.add(quad);
            return this;
        }

        public Builder particle(TextureAtlasSprite particleIcon) {
            this.particleIcon = particleIcon;
            return this;
        }

        public Builder item() {
            return this;
        }

        @Deprecated
        public BakedModel build() {
            return this.build(RenderTypeGroup.EMPTY);
        }

        public BakedModel build(RenderTypeGroup renderTypes) {
            if (this.particleIcon == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new ComplexBaker(this.unculledFaces, this.culledFaces, this.hasAmbientOcclusion, this.usesBlockLight, this.isGui3d, this.particleIcon, this.transforms, this.overrides);
        }
    }
}

