/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.omnigrid.Utils.ButtonCategory;
import com.omnigrid.Utils.ModUtil;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.ClientModInitializer;
import com.omnigrid.neoforge.CoreItem;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.OmniGridScreen;
import com.omnigrid.neoforge.ToggleableCoreSlot;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class CommandConfigurationButton
extends AbstractWidget {
    private int value = 0;
    private final ResourceLocation[] sprites;
    public boolean disabled = false;
    private boolean useAnySprites = false;
    public int colorslot = -1;
    private ResourceLocation[] anySprites;
    private final Consumer<CommandConfigurationButton> onPressHandler;
    private int dataIndex = 0;
    private int type = 0;
    public boolean rightClick = false;
    public ButtonCategory category;
    public ItemStack ghost;
    public OmniGridScreen screen;
    public AbstractOmniGridContainerMenu menu;
    public boolean requiresBooster = false;
    @Nullable
    public CoreTypes requiredCore;
    private int identifier = 0;

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public ResourceLocation[] getAnySprites() {
        return this.anySprites;
    }

    public void setAnySprites(ResourceLocation[] anySprites) {
        this.anySprites = anySprites;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    @Nullable
    public CoreTypes getRequiredCore() {
        return this.requiredCore;
    }

    public void setRequiredCore(@Nullable CoreTypes requiredCore) {
        this.requiredCore = requiredCore;
    }

    public ResourceLocation[] getSprites() {
        return this.sprites;
    }

    public CommandConfigurationButton(int x, int y, int width, int height, ResourceLocation[] sprites, int dataIndex, Consumer<CommandConfigurationButton> onPressHandler, int type, int identifier, OmniGridScreen screen, ButtonCategory category) {
        super(x, y, width, height, (Component)Component.empty());
        if (sprites == null || sprites.length == 0) {
            throw new IllegalArgumentException("Sprite array cannot be null or empty");
        }
        this.dataIndex = dataIndex;
        this.sprites = sprites;
        this.onPressHandler = onPressHandler;
        this.type = type;
        this.identifier = identifier;
        this.screen = screen;
        this.menu = (AbstractOmniGridContainerMenu)this.screen.getMenu();
        this.category = category;
    }

    public int getValue() {
        return this.value;
    }

    public int getDataIndex() {
        return this.dataIndex;
    }

    public void setValue(int value) {
        this.value = (value % this.sprites.length + this.sprites.length) % this.sprites.length;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active || this.screen.buttonCategory != this.category || this.requiredCore == CoreTypes.NONE) {
            return false;
        }
        if (this.requiresBooster && !this.menu.isUtilityInstalled(UtilityType.REMOTE_BOOSTER)) {
            return false;
        }
        if (this.isMouseOver(mouseX, mouseY) && this.isActive()) {
            int old = this.value++;
            if (!this.coreInstalled()) {
                this.value = 0;
                return true;
            }
            if (button == 0) {
                if (this.value >= this.sprites.length) {
                    this.value = 0;
                }
            } else if (button == 1) {
                --this.value;
                this.rightClick = true;
                if (this.value < 0) {
                    this.value = this.sprites.length - 1;
                }
            }
            this.onPressHandler.accept(this);
            this.rightClick = false;
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return false;
    }

    public boolean coreInstalled() {
        if (this.requiredCore == null) {
            return true;
        }
        for (ToggleableCoreSlot coreSlot : this.menu.coreSlots) {
            CoreItem coreItem;
            Item item = coreSlot.getItem().getItem();
            if (!(item instanceof CoreItem) || (coreItem = (CoreItem)item).getCoreType() != this.requiredCore) continue;
            return true;
        }
        return false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.active || this.screen.buttonCategory != this.category || this.requiredCore == CoreTypes.NONE) {
            return;
        }
        if (this.requiresBooster && !this.menu.isUtilityInstalled(UtilityType.REMOTE_BOOSTER)) {
            return;
        }
        ResourceLocation sprite = this.sprites[this.value];
        if (sprite == null) {
            return;
        }
        boolean selected = this.type == 0 && this.value > 0 && !this.disabled;
        boolean fillRed = false;
        if (this.colorslot > -1) {
            int color = ClientModInitializer.getColorForSlot(this.colorslot, selected);
            if (!selected) {
                color = CommandConfigurationButton.brightenColor(color, 0.5f);
                color = CommandConfigurationButton.saturateColor(color, 0.2f);
            } else {
                color = CommandConfigurationButton.saturateColor(color, 0.5f);
                color = CommandConfigurationButton.brightenColor(color, 0.2f);
            }
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            guiGraphics.setColor(r, g, b, a);
        } else if (this.value > 0) {
            if (this.type != 1) {
                fillRed = true;
            }
        } else {
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        guiGraphics.blitSprite(ModUtil.OmniIdentifier("widget/none"), this.getX(), this.getY(), this.width, this.height);
        if (this.type == 0 && this.value > 0) {
            guiGraphics.pose().pushPose();
            fillRed = true;
            if (this.ghost != null && !this.ghost.is(Items.AIR)) {
                this.renderGhostItem(guiGraphics);
            } else {
                guiGraphics.blitSprite(this.sprites[0], this.getX(), this.getY(), this.width, this.height);
            }
            guiGraphics.pose().popPose();
        } else if (this.ghost != null && !this.ghost.is(Items.AIR)) {
            this.renderGhostItem(guiGraphics);
        } else {
            guiGraphics.blitSprite(sprite, this.getX(), this.getY(), this.width, this.height);
        }
        if (fillRed) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 150.0f);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
            guiGraphics.blitSprite(ModUtil.OmniIdentifier("widget/selection"), this.getX(), this.getY(), this.width, this.height);
            guiGraphics.pose().popPose();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
        if (this.requiredCore != null && !this.coreInstalled()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.setColor(0.0f, 0.0f, 0.0f, 0.55f);
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -2013265920);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.8f);
            guiGraphics.blitSprite(ModUtil.OmniIdentifier("widget/locked_icon"), this.getX(), this.getY(), this.width, this.height);
            guiGraphics.pose().popPose();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.disabled) {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, Integer.MIN_VALUE);
        }
    }

    public void renderGhostItem(GuiGraphics guiGraphics) {
        float scale = 0.8f;
        int iconSize = 16;
        float centerX = (float)this.getX() + (float)this.width / 2.0f;
        float centerY = (float)this.getY() + (float)this.height / 2.0f;
        float drawX = centerX - (float)iconSize * scale / 2.0f;
        float drawY = centerY - (float)iconSize * scale / 2.0f;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(drawX + offsetX, drawY + offsetY, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.renderItem(this.ghost, 0, 0);
        guiGraphics.pose().popPose();
    }

    @Nullable
    public Tooltip getTooltip() {
        if (this.requiresBooster && !this.menu.isUtilityInstalled(UtilityType.REMOTE_BOOSTER)) {
            return null;
        }
        if (this.requiredCore == CoreTypes.NONE) {
            return null;
        }
        if (!this.coreInstalled() && this.requiredCore != null) {
            return Tooltip.create((Component)Component.literal((String)("Requires " + String.valueOf((Object)this.requiredCore))));
        }
        return super.getTooltip();
    }

    private static int desaturateColor(int argb, float amount) {
        amount = Math.max(0.0f, Math.min(1.0f, amount));
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        float gray = 0.3f * (float)r + 0.59f * (float)g + 0.11f * (float)b;
        int rr = (int)((float)r * (1.0f - amount) + gray * amount);
        int gg = (int)((float)g * (1.0f - amount) + gray * amount);
        int bb = (int)((float)b * (1.0f - amount) + gray * amount);
        return a << 24 | rr << 16 | gg << 8 | bb;
    }

    private static int saturateColor(int argb, float amount) {
        amount = Math.max(0.0f, Math.min(1.0f, amount));
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        float gray = 0.3f * (float)r + 0.59f * (float)g + 0.11f * (float)b;
        int rr = (int)(gray + ((float)r - gray) * (1.0f + amount));
        int gg = (int)(gray + ((float)g - gray) * (1.0f + amount));
        int bb = (int)(gray + ((float)b - gray) * (1.0f + amount));
        rr = Math.min(255, Math.max(0, rr));
        gg = Math.min(255, Math.max(0, gg));
        bb = Math.min(255, Math.max(0, bb));
        return a << 24 | rr << 16 | gg << 8 | bb;
    }

    private static int brightenColor(int argb, float amount) {
        amount = Math.max(0.0f, Math.min(1.0f, amount));
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        int rr = (int)((float)r + (float)(255 - r) * amount);
        int gg = (int)((float)g + (float)(255 - g) * amount);
        int bb = (int)((float)b + (float)(255 - b) * amount);
        return a << 24 | rr << 16 | gg << 8 | bb;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

