/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.omnigrid.StorageProxy.OmniFilterScreen;
import com.omnigrid.StorageProxy.OmniProxyRemoteItem;
import com.omnigrid.StorageProxy.ResourceChestScreen;
import com.omnigrid.Utils.ModUtil;
import com.omnigrid.Utils.OmniPortScreen;
import com.omnigrid.Utils.QuantityIndicator;
import com.omnigrid.Utils.ResourceTooltipRenderer;
import com.omnigrid.Utils.ResourceTrackerTooltipComponent;
import com.omnigrid.Utils.UtilityBundle;
import com.omnigrid.customRender.OmniGridBlockEntityRenderer;
import com.omnigrid.neoforge.AbstractClientModInitializer;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.AbstractOmniGridEntity;
import com.omnigrid.neoforge.BlockEntities;
import com.omnigrid.neoforge.ClientResourceTracker;
import com.omnigrid.neoforge.ContentIds;
import com.omnigrid.neoforge.ContentNames;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.KeyMappings;
import com.omnigrid.neoforge.Menus;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridModelLoader;
import com.omnigrid.neoforge.OmniGridScreen;
import com.omnigrid.neoforge.OmniTransferEffect;
import com.omnigrid.neoforge.PickBlockRequest;
import com.omnigrid.neoforge.StopServerMenuPacket;
import com.omnigrid.neoforge.UpdateTracker;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.options.VideoSettingsScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ClientModInitializer
extends AbstractClientModInitializer {
    private static float walkTime = 0.0f;
    public static float bobIntensityX = 3.0f;
    public static float bobIntensityY = 4.0f;
    public static float bobSpeed = 5.0f;
    public static float bobSprintMultiplier = 1.7f;
    public static float bobPhaseOffset = 0.0f;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientModInitializer.class);
    private static final RateLimiter effectIncrementer = RateLimiter.create((double)5.0);
    private static float incrementer = 0.0f;
    public static Vector2f mhPos;
    public static Vector2f ohPos;
    private static final Map<Direction, Vec3[]> FACE_CORNERS;
    private static boolean cachedBob;
    private static boolean overrideActive;
    private static boolean lastHasOmni;
    private static long omniSuppressUntilMs;
    private static Class<?> lastBlockedMenu;
    private static long lastBlockTime;
    private static boolean wasAlive;
    public static final int[] SLOT_COLORS;

    @SubscribeEvent
    public static void registerLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ModUtil.OmniIdentifier("omni_grid_loader"), (IGeometryLoader)new OmniGridModelLoader());
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        ClientModInitializer.handleInputEvents();
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.player.containerMenu != mc.player.inventoryMenu) {
            return;
        }
        if (event.getButton() != 2 || event.getAction() != 1) {
            return;
        }
        HitResult hit = mc.hitResult;
        if (hit == null) {
            return;
        }
        ItemStack picked = ItemStack.EMPTY;
        switch (hit.getType()) {
            case BLOCK: {
                BlockHitResult bhr = (BlockHitResult)hit;
                ClientLevel level = mc.level;
                BlockPos pos = bhr.getBlockPos();
                BlockState state = level.getBlockState(pos);
                picked = state.getCloneItemStack((HitResult)bhr, (LevelReader)level, pos, (Player)mc.player);
                break;
            }
            case ENTITY: {
                EntityHitResult ehr = (EntityHitResult)hit;
                Entity entity = ehr.getEntity();
                picked = entity.getPickedResult(hit);
                break;
            }
            default: {
                return;
            }
        }
        if (picked == null || picked.isEmpty()) {
            return;
        }
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new PickBlockRequest(picked));
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(RegisterMenuScreensEvent e) {
        e.register(Menus.INSTANCE.getPortableCraftingGridItem(), OmniGridScreen::new);
        e.register(Menus.INSTANCE.getPortableCraftingGridBlock(), OmniGridScreen::new);
        e.register(Menus.INSTANCE.getOmniProxyRemote(), OmniPortScreen::new);
        e.register(Menus.INSTANCE.getResourceChestContainerMenu(), ResourceChestScreen::new);
        e.register(Menus.INSTANCE.getOmniFilterData(), OmniFilterScreen::new);
    }

    @SubscribeEvent
    public static void registerTooltipExtensions(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ResourceTrackerTooltipComponent.class, ResourceTooltipRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientModInitializer.registerBlockEntityRenderer();
    }

    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent e) {
        e.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return QuantityIndicator.getINSTANCE();
            }
        }, new Item[]{Items.INSTANCE.getOmniGrid()});
    }

    @SubscribeEvent
    public static void onRenderHud(RenderGuiEvent.Post event) {
        boolean shouldOverride;
        boolean hasCurio;
        BlockHitResult look;
        BlockPos pos;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Options opts = mc.options;
        GuiGraphics gui = event.getGuiGraphics();
        Level level = player.level();
        BlockEntity be = level.getBlockEntity(pos = (look = ClientModInitializer.getLookedAtBlock((Player)player, level, 64.0)).getBlockPos());
        if (be instanceof AbstractOmniGridEntity) {
            ClientResourceTracker tracker;
            UUID ref;
            AbstractOmniGridEntity grid = (AbstractOmniGridEntity)be;
            double dist = player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            if (dist > 32.0 && (ref = grid.getStorageReference()) != null && (tracker = UpdateTracker.CLIENT_TRACKERS.get(ref)) != null) {
                ClientModInitializer.renderOmniDistantHud(gui, tracker);
            }
        }
        boolean hasMain = player.getMainHandItem().getItem() instanceof OmniGridBlockItem;
        boolean hasOff = player.getOffhandItem().getItem() instanceof OmniGridBlockItem;
        ClientResourceTracker curioTracker = ClientModInitializer.getCuriosOmniGrid((Player)player, false);
        boolean bl = hasCurio = curioTracker != null;
        if (!(hasMain || hasOff || hasCurio)) {
            return;
        }
        boolean canRenderHandHUD = QuantityIndicator.mhPos != null || QuantityIndicator.ohPos != null;
        float moveDelta = player.walkDist - player.walkDistO;
        boolean moving = Math.abs(moveDelta) > 0.001f;
        boolean currentBob = (Boolean)opts.bobView().get();
        Screen screen = mc.screen;
        long nowMs = Util.getMillis();
        if (screen instanceof OptionsScreen || screen instanceof VideoSettingsScreen) {
            cachedBob = currentBob;
        }
        boolean hasOmni = hasMain || hasOff || hasCurio;
        boolean bl2 = shouldOverride = hasOmni && moving;
        if (shouldOverride && !overrideActive) {
            if (cachedBob) {
                opts.bobView().set((Object)false);
            }
            overrideActive = true;
        }
        if (!shouldOverride && overrideActive) {
            opts.bobView().set((Object)cachedBob);
            overrideActive = false;
        }
        if (hasOmni && !lastHasOmni) {
            omniSuppressUntilMs = nowMs + 500L;
        }
        lastHasOmni = hasOmni;
        if (hasOmni && nowMs < omniSuppressUntilMs) {
            return;
        }
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        float targetY = (float)screenH * 0.75f;
        float xIncrement = (float)screenW * 0.01f;
        float yIncrement = (float)screenH * 0.02f;
        if (hasCurio && curioTracker != null) {
            ClientModInitializer.renderCuriosOmniHud(gui, mc, curioTracker, false);
            ClientResourceTracker curioTracker2 = ClientModInitializer.getCuriosOmniGrid((Player)player, true);
            if (curioTracker2 != null) {
                ClientModInitializer.renderCuriosOmniHud(gui, mc, curioTracker2, true);
            }
        }
        if (canRenderHandHUD) {
            int iconY;
            int iconX;
            String formatted;
            long count;
            Optional<PlatformResourceKey> opt;
            int i;
            float baseY;
            float baseX;
            UUID id;
            ClientResourceTracker tracker;
            if (hasOff && (tracker = UpdateTracker.CLIENT_TRACKERS.get(id = (UUID)player.getOffhandItem().get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()))) != null && QuantityIndicator.ohPos != null) {
                baseX = QuantityIndicator.ohPos.x - xIncrement * 10.0f;
                baseY = targetY;
                for (i = 0; i < 4; ++i) {
                    opt = tracker.resource(i);
                    if (opt.isEmpty()) continue;
                    count = tracker.count(i);
                    formatted = QuantityIndicator.formatQuantity(count);
                    iconX = (int)(baseX + (float)i * (xIncrement * 5.0f));
                    iconY = (int)(baseY - (float)i * yIncrement);
                    ClientModInitializer.renderResource(gui, iconX, iconY, opt.get());
                    gui.drawString(mc.font, formatted, (int)((float)iconX + xIncrement), (int)((float)iconY + yIncrement * 4.0f), 0xFFFFFF, false);
                }
            }
            if (hasMain && (tracker = UpdateTracker.CLIENT_TRACKERS.get(id = (UUID)player.getMainHandItem().get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()))) != null && QuantityIndicator.mhPos != null) {
                baseX = QuantityIndicator.mhPos.x + xIncrement * 15.0f;
                baseY = targetY - yIncrement;
                for (i = 0; i < 4; ++i) {
                    opt = tracker.resource(i);
                    if (opt.isEmpty()) continue;
                    count = tracker.count(i);
                    formatted = QuantityIndicator.formatQuantity(count);
                    iconX = (int)(baseX - (float)i * (xIncrement * 5.0f));
                    iconY = (int)(baseY - (float)i * yIncrement);
                    ClientModInitializer.renderResource(gui, iconX, iconY, opt.get());
                    gui.drawString(mc.font, formatted, (int)((float)iconX + xIncrement), (int)((float)iconY + yIncrement * 4.0f), 0xFFFFFF, false);
                }
            }
        }
    }

    private static void renderCuriosOmniHud(GuiGraphics gui, Minecraft mc, ClientResourceTracker tracker, boolean second) {
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        int hotbarX = second ? screenW / 2 + 150 : screenW / 2 - 91;
        int hotbarY = screenH - 16;
        HumanoidArm mainHand = (HumanoidArm)mc.options.mainHand().get();
        int offX = mainHand == HumanoidArm.RIGHT ? hotbarX - 26 : hotbarX + 182;
        int offY = hotbarY;
        PoseStack pose = gui.pose();
        float scale = 0.6f;
        float iconScale = 1.2f;
        int iconSize = 16;
        int padding = 4;
        int bgW = iconSize * 2 + padding * 3;
        int bgH = iconSize * 2 + padding * 3;
        int hudX = offX - (int)((float)bgW * scale) - 6;
        int hudY = offY - (int)((float)bgH * scale / 2.0f);
        pose.pushPose();
        pose.translate((float)hudX, (float)hudY, 300.0f);
        pose.scale(scale, scale, 1.0f);
        gui.fill(0, 0, bgW, bgH, 0x77222222);
        gui.fill(-1, -1, bgW + 1, 0, -16777216);
        gui.fill(-1, bgH, bgW + 1, bgH + 1, -16777216);
        gui.fill(-1, 0, 0, bgH, -16777216);
        gui.fill(bgW, 0, bgW + 1, bgH, -16777216);
        for (int i = 0; i < 4; ++i) {
            Optional<PlatformResourceKey> opt = tracker.resource(i);
            if (opt.isEmpty()) continue;
            int row = i / 2;
            int col = i % 2;
            int iconX = padding + col * (iconSize + padding);
            int iconY = padding + row * (iconSize + padding);
            pose.pushPose();
            pose.translate((float)iconX + (float)iconSize / 2.0f, (float)iconY + (float)iconSize / 2.0f, 0.0f);
            pose.scale(iconScale, iconScale, 1.0f);
            pose.translate((float)(-iconSize) / 2.0f, (float)(-iconSize) / 2.0f, 0.0f);
            ClientModInitializer.renderResource(gui, 0, 0, opt.get());
            pose.popPose();
            long count = tracker.count(i);
            String txt = QuantityIndicator.formatQuantity(count);
            float scaledW = (float)iconSize * iconScale;
            float scaledH = (float)iconSize * iconScale;
            float iconCenterX = (float)iconX + scaledW / 2.0f;
            float iconBottomY = (float)iconY + scaledH;
            int textX = (int)(iconCenterX - (float)mc.font.width(txt) / 2.0f);
            int textY = (int)(iconBottomY + 1.0f) - iconSize / 2;
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 350.0f);
            gui.drawString(mc.font, txt, textX + 1, textY + 1, -1442840576, false);
            gui.drawString(mc.font, txt, textX, textY, 0xFFFFFF, false);
            pose.popPose();
        }
        pose.popPose();
    }

    public static void renderResource(GuiGraphics graphics, int x, int y, PlatformResourceKey resourceKey) {
        ResourceRendering renderer = RefinedStorageClientApi.INSTANCE.getResourceRendering(resourceKey.getClass());
        renderer.render((ResourceKey)resourceKey, graphics, x, y);
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent e) {
        KeyMapping openPortableGrid = new KeyMapping(ContentNames.OPEN_omni_grid_TRANSLATION_KEY, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "mod.omnigrid");
        e.register(openPortableGrid);
        KeyMappings.INSTANCE.setOpenPortableCraftingGrid(openPortableGrid);
    }

    @SubscribeEvent
    public static void onScreenOpening(ScreenEvent.Opening event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        Screen screen = event.getScreen();
        Boolean stop = false;
        for (Boolean bool : OmniGridBlockItem.stopClient.values()) {
            if (!bool.booleanValue()) continue;
            stop = true;
            break;
        }
        if (stop == null || !stop.booleanValue()) {
            return;
        }
        if (!(screen instanceof ContainerScreen)) {
            return;
        }
        if (!(mc.player.containerMenu instanceof ChestMenu)) {
            return;
        }
        AbstractContainerMenu menu = mc.player.containerMenu;
        if (menu.getClass() == lastBlockedMenu && System.currentTimeMillis() - lastBlockTime < 500L) {
            event.setCanceled(true);
            return;
        }
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new StopServerMenuPacket());
        event.setCanceled(true);
        lastBlockedMenu = menu.getClass();
        lastBlockTime = System.currentTimeMillis();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        boolean alive = mc.player.isAlive();
        if (!alive && wasAlive) {
            for (UUID uuid : OmniGridBlockItem.stopClient.keySet()) {
                OmniGridBlockItem.stopClient.put(uuid, false);
            }
        }
        wasAlive = alive;
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Level level = player.level();
        OmniTransferEffect.Process();
        PoseStack poseStack = event.getPoseStack();
        incrementer += 0.01f;
        if (incrementer >= 1.0f) {
            incrementer = 0.0f;
        }
        BufferBuilder buffer1 = ClientModInitializer.beginSpriteBatch(ModUtil.OmniIdentifier("textures/particle/rs.png"));
        for (OmniTransferEffect effect : OmniTransferEffect.clientEffects) {
            for (int i = 0; i < 4; ++i) {
                ClientModInitializer.addBlockToBatch(buffer1, poseStack, mc.gameRenderer.getMainCamera(), level, effect.blockPos, incrementer, i, effect.active, effect.color);
            }
        }
        ClientModInitializer.endSpriteBatch(buffer1);
        OmniBlockTarget[] blockTargets = null;
        ItemStack item = player.getMainHandItem();
        if ((item.getItem() instanceof OmniGridBlockItem || item.getItem() instanceof OmniProxyRemoteItem) && item.has(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference())) {
            blockTargets = OmniGridBlockItem.CLIENT_BLOCK_TARGETS.get(item.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()));
        } else if (item.getItem() instanceof UtilityBundle && item.has(DataComponents.INSTANCE.getLink())) {
            blockTargets = new OmniBlockTarget[]{(OmniBlockTarget)item.get(DataComponents.INSTANCE.getLink())};
        } else {
            BlockHitResult result = ClientModInitializer.getLookedAtBlock((Player)player, level, 8.0);
            BlockEntity be = level.getBlockEntity(result.getBlockPos());
            if (be instanceof AbstractOmniGridEntity) {
                AbstractOmniGridEntity entity = (AbstractOmniGridEntity)be;
                if (entity.getStorageReference() == null) {
                    return;
                }
                blockTargets = OmniGridBlockItem.CLIENT_BLOCK_TARGETS.get(entity.getStorageReference());
            }
        }
        if (blockTargets == null) {
            return;
        }
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buffer = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (int slot = 0; slot < blockTargets.length; ++slot) {
            OmniBlockTarget target = blockTargets[slot];
            if (target == null) continue;
            BlockPos pos = target.getPosition();
            Direction face = target.getDirection();
            int color = ClientModInitializer.getColorForSlot(slot, false);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = 0.4f;
            double x = (double)pos.getX() - camPos.x;
            double y = (double)pos.getY() - camPos.y;
            double z = (double)pos.getZ() - camPos.z;
            Matrix4f matrix = poseStack.last().pose();
            Vec3[] corners = ClientModInitializer.getFaceCorners(face);
            ClientModInitializer.addQuadBothSides(buffer, matrix, x, y, z, corners, r, g, b, a);
        }
        MeshData mesh = buffer.build();
        if (mesh != null) {
            BufferUploader.drawWithShader((MeshData)mesh);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static Vec3[] getFaceCorners(Direction face) {
        Vec3[] vec3Array;
        switch (face) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: {
                Vec3[] vec3Array2 = new Vec3[4];
                vec3Array2[0] = new Vec3(0.0, 1.0, 0.0);
                vec3Array2[1] = new Vec3(1.0, 1.0, 0.0);
                vec3Array2[2] = new Vec3(1.0, 1.0, 1.0);
                vec3Array = vec3Array2;
                vec3Array2[3] = new Vec3(0.0, 1.0, 1.0);
                break;
            }
            case DOWN: {
                Vec3[] vec3Array3 = new Vec3[4];
                vec3Array3[0] = new Vec3(0.0, 0.0, 0.0);
                vec3Array3[1] = new Vec3(1.0, 0.0, 0.0);
                vec3Array3[2] = new Vec3(1.0, 0.0, 1.0);
                vec3Array = vec3Array3;
                vec3Array3[3] = new Vec3(0.0, 0.0, 1.0);
                break;
            }
            case NORTH: {
                Vec3[] vec3Array4 = new Vec3[4];
                vec3Array4[0] = new Vec3(0.0, 0.0, 0.0);
                vec3Array4[1] = new Vec3(1.0, 0.0, 0.0);
                vec3Array4[2] = new Vec3(1.0, 1.0, 0.0);
                vec3Array = vec3Array4;
                vec3Array4[3] = new Vec3(0.0, 1.0, 0.0);
                break;
            }
            case SOUTH: {
                Vec3[] vec3Array5 = new Vec3[4];
                vec3Array5[0] = new Vec3(0.0, 0.0, 1.0);
                vec3Array5[1] = new Vec3(1.0, 0.0, 1.0);
                vec3Array5[2] = new Vec3(1.0, 1.0, 1.0);
                vec3Array = vec3Array5;
                vec3Array5[3] = new Vec3(0.0, 1.0, 1.0);
                break;
            }
            case WEST: {
                Vec3[] vec3Array6 = new Vec3[4];
                vec3Array6[0] = new Vec3(0.0, 0.0, 0.0);
                vec3Array6[1] = new Vec3(0.0, 0.0, 1.0);
                vec3Array6[2] = new Vec3(0.0, 1.0, 1.0);
                vec3Array = vec3Array6;
                vec3Array6[3] = new Vec3(0.0, 1.0, 0.0);
                break;
            }
            case EAST: {
                Vec3[] vec3Array7 = new Vec3[4];
                vec3Array7[0] = new Vec3(1.0, 0.0, 0.0);
                vec3Array7[1] = new Vec3(1.0, 0.0, 1.0);
                vec3Array7[2] = new Vec3(1.0, 1.0, 1.0);
                vec3Array = vec3Array7;
                vec3Array7[3] = new Vec3(1.0, 1.0, 0.0);
            }
        }
        return vec3Array;
    }

    private static void addQuadBothSides(BufferBuilder buffer, Matrix4f matrix, double x, double y, double z, Vec3[] corners, float r, float g, float b, float a) {
        for (Vec3 corner : corners) {
            buffer.addVertex(matrix, (float)(corner.x + x), (float)(corner.y + y), (float)(corner.z + z)).setColor(r, g, b, a);
        }
        for (int i = corners.length - 1; i >= 0; --i) {
            Vec3 corner = corners[i];
            buffer.addVertex(matrix, (float)(corner.x + x), (float)(corner.y + y), (float)(corner.z + z)).setColor(r, g, b, a);
        }
    }

    public static BufferBuilder beginSpriteBatch(ResourceLocation spriteTexture) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)spriteTexture);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        return buffer;
    }

    public static void endSpriteBatch(BufferBuilder buffer) {
        MeshData mesh = buffer.build();
        if (mesh != null) {
            BufferUploader.drawWithShader((MeshData)mesh);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void addBlockToBatch(BufferBuilder buffer, PoseStack poseStack, Camera camera, Level level, BlockPos pos, float slideProgress, int sideIndex, boolean active, int color) {
        Vec3 c;
        int i;
        float[][] fArrayArray;
        float vBase;
        Vec3 camPos = camera.getPosition();
        Matrix4f matrix = poseStack.last().pose();
        double x = (double)pos.getX() - camPos.x;
        double y = (double)pos.getY() - camPos.y;
        double z = (double)pos.getZ() - camPos.z;
        Direction face = switch (sideIndex & 3) {
            case 0 -> Direction.NORTH;
            case 1 -> Direction.EAST;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.WEST;
            default -> Direction.NORTH;
        };
        float frameWidth = 0.5f;
        float frameHeight = 0.04347826f;
        float alpha = 0.6f;
        if (!active) {
            slideProgress = 1.0f - slideProgress;
            alpha *= 0.7f;
        }
        float u0 = Mth.clamp((float)slideProgress, (float)0.0f, (float)1.0f) * 0.5f;
        float u1 = u0 + 0.5f;
        int effectIndex = Mth.clamp((int)color, (int)0, (int)22);
        float v0 = vBase = (float)effectIndex * 0.04347826f;
        float v1 = vBase + 0.04347826f;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        Vec3[] base = FACE_CORNERS.get(face);
        Vec3[] corners = new Vec3[4];
        double yScale = active ? 1.0 : 0.5;
        for (int i2 = 0; i2 < 4; ++i2) {
            Vec3 c2 = base[i2];
            corners[i2] = new Vec3(c2.x, c2.y * yScale, c2.z);
        }
        switch (face) {
            case NORTH: {
                float[][] fArrayArray2 = new float[4][];
                fArrayArray2[0] = new float[]{u0, v1};
                fArrayArray2[1] = new float[]{u1, v1};
                fArrayArray2[2] = new float[]{u1, v0};
                fArrayArray = fArrayArray2;
                fArrayArray2[3] = new float[]{u0, v0};
                break;
            }
            case SOUTH: {
                float[][] fArrayArray3 = new float[4][];
                fArrayArray3[0] = new float[]{u1, v1};
                fArrayArray3[1] = new float[]{u0, v1};
                fArrayArray3[2] = new float[]{u0, v0};
                fArrayArray = fArrayArray3;
                fArrayArray3[3] = new float[]{u1, v0};
                break;
            }
            case EAST: {
                float[][] fArrayArray4 = new float[4][];
                fArrayArray4[0] = new float[]{u0, v1};
                fArrayArray4[1] = new float[]{u1, v1};
                fArrayArray4[2] = new float[]{u1, v0};
                fArrayArray = fArrayArray4;
                fArrayArray4[3] = new float[]{u0, v0};
                break;
            }
            case WEST: {
                float[][] fArrayArray5 = new float[4][];
                fArrayArray5[0] = new float[]{u1, v1};
                fArrayArray5[1] = new float[]{u0, v1};
                fArrayArray5[2] = new float[]{u0, v0};
                fArrayArray = fArrayArray5;
                fArrayArray5[3] = new float[]{u1, v0};
                break;
            }
            default: {
                float[][] fArrayArray6 = new float[4][];
                fArrayArray6[0] = new float[]{u0, v1};
                fArrayArray6[1] = new float[]{u1, v1};
                fArrayArray6[2] = new float[]{u1, v0};
                fArrayArray = fArrayArray6;
                fArrayArray6[3] = new float[]{u0, v0};
            }
        }
        float[][] uvs = fArrayArray;
        for (i = 0; i < 4; ++i) {
            c = corners[i];
            buffer.addVertex(matrix, (float)(c.x + x), (float)(c.y + y), (float)(c.z + z)).setUv(uvs[i][0], uvs[i][1]).setColor(r, g, b, alpha);
        }
        for (i = 3; i >= 0; --i) {
            c = corners[i];
            buffer.addVertex(matrix, (float)(c.x + x), (float)(c.y + y), (float)(c.z + z)).setUv(uvs[i][0], uvs[i][1]).setColor(r, g, b, alpha);
        }
    }

    public static void registerBlockEntityRenderer() {
        BlockEntityRenderers.register(BlockEntities.INSTANCE.getOmniGrid(), OmniGridBlockEntityRenderer::new);
    }

    public static BlockHitResult getLookedAtBlock(Player player, Level level, double reachDistance) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getLookAngle();
        Vec3 end = eyePos.add(lookVec.scale(reachDistance));
        return level.clip(new ClipContext(eyePos, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public static int getColorForSlot(int slot, boolean selected) {
        int base = SLOT_COLORS[slot % SLOT_COLORS.length];
        return base;
    }

    private static void renderOmniDistantHud(GuiGraphics gui, ClientResourceTracker tracker) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack pose = gui.pose();
        ArrayList<PlatformResourceKey> resources = new ArrayList<PlatformResourceKey>();
        ArrayList<Long> counts = new ArrayList<Long>();
        for (int i = 0; i < 4; ++i) {
            Optional<PlatformResourceKey> opt = tracker.resource(i);
            if (!opt.isPresent()) continue;
            resources.add(opt.get());
            counts.add(tracker.count(i));
        }
        if (resources.isEmpty()) {
            return;
        }
        int ICON_SIZE = 16;
        int SPACING = 2;
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int iconY = (int)((float)screenHeight * 0.3f);
        int textY = iconY + 16 + 1;
        int totalWidth = resources.size() * 18 - 2;
        int xStart = (screenWidth - totalWidth) / 2;
        int padX = 2;
        int padY = 1;
        int textHeight = 6;
        int bgLeft = xStart - padX;
        int bgRight = xStart + totalWidth + padX;
        int bgTop = iconY - padY;
        int bgBottom = textY + textHeight + padY;
        gui.fill(bgLeft, bgTop, bgRight, bgBottom, -2011028958);
        gui.fill(bgLeft - 1, bgTop - 1, bgRight + 1, bgBottom + 1, -1442840576);
        int x = xStart;
        for (int i = 0; i < resources.size(); ++i) {
            ClientModInitializer.renderResourceHUD(gui, x, iconY, textY, (PlatformResourceKey)resources.get(i), (Long)counts.get(i));
            x += 18;
        }
    }

    @Nullable
    public static ClientResourceTracker getCuriosOmniGrid(Player player, boolean second) {
        if (!ModList.get().isLoaded("curios") || CuriosApi.getCuriosInventory((LivingEntity)player).isEmpty()) {
            return null;
        }
        for (int i = 0; i < ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).getEquippedCurios().getSlots(); ++i) {
            ItemStack itemstack = ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).getEquippedCurios().getStackInSlot(i);
            if (itemstack.getItem() != Items.INSTANCE.getOmniGrid() || !itemstack.has(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()) || !UpdateTracker.CLIENT_TRACKERS.containsKey(itemstack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()))) continue;
            if (second) {
                second = false;
                continue;
            }
            return UpdateTracker.CLIENT_TRACKERS.get(itemstack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()));
        }
        return null;
    }

    private static void renderResourceHUD(GuiGraphics gui, int x, int iconY, int textY, PlatformResourceKey resource, long count) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack pose = gui.pose();
        ItemStack stack = ItemStack.EMPTY;
        if (resource instanceof ItemResource) {
            ItemResource itemRes = (ItemResource)resource;
            stack = itemRes.toItemStack();
        }
        float iconScale = 0.6f;
        pose.pushPose();
        pose.translate((float)(x + 8), (float)(iconY + 8), 0.0f);
        pose.scale(iconScale, iconScale, iconScale);
        pose.translate((float)(-(x + 8)), (float)(-(iconY + 8)), 0.0f);
        gui.renderItem(stack, x, iconY);
        pose.popPose();
        float textScale = 0.6f;
        String text = QuantityIndicator.formatQuantity(count);
        float scaledWidth = (float)mc.font.width(text) * textScale;
        float textX = (float)(x + 8) - scaledWidth / 2.0f;
        float textYf = textY;
        pose.pushPose();
        pose.translate(textX, textYf, 300.0f);
        pose.scale(textScale, textScale, textScale);
        gui.drawString(mc.font, text, 1, 1, 0x55000000);
        gui.drawString(mc.font, text, 0, 0, 0xFFFFFF);
        pose.popPose();
    }

    @SubscribeEvent
    public static void onRegisterCustomModels(ModelEvent.RegisterGeometryLoaders e) {
        e.register(ContentIds.omni_grid, (IGeometryLoader)new OmniGridModelLoader());
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key e) {
        ClientModInitializer.handleInputEvents();
    }

    @Nullable
    public static UUID getStorageReferenceForClient() {
        BlockEntity blockEntity;
        Vec3 lookVec;
        Vec3 reach;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return null;
        }
        Vec3 eyePos = mc.player.getEyePosition();
        ClipContext context = new ClipContext(eyePos, reach = eyePos.add((lookVec = mc.player.getLookAngle()).scale(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)mc.player);
        BlockHitResult result = mc.level.clip(context);
        if (mc.level.getBlockEntity(result.getBlockPos()) != null && (blockEntity = mc.level.getBlockEntity(result.getBlockPos())) instanceof AbstractOmniGridBlockEntity) {
            AbstractOmniGridBlockEntity be = (AbstractOmniGridBlockEntity)blockEntity;
            return be.getStorageReference();
        }
        return null;
    }

    static {
        FACE_CORNERS = Map.of(Direction.UP, new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(1.0, 1.0, 1.0), new Vec3(0.0, 1.0, 1.0)}, Direction.DOWN, new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0)}, Direction.NORTH, new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 0.0)}, Direction.SOUTH, new Vec3[]{new Vec3(0.0, 0.0, 1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(0.0, 1.0, 1.0)}, Direction.WEST, new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 1.0, 0.0)}, Direction.EAST, new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 1.0, 0.0)});
        cachedBob = true;
        overrideActive = false;
        lastHasOmni = false;
        omniSuppressUntilMs = 0L;
        lastBlockedMenu = null;
        lastBlockTime = 0L;
        wasAlive = true;
        SLOT_COLORS = new int[]{-2130771968, -2147418368, -2147483393, -2130706688, -2130771713, -2147418113, -2130729728, -2139094912, -2147450752, -2138356461, -2139062144, -2130706433};
    }
}

