/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.refinedmods.refinedstorage.common.grid.AutocraftableResourceHint;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

class AutocraftableClientTooltipComponent
implements ClientTooltipComponent {
    private static final ResourceLocation ICON = IdentifierUtil.createIdentifier((String)"grid/craftable");
    private static final int ICON_SIZE = 9;
    private static final int ICON_MARGIN = 4;
    private static final Component AUTOCRAFTABLE = IdentifierUtil.createTranslation((String)"gui", (String)"grid.autocraftable");
    private static final Component PATTERN_IN_INVENTORY = IdentifierUtil.createTranslation((String)"gui", (String)"grid.pattern_in_inventory");
    private static final Component EMPTY = IdentifierUtil.createTranslation((String)"gui", (String)"grid.click_to_autocraft");
    private static final Component EXISTING = IdentifierUtil.createTranslation((String)"gui", (String)"grid.ctrl_click_to_autocraft");
    private final Component text;

    private AutocraftableClientTooltipComponent(Component text) {
        this.text = text;
    }

    static AutocraftableClientTooltipComponent autocraftable(AutocraftableResourceHint hint) {
        return new AutocraftableClientTooltipComponent(hint == AutocraftableResourceHint.AUTOCRAFTABLE ? AUTOCRAFTABLE : PATTERN_IN_INVENTORY);
    }

    static AutocraftableClientTooltipComponent empty() {
        return new AutocraftableClientTooltipComponent(EMPTY);
    }

    static AutocraftableClientTooltipComponent existing() {
        return new AutocraftableClientTooltipComponent(EXISTING);
    }

    public int getHeight() {
        return 11;
    }

    public int getWidth(Font font) {
        return 13 + (int)((float)font.width((FormattedText)this.text) * 0.7f);
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        int yOffset = SmallText.isSmall() ? 2 : 0;
        SmallText.render((Font)font, (FormattedCharSequence)this.text.getVisualOrderText(), (int)(x + 9 + 4), (int)(y + yOffset), (int)10452816, (Matrix4f)matrix, (MultiBufferSource.BufferSource)bufferSource, (float)0.7f);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        graphics.blitSprite(ICON, x, y, 9, 9);
    }
}

