/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.ModUtil;
import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.SynchronizationModeSideButtonWidget;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.AutocraftableClientTooltipComponent;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.GridSearchBoxWidget;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniRootStorage;
import com.omnigrid.neoforge.ResourceTypeSideButtonWidget;
import com.omnigrid.neoforge.SortingDirectionSideButtonWidget;
import com.omnigrid.neoforge.SortingTypeSideButtonWidget;
import com.omnigrid.neoforge.ViewTypeSideButtonWidget;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.AutocraftableResourceHint;
import com.refinedmods.refinedstorage.common.grid.NoopGridSynchronizer;
import com.refinedmods.refinedstorage.common.grid.view.ItemGridResource;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSize;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.AutoSelectedSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighter;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighterColors;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOmniGridScreen<T extends AbstractOmniGridContainerMenu>
extends AbstractStretchingScreen<T> {
    protected static final int CLEAR_BUTTON_SIZE = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOmniGridScreen.class);
    private static final int MIN_ROWS = 3;
    private static final ResourceLocation ROW_SPRITE = ModUtil.OmniIdentifier("row");
    private static final int MODIFIED_JUST_NOW_MAX_SECONDS = 10;
    private static final int ROW_PADDING = 3;
    private static final int OMNI_COLUMNS = 10;
    private static final int DISABLED_SLOT_COLOR = -10790053;
    private static final List<String> SEARCH_FIELD_HISTORY = new ArrayList<String>();
    private static final int INVENTORY_INCLUDING_TITLE_HEIGHT = 99;
    private GridResource heldResource = null;
    private long holdStartTime = 0L;
    private boolean isHolding = false;
    private static final long HOLD_THRESHOLD_MS = 500L;
    private static final int REPEAT_RATE_TICKS = 2;
    private int repeatTickCounter = 0;
    protected final int bottomHeight;
    @Nullable
    public GridSearchBoxWidget searchField;
    private int totalRows;
    private int currentGridSlotIndex;
    private int visibleRows;
    @Nullable
    public ScrollbarWidget sb;
    private static final ItemStack GHOST_CRAFTING = new ItemStack((ItemLike)Items.CRAFTING_TABLE);

    protected AbstractOmniGridScreen(T menu, Inventory playerInventory, Component title, int bottomHeight) {
        super(menu, playerInventory, new TextMarquee(title, 70));
        this.bottomHeight = bottomHeight;
    }

    private int calculateVisibleRows() {
        int screenSpaceAvailable = (int)((float)(this.height - 19) - (float)this.getBottomHeight() / 1.5f);
        int maxRows = this.getMaxRows();
        return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, maxRows));
    }

    private int getMaxRows() {
        return switch (Platform.INSTANCE.getConfig().getScreenSize()) {
            case ScreenSize.STRETCH -> Platform.INSTANCE.getConfig().getMaxRowsStretch();
            case ScreenSize.SMALL -> 3;
            case ScreenSize.MEDIUM -> 5;
            case ScreenSize.LARGE -> 8;
            case ScreenSize.EXTRA_LARGE -> 12;
            default -> throw new MatchException(null, null);
        };
    }

    @Nullable
    private ScrollbarWidget findScrollbarFromSuper() {
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof ScrollbarWidget)) continue;
            ScrollbarWidget sb = (ScrollbarWidget)child;
            return sb;
        }
        return null;
    }

    public void ssInit() {
        this.visibleRows = this.calculateVisibleRows();
        this.imageHeight = 19 + 18 * this.visibleRows + this.getBottomHeight();
        this.inventoryLabelY = this.imageHeight - 99 + 4;
        this.resize();
        this.clearWidgets();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.init(this.visibleRows);
        this.addSideButton((AbstractSideButtonWidget)new ScreenSizeSideButtonWidget((AbstractStretchingScreen)this));
        boolean onlyHasNoopSynchronizer = RefinedStorageApi.INSTANCE.getGridSynchronizerRegistry().getAll().stream().allMatch(synchronizer -> synchronizer == NoopGridSynchronizer.INSTANCE);
        if (!onlyHasNoopSynchronizer) {
            this.addSideButton(new SynchronizationModeSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
            this.searchField.addListener(this::trySynchronizeFromGrid);
        }
    }

    private void trySynchronizeFromGrid(String text) {
        ((AbstractOmniGridContainerMenu)this.getMenu()).getSynchronizer().synchronizeFromGrid(text);
    }

    protected void containerTick() {
        super.containerTick();
        this.trySynchronizeToGrid();
    }

    private void trySynchronizeToGrid() {
        if (this.searchField == null) {
            return;
        }
        String text = ((AbstractOmniGridContainerMenu)this.getMenu()).getSynchronizer().getTextToSynchronizeToGrid();
        if (text == null || this.searchField.getValue().equals(text)) {
            return;
        }
        this.searchField.setValue(text);
    }

    protected void init() {
        this.visibleRows = this.calculateVisibleRows();
        this.imageHeight = 19 + 18 * this.visibleRows + this.getBottomHeight();
        this.inventoryLabelY = this.imageHeight - 99 + 4;
        this.imageHeight = 19 + 18 * this.visibleRows + this.getBottomHeight();
        this.inventoryLabelY = this.imageHeight - 99 + 4;
        this.resize();
        this.ssInit();
        this.sb = this.findScrollbarFromSuper();
        if (this.sb != null) {
            this.sb.setX(this.leftPos + 174 + 18);
            this.sb.setHeight(this.visibleRows * 18 - 2);
        } else {
            this.sb = new ScrollbarWidget(this.leftPos + 174 + 18, this.topPos + 20, ScrollbarWidget.Type.NORMAL, this.visibleRows * 18 - 2);
            this.sb.setListener(offset -> this.scrollbarChanged(this.visibleRows));
            this.addWidget((GuiEventListener)this.sb);
            this.addRenderableWidget((GuiEventListener)this.sb);
        }
        this.init(this.visibleRows);
    }

    protected List<ClientTooltipComponent> getResourceSlotTooltip(ResourceKey resource, ResourceSlot slot) {
        List tooltip = super.getResourceSlotTooltip(resource, slot);
        return tooltip;
    }

    protected void init(int rows) {
        LOGGER.debug("Initializing grid screen - this shouldn't happen too much!");
        if (this.searchField == null) {
            this.searchField = new GridSearchBoxWidget(this.font, this.leftPos + 94 + 1, this.topPos + 6 + 1, 67, new SyntaxHighlighter(SyntaxHighlighterColors.DEFAULT_COLORS), new History(SEARCH_FIELD_HISTORY));
        } else {
            this.searchField.setX(this.leftPos + 94 + 1);
            this.searchField.setY(this.topPos + 6 + 1);
        }
        ((AbstractOmniGridContainerMenu)this.getMenu()).setSearchBox(this.searchField);
        ((AbstractOmniGridContainerMenu)this.getMenu()).getRepository().setListener(this::updateScrollbar);
        this.updateScrollbar();
        this.addWidget((GuiEventListener)this.searchField);
        for (Renderable renderable : this.renderables) {
            if (!(renderable instanceof ViewTypeSideButtonWidget)) continue;
            return;
        }
        this.addSideButton(new ViewTypeSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
        this.addSideButton(new ResourceTypeSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
        this.addSideButton(new SortingDirectionSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
        this.addSideButton(new SortingTypeSideButtonWidget((AbstractGridContainerMenu)this.getMenu()));
        this.addSideButton((AbstractSideButtonWidget)new AutoSelectedSideButtonWidget((SearchFieldWidget)this.searchField));
        if (((AbstractOmniGridContainerMenu)this.getMenu()).hasProperty(PropertyTypes.REDSTONE_MODE)) {
            this.addSideButton((AbstractSideButtonWidget)new RedstoneModeSideButtonWidget(((AbstractOmniGridContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (this.isOverStorageArea(x, y)) {
            this.renderOverStorageAreaTooltip(graphics, x, y);
        }
        if (((AbstractOmniGridContainerMenu)this.getMenu()).getCarried().isEmpty()) {
            // empty if block
        }
        if (((AbstractOmniGridContainerMenu)this.getMenu()).getCarried().isEmpty() && this.tryRenderAutocraftableResourceHintTooltip(graphics, x, y)) {
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    private void renderOverStorageAreaTooltip(GuiGraphics graphics, int x, int y) {
        GridResource gridResource = this.getCurrentGridResource();
        if (gridResource != null) {
            this.renderHoveredResourceTooltip(graphics, x, y, gridResource);
            return;
        }
        ItemStack carried = ((AbstractOmniGridContainerMenu)this.getMenu()).getCarried();
        if (carried.isEmpty()) {
            return;
        }
        List hints = RefinedStorageClientApi.INSTANCE.getGridInsertionHints().getHints(carried);
        Platform.INSTANCE.renderTooltip(graphics, hints, x, y);
    }

    private void renderHoveredResourceTooltip(GuiGraphics graphics, int mouseX, int mouseY, GridResource resource) {
        Integer queued;
        PlatformResourceKey key;
        FluidResource fr;
        PlatformResourceKey platformResourceKey;
        ItemStack itemStack;
        if (resource instanceof ItemGridResource) {
            ItemGridResource itemResource = (ItemGridResource)resource;
            itemStack = itemResource.getItemStack();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        ItemStack stackContext = itemStack;
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>(resource.getTooltip());
        if (((AbstractOmniGridContainerMenu)this.menu).getCarried().isEmpty() && ((AbstractOmniGridContainerMenu)this.menu).isUtilityInstalled(UtilityType.XP_HANLDER) && (platformResourceKey = resource.getResourceForRecipeMods()) instanceof FluidResource && (fr = (FluidResource)platformResourceKey).fluid().is(OmniItemProxxy.XP_TAG)) {
            lines.add(Component.literal((String)"Right click to take XP").withStyle(ChatFormatting.GREEN));
        }
        if ((key = resource.getResourceForRecipeMods()) != null && (queued = ((AbstractOmniGridContainerMenu)this.menu).craftingMap.get(key)) != null) {
            if (queued <= 0) {
                ((AbstractOmniGridContainerMenu)this.menu).craftingMap.remove(key);
            } else {
                lines.add(Component.literal((String)("Quened: " + queued)).withStyle(ChatFormatting.GREEN));
            }
        }
        List processedLines = Platform.INSTANCE.processTooltipComponents(stackContext, graphics, mouseX, resource.getTooltipImage(), lines);
        long amount = resource.getAmount(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository());
        if (amount > 0L && Platform.INSTANCE.getConfig().getGrid().isDetailedTooltip()) {
            this.addDetailedTooltip(resource, processedLines);
        }
        if (resource.isAutocraftable(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository()) || ((AbstractOmniGridContainerMenu)this.getMenu()).isOmniAutocraftable(resource)) {
            processedLines.add(amount == 0L ? AutocraftableClientTooltipComponent.empty() : AutocraftableClientTooltipComponent.existing());
        }
        if (amount > 0L) {
            processedLines.addAll(resource.getExtractionHints(((AbstractOmniGridContainerMenu)this.getMenu()).getCarried(), ((AbstractOmniGridContainerMenu)this.getMenu()).getRepository()));
        }
        Platform.INSTANCE.renderTooltip(graphics, processedLines, mouseX, mouseY);
    }

    private void addDetailedTooltip(GridResource resource, List<ClientTooltipComponent> lines) {
        String amountInTooltip = resource.getAmountInTooltip(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository());
        lines.add((ClientTooltipComponent)new SmallTextClientTooltipComponent((Component)IdentifierUtil.createTranslation((String)"misc", (String)"total", (Object[])new Object[]{amountInTooltip}).withStyle(ChatFormatting.GRAY)));
        TrackedResource trackedResource = resource.getTrackedResource(arg_0 -> ((AbstractOmniGridContainerMenu)((AbstractOmniGridContainerMenu)this.getMenu())).getTrackedResource(arg_0));
        if (trackedResource != null) {
            lines.add((ClientTooltipComponent)new SmallTextClientTooltipComponent((Component)this.getLastModifiedText(trackedResource).withStyle(ChatFormatting.GRAY)));
        }
    }

    private boolean tryStartAutocrafting(GridResource resource) {
        ResourceAmount request = resource.getAutocraftingRequest();
        if (request == null) {
            return false;
        }
        RefinedStorageClientApi.INSTANCE.openAutocraftingPreview(List.of(request), (Screen)this);
        return true;
    }

    private MutableComponent getLastModifiedText(TrackedResource trackedResource) {
        boolean plural;
        LastModified lastModified = LastModified.calculate(trackedResource.getTime(), System.currentTimeMillis());
        if (this.isModifiedJustNow(lastModified)) {
            return IdentifierUtil.createTranslation((String)"misc", (String)"last_modified.just_now", (Object[])new Object[]{trackedResource.getSourceName()});
        }
        Object translationKey = lastModified.type().toString().toLowerCase();
        boolean bl = plural = lastModified.amount() != 1L;
        if (plural) {
            translationKey = (String)translationKey + "s";
        }
        return IdentifierUtil.createTranslation((String)"misc", (String)("last_modified." + (String)translationKey), (Object[])new Object[]{lastModified.amount(), trackedResource.getSourceName()});
    }

    private boolean isModifiedJustNow(LastModified lastModified) {
        return lastModified.type() == LastModified.Type.SECOND && lastModified.amount() <= 10L;
    }

    public boolean checkCraftingCore(GridResource resource) {
        if (!((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().isCoreInstalled(CoreTypes.AUTOCRAFTING)) {
            return false;
        }
        return this.tryStartAutocrafting(resource);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        ItemStack carriedStack = ((AbstractOmniGridContainerMenu)this.getMenu()).getCarried();
        GridResource resource = this.getCurrentGridResource();
        if (this.canExtract(resource, carriedStack)) {
            this.mouseClickedInGrid(clickedButton, resource);
            return true;
        }
        if (this.canInsert((int)mouseX, (int)mouseY, clickedButton, carriedStack)) {
            this.mouseClickedInGrid(clickedButton);
            return true;
        }
        if (resource != null && (resource.isAutocraftable(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository()) || ((AbstractOmniGridContainerMenu)this.getMenu()).isOmniAutocraftable(resource)) && this.checkCraftingCore(resource)) {
            return true;
        }
        if (this.sb != null && this.sb.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    public void mouseMoved(double mx, double my) {
        if (this.sb != null) {
            this.sb.mouseMoved(mx, my);
        }
        super.mouseMoved(mx, my);
    }

    private boolean tryRenderAutocraftableResourceHintTooltip(GuiGraphics graphics, int x, int y) {
        if (this.hoveredSlot == null || !this.hoveredSlot.hasItem()) {
            return false;
        }
        AutocraftableResourceHint hint = ((AbstractOmniGridContainerMenu)this.getMenu()).getAutocraftableResourceHint(this.hoveredSlot);
        if (hint == null) {
            return false;
        }
        ItemStack stack = this.hoveredSlot.getItem();
        List lines = this.getTooltipFromContainerItem(stack);
        List processedLines = Platform.INSTANCE.processTooltipComponents(stack, graphics, x, stack.getTooltipImage(), lines);
        processedLines.add(AutocraftableClientTooltipComponent.autocraftable(hint));
        Platform.INSTANCE.renderTooltip(graphics, processedLines, x, y);
        return true;
    }

    private void mouseClickedInGrid(int clickedButton) {
        GridInsertMode mode = clickedButton == 1 ? GridInsertMode.SINGLE_RESOURCE : GridInsertMode.ENTIRE_RESOURCE;
        boolean tryAlternatives = clickedButton == 1;
        ((AbstractOmniGridContainerMenu)this.getMenu()).onInsert(mode, tryAlternatives);
    }

    protected void mouseClickedInGrid(int clickedButton, GridResource resource) {
        resource.onExtract(AbstractOmniGridScreen.getExtractMode(clickedButton), AbstractOmniGridScreen.shouldExtractToCursor(), (GridExtractionStrategy)this.getMenu());
        this.heldResource = resource;
        this.isHolding = true;
        this.holdStartTime = System.currentTimeMillis();
        this.repeatTickCounter = 0;
    }

    public boolean mouseReleased(double mx, double my, int button) {
        this.isHolding = false;
        this.heldResource = null;
        return super.mouseReleased(mx, my, button);
    }

    private static GridExtractMode getExtractMode(int clickedButton) {
        if (clickedButton == 1) {
            return GridExtractMode.HALF_RESOURCE;
        }
        return GridExtractMode.ENTIRE_RESOURCE;
    }

    private static boolean shouldExtractToCursor() {
        return !Screen.hasShiftDown();
    }

    public void rapidExtraction() {
        if (!this.isHolding || this.heldResource == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.holdStartTime < 500L) {
            return;
        }
        ++this.repeatTickCounter;
        if (this.repeatTickCounter < 2) {
            return;
        }
        this.repeatTickCounter = 0;
        if (!this.getResourceList().contains(this.heldResource)) {
            this.isHolding = false;
            this.heldResource = null;
            return;
        }
        if (RefinedTypesUtil.rtInstalled() && this.heldResource.belongsToResourceType(EnergyResource.createEnergyResource().getResourceType())) {
            this.heldResource.onExtract(GridExtractMode.ENTIRE_RESOURCE, AbstractOmniGridScreen.shouldExtractToCursor(), (GridExtractionStrategy)this.getMenu());
        }
    }

    @Nullable
    public GridResource getCurrentGridResource() {
        if (this.currentGridSlotIndex < 0) {
            return null;
        }
        List<GridResource> viewList = this.getResourceList();
        if (this.currentGridSlotIndex >= viewList.size()) {
            return null;
        }
        return viewList.get(this.currentGridSlotIndex);
    }

    private boolean canExtract(@Nullable GridResource resource, ItemStack carriedStack) {
        return resource != null && resource.canExtract(carriedStack, ((AbstractOmniGridContainerMenu)this.getMenu()).getRepository()) && !AbstractOmniGridScreen.hasControlDown();
    }

    private boolean canInsert(int mouseX, int mouseY, int clickedButton, ItemStack carriedStack) {
        return this.isOverStorageArea(mouseX, mouseY) && !carriedStack.isEmpty() && (clickedButton == 0 || clickedButton == 1);
    }

    private void synchronizeToGrid(String s) {
        if (this.searchField == null) {
            return;
        }
        String text = ((AbstractOmniGridContainerMenu)this.getMenu()).getSynchronizer().getTextToSynchronizeToGrid();
        if (text == null || this.searchField.getValue().equals(text)) {
            return;
        }
        this.searchField.setValue(text);
    }

    protected void renderRows(GuiGraphics graphics, int x, int y, int topHeight, int rows, int mouseX, int mouseY) {
        this.currentGridSlotIndex = -1;
        for (int row = 0; row < Math.max(this.totalRows, rows); ++row) {
            boolean isOutOfFrame;
            int rowX = x + 7;
            int rowY = y + topHeight + row * 18 - this.getNewScrollbarOffset();
            boolean bl = isOutOfFrame = rowY < y + topHeight - 18 || rowY > y + topHeight + 18 * rows;
            if (isOutOfFrame) continue;
            this.renderOmniRow(graphics, mouseX, mouseY, rowX, rowY, row);
        }
    }

    private void renderOmniRow(GuiGraphics graphics, int mouseX, int mouseY, int rowX, int rowY, int row) {
        graphics.blitSprite(ROW_SPRITE, rowX, rowY, 180, 18);
        for (int column = 0; column < 10; ++column) {
            this.renderCell(graphics, mouseX, mouseY, rowX, rowY, row * 10 + column, column);
        }
    }

    protected final int getNewScrollbarOffset() {
        if (this.sb == null) {
            return 0;
        }
        int scrollbarOffset = (int)this.sb.getOffset();
        if (!this.sb.isSmoothScrolling()) {
            return scrollbarOffset * 18;
        }
        return scrollbarOffset;
    }

    private void renderCell(GuiGraphics graphics, int mouseX, int mouseY, int rowX, int rowY, int idx, int column) {
        ResourceRepository repository = ((AbstractOmniGridContainerMenu)this.getMenu()).getRepository();
        int slotX = rowX + 1 + column * 18;
        int slotY = rowY + 1;
        if (!((AbstractOmniGridContainerMenu)this.getMenu()).isActive()) {
            this.renderDisabledSlot(graphics, slotX, slotY);
        } else {
            this.renderSlot(graphics, mouseX, mouseY, idx, (ResourceRepository<GridResource>)repository, slotX, slotY);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.searchField != null) {
            this.searchField.render(graphics, 0, 0, 0.0f);
        }
    }

    private void renderSlot(GuiGraphics graphics, int mouseX, int mouseY, int idx, ResourceRepository<GridResource> repository, int slotX, int slotY) {
        boolean inBounds = mouseX >= slotX && mouseY >= slotY && mouseX <= slotX + 16 && mouseY <= slotY + 16;
        GridResource resource = null;
        if (idx < this.getResourceList().size()) {
            resource = this.getResourceList().get(idx);
            this.renderResourceWithAmount(graphics, slotX, slotY, resource);
        }
        if (inBounds && this.isOverStorageArea(mouseX, mouseY)) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)slotX, (int)slotY, (int)0);
            if (resource != null) {
                this.currentGridSlotIndex = idx;
            }
        }
    }

    public List<GridResource> getResourceList() {
        return ((AbstractOmniGridContainerMenu)this.menu).getResourceList();
    }

    private boolean isOverStorageArea(int mouseX, int mouseY) {
        int relativeMouseX = mouseX - this.leftPos;
        int relativeMouseY = mouseY - this.topPos;
        return relativeMouseX >= 7 && relativeMouseX <= 186 && this.isThisInStretchedArea(relativeMouseY);
    }

    protected final boolean isThisInStretchedArea(int y) {
        return y >= 19 && y < 19 + 18 * this.visibleRows;
    }

    public static int getOperationColor(String oaName) {
        if (oaName == null) {
            return 0;
        }
        return switch (oaName) {
            case "Pull" -> -11563185;
            case "Collect" -> -12611697;
            case "Push" -> -7385265;
            case "Auto-Loot" -> -1654198;
            case "Vacuum" -> -9803158;
            case "Depositor" -> -11571281;
            case "Search" -> -9744850;
            case "Autocrafter" -> -5211444;
            default -> 0;
        };
    }

    private void renderResourceWithAmount(GuiGraphics graphics, int slotX, int slotY, GridResource resource) {
        Integer queued;
        TrackedResource tracked;
        if (((AbstractOmniGridContainerMenu)this.menu).isUtilityInstalled(UtilityType.NOTIFIER) && resource.getResourceForRecipeMods() != null && ((AbstractOmniGridContainerMenu)this.menu).getTrackedResource((ResourceKey)resource.getResourceForRecipeMods()) != null && ((AbstractOmniGridContainerMenu)this.menu).storageReference != null && OmniGridBlockItem.lastOpened.containsKey(((AbstractOmniGridContainerMenu)this.menu).storageReference) && (tracked = ((AbstractOmniGridContainerMenu)this.menu).getTrackedResource((ResourceKey)resource.getResourceForRecipeMods())) != null && OmniGridBlockItem.lastOpened.containsKey(((AbstractOmniGridContainerMenu)this.menu).storageReference)) {
            long openedAt = OmniGridBlockItem.lastOpened.get(((AbstractOmniGridContainerMenu)this.menu).storageReference);
            long modifiedAt = tracked.getTime();
            if (modifiedAt > openedAt) {
                AbstractOmniGridScreen.renderSlotBackground(graphics, slotX, slotY, false, AbstractOmniGridScreen.getOperationColor(tracked.getSourceName()));
            }
        }
        if (resource.isAutocraftable(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository()) || ((AbstractOmniGridContainerMenu)this.getMenu()).isOmniAutocraftable(resource)) {
            AbstractOmniGridScreen.renderSlotBackground(graphics, slotX, slotY, false, AutocraftableResourceHint.AUTOCRAFTABLE.getColor());
        } else if (resource.getAmount(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository()) == 0L) {
            AbstractOmniGridScreen.renderSlotBackground(graphics, slotX, slotY, false, 0x66FF0000);
        }
        resource.render(graphics, slotX, slotY);
        PlatformResourceKey key = resource.getResourceForRecipeMods();
        if (key != null && (queued = ((AbstractOmniGridContainerMenu)this.menu).craftingMap.get(key)) != null && queued > 0) {
            this.renderCraftingGhost(graphics, slotX, slotY);
        }
        this.renderAmount(graphics, slotX, slotY, resource);
    }

    private void renderResourceWithAmount(GuiGraphics graphics, int slotX, int slotY, ResourceKey resource) {
        AbstractOmniGridScreen.renderSlotBackground(graphics, slotX, slotY, false, AutocraftableResourceHint.AUTOCRAFTABLE.getColor());
        graphics.renderItem(((ItemResource)resource).toItemStack(), slotX, slotY);
    }

    public static void renderSlotBackground(GuiGraphics graphics, int slotX, int slotY, boolean large, int color) {
        int offset = large ? 4 : 0;
        graphics.fill(slotX - offset, slotY - offset, slotX + 16 + offset, slotY + 16 + offset, color);
    }

    private void renderAmount(GuiGraphics graphics, int slotX, int slotY, GridResource resource) {
        long amount = resource.getAmount(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository());
        String text = this.getAmountText(resource, amount);
        int color = this.getAmountColor(resource, amount);
        boolean large = this.minecraft != null && this.minecraft.isEnforceUnicode() || Platform.INSTANCE.getConfig().getGrid().isLargeFont();
        ResourceSlotRendering.renderAmount((GuiGraphics)graphics, (int)slotX, (int)slotY, (String)text, (int)color, (boolean)large);
    }

    public boolean isInfinite(GridResource resource) {
        FluidResource fluid;
        ItemResource item;
        ResourceKey key = resource.getAutocraftingRequest().resource();
        if (key instanceof ItemResource && (item = (ItemResource)key).item() == OmniRootStorage.COBBLE.item() && (((AbstractOmniGridContainerMenu)this.getMenu()).isUtilityInstalled(UtilityType.COBBLE_GENERATOR) || ((AbstractOmniGridContainerMenu)this.getMenu()).isUtilityInstalled(UtilityType.CREATIVE))) {
            return true;
        }
        if (key instanceof FluidResource && (fluid = (FluidResource)key).fluid().isSame((Fluid)Fluids.WATER) && (((AbstractOmniGridContainerMenu)this.getMenu()).isUtilityInstalled(UtilityType.WATER_SOURCE) || ((AbstractOmniGridContainerMenu)this.getMenu()).isUtilityInstalled(UtilityType.CREATIVE))) {
            return true;
        }
        if (RefinedTypesUtil.rtInstalled()) {
            return key instanceof EnergyResource && ((AbstractOmniGridContainerMenu)this.getMenu()).isUtilityInstalled(UtilityType.CREATIVE);
        }
        return false;
    }

    private int getAmountColor(GridResource resource, long amount) {
        if (amount == 0L) {
            if (resource.isAutocraftable(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository()) || ((AbstractOmniGridContainerMenu)this.getMenu()).isOmniAutocraftable(resource)) {
                return 0xFFFFFF;
            }
            return 0xFF5555;
        }
        return 0xFFFFFF;
    }

    private void renderCraftingGhost(GuiGraphics graphics, int slotX, int slotY) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)(slotX + 10), (float)slotY, 200.0f);
        graphics.pose().scale(0.4f, 0.4f, 1.0f);
        graphics.setColor(1.0f, 1.0f, 1.0f, 0.7f);
        graphics.renderItem(GHOST_CRAFTING, 0, 0);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.pose().popPose();
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(graphics, x, y);
        this.renderRows(graphics, mouseX, mouseY, x, y);
    }

    private void renderBackground(GuiGraphics graphics, int x, int y) {
        graphics.blit(this.getTexture(), x, y, 0, 0, this.imageWidth, 19);
        this.renderStretchingBackground(graphics, x, y + 19, this.visibleRows);
        graphics.blit(this.getTexture(), x, y + 19 + 18 * this.visibleRows, 0, this.getBottomV(), this.imageWidth, this.getBottomHeight());
    }

    private void renderRows(GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        graphics.enableScissor(x + 7, y + 19 + 1, x + 7 + 180, y + 19 + 1 + 18 * this.visibleRows - 2);
        this.renderRows(graphics, x, y, 19, this.visibleRows, mouseX, mouseY);
        graphics.disableScissor();
    }

    private String getAmountText(GridResource resource, long amount) {
        if (amount == 0L && (resource.isAutocraftable(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository()) || ((AbstractOmniGridContainerMenu)this.getMenu()).isOmniAutocraftable(resource))) {
            String text = I18n.get((String)IdentifierUtil.createTranslationKey((String)"gui", (String)"grid.craft"), (Object[])new Object[0]);
            return text;
        }
        if (this.isInfinite(resource)) {
            return "\u221e";
        }
        return resource.getDisplayedAmount(((AbstractOmniGridContainerMenu)this.getMenu()).getRepository());
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        super.renderSlot(guiGraphics, slot);
    }

    private void renderDisabledSlot(GuiGraphics graphics, int slotX, int slotY) {
        graphics.fill(RenderType.guiOverlay(), slotX, slotY, slotX + 16, slotY + 16, -10790053);
    }

    protected void updateScrollbar() {
        this.totalRows = (int)Math.ceil((float)this.getResourceList().size() / 10.0f);
        this.updateNewScrollbar(this.totalRows);
    }

    protected final void updateNewScrollbar(int totalRows) {
        if (this.sb == null) {
            return;
        }
        this.sb.setEnabled(totalRows > this.visibleRows);
        int rowsExcludingVisibleOnes = totalRows - this.visibleRows;
        int maxOffset = this.sb.isSmoothScrolling() ? rowsExcludingVisibleOnes * 18 + this.getScrollPanePadding() : rowsExcludingVisibleOnes;
        this.sb.setMaxOffset((double)maxOffset);
    }

    public boolean mouseScrolled(double x, double y, double z, double delta) {
        boolean didScrollbar = this.sb != null && !AbstractOmniGridScreen.hasShiftDown() && !AbstractOmniGridScreen.hasControlDown() && this.sb.mouseScrolled(x, y, z, delta);
        return didScrollbar;
    }

    record LastModified(Type type, long amount) {
        private static final long SECOND = 1000L;
        private static final long MINUTE = 60000L;
        private static final long HOUR = 3600000L;
        private static final long DAY = 86400000L;
        private static final long WEEK = 604800000L;
        private static final long YEAR = 31536000000L;

        static LastModified calculate(long time, long now) {
            long diff = now - time;
            LastModified lastModified = diff < 60000L ? new LastModified(Type.SECOND, diff / 1000L) : (diff < 3600000L ? new LastModified(Type.MINUTE, diff / 60000L) : (diff < 86400000L ? new LastModified(Type.HOUR, diff / 3600000L) : (diff < 604800000L ? new LastModified(Type.DAY, diff / 86400000L) : (diff < 31536000000L ? new LastModified(Type.WEEK, diff / 604800000L) : new LastModified(Type.YEAR, diff / 31536000000L)))));
            return lastModified;
        }

        static enum Type {
            SECOND,
            MINUTE,
            HOUR,
            DAY,
            WEEK,
            YEAR;

        }
    }
}

