/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.StorageProxy.OmniProxyRemoteItem;
import com.omnigrid.Utils.VirtualContainerUtil;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.InteractionUtils;
import com.omnigrid.neoforge.ModInitializer;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniGridBlockContainerMenu;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridMenuData;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.storage.StorageNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.support.energy.TransferableBlockEntityEnergy;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.RedstoneModeSettings;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class AbstractOmniGridEntity
extends AbstractOmniGridBlockEntity<StorageNetworkNode>
implements TransferableBlockEntityEnergy,
ExtendedMenuProvider<OmniGridMenuData> {
    private static final String TAG_REDSTONE_MODE = "rm";
    private static final String TAG_CUSTOM_NAME = "CustomName";
    @Nullable
    private Component name;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    protected AbstractOmniGridEntity(BlockPos pos, BlockState state) {
        super(pos, state, new StorageNetworkNode(com.refinedmods.refinedstorage.common.Platform.INSTANCE.getConfig().getDiskDrive().getEnergyUsage(), Platform.getConfig().getOmniGrid().omniNetworkChargeRate(), 1));
    }

    @Override
    protected void setFilters(Set<ResourceKey> filters) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilters(filters);
    }

    @Override
    protected void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setNormalizer(normalizer);
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            this.initialize(level);
        }
    }

    @Override
    public void initialize(Level level) {
        ((StorageNetworkNode)this.mainNetworkNode).setProvider((AbstractStorageContainerNetworkNode.Provider)this);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_REDSTONE_MODE)) {
            this.redstoneMode = RedstoneModeSettings.getRedstoneMode((int)tag.getInt(TAG_REDSTONE_MODE));
        }
        if (tag.contains(TAG_CUSTOM_NAME, 8)) {
            this.name = AbstractOmniGridEntity.parseCustomNameSafe((String)tag.getString(TAG_CUSTOM_NAME), (HolderLookup.Provider)provider);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.name = (Component)componentInput.get(net.minecraft.core.component.DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(net.minecraft.core.component.DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.setChanged();
    }

    @Nullable
    public AbstractGridContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        if (!InteractionUtils.canInteractWithBlock(player, player.level(), this.worldPosition, Direction.NORTH)) {
            return null;
        }
        if (player.isShiftKeyDown() && player.getMainHandItem().isEmpty()) {
            BlockState blockState = this.getBlockState();
            ItemStack itemStack = new ItemStack((ItemLike)blockState.getBlock().asItem());
            if (!OmniGridBlockItem.GLOBAL_STORAGES.containsKey(this.getStorageReference())) {
                OmniGridBlockItem.setDiskInventory(itemStack, this.getOmniUtilityInventory(), player.level());
            }
            CustomModelData color = (CustomModelData)this.components().get(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA);
            itemStack.set(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA, (Object)color);
            itemStack.set(net.minecraft.core.component.DataComponents.CUSTOM_NAME, (Object)this.name);
            if (!this.level.isClientSide()) {
                VirtualContainerUtil.saveVirtualInventoryAndOmniData((Container)this.getOmniUtilityInventory(), this.getOmniData(), this.getStorageReference(), this.level);
            }
            itemStack.set(DataComponents.INSTANCE.getStorageReference(), (Object)this.getStorageReference());
            player.setItemSlot(EquipmentSlot.MAINHAND, itemStack);
            if (this.enchantments != null) {
                itemStack.set(net.minecraft.core.component.DataComponents.ENCHANTMENTS, (Object)this.enchantments);
            }
            ((IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(itemStack, null)).receiveEnergy((int)this.getEnergyStorage().getStored(), false);
            this.level.removeBlock(this.getBlockPos(), true);
            OmniGridBlockItem.GLOBAL_STORAGES.get(this.getStorageReference()).setDirty(true);
            ModInitializer.SaveProxxyInfo(this.getStorageReference(), this.level);
            return null;
        }
        OmniCommandData data = this.getOmniData();
        this.update(this.getBlockState());
        this.inWorldOmniGrid.initRecipie(() -> ((AbstractOmniGridEntity)this).getLevel());
        this.inWorldOmniGrid.getBlockEntity().setProxxy();
        if (this.proxxy != null && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.proxxy.distributeXP(sp);
            this.inWorldOmniGrid.updateStorage();
        }
        if (player.getMainHandItem().getItem() instanceof OmniProxyRemoteItem) {
            player.getMainHandItem().set(DataComponents.INSTANCE.getStorageReference(), (Object)this.getStorageReference());
        }
        return new OmniGridBlockContainerMenu(syncId, inventory, this, data);
    }

    public OmniGridMenuData getMenuData() {
        return new OmniGridMenuData(GridData.of((Grid)this.inWorldOmniGrid), this.getEnergyStorage().getStored(), this.getEnergyStorage().getCapacity(), this.getInWorldOmniGrid().getBlockEntity().getOmniData(), Optional.empty());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, OmniGridMenuData> getMenuCodec() {
        return OmniGridMenuData.STREAM_CODEC;
    }

    protected boolean calculateActive() {
        boolean hasLevel;
        long energyUsage = ((StorageNetworkNode)this.mainNetworkNode).getEnergyUsage();
        boolean bl = hasLevel = this.level != null && this.level.isLoaded(this.worldPosition);
        boolean redstoneModeActive = !this.hasRedstoneMode() || this.redstoneMode.isActive(hasLevel && this.level.hasNeighborSignal(this.worldPosition));
        return hasLevel && redstoneModeActive && ((StorageNetworkNode)this.mainNetworkNode).getNetwork() != null && ((EnergyNetworkComponent)((StorageNetworkNode)this.mainNetworkNode).getNetwork().getComponent(EnergyNetworkComponent.class)).getStored() >= energyUsage;
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((BlockState)oldBlockState, (BlockState)newBlockState);
    }

    protected void containerInitialized() {
        super.containerInitialized();
        PlatformUtil.sendBlockUpdateToClient((Level)this.level, (BlockPos)this.worldPosition);
    }
}

