/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.google.common.util.concurrent.RateLimiter;
import com.omnigrid.StorageProxy.OmniProxyRemoteItem;
import com.omnigrid.Utils.OmniProxxyStorage;
import com.omnigrid.Utils.OmniTransferManager;
import com.omnigrid.Utils.OmniUtilityItem;
import com.omnigrid.Utils.ToggleableDiskSlot;
import com.omnigrid.Utils.ToggleableQuickCraftingSlot;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.Utils.UtilityBundle;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.Utils.VirtualContainerUtil;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.ClientCraftingGrid;
import com.omnigrid.neoforge.ClientModInitializer;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.CraftingGridBalancePacket;
import com.omnigrid.neoforge.CraftingGridClearPacket;
import com.omnigrid.neoforge.CraftingGridResultSlot;
import com.omnigrid.neoforge.CraftingGridSpreadPacket;
import com.omnigrid.neoforge.InWorldOmniGrid;
import com.omnigrid.neoforge.ItemTransferPacket;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.MarkedContainerFilterSlot;
import com.omnigrid.neoforge.ModInitializer;
import com.omnigrid.neoforge.OmniCommand;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniFurnaceContainerData;
import com.omnigrid.neoforge.OmniFurnaceSlot;
import com.omnigrid.neoforge.OmniGrid;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridItemContainerMenu;
import com.omnigrid.neoforge.OmniGridMenuData;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniResourceSlot;
import com.omnigrid.neoforge.OmniUpgradeSlot;
import com.omnigrid.neoforge.Platform;
import com.omnigrid.neoforge.QuickPatternContainer;
import com.omnigrid.neoforge.RequestOmniDataSync;
import com.omnigrid.neoforge.SyncTabPacket;
import com.omnigrid.neoforge.ToggleableCoreSlot;
import com.omnigrid.neoforge.ToggleableMonitoredResourceSlot;
import com.omnigrid.neoforge.ToggleableResourceSlot;
import com.omnigrid.neoforge.ToggleableSlot;
import com.omnigrid.neoforge.ToggleableUtilitySlot;
import com.omnigrid.neoforge.UpdateCommand;
import com.omnigrid.neoforge.UpdateCommandData;
import com.omnigrid.neoforge.UpdateFurnace;
import com.omnigrid.neoforge.UpdateUpgrades;
import com.omnigrid.neoforge.UpgradeCountContainer;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryFilter;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.autocrafting.CraftingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.view.ItemGridResource;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOmniGridContainerMenu
extends AbstractGridContainerMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOmniGridContainerMenu.class);
    private static final int Y_OFFSET_BETWEEN_PLAYER_INVENTORY_AND_FIRST_CRAFTING_MATRIX_SLOT = 69;
    public long power = 0L;
    public final Player gridPlayer;
    private final CraftingGrid craftingGrid;
    @Nullable
    private Consumer<Boolean> activenessListener;
    @Nullable
    private ResourceRepositoryFilter<GridResource> filterBeforeFilteringBasedOnCraftingMatrixItems;
    public OmniGrid omniGrid;
    private OmniCommandData dataClient;
    public OmniCommandData dataServer;
    public boolean closeConfig = false;
    private final RateLimiter storageUpdater = RateLimiter.create((double)1.0);
    public final List<ToggleableSlot> craftingMatrixSlots = new ArrayList<ToggleableSlot>();
    public final List<ToggleableUtilitySlot> utilitySlots = new ArrayList<ToggleableUtilitySlot>();
    public OmniFurnaceSlot[] furnaceSlots = new OmniFurnaceSlot[12];
    public CraftingGridResultSlot result;
    @Nullable
    public BlockPos blockEntityPosition;
    @Nullable
    public BlockPos blockPos;
    private SlotReference referenceCopy;
    private final FilteredContainer diskInventory;
    private final ArrayList<Slot> diskSlots = new ArrayList();
    public SimpleContainer upgradeContainer;
    public final OmniUpgradeSlot[] upgradeSlots = new OmniUpgradeSlot[4];
    public OmniResourceSlot[] resourceSlots = new OmniResourceSlot[16];
    public ToggleableCoreSlot[] coreSlots = new ToggleableCoreSlot[20];
    private boolean isBlock = true;
    private long[] storageInfoClient = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
    private static final int PLAYER_INV_Y_BASE = 178;
    public List<ItemStack> autocraftable = new ArrayList<ItemStack>();
    private boolean loadedSlots = false;
    private int[] lastCommittedUpgradeCounts = new int[]{-1, -1, -1, -1};
    private final RateLimiter upgradeSendLimiter = RateLimiter.create((double)10.0);
    private final RateLimiter drainLimiter = RateLimiter.create((double)0.5);
    private final RateLimiter energyLimiter = RateLimiter.create((double)0.5);
    private boolean awaitingInitialSync = false;
    public int multiplier = 1;
    public long baseCapacity = 1L;
    public long lastCapacity = 1L;
    public long lastStored = 1L;
    public boolean dirtyEnergy = false;
    public boolean updateScheduled = false;
    private long lastDataServerChange = 0L;
    public boolean disableCoreUpdates = false;
    public boolean updateImmediete = false;
    public int tabPage = 0;
    public boolean surpressUpdate = false;
    public boolean screenIsTransferPanel = false;
    public List<MarkedContainerFilterSlot> markedContainerFilterSlots = new ArrayList<MarkedContainerFilterSlot>();
    public QuickPatternContainer quickPatternContainer;
    public UUID storageReference;
    public OmniTransferManager transferManager;
    public ToggleableMonitoredResourceSlot[] trackedSlots = new ToggleableMonitoredResourceSlot[4];
    public ToggleableResourceSlot toggleableResourceSlot;
    public GridData gridData;
    private boolean furnaceUiReady = false;
    @Nullable
    private GridData clientGridData;
    private final boolean isClientMenu;
    public int smeltProcess = 0;
    public OmniFurnaceContainerData containerData;
    public final ResourceContainer furnaceContainer = ResourceContainerImpl.createForFilter((int)12);
    public final ResourceContainer trackedContainer = ResourceContainerImpl.createForFilter((int)4);
    private int lastDiskItemCount = -1;
    public HashMap<ResourceKey, Integer> craftingMap = new HashMap();
    public List<GridResource> cachedResources = List.of();
    public boolean resourcesDirty = true;
    public boolean loadedCrafting = false;
    public boolean urgent = false;
    private long nextAllowedUpdate = 0L;
    public RateLimiter rateLimiter = RateLimiter.create((double)1.0);
    private boolean shouldReset = false;
    public static boolean resetting = false;
    private final Map<ResourceKey, Long> pendingDeltas = new HashMap<ResourceKey, Long>();
    public int sortDelayTicks = -1;
    private EnumSet<UtilityType> cachedUtilities = EnumSet.noneOf(UtilityType.class);
    public List<ResourceKey> cachedAutocraftables = new ArrayList<ResourceKey>();
    public boolean utilityCacheDirty = true;

    public FilteredContainer getDiskInventory() {
        return this.diskInventory;
    }

    public ArrayList<Slot> getDiskSlots() {
        return this.diskSlots;
    }

    public OmniResourceSlot[] getCommandResourceSlots() {
        return this.resourceSlots;
    }

    public Container getUpgradeContainer() {
        return this.upgradeContainer;
    }

    public OmniGrid getGrid() {
        return this.omniGrid;
    }

    public long[] getStorageInfoClient() {
        return this.storageInfoClient;
    }

    public void setStorageInfoClient(long[] v) {
        this.storageInfoClient = v;
    }

    public ToggleableMonitoredResourceSlot[] getTrackedSlots() {
        return this.trackedSlots;
    }

    public AbstractOmniGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> type, int syncId, Inventory inv, OmniGridMenuData data) {
        super(type, syncId, inv, data.gridData());
        this.craftingGrid = new ClientCraftingGrid();
        this.dataClient = data.data();
        this.gridPlayer = inv.player;
        this.gridData = data.gridData();
        this.containerData = new OmniFurnaceContainerData();
        this.addDataSlots(this.containerData);
        this.lastCapacity = data.capacity();
        this.lastStored = data.stored();
        this.diskInventory = new FilteredContainer(80, StorageContainerItem.stackValidator());
        this.upgradeContainer = new SimpleContainer(4);
        this.buildAllSlotsFirstTime();
        this.awaitingInitialSync = true;
        this.clientGridData = data.gridData();
        this.isClientMenu = true;
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new RequestOmniDataSync());
    }

    public AbstractOmniGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> type, int syncId, Inventory inv, OmniGrid grid, EnergyStorage energyStorage, FilteredContainer diskInventory, OmniCommandData cmd) {
        super(type, syncId, inv, (Grid)grid);
        this.craftingGrid = grid;
        this.gridPlayer = inv.player;
        this.diskInventory = diskInventory;
        this.omniGrid = grid;
        this.containerData = new OmniFurnaceContainerData();
        this.addDataSlots(this.containerData);
        this.dataClient = this.dataServer = cmd;
        if (!this.gridPlayer.level().isClientSide) {
            this.diskInventory.addListener(c -> {
                int currentCount = this.countDiskItems();
                if (this.lastDiskItemCount == -1) {
                    this.requestReset();
                    return;
                }
                if (currentCount != this.lastDiskItemCount) {
                    this.lastDiskItemCount = currentCount;
                    this.requestReset();
                }
            });
        }
        this.clientGridData = null;
        this.isClientMenu = false;
        this.dataClient = cmd != null ? cmd : new OmniCommandData();
        OmniGrid omniGrid = this.omniGrid;
        if (omniGrid instanceof InWorldOmniGrid) {
            InWorldOmniGrid worldGrid = (InWorldOmniGrid)omniGrid;
            this.upgradeContainer = new UpgradeCountContainer(worldGrid);
            this.buildAllSlotsFirstTime();
            this.loadUpgradesIntoContainerServer();
        } else {
            this.upgradeContainer = new SimpleContainer(4);
            this.buildAllSlotsFirstTime();
            this.populateUiFromData(this.getDataClient());
            this.loadUpgradesAndCores(cmd);
        }
        omniGrid = this.upgradeContainer;
        if (omniGrid instanceof SimpleContainer) {
            OmniGrid sc = omniGrid;
            sc.addListener(c -> {
                this.onUpgradeContainerChanged();
                this.broadcastChanges();
            });
        }
    }

    public void requestReset() {
        this.shouldReset = true;
        this.utilityCacheDirty = true;
        this.broadcastChanges();
        this.markDataServerDirty();
        this.updateVirtualData();
    }

    private int countDiskItems() {
        int count = 0;
        for (int i = 0; i < 80; ++i) {
            if (this.diskInventory.getItem(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private void buildAllSlotsFirstTime() {
        this.resized(178, 0, 0);
    }

    private void loadUpgradesIntoContainerServer() {
        int i;
        CraftingGrid craftingGrid = this.craftingGrid;
        if (!(craftingGrid instanceof InWorldOmniGrid)) {
            return;
        }
        InWorldOmniGrid world = (InWorldOmniGrid)craftingGrid;
        int[] up = world.getBlockEntity().getOmniData().getUpgrades();
        for (i = 0; i < 4; ++i) {
            ItemStack s = switch (i) {
                case 0 -> {
                    if (up[i] > 0) {
                        yield new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade(), up[i]);
                    }
                    yield ItemStack.EMPTY;
                }
                case 1 -> {
                    if (up[i] > 0) {
                        yield new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStackUpgrade(), up[i]);
                    }
                    yield ItemStack.EMPTY;
                }
                case 2 -> {
                    if (up[i] > 0) {
                        yield new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getRangeUpgrade(), up[i]);
                    }
                    yield ItemStack.EMPTY;
                }
                case 3 -> {
                    if (up[i] > 0) {
                        yield new ItemStack((ItemLike)Items.INSTANCE.getOmniEnergy(), up[i]);
                    }
                    yield ItemStack.EMPTY;
                }
                default -> ItemStack.EMPTY;
            };
            this.upgradeContainer.setItem(i, s);
        }
        this.upgradeContainer.setChanged();
        if (this.trackedContainer != null) {
            for (i = 0; i < 4; ++i) {
                if (world.getBlockEntity().getOmniData().tracked[i] == null) continue;
                this.trackedContainer.set(i, new ResourceAmount((ResourceKey)world.getBlockEntity().getOmniData().tracked[i], 1L));
            }
        }
        this.trackedContainer.toItemContainer().setChanged();
    }

    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        this.craftingMatrixSlots.clear();
        this.diskSlots.clear();
        this.utilitySlots.clear();
        this.resourceSlots = new OmniResourceSlot[16];
        this.furnaceSlots = new OmniFurnaceSlot[12];
        super.resized(playerInventoryY + 3, topYStart, topYEnd);
        this.buildCustomSlots(playerInventoryY);
        this.transferManager = new OmniTransferManager(this);
        this.transferManager.addRule(ToggleableCoreSlot.class);
        this.transferManager.addRule(ToggleableDiskSlot.class);
        this.transferManager.addRule(ToggleableUtilitySlot.class);
        this.transferManager.addRule(OmniUpgradeSlot.class);
    }

    public void setActivenessListener(@Nullable Consumer<Boolean> activenessListener) {
        this.activenessListener = activenessListener;
    }

    private boolean isDisabledPlayerSlot(Slot slot) {
        if (slot == null) {
            return false;
        }
        if (slot.hasItem() && slot.getItem().getItem() instanceof OmniProxyRemoteItem && slot.getItem().has(DataComponents.INSTANCE.getStorageReference()) && slot.getItem().get(DataComponents.INSTANCE.getStorageReference()) == this.storageReference) {
            return true;
        }
        if (this.disabledSlot == null) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)this.disabledSlot.resolve(this.gridPlayer).get()), (ItemStack)slot.getItem());
    }

    public long getMaxPower() {
        long power = Platform.getConfig().getOmniGrid().getEnergyCapacity();
        return (long)(1 + this.dataClient.getUpgrades()[3]) * power;
    }

    public void clicked(int slotId, int button, ClickType type, Player player) {
        Slot slot;
        if (this.awaitingInitialSync) {
            return;
        }
        if (slotId >= 0 && slotId < this.slots.size() && this.isDisabledPlayerSlot(slot = (Slot)this.slots.get(slotId))) {
            return;
        }
        super.clicked(slotId, button, type, player);
        if (slotId >= 0 && slotId < this.slots.size() && (slot = (Slot)this.slots.get(slotId)) instanceof OmniUpgradeSlot) {
            int amount;
            int idx = slot.getContainerSlot();
            int n = amount = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
            if (this.upgradeContainer instanceof UpgradeCountContainer) {
                if (player.level().isClientSide()) {
                    com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new UpdateUpgrades(idx, amount));
                } else {
                    InWorldOmniGrid world;
                    OmniCommandData d;
                    int[] up;
                    CraftingGrid craftingGrid = this.craftingGrid;
                    if (craftingGrid instanceof InWorldOmniGrid && (up = (d = (world = (InWorldOmniGrid)craftingGrid).getBlockEntity().getOmniData()).getUpgrades())[idx] != amount) {
                        up[idx] = amount;
                        d.setUpgrades(up);
                        world.getBlockEntity().updateOmniController(d);
                        world.getBlockEntity().setChanged();
                        this.dataClient = d;
                    }
                }
            } else if (!player.level().isClientSide()) {
                this.syncUpgradeDataItemModeImmediate(idx, amount);
            }
            if (idx >= 0 && idx < this.lastCommittedUpgradeCounts.length) {
                this.lastCommittedUpgradeCounts[idx] = amount;
            }
            this.broadcastChanges();
        }
    }

    public void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        if (this.activenessListener != null) {
            this.activenessListener.accept(newActive);
        }
    }

    public void setDataClient(OmniCommandData dataClient) {
        this.dataClient = dataClient;
    }

    public OmniCommandData getDataClient() {
        if (this.dataClient == null) {
            this.dataClient = new OmniCommandData();
            this.dataClient.setUpgrades(new int[]{0, 0, 0, 0});
        } else if (this.dataClient.getUpgrades() == null) {
            this.dataClient.setUpgrades(new int[]{0, 0, 0, 0});
        }
        return this.dataClient;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.gridPlayer != null && !this.gridPlayer.level().isClientSide) {
            if (this.omniGrid.storage != null && this.omniGrid.storage.resolveStorage() != null && this.omniGrid.storage.resolveStorage().menu == null) {
                this.omniGrid.storage.resolveStorage().menu = this;
            }
            if (this.storageReference == null) {
                if (this.disabledSlot != null) {
                    this.storageReference = OmniGridBlockItem.getOrCreate((ItemStack)this.disabledSlot.resolve(this.gridPlayer).get());
                } else {
                    InWorldOmniGrid inWorldOmniGrid;
                    Object object = this.omniGrid;
                    if (object instanceof InWorldOmniGrid && (object = (inWorldOmniGrid = (InWorldOmniGrid)object).getBlockEntity()) instanceof AbstractOmniGridBlockEntity) {
                        Object abstractOmniGridBlockEntity = object;
                        this.storageReference = ((AbstractOmniGridBlockEntity)((Object)abstractOmniGridBlockEntity)).getStorageReference();
                    }
                }
            }
            if (this.drainLimiter != null && this.drainLimiter.tryAcquire()) {
                if (this.tabPage == 2) {
                    this.utilityCacheDirty = true;
                }
                if (this.omniGrid != null && this.omniGrid.storage != null && this.omniGrid.storage.resolveStorage() != null) {
                    this.omniGrid.energyStorage.extract(this.omniGrid.storage.resolveStorage().consumePrinterDrain(), Action.EXECUTE);
                    if (this.omniGrid.storage.getProxxy().dirtyResourceSlots) {
                        this.resourceSlots[0].container.setChanged();
                        this.omniGrid.storage.getProxxy().dirtyResourceSlots = false;
                    }
                }
            }
            try {
                this.serverTick();
            }
            catch (Exception e) {
                LOGGER.error("serverTick() exception", (Throwable)e);
            }
        }
        if (this.gridPlayer.level().isClientSide() && this.drainLimiter != null && this.drainLimiter.tryAcquire()) {
            this.markResourcesDirty();
        }
    }

    public void updateCommandsInstant() {
        CraftingGrid craftingGrid;
        Optional resolved;
        this.SaveCraftingMatrix();
        if (this.disabledSlot != null && (resolved = this.disabledSlot.resolve(this.gridPlayer)).isPresent()) {
            ItemStack item = (ItemStack)resolved.get();
            OmniGridBlockItem.UpdatePlayerTransferCache(item, this.gridPlayer.level(), this.getDiskInventory());
        }
        if ((craftingGrid = this.craftingGrid) instanceof InWorldOmniGrid) {
            InWorldOmniGrid world = (InWorldOmniGrid)craftingGrid;
            world.getBlockEntity().updateOmniController(this.dataServer);
            world.getBlockEntity().setChanged();
            world.getBlockEntity().proxxy.setDirty(true);
            ModInitializer.SaveProxxyInventory(this.storageReference, this.gridPlayer.level(), this.diskInventory);
            this.updateVirtualData();
        }
        this.diskInventory.setChanged();
        this.gridPlayer.getInventory().setChanged();
        this.gridPlayer.containerMenu.broadcastChanges();
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (this.isDisabledPlayerSlot(slot)) {
            return false;
        }
        if (slot instanceof CraftingGridResultSlot) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    public void createPattern(ItemStack result) {
        PatternState patternState = new PatternState(UUID.randomUUID(), PatternType.CRAFTING);
        result.set(DataComponents.INSTANCE.getPatternState(), (Object)patternState);
        if (this.craftingGrid != null) {
            CraftingPatternState state = new CraftingPatternState(false, this.craftingGrid.getCraftingMatrix().asPositionedCraftInput());
            result.set(DataComponents.INSTANCE.getCraftingPatternState(), (Object)state);
        } else {
            CraftingPatternState state = new CraftingPatternState(false, this.omniGrid.getCraftingMatrix().asPositionedCraftInput());
            result.set(DataComponents.INSTANCE.getCraftingPatternState(), (Object)state);
        }
    }

    public boolean tryPlaceInEmptySlot(List<ToggleableUtilitySlot> slots, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (Slot slot : slots) {
            if (slot.hasItem() || !slot.mayPlace(stack)) continue;
            ItemStack toInsert = stack.copy();
            toInsert.setCount(1);
            slot.set(toInsert);
            slot.setChanged();
            this.utilityCacheDirty = true;
            return true;
        }
        return false;
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack routedResult;
        CraftingGridResultSlot resultSlot;
        Object ts;
        Slot slot = this.getSlot(slotIndex);
        if (slot instanceof ToggleableQuickCraftingSlot) {
            ToggleableQuickCraftingSlot ts2 = (ToggleableQuickCraftingSlot)slot;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ItemStack pattern = this.getPattern();
                this.createPattern(pattern);
                boolean result = this.tryPlaceInEmptySlot(this.utilitySlots, pattern);
                if (result) {
                    this.omniGrid.storage.extract(new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getPattern()), 1, false);
                }
            }
            return ItemStack.EMPTY;
        }
        if (slot instanceof ToggleableSlot && !((ToggleableSlot)((Object)(ts = (ToggleableSlot)slot))).isValid()) {
            return ItemStack.EMPTY;
        }
        if (slot instanceof ToggleableResourceSlot && !((ToggleableResourceSlot)((Object)(ts = (ToggleableResourceSlot)slot))).isValid()) {
            return ItemStack.EMPTY;
        }
        if (!player.level().isClientSide() && slot instanceof CraftingGridResultSlot && (resultSlot = (CraftingGridResultSlot)slot).hasItem()) {
            ItemStack crafted = resultSlot.onQuickCraft(player);
            this.craftingGrid.acceptQuickCraft(player, crafted);
            return ItemStack.EMPTY;
        }
        ItemStack before = slot.getItem().copy();
        if (!(before.isEmpty() || (routedResult = this.transferManager.move(slotIndex)).isEmpty() && !slot.getItem().isEmpty())) {
            return routedResult;
        }
        return super.quickMoveStack(player, slotIndex);
    }

    public void removed(Player player) {
        if (!player.level().isClientSide()) {
            this.SaveCraftingMatrix();
            this.flushUpgradeStateOnClose(player);
        } else if (this.storageReference != null) {
            OmniGridBlockItem.stopClient.put(this.storageReference, !this.isBlock && OmniGridBlockItem.updateClientList(this.dataClient));
            OmniGridBlockItem.lastOpened.put(this.storageReference, System.currentTimeMillis());
        }
        if (!player.level().isClientSide) {
            for (int i = 0; i < 4; ++i) {
                if (this.dataServer.isCoreInstalled(CoreTypes.MONITOR)) {
                    if (this.trackedContainer.get(i) != null) {
                        this.dataServer.tracked[i] = (PlatformResourceKey)this.trackedContainer.get(i).resource();
                        continue;
                    }
                    this.dataServer.tracked[i] = null;
                    continue;
                }
                this.dataServer.tracked[i] = null;
            }
            this.updateVirtualData();
        }
        super.removed(player);
    }

    public void markResourcesDirty() {
        this.resourcesDirty = true;
    }

    public List<GridResource> getResourceList() {
        if (!this.resourcesDirty) {
            return this.cachedResources;
        }
        ResourceRepository repo = this.getRepository();
        List baseView = repo.getViewList();
        ArrayList<GridResource> list = new ArrayList<GridResource>(baseView.size() + this.cachedAutocraftables.size());
        list.addAll(baseView);
        if (!this.cachedAutocraftables.isEmpty()) {
            for (ResourceKey rl : this.cachedAutocraftables) {
                GridResource grid;
                if (repo.getAmount(rl) > 0L || repo.isSticky(rl) || baseView.contains(grid = this.toGridRes(rl))) continue;
                list.add(grid);
            }
        }
        this.cachedResources = List.copyOf(list);
        this.resourcesDirty = false;
        return this.cachedResources;
    }

    private void flushUpgradeStateOnClose(Player player) {
        int[] counts = this.readUpgradeCountsFromUi();
        if (this.disabledSlot != null) {
            Optional resolved = this.disabledSlot.resolve(player);
            if (resolved.isPresent() && !((ItemStack)resolved.get()).isEmpty()) {
                ItemStack item = (ItemStack)resolved.get();
                OmniCommandData data = VirtualContainerUtil.loadOmniDataFromVirtual(item, this.gridPlayer);
                if (data == null) {
                    data = new OmniCommandData();
                }
                data.setUpgrades(counts);
                VirtualContainerUtil.saveOmniDataToVirtual(data, item, this.gridPlayer);
                OmniGridBlockItem.UpdatePlayerTransferCache(item, player.level(), this.getDiskInventory());
                this.dataClient = data;
            }
        } else {
            CraftingGrid resolved = this.craftingGrid;
            if (resolved instanceof InWorldOmniGrid) {
                InWorldOmniGrid world = (InWorldOmniGrid)resolved;
                OmniCommandData d = world.getBlockEntity().getOmniData();
                d.setUpgrades(counts);
                world.getBlockEntity().updateOmniController(d);
                world.getBlockEntity().setChanged();
                this.dataClient = d;
            }
        }
    }

    public List<ToggleableSlot> getCraftingMatrixSlots() {
        return this.craftingMatrixSlots;
    }

    public void clearClient(boolean toPlayerInventory) {
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new CraftingGridClearPacket(toPlayerInventory));
    }

    public void clear(boolean toPlayerInventory) {
        this.craftingGrid.clearMatrix(this.gridPlayer, toPlayerInventory);
    }

    public MutableResourceList getAvailableListForRecipeTransfer() {
        MutableResourceList available = this.getRepository().copyBackingList();
        this.addContainerToList((Container)this.craftingGrid.getCraftingMatrix(), available);
        this.addContainerToList((Container)this.gridPlayer.getInventory(), available);
        return available;
    }

    private void addContainerToList(Container container, MutableResourceList available) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            available.add((ResourceKey)ItemResource.ofItemStack((ItemStack)stack), (long)stack.getCount());
        }
    }

    @Nullable
    protected ResourceKey getResourceForAutocraftableHint(Slot slot) {
        if (slot.container == this.craftingGrid.getCraftingMatrix() || slot.container == this.craftingGrid.getCraftingResult()) {
            return ItemResource.ofItemStack((ItemStack)slot.getItem());
        }
        return super.getResourceForAutocraftableHint(slot);
    }

    public boolean isLargeSlot(Slot slot) {
        return slot.container == this.craftingGrid.getCraftingResult() || super.isLargeSlot(slot);
    }

    public void spread() {
        CraftingGrid craftingGrid = this.craftingGrid;
        if (craftingGrid instanceof OmniGrid) {
            OmniGrid grid = (OmniGrid)craftingGrid;
            grid.spreadItems();
        }
    }

    public void balance() {
        CraftingGrid craftingGrid = this.craftingGrid;
        if (craftingGrid instanceof OmniGrid) {
            OmniGrid grid = (OmniGrid)craftingGrid;
            grid.balanceItems();
        }
    }

    public void spreadPacket(boolean spread) {
        if (spread) {
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new CraftingGridSpreadPacket());
        } else {
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new CraftingGridBalancePacket());
        }
    }

    public void depositPacket(boolean deposit, ItemStack filter) {
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new ItemTransferPacket(deposit, filter));
    }

    public void depositItems(boolean deposit, ItemStack item) {
        OmniGrid c = (OmniGrid)this.craftingGrid;
        c.depositItems(this.gridPlayer, deposit, item);
    }

    public void transferRecipe(List<List<ItemResource>> recipe) {
        this.craftingGrid.transferRecipe(this.gridPlayer, recipe);
    }

    public void filterBasedOnCraftingMatrixItems() {
        Set<ItemResource> craftingMatrixItems = this.getCraftingMatrixItems();
        this.filterBeforeFilteringBasedOnCraftingMatrixItems = this.getRepository().setFilterAndSort((view, resource) -> {
            ItemGridResource itemResource;
            return resource instanceof ItemGridResource && craftingMatrixItems.contains((itemResource = (ItemGridResource)resource).getItemResource());
        });
    }

    private Set<ItemResource> getCraftingMatrixItems() {
        HashSet<ItemResource> craftingMatrixItems = new HashSet<ItemResource>();
        for (int i = 0; i < this.craftingGrid.getCraftingMatrix().getContainerSize(); ++i) {
            ItemStack craftingMatrixStack = this.craftingGrid.getCraftingMatrix().getItem(i);
            if (craftingMatrixStack.isEmpty()) continue;
            craftingMatrixItems.add(ItemResource.ofItemStack((ItemStack)craftingMatrixStack));
        }
        return craftingMatrixItems;
    }

    public void stopFilteringBasedOnCraftingMatrixItems() {
        if (this.filterBeforeFilteringBasedOnCraftingMatrixItems == null) {
            return;
        }
        this.getRepository().setFilterAndSort(this.filterBeforeFilteringBasedOnCraftingMatrixItems);
        this.filterBeforeFilteringBasedOnCraftingMatrixItems = null;
    }

    public void loadCraftingMatrix() {
        if (this.dataServer == null || this.dataServer.craftingMatrix == null) {
            return;
        }
        this.surpressUpdate = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack s;
            if (this.dataServer.craftingMatrix[i] == null || (s = this.dataServer.craftingMatrix[i]).getItem() == Items.INSTANCE.getFakeOmniGrid()) continue;
            this.getCraftingMatrixSlots().get(i).set(s.isEmpty() ? ItemStack.EMPTY : s.copy());
        }
        this.craftingGrid.getCraftingMatrix().setChanged();
        this.surpressUpdate = false;
        this.loadedCrafting = true;
    }

    public void SaveCraftingMatrix() {
        if (this.dataServer == null || !this.loadedCrafting) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack s = this.craftingGrid.getCraftingMatrix().getItem(i);
            this.dataServer.craftingMatrix[i] = s.isEmpty() ? null : s.copy();
        }
        this.markDataServerDirty();
    }

    protected boolean canTransferSlot(Slot slot) {
        return slot.container != this.diskInventory;
    }

    public void onChanged(ResourceKey resource, long change, @Nullable TrackedResource trackedResource) {
        TrackedResource trackedResource1 = trackedResource;
        if (!(resource instanceof PlatformResourceKey)) {
            return;
        }
        PlatformResourceKey platformResource = (PlatformResourceKey)resource;
        if (change == 0L) {
            return;
        }
        Player player = this.playerInventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            S2CPackets.sendGridUpdate((ServerPlayer)sp, (PlatformResourceKey)platformResource, (long)change, (TrackedResource)trackedResource1);
        }
    }

    public void resetStorage() {
        OmniProxxyStorage rootStorage = this.omniGrid.storage;
        if (rootStorage == null) {
            return;
        }
        ArrayList snapshots = new ArrayList();
        rootStorage.getAll().forEach(ra -> {
            if (ra != null) {
                TrackedResource tr = this.getTrackedResource(ra.resource());
                snapshots.add(new TrackedSnapshot(ra.resource(), ra.amount(), tr));
            }
        });
        this.invalidate();
        for (TrackedSnapshot snap : snapshots) {
            this.onChanged(snap.resource(), snap.amount(), snap.tracked());
        }
    }

    public void syncSlot(int index) {
        if (index == -1) {
            for (int i = 0; i < 16; ++i) {
                this.resourceSlots[i].change(ItemStack.EMPTY, false);
                this.getDataClient().commands[i] = new OmniCommand();
            }
            return;
        }
        if (!this.loadedSlots) {
            return;
        }
        PlatformResourceKey res = this.resourceSlots[index].getResource();
        OmniCommand cmd = this.getDataClient().commands[index];
        cmd.setResource(res);
        if (FMLEnvironment.dist.isClient()) {
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new UpdateCommand(index, cmd));
        }
    }

    public void syncFurnace(int index) {
        if (!this.loadedSlots) {
            return;
        }
        if (FMLEnvironment.dist.isClient()) {
            PlatformResourceKey key;
            long amount;
            ResourceAmount amt = this.furnaceContainer.get(index);
            if (amt == null) {
                amount = 1L;
                key = ItemResource.ofItemStack((ItemStack)ItemStack.EMPTY);
            } else {
                key = (PlatformResourceKey)amt.resource();
                amount = amt.amount();
            }
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new UpdateFurnace(index, key, amount));
        }
    }

    public boolean showCommandSlots() {
        return (this.tabPage == 0 || this.tabPage == 1) && !this.screenIsTransferPanel;
    }

    public void syncUpgrade(int index) {
        if (!this.loadedSlots) {
            return;
        }
        if (!(this.upgradeContainer instanceof UpgradeCountContainer)) {
            return;
        }
        ItemStack s = this.upgradeContainer.getItem(index);
        int amount = s.isEmpty() ? 0 : s.getCount();
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new UpdateUpgrades(index, amount));
    }

    private void loadUpgradesAndCores(@Nullable OmniCommandData cmdFromOpener) {
        OmniCommandData data;
        OmniCommandData omniCommandData = data = this.dataServer != null ? this.dataServer : cmdFromOpener;
        if (data == null) {
            return;
        }
        int[] counts = data.getUpgrades();
        if (counts == null || counts.length < 4) {
            counts = new int[]{0, 0, 0, 0};
        }
        this.getDataClient().setUpgrades(counts);
        for (int i = 0; i < 4; ++i) {
            ItemStack s = switch (i) {
                case 0 -> {
                    if (counts[i] > 0) {
                        yield new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade(), counts[i]);
                    }
                    yield ItemStack.EMPTY;
                }
                case 1 -> {
                    if (counts[i] > 0) {
                        yield new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStackUpgrade(), counts[i]);
                    }
                    yield ItemStack.EMPTY;
                }
                case 2 -> {
                    if (counts[i] > 0) {
                        yield new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getRangeUpgrade(), counts[i]);
                    }
                    yield ItemStack.EMPTY;
                }
                case 3 -> {
                    if (counts[i] > 0) {
                        yield new ItemStack((ItemLike)Items.INSTANCE.getOmniEnergy(), counts[i]);
                    }
                    yield ItemStack.EMPTY;
                }
                default -> ItemStack.EMPTY;
            };
            this.upgradeContainer.setItem(i, s);
        }
        this.upgradeContainer.setChanged();
    }

    public GridResource toGridRes(ResourceKey rk) {
        return (GridResource)RefinedStorageApi.INSTANCE.getGridResourceRepositoryMapper().apply((Object)rk);
    }

    public void onResourceUpdate(ResourceKey resource, long amount, @Nullable TrackedResource trackedResource) {
        TrackedResource tr = null;
        if (this.getTrackedResource(resource) != null) {
            tr = new TrackedResource(this.getTrackedResource(resource).getSourceName(), this.getTrackedResource(resource).getTime());
        }
        super.onResourceUpdate(resource, amount, tr);
    }

    public void onSyncDataReceived(OmniCommandData synced) {
        this.dataClient = synced;
        this.populateUiFromData(synced);
        this.loadUpgradesAndCores(synced);
        this.lastCommittedUpgradeCounts = Arrays.copyOf(synced.getUpgrades(), 4);
        this.awaitingInitialSync = false;
        this.loadedSlots = true;
        this.loadCraftingMatrix();
    }

    public void clearTarget(int index) {
        this.dataServer.blockTargets[index] = null;
    }

    public void markDataServerDirty() {
        if (this.gridPlayer.level().isClientSide) {
            return;
        }
        this.lastDataServerChange = System.currentTimeMillis();
        if (!this.updateScheduled) {
            this.updateScheduled = true;
            this.gridPlayer.level().scheduleTick(this.gridPlayer.blockPosition(), Blocks.AIR, 60);
        }
    }

    public ResourceKey getTestRes() {
        return new ItemResource(net.minecraft.world.item.Items.DIAMOND_BLOCK);
    }

    public boolean isOmniAutocraftable(GridResource gr) {
        return this.cachedAutocraftables.contains(gr.getResourceForRecipeMods());
    }

    private void serverTick() {
        if (this.gridPlayer.level().isClientSide) {
            return;
        }
        if (!this.updateScheduled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextAllowedUpdate && !this.urgent) {
            return;
        }
        this.nextAllowedUpdate = now + (long)(this.urgent ? 50 : 500);
        this.updateScheduled = false;
        this.urgent = false;
        this.updateImmediete = false;
        this.updateVirtualData();
    }

    public void updateVirtualData() {
        if (!this.rateLimiter.tryAcquire()) {
            return;
        }
        this.SaveCraftingMatrix();
        if (this.toggleableResourceSlot instanceof ResourceContainer) {
            ((ResourceContainer)this.toggleableResourceSlot.container).remove(0);
        }
        OmniGrid c = (OmniGrid)this.craftingGrid;
        this.utilityCacheDirty = true;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (this.dataServer.isFullyUpgradedAndCored()) {
                TransferUtils.giveAdvancement(sp, "omni_potent", "never");
            }
        }
        if (this.disabledSlot != null) {
            Optional resolved = this.disabledSlot.resolve(this.gridPlayer);
            if (resolved.isPresent() && !((ItemStack)resolved.get()).isEmpty()) {
                ItemStack item = (ItemStack)resolved.get();
                this.dataServer = VirtualContainerUtil.readOmniDataFromInventory((Container)this.diskInventory, this.dataServer);
                VirtualContainerUtil.saveVirtualInventoryAndOmniData((Container)this.diskInventory, this.dataServer, this.storageReference, this.gridPlayer.level());
                OmniGridBlockItem.UpdatePlayerTransferCache(item, this.gridPlayer.level(), this.diskInventory);
            }
        } else if (c instanceof InWorldOmniGrid) {
            InWorldOmniGrid world = (InWorldOmniGrid)c;
            this.dataServer = VirtualContainerUtil.readOmniDataFromInventory((Container)this.diskInventory, this.dataServer);
            VirtualContainerUtil.saveVirtualInventoryAndOmniData((Container)this.diskInventory, this.dataServer, world.getBlockEntity().getStorageReference(), this.gridPlayer.level());
            world.updateStorage();
            if (world.getBlockEntity().proxxy != null) {
                world.getBlockEntity().proxxy.setDirty(true);
            }
        }
        this.gridPlayer.getInventory().setChanged();
        this.gridPlayer.containerMenu.broadcastChanges();
        if (this.shouldReset) {
            this.resetStorage();
        }
        this.shouldReset = false;
        this.urgent = false;
        ModInitializer.SaveProxxyInventory(this.storageReference, this.gridPlayer.level(), this.diskInventory);
    }

    public void broadcastFullState() {
        super.broadcastFullState();
    }

    public void syncDataSlotServer(int index, OmniCommand command) {
        if (index == -1) {
            for (int i = 0; i < 16; ++i) {
                this.dataServer.commands[index] = new OmniCommand();
            }
            return;
        }
        this.dataServer.commands[index] = command;
        this.markDataServerDirty();
        this.updateCommandsInstant();
    }

    public void syncFurnaceServer(int index, PlatformResourceKey key, long amt) {
        ResourceAmount ra;
        ResourceAmount resourceAmount = ra = key == null || AbstractOmniGridContainerMenu.isAirResource(key) ? null : new ResourceAmount((ResourceKey)key, amt);
        if (ra == null) {
            this.furnaceContainer.remove(index);
        } else {
            this.furnaceContainer.set(index, ra);
        }
        this.furnaceSlots[index].setFilter(key);
        this.furnaceSlots[index].changeAmount(amt);
        if (index < 8) {
            this.dataServer.furnaceData.smeltItems[index] = key;
            this.dataServer.furnaceData.toSmelt[index] = amt;
        } else {
            this.dataServer.furnaceData.fuelItems[index - 8] = key;
        }
        this.markDataServerDirty();
    }

    private static Set<CoreTypes> getRequiredCoresFor(OmniCommand command) {
        HashSet<CoreTypes> requiredCores = new HashSet<CoreTypes>();
        int action = command.getAction();
        int direction = command.getTarget();
        int mode = command.getMode();
        boolean inverted = command.isInverted();
        boolean linked = command.isLinked();
        switch (action) {
            case 0: {
                requiredCores.add(CoreTypes.PROVIDE);
                break;
            }
            case 1: {
                requiredCores.add(CoreTypes.PULL);
                break;
            }
            case 2: {
                requiredCores.add(CoreTypes.COLLECT);
                break;
            }
            case 3: {
                requiredCores.add(CoreTypes.PUSH);
                break;
            }
            case 4: {
                requiredCores.add(CoreTypes.BLACKLIST);
                break;
            }
            case 5: {
                requiredCores.add(CoreTypes.SEARCH);
                break;
            }
            case 6: {
                requiredCores.add(CoreTypes.EXTERNAL_STORAGE);
                break;
            }
            case 7: {
                requiredCores.add(CoreTypes.BASIC_CRAFTING);
                break;
            }
            case 8: {
                requiredCores.add(CoreTypes.REGULATE);
                break;
            }
            case 9: {
                requiredCores.add(CoreTypes.LOOTING);
                break;
            }
            default: {
                requiredCores.add(CoreTypes.NONE);
            }
        }
        if (direction == 1) {
            requiredCores.add(CoreTypes.NONE);
        }
        if (direction == 3) {
            requiredCores.add(CoreTypes.PLAYER);
        }
        if (direction > 10) {
            requiredCores.add(CoreTypes.REMOTE);
        }
        if (mode > 0) {
            requiredCores.add(CoreTypes.FILTER);
        }
        if (inverted) {
            requiredCores.add(CoreTypes.INVERTED);
        }
        if (linked) {
            requiredCores.add(CoreTypes.LINK);
        }
        return requiredCores.isEmpty() ? null : requiredCores;
    }

    public OmniCommandData validateCommands(OmniCommandData data) {
        OmniCommand[] commands = data.commands;
        boolean[] installed = data.coresInstalled;
        for (int i = 0; i < commands.length; ++i) {
            OmniCommand command = commands[i];
            Set<CoreTypes> required = AbstractOmniGridContainerMenu.getRequiredCoresFor(command);
            if (required == null || AbstractOmniGridContainerMenu.hasAllCores(required, installed)) continue;
            data.commands[i] = new OmniCommand();
            this.updateScheduled = true;
        }
        return data;
    }

    private static boolean hasAllCores(Set<CoreTypes> required, boolean[] installed) {
        for (CoreTypes core : required) {
            int index = core.ordinal();
            if (index < installed.length && installed[index]) continue;
            return false;
        }
        return true;
    }

    public boolean onExtract(PlatformResourceKey resource, GridExtractMode extractMode, boolean cursor) {
        if (!this.isUtilityInstalled(UtilityType.XP_HANLDER)) {
            return super.onExtract(resource, extractMode, cursor);
        }
        if (this.gridPlayer.level().isClientSide) {
            return super.onExtract(resource, extractMode, cursor);
        }
        if (!(resource instanceof FluidResource)) {
            return super.onExtract(resource, extractMode, cursor);
        }
        FluidResource fr = (FluidResource)resource;
        if (!fr.fluid().is(OmniItemProxxy.XP_TAG)) {
            return super.onExtract(resource, extractMode, cursor);
        }
        if (extractMode != GridExtractMode.HALF_RESOURCE) {
            return super.onExtract(resource, extractMode, cursor);
        }
        Player player = this.gridPlayer;
        long availableFluid = this.omniGrid.storage.get((ResourceKey)fr);
        if (availableFluid < 20L) {
            return true;
        }
        int xpToGrant = (int)(availableFluid / 20L);
        if (xpToGrant <= 0) {
            return true;
        }
        long fluidToExtract = (long)xpToGrant * 20L;
        this.omniGrid.storage.extract((ResourceKey)fr, fluidToExtract, Action.EXECUTE, (Actor)new PlayerActor("XP"));
        player.giveExperiencePoints(xpToGrant);
        return true;
    }

    private void syncUpgradeDataItemModeImmediate(int index, int amount) {
        if (this.disabledSlot == null) {
            return;
        }
        Optional resolved = this.disabledSlot.resolve(this.gridPlayer);
        if (resolved == null || resolved.isEmpty() || ((ItemStack)resolved.get()).isEmpty()) {
            return;
        }
        int[] list = this.dataServer.getUpgrades();
        list[index] = amount;
        this.dataServer.setUpgrades(list);
        this.markDataServerDirty();
        this.gridPlayer.getInventory().setChanged();
        this.gridPlayer.containerMenu.broadcastChanges();
    }

    public void syncUpgradeData(int index, int amount) {
        int[] list = this.dataServer.getUpgrades();
        list[index] = amount;
        this.dataServer.setUpgrades(list);
        this.markDataServerDirty();
        this.broadcastChanges();
    }

    public void UpdateServerTab(int tab, boolean screenIsTransferPanel) {
        if (this.gridPlayer.level().isClientSide) {
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SyncTabPacket(tab, screenIsTransferPanel));
        }
        this.tabPage = tab;
        this.screenIsTransferPanel = screenIsTransferPanel;
    }

    public void syncBooleanData(int index) {
        if (index == 17) {
            this.dataServer.bruteforce = this.omniGrid.bruteForceCrafting = !this.omniGrid.bruteForceCrafting;
            if (this.dataServer.bruteforce) {
                this.containerData.set(3, 1);
            } else {
                this.containerData.set(3, 0);
            }
            this.broadcastChanges();
            this.markDataServerDirty();
            return;
        }
        this.dataServer.disabledCommands[index] = !this.dataServer.disabledCommands[index];
        this.updateCommandsInstant();
    }

    public void syncCoreData(int index, boolean insertedCore) {
        CoreTypes type = CoreTypes.fromId(index -= 50);
        if (this.dataServer != null) {
            this.dataServer.setCoreInstalled(type, insertedCore);
            this.markDataServerDirty();
            Player player = this.gridPlayer;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                this.omniGrid.updateStorage();
                if (this.omniGrid.storage != null) {
                    this.omniGrid.storage.getProxxy().getTaskManager().dirty = true;
                }
                com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(sp, (CustomPacketPayload)new UpdateCommandData(this.dataServer));
            }
        }
        if (this.dataClient != null) {
            this.dataClient.setCoreInstalled(type, insertedCore);
        }
    }

    public void slotsChanged(Container container) {
        if (container == this.craftingGrid.getCraftingMatrix()) {
            this.SaveCraftingMatrix();
        }
        if (container == this.upgradeContainer) {
            this.onUpgradeContainerChanged();
        }
        this.markDataServerDirty();
        this.updateImmediete = true;
        super.slotsChanged(container);
    }

    private int[] readUpgradeCountsFromUi() {
        int[] counts = new int[4];
        for (int i = 0; i < 4; ++i) {
            ItemStack s = this.upgradeContainer.getItem(i);
            counts[i] = s.isEmpty() ? 0 : s.getCount();
        }
        return counts;
    }

    private boolean isBlockMode() {
        return this.disabledSlot == null;
    }

    private void sendUpgradeDeltasToServerIfClient(int[] newCounts) {
        if (!this.gridPlayer.level().isClientSide()) {
            return;
        }
        this.dataClient.setUpgrades(newCounts);
        if (!this.isBlockMode()) {
            return;
        }
        if (!this.upgradeSendLimiter.tryAcquire()) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.lastCommittedUpgradeCounts[i] == newCounts[i]) continue;
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new UpdateUpgrades(i, newCounts[i]));
            if (i != 3) continue;
        }
    }

    private void onUpgradeContainerChanged() {
        ItemStack item;
        OmniCommandData data;
        Optional resolved;
        if (!this.loadedSlots) {
            return;
        }
        int[] newCounts = this.readUpgradeCountsFromUi();
        this.sendUpgradeDeltasToServerIfClient(newCounts);
        if (this.upgradeContainer instanceof UpgradeCountContainer) {
            InWorldOmniGrid world;
            OmniCommandData data2;
            CraftingGrid craftingGrid;
            if (!this.gridPlayer.level().isClientSide() && (craftingGrid = this.craftingGrid) instanceof InWorldOmniGrid && !Arrays.equals((data2 = (world = (InWorldOmniGrid)craftingGrid).getBlockEntity().getOmniData()).getUpgrades(), newCounts)) {
                data2.setUpgrades((int[])newCounts.clone());
                world.getBlockEntity().updateOmniController(data2);
                world.getBlockEntity().setChanged();
                this.dataClient = data2;
            }
        } else if (!this.gridPlayer.level().isClientSide() && this.disabledSlot != null && (resolved = this.disabledSlot.resolve(this.gridPlayer)) != null && resolved.isPresent() && !((ItemStack)resolved.get()).isEmpty() && (data = VirtualContainerUtil.loadOmniDataFromVirtual(item = (ItemStack)resolved.get(), this.gridPlayer)) != null && !Arrays.equals(data.getUpgrades(), newCounts)) {
            data.setUpgrades((int[])newCounts.clone());
            VirtualContainerUtil.saveOmniDataToVirtual(data, item, this.gridPlayer);
            OmniGridBlockItem.UpdatePlayerTransferCache(item, this.gridPlayer.level(), this.getDiskInventory());
            this.dataClient = data;
            this.gridPlayer.getInventory().setChanged();
        }
        this.lastCommittedUpgradeCounts = newCounts;
        this.broadcastChanges();
    }

    public boolean isBlock() {
        return this.disabledSlot == null;
    }

    public void recordDelta(ResourceKey key, long delta) {
        if (delta == 0L || key == null) {
            return;
        }
        ResourceKey normalizedKey = key;
        this.pendingDeltas.merge(normalizedKey, delta, Long::sum);
    }

    public void flushDeltas() {
        if (this.pendingDeltas.isEmpty()) {
            return;
        }
        for (Map.Entry<ResourceKey, Long> delta : this.pendingDeltas.entrySet()) {
            TrackedResource tr = this.getTrackedResource(delta.getKey());
            this.onChanged(delta.getKey(), delta.getValue(), tr);
        }
        this.pendingDeltas.clear();
    }

    private void populateUiFromData(OmniCommandData data) {
        if (this.upgradeContainer != null) {
            int[] u = data.getUpgrades();
            this.upgradeContainer.setItem(0, u[0] > 0 ? new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade(), u[0]) : ItemStack.EMPTY);
            this.upgradeContainer.setItem(1, u[1] > 0 ? new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStackUpgrade(), u[1]) : ItemStack.EMPTY);
            this.upgradeContainer.setItem(2, u[2] > 0 ? new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getRangeUpgrade(), u[2]) : ItemStack.EMPTY);
            this.upgradeContainer.setItem(3, u[3] > 0 ? new ItemStack((ItemLike)Items.INSTANCE.getOmniEnergy(), u[3]) : ItemStack.EMPTY);
            this.upgradeContainer.setChanged();
        }
        if (this.resourceSlots != null && data.commands != null) {
            for (int i = 0; i < Math.min(this.resourceSlots.length, data.commands.length); ++i) {
                boolean shouldUpdateCore;
                if (this.resourceSlots[i] != null) {
                    this.resourceSlots[i].setFilter(data.commands[i].getResource());
                }
                if (this.coreSlots == null || this.coreSlots[i] == null || !(shouldUpdateCore = this.coreSlots[i].getItem().isEmpty())) continue;
                this.coreSlots[i].set(ItemStack.EMPTY);
            }
        }
        if (this.furnaceSlots != null) {
            this.furnaceContainer.clear();
            for (int i = 0; i < 12; ++i) {
                long amt;
                PlatformResourceKey key = i < 8 ? data.furnaceData.smeltItems[i] : data.furnaceData.fuelItems[i - 8];
                long l = amt = i < 8 ? data.furnaceData.toSmelt[i] : 1L;
                if (key == null || AbstractOmniGridContainerMenu.isAirResource(key)) continue;
                this.furnaceContainer.set(i, new ResourceAmount((ResourceKey)key, amt));
                this.furnaceSlots[i].setFilter(key);
                this.furnaceSlots[i].changeAmount(amt);
            }
            this.containerData.setFuel(data.furnaceData.fuel);
        }
        if (this.trackedContainer != null) {
            for (int i = 0; i < 4; ++i) {
                if (data.tracked[i] == null) continue;
                this.trackedContainer.set(i, new ResourceAmount((ResourceKey)data.tracked[i], 1L));
            }
        }
        this.surpressUpdate = false;
        this.furnaceContainer.toItemContainer().setChanged();
        this.trackedContainer.toItemContainer().setChanged();
        this.slotsChanged(this.furnaceContainer.toItemContainer());
        if (this.gridPlayer.level().isClientSide) {
            this.sortDelayTicks = 30;
            if (this.disabledSlot != null) {
                this.storageReference = Objects.requireNonNull((UUID)((ItemStack)this.disabledSlot.resolve(this.gridPlayer).get()).get(DataComponents.INSTANCE.getStorageReference()));
            } else if (this.storageReference == null) {
                if (this.gridPlayer != null && this.gridPlayer.getMainHandItem().getItem() instanceof OmniProxyRemoteItem && this.gridPlayer.getMainHandItem().has(DataComponents.INSTANCE.getStorageReference())) {
                    this.storageReference = (UUID)this.gridPlayer.getMainHandItem().get(DataComponents.INSTANCE.getStorageReference());
                }
                if (this.storageReference == null) {
                    this.storageReference = ClientModInitializer.getStorageReferenceForClient();
                }
            }
            if (this instanceof OmniGridItemContainerMenu) {
                this.blockEntityPosition = this.gridPlayer.blockPosition();
                this.isBlock = false;
            }
        } else {
            if (this.omniGrid != null) {
                this.omniGrid.bruteForceCrafting = data.bruteforce;
            }
            if (data.bruteforce) {
                this.containerData.set(3, 1);
            } else {
                this.containerData.set(3, 0);
            }
            this.markDataServerDirty();
            this.urgent = true;
        }
        this.broadcastChanges();
    }

    public static boolean isAirResource(@Nullable PlatformResourceKey key) {
        ItemResource itemRes;
        Item item;
        if (key == null) {
            return true;
        }
        return key instanceof ItemResource && (item = (itemRes = (ItemResource)key).item()) == net.minecraft.world.item.Items.AIR;
    }

    public List<UtilityType> getUtilityTypes() {
        ArrayList<UtilityType> types = new ArrayList<UtilityType>();
        if (!this.loadedSlots || this.utilitySlots == null || this.utilitySlots.isEmpty()) {
            return types;
        }
        for (ToggleableUtilitySlot slot : this.utilitySlots) {
            ItemStack stack = slot.getItem();
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof OmniUtilityItem) {
                OmniUtilityItem item2 = (OmniUtilityItem)item;
                types.add(item2.getUtilityType());
            }
            if (!(stack.getItem() instanceof UtilityBundle)) continue;
            types.addAll(UtilityBundle.getUtilityTypes(stack));
        }
        return types;
    }

    private void rebuildUtilityCache() {
        this.cachedUtilities.clear();
        this.cachedAutocraftables.clear();
        if (!this.loadedSlots || this.utilitySlots == null || this.utilitySlots.isEmpty()) {
            this.utilityCacheDirty = false;
            return;
        }
        for (ToggleableUtilitySlot slot : this.utilitySlots) {
            PatternItem util;
            ItemStack stack = slot.getItem();
            if (stack.isEmpty()) continue;
            Object object = stack.getItem();
            if (object instanceof OmniUtilityItem) {
                OmniUtilityItem item = (OmniUtilityItem)((Object)object);
                this.cachedUtilities.add(item.getUtilityType());
            }
            if ((object = stack.getItem()) instanceof UtilityBundle) {
                UtilityBundle bundle = (UtilityBundle)((Object)object);
                this.cachedUtilities.addAll(UtilityBundle.getUtilityTypes(stack));
                this.cachedAutocraftables.addAll(UtilityBundle.getPatternOutputs(stack, this.gridPlayer.level()));
            }
            if (!((object = stack.getItem()) instanceof PatternItem) || !(util = (PatternItem)object).getPattern(stack, this.gridPlayer.level()).isPresent()) continue;
            for (ResourceAmount res : ((Pattern)util.getPattern(stack, this.gridPlayer.level()).get()).layout().outputs()) {
                this.cachedAutocraftables.add(res.resource());
            }
        }
        this.utilityCacheDirty = false;
    }

    public boolean isUtilityInstalled(UtilityType toCheck) {
        if (!this.gridPlayer.level().isClientSide) {
            return this.omniGrid.storage.getProxxy().utilityTypes.contains((Object)toCheck);
        }
        if (this.utilityCacheDirty || this.cachedUtilities.isEmpty()) {
            this.rebuildUtilityCache();
        }
        return this.cachedUtilities.contains((Object)toCheck);
    }

    public ItemStack getPattern() {
        ItemStack pattern = new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getPattern());
        return pattern;
    }

    public void buildCustomSlots(int playerInventoryY) {
        ToggleableCoreSlot coreSlot;
        int i;
        this.craftingMatrixSlots.clear();
        this.diskSlots.clear();
        this.markedContainerFilterSlots.clear();
        this.utilitySlots.clear();
        Arrays.fill((Object[])this.upgradeSlots, null);
        int slotYBase = playerInventoryY - 69 - 38;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int sx = 20 + x * 18;
                int sy = playerInventoryY - 69 + y * 18 + 2;
                ToggleableSlot s = (ToggleableSlot)this.addSlot(new ToggleableSlot((Container)this.craftingGrid.getCraftingMatrix(), x + y * 3, sx, sy, 0, this));
                this.craftingMatrixSlots.add(s);
            }
        }
        this.furnaceSlots = new OmniFurnaceSlot[12];
        int furnaceCounter = 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 4; ++x) {
                OmniFurnaceSlot s;
                MutableComponent component;
                int sx = 11 + x * 18;
                int sy = playerInventoryY - 69 + y * 18;
                boolean smelting = true;
                ResourceSlotType type = ResourceSlotType.FILTER_WITH_AMOUNT;
                if (furnaceCounter < 8) {
                    component = Component.literal((String)"Digital Furnace - The Omni Grid will smelt this quantity of the resource from storage");
                } else {
                    smelting = false;
                    type = ResourceSlotType.FILTER;
                    MutableComponent desc = Component.literal((String)"Converts burnable items and fluid lava in storage to fuel.");
                    if (ModList.get().isLoaded("refinedtypes")) {
                        desc = Component.literal((String)"Converts burnable items and fluid lava in storage to fuel.\nEnergy stored in energy disks can also be used.");
                    }
                    component = desc;
                    sy += 7;
                }
                this.furnaceSlots[furnaceCounter] = s = (OmniFurnaceSlot)this.addSlot((Slot)new OmniFurnaceSlot(smelting, this, this.furnaceContainer, furnaceCounter, (Component)component, sx, sy, type, slot -> this.syncFurnace(slot.getDataIndex())));
                ++furnaceCounter;
            }
        }
        ResourceContainer commandRequested = ResourceContainerImpl.createForFilter((int)1);
        this.toggleableResourceSlot = (ToggleableResourceSlot)this.addSlot((Slot)new ToggleableResourceSlot(commandRequested, 0, (Component)Component.literal((String)"A command requested this to be smelt"), 70, -9999, ResourceSlotType.FILTER, this, 1));
        this.toggleableResourceSlot.isFurnaceDisplay = true;
        this.result = (CraftingGridResultSlot)this.addSlot((Slot)new CraftingGridResultSlot(this.gridPlayer, this.craftingGrid, 103, playerInventoryY - 69 + 18 + 2));
        int indx = 20;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 7; ++x) {
                int sx = 11 + x * 18;
                int sy = playerInventoryY - 69 + y * 18 - 2 + 5;
                ToggleableUtilitySlot s = (ToggleableUtilitySlot)this.addSlot(new ToggleableUtilitySlot((Container)this.diskInventory, this, indx, sx, sy));
                this.utilitySlots.add(s);
                ++indx;
            }
        }
        this.quickPatternContainer = new QuickPatternContainer();
        Slot tqs = this.addSlot(new ToggleableQuickCraftingSlot((Container)this.quickPatternContainer, 0, this.result.x - 26, this.result.y - 22, 0, this));
        tqs.set(this.getPattern());
        this.quickPatternContainer.setItem(0, this.getPattern());
        this.quickPatternContainer.setChanged();
        int bottomRowY = playerInventoryY - 69 + 36 - 2;
        int trackedY = bottomRowY + 18;
        this.trackedSlots = new ToggleableMonitoredResourceSlot[4];
        int idx0 = 0;
        for (i = 0; i < 2; ++i) {
            for (int o = 0; o < 2; ++o) {
                int sx = 162 + i * 18;
                int sy = trackedY + o * 18 - 40;
                this.trackedSlots[i] = (ToggleableMonitoredResourceSlot)this.addSlot((Slot)new ToggleableMonitoredResourceSlot(this.trackedContainer, idx0, (Component)Component.empty(), sx, sy, ResourceSlotType.FILTER, this));
                ++idx0;
            }
        }
        for (i = 0; i < 4; ++i) {
            this.getDiskSlots().add(this.addSlot(new ToggleableDiskSlot((Container)this.diskInventory, i, -16, 4 + 18 * i, -1, this)));
            this.getDiskSlots().add(this.addSlot(new ToggleableDiskSlot((Container)this.diskInventory, i + 4, -34, 4 + 18 * i, -1, this)));
        }
        for (i = 0; i < 4; ++i) {
            OmniUpgradeSlot u;
            int idx = i;
            boolean isCountBacked = this.upgradeContainer instanceof UpgradeCountContainer;
            this.upgradeSlots[i] = u = new OmniUpgradeSlot(this.getUpgradeContainer(), i, 191, bottomRowY + 40 + 18 * i, slot -> {
                if (isCountBacked) {
                    this.syncUpgrade(idx);
                } else {
                    ItemStack s = this.upgradeContainer.getItem(idx);
                    int amount = s.isEmpty() ? 0 : s.getCount();
                    int[] up = this.getDataClient().getUpgrades();
                    up[idx] = amount;
                    this.getDataClient().setUpgrades(up);
                    if (!this.gridPlayer.level().isClientSide()) {
                        this.syncUpgradeDataItemModeImmediate(idx, amount);
                    }
                }
            });
            this.addSlot(u);
        }
        for (i = 0; i < 3; ++i) {
            MarkedContainerFilterSlot marked = new MarkedContainerFilterSlot((Container)this.diskInventory, i + 17, 128 + 18 * i + 1000, slotYBase + 54);
            this.markedContainerFilterSlots.add(marked);
            this.addSlot((Slot)marked);
        }
        ResourceContainer commands = ResourceContainerImpl.createForFilter((int)16);
        int resourceCounter = 0;
        boolean coreCounter = false;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                OmniResourceSlot s;
                this.resourceSlots[resourceCounter] = s = (OmniResourceSlot)this.addSlot((Slot)new OmniResourceSlot(commands, resourceCounter, (Component)Component.literal((String)"Left-Click to Configure\n").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"Right-Click to Clear").withStyle(ChatFormatting.YELLOW)), 135 + col * 18, slotYBase + 18 * row + 36, ResourceSlotType.FILTER, c -> this.syncSlot(c.getDataIndex()), this));
                ++resourceCounter;
            }
        }
        int yCoreBase = slotYBase + 36 + 18;
        int counter = 0;
        for (TripleInt cord : AbstractOmniGridContainerMenu.slotPositions(50, 11, yCoreBase, 5, 2, 18)) {
            coreSlot = (ToggleableCoreSlot)this.addSlot(new ToggleableCoreSlot((Container)this.diskInventory, this, cord.index, cord.x, cord.y, counter));
            this.addSlot(coreSlot);
            this.coreSlots[counter] = coreSlot;
            ++counter;
        }
        for (TripleInt cord : AbstractOmniGridContainerMenu.slotPositions(60, 108, yCoreBase, 3, 2, 18)) {
            coreSlot = (ToggleableCoreSlot)this.addSlot(new ToggleableCoreSlot((Container)this.diskInventory, this, cord.index, cord.x, cord.y, counter));
            this.addSlot(coreSlot);
            this.coreSlots[counter] = coreSlot;
            ++counter;
        }
        for (TripleInt cord : AbstractOmniGridContainerMenu.slotPositions(66, 168, yCoreBase, 2, 2, 18)) {
            coreSlot = (ToggleableCoreSlot)this.addSlot(new ToggleableCoreSlot((Container)this.diskInventory, this, cord.index, cord.x, cord.y, counter));
            this.addSlot(coreSlot);
            this.coreSlots[counter] = coreSlot;
            ++counter;
        }
        if (this.blockEntityPosition == null && !this.isBlock) {
            this.blockEntityPosition = this.gridPlayer.blockPosition();
        }
        this.furnaceUiReady = true;
    }

    public static List<TripleInt> slotPositions(int startingIndex, int x, int y, int width, int height, int size) {
        ArrayList<TripleInt> vec3s = new ArrayList<TripleInt>();
        for (int o = 0; o < height; ++o) {
            for (int i = 0; i < width; ++i) {
                vec3s.add(new TripleInt(startingIndex, x + i * size, y + o * size));
                ++startingIndex;
            }
        }
        return vec3s;
    }

    record TrackedSnapshot(ResourceKey resource, long amount, @Nullable TrackedResource tracked) {
    }

    public record TripleInt(int index, int x, int y) {
    }
}

