/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.google.common.util.concurrent.RateLimiter;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.omnigrid.Utils.OmniProxxyStorage;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.Utils.VirtualContainerUtil;
import com.omnigrid.customRender.OmniClientBlockPacket;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.AbstractOmniGridEntity;
import com.omnigrid.neoforge.BlockEntities;
import com.omnigrid.neoforge.ContentNames;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.InWorldOmniGrid;
import com.omnigrid.neoforge.ModInitializer;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniGrid;
import com.omnigrid.neoforge.OmniGridBlock;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridResourceHandler;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniUtilityInventory;
import com.omnigrid.neoforge.Platform;
import com.omnigrid.neoforge.UpgradeableEnergyStorage;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.DiskStateChangeListener;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOmniGridBlockEntity<T extends AbstractStorageContainerNetworkNode>
extends AbstractBaseNetworkNodeContainerBlockEntity<T>
implements AbstractStorageContainerNetworkNode.Provider {
    public static final String TAG_DISK_INVENTORY = "inv";
    private static final String TAG_DISKS = "disks";
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractOmniGridBlockEntity.class);
    private UUID placedBy;
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> energyCaches = new EnumMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>>(Direction.class);
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> containerCaches = new EnumMap<Direction, BlockCapabilityCache<IItemHandler, Direction>>(Direction.class);
    private final Map<Direction, BlockCapabilityCache<IFluidHandler, Direction>> fluidCaches = new EnumMap<Direction, BlockCapabilityCache<IFluidHandler, Direction>>(Direction.class);
    public int resetGrid = 0;
    private boolean disableUpdate = false;
    public int activeTaskCount = 0;
    public ItemEnchantments enchantments;
    @Nullable
    public OmniItemProxxy proxxy;
    public final InWorldOmniGrid inWorldOmniGrid;
    public int activity = 0;
    private long lastTransferUpdateRequestTick = 0L;
    private boolean pendingTransferRebuild = false;
    private static final int TRANSFER_REBUILD_DELAY_TICKS = 5;
    public final Map<Direction, OmniGridResourceHandler> resourceHandler = new EnumMap<Direction, OmniGridResourceHandler>(Direction.class);
    public final DiskStateChangeListener diskStateListener = new DiskStateChangeListener((BlockEntity)this);
    private UpgradeableEnergyStorage energyStorage;
    private final RateLimiter activenessChangeRateLimiter = RateLimiter.create((double)1.0);
    private boolean updatedEnergy = false;
    public int customModel = 7;
    private static final String TAG_CUSTOM_MODEL = "CustomModel";
    private UUID storageReference;
    public static final String TAG_STORAGE_ID = "sid";
    public boolean pendingVirtualCorrection = true;
    private boolean startupTransfer = false;
    private static final GameProfile OMNI_FAKE_PROFILE = new GameProfile(UUID.nameUUIDFromBytes("omni-grid-fake-player".getBytes()), "[OmniGridFake]");
    private static final Map<ServerLevel, FakePlayer> FAKE_PLAYERS = new WeakHashMap<ServerLevel, FakePlayer>();

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.initialize(this.level);
        }
    }

    public IItemHandler getItemHandler(Direction side) {
        return this.resourceHandler.get(side);
    }

    public IFluidHandler getFluidHandler(Direction side) {
        return this.resourceHandler.get(side);
    }

    protected AbstractOmniGridBlockEntity(BlockPos pos, BlockState state, T node) {
        super(AbstractOmniGridBlockEntity.getBlockEntityType(), pos, state, node);
        this.energyStorage = AbstractOmniGridBlockEntity.createEnergyStorage(this, 4);
        this.inWorldOmniGrid = new InWorldOmniGrid((EnergyStorage)this.energyStorage, (StateTrackedStorage.Listener)this.diskStateListener, this);
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setListener((StateTrackedStorage.Listener)this.diskStateListener);
    }

    public void initialize(Level level) {
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setProvider((AbstractStorageContainerNetworkNode.Provider)this);
    }

    public Component getName() {
        MutableComponent defaultName = ContentNames.omni_grid;
        return this.getCustomName() == null ? defaultName : this.getCustomName();
    }

    private void onDiskChanged(int index) {
        boolean isJustPlacedIntoLevelOrLoading;
        boolean bl = isJustPlacedIntoLevelOrLoading = this.level == null || this.level.isClientSide();
        if (isJustPlacedIntoLevelOrLoading || this.disableUpdate || index <= 7) {
            return;
        }
        this.UpdateTransferCaches();
        PlatformUtil.sendBlockUpdateToClient((Level)this.level, (BlockPos)this.worldPosition);
        this.setChanged();
    }

    public void UpdateTransferCaches() {
        if (this.inWorldOmniGrid != null) {
            this.inWorldOmniGrid.updateStorage();
        }
        this.pendingTransferRebuild = true;
        this.lastTransferUpdateRequestTick = this.level.getGameTime();
    }

    public void ResetTransferCaches() {
        if (this.pendingVirtualCorrection) {
            return;
        }
        boolean validStorage = this.inWorldOmniGrid.updateStorage();
        this.UpdateEnergyCapacity();
        if (this.getInWorldOmniGrid().storage == null) {
            LOGGER.debug("No storage, skipping cache update");
            return;
        }
        if (this.setProxxy()) {
            for (Direction direction : Direction.values()) {
                Direction facing = ((BiDirection)this.getBlockState().getValue((Property)BiDirectionType.INSTANCE.getProperty())).asDirection();
                Direction rotated = AbstractOmniGridBlockEntity.rotateDirection(direction, facing);
                if (direction == Direction.EAST || direction == Direction.WEST) {
                    rotated = rotated.getOpposite();
                }
                this.initCache(rotated);
            }
        }
        this.update(this.getBlockState());
    }

    public static boolean contains(int[] array, int target) {
        for (int i : array) {
            if (i != target) continue;
            return true;
        }
        return false;
    }

    private Direction rotateByFacing(Direction local, Direction gridFacing) {
        return switch (gridFacing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> local;
            case Direction.SOUTH -> local.getOpposite();
            case Direction.WEST -> local.getClockWise();
            case Direction.EAST -> local.getCounterClockWise();
            case Direction.UP, Direction.DOWN -> local;
        };
    }

    private BlockPos offsetPos(BlockPos origin, Direction dir) {
        return origin.relative(dir);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getStorageReference() != null) {
                try {
                    ModInitializer.SaveProxxyInfo(this.storageReference, this.level);
                    tag.putUUID(TAG_STORAGE_ID, this.storageReference);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.enchantments != null) {
            Optional result = ItemEnchantments.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.enchantments).result();
            result.ifPresent(enchantTag -> tag.put("Enchantments", enchantTag));
        }
        ItemBlockEnergyStorage.writeToTag((CompoundTag)tag, (long)this.energyStorage.getStored());
        this.writeConfiguration(tag, provider);
        if (this.placedBy != null) {
            tag.putUUID("pbpid", this.placedBy);
        }
    }

    public OmniCommandData getOmniData() {
        return this.proxxy.getCachedData();
    }

    public boolean setProxxy() {
        this.proxxy = VirtualContainerUtil.proxxyFromVirtualData(this.level, this.storageReference, this.getBlockPos(), ((BiDirection)this.getBlockState().getValue((Property)BiDirectionType.INSTANCE.getProperty())).asDirection(), this.energyStorage);
        Block block = this.getBlockState().getBlock();
        if (block instanceof OmniGridBlock) {
            OmniGridBlock grid = (OmniGridBlock)block;
            v0 = (Integer)this.getBlockState().getValue((Property)OmniGridBlock.CUSTOM_MODEL_DATA);
        } else {
            v0 = this.proxxy.color = 0;
        }
        if (OmniGridBlockItem.GLOBAL_STORAGES.containsKey(this.storageReference)) {
            TransferUtils.transferProxxyData(OmniGridBlockItem.GLOBAL_STORAGES.get(this.storageReference), this.proxxy);
        }
        if (this.getCustomName() != null) {
            this.proxxy.name = this.getCustomName();
        }
        if (this.resourceHandler.isEmpty()) {
            for (Direction direction : Direction.values()) {
                OmniGridResourceHandler handler = new OmniGridResourceHandler(this);
                this.resourceHandler.put(direction, handler);
            }
        }
        this.energyStorage.uuid = this.storageReference;
        this.proxxy.blockPos = this.getBlockPos();
        this.inWorldOmniGrid.setId(this.storageReference);
        OmniGridBlockItem.GLOBAL_STORAGES.put(this.storageReference, this.proxxy);
        this.inWorldOmniGrid.updateStorage();
        return true;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        Level level;
        if (tag.contains("omnigrid-ProxxyID")) {
            // empty if block
        }
        if (tag.contains(TAG_STORAGE_ID)) {
            this.storageReference = tag.getUUID(TAG_STORAGE_ID);
        }
        this.disableUpdate = true;
        if (tag.contains("Enchantments")) {
            this.enchantments = ItemEnchantments.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Enchantments")).result().orElse(ItemEnchantments.EMPTY);
        }
        this.disableUpdate = false;
        if (tag.contains(TAG_CUSTOM_MODEL, 3)) {
            this.customModel = tag.getInt(TAG_CUSTOM_MODEL);
        }
        ItemBlockEnergyStorage.readFromTag((EnergyStorage)this.energyStorage, (CompoundTag)tag);
        this.readConfiguration(tag, provider);
        if (tag.hasUUID("pbpid")) {
            this.placedBy = tag.getUUID("pbpid");
            this.setPlacedBy(this.placedBy);
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getStorageReference() != null) {
                this.setProxxy();
            }
        }
    }

    public void fixVirtualData() {
        Level level;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.pendingVirtualCorrection && !this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.storageReference == null) {
                if (serverLevel.getServer().getPlayerList().getPlayerCount() > 0) {
                    ServerPlayer player = (ServerPlayer)serverLevel.getServer().getPlayerList().getPlayers().get(0);
                    this.registerVirtualStorage((Player)player);
                }
            } else {
                this.disableUpdate = true;
                VirtualContainerUtil.getVirtualInventory(this.getOmniUtilityInventory(), this.getStorageReference(), (Level)serverLevel);
                this.disableUpdate = false;
                this.pendingVirtualCorrection = false;
                if (this.proxxy == null) {
                    this.setProxxy();
                    this.proxxy.updateTrackedBlock(serverLevel, this.getBlockPos(), this.storageReference);
                    this.inWorldOmniGrid.updateStorage();
                }
                this.update(this.getBlockState());
                this.setChanged();
            }
        } else if (this.storageReference != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VirtualContainerUtil.getVirtualInventory(this.getOmniUtilityInventory(), this.storageReference, (Level)serverLevel);
        }
    }

    public void registerVirtualStorage(Player player) {
        ItemStack virtualDisk = new ItemStack((ItemLike)Items.INSTANCE.getItemStorageDisk(ItemStorageVariant.ONE_K));
        virtualDisk.inventoryTick(this.level, (Entity)player, 0, false);
        DataComponents rsData = DataComponents.INSTANCE;
        UUID newRef = (UUID)virtualDisk.get(rsData.getStorageReference());
        this.setStorageReference(newRef);
    }

    public void markDataDirty() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        CompoundTag tag = pkt.getTag();
        if (tag != null && tag.hasUUID("StorageReference")) {
            this.storageReference = tag.getUUID("StorageReference");
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        if (tag.hasUUID("StorageReference")) {
            this.storageReference = tag.getUUID("StorageReference");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.storageReference != null) {
            tag.putUUID("StorageReference", this.storageReference);
        }
        return tag;
    }

    public static boolean containsItem(ItemStack[] list, ItemStack item) {
        for (ItemStack stack : list) {
            if (stack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)item)) continue;
            return true;
        }
        return false;
    }

    private static BlockEntityType<AbstractOmniGridEntity> getBlockEntityType() {
        return BlockEntities.INSTANCE.getOmniGrid();
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((BlockState)oldBlockState, (BlockState)newBlockState);
    }

    private static UpgradeableEnergyStorage createEnergyStorage(AbstractOmniGridBlockEntity blockEntity, int multiplier) {
        return new UpgradeableEnergyStorage(Platform.getConfig().getOmniGrid().getEnergyCapacity() * (long)multiplier, blockEntity.storageReference);
    }

    public void UpdateEnergyCapacity() {
        if (this.proxxy != null) {
            long capacity = Platform.getConfig().getOmniGrid().getEnergyCapacity() * (long)(this.proxxy.energy + 1);
            this.energyStorage.setStored(Math.min(capacity, this.energyStorage.getStored()));
            this.energyStorage.setCapacity(capacity);
            this.updatedEnergy = true;
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getStorageReference() == null) {
                this.migrateLegacyData(serverLevel);
            }
            this.initialize(level);
            this.inWorldOmniGrid.initRecipie(() -> ((AbstractOmniGridBlockEntity)this).getLevel());
        }
    }

    private void migrateLegacyData(ServerLevel serverLevel) {
        CustomData beData = (CustomData)this.components().get(net.minecraft.core.component.DataComponents.BLOCK_ENTITY_DATA);
        if (beData == null) {
            return;
        }
        CompoundTag tag = beData.copyTag();
        if (!tag.contains(TAG_DISK_INVENTORY)) {
            return;
        }
        ItemStack virtualDisk = new ItemStack((ItemLike)Items.INSTANCE.getItemStorageDisk(ItemStorageVariant.ONE_K));
        virtualDisk.inventoryTick((Level)serverLevel, null, 0, false);
        UUID newRef = (UUID)virtualDisk.get(DataComponents.INSTANCE.getStorageReference());
        if (newRef == null) {
            return;
        }
        this.setStorageReference(newRef);
        SimpleContainer inv = new SimpleContainer(32);
        ContainerUtil.read((CompoundTag)tag.getCompound(TAG_DISK_INVENTORY), (Container)inv, (HolderLookup.Provider)serverLevel.registryAccess());
        tag.remove(TAG_DISK_INVENTORY);
    }

    public void update(BlockState state) {
        Level powerToTake2;
        ServerLevel serverLevel;
        boolean validStorage;
        long now;
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.pendingTransferRebuild && (now = this.level.getGameTime()) - this.lastTransferUpdateRequestTick >= 5L) {
            this.pendingTransferRebuild = false;
            this.ResetTransferCaches();
        }
        if (this.getLevel() == null) {
            return;
        }
        this.fixVirtualData();
        if (this.level != null && this.resetGrid < 100) {
            ++this.resetGrid;
            if (this.resetGrid >= 100) {
                this.level.neighborChanged(this.getBlockPos(), state.getBlock(), this.getBlockPos());
            }
        }
        this.diskStateListener.updateIfNecessary();
        boolean newActive = this.inWorldOmniGrid.isGridActive();
        boolean activenessNeedsUpdate = (Boolean)state.getValue((Property)OmniGridBlock.ACTIVE) != newActive;
        boolean bl = validStorage = this.inWorldOmniGrid.storage != null;
        if (!this.updatedEnergy) {
            this.UpdateEnergyCapacity();
        }
        if (this.activenessChangeRateLimiter.tryAcquire()) {
            Network net;
            Level level = this.level;
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                this.attemptAchievement(serverLevel);
            }
            this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
            if (this.activity > 0) {
                --this.activity;
            }
            if (this.inWorldOmniGrid.level == null) {
                this.inWorldOmniGrid.level = this.getLevel();
            }
            if (activenessNeedsUpdate) {
                this.updateActivenessBlockState(state, newActive);
                this.inWorldOmniGrid.activeChanged(newActive);
            }
            if (!this.startupTransfer && this.level != null && !this.level.isClientSide()) {
                this.UpdateTransferCaches();
                this.startupTransfer = true;
            }
            if ((net = ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork()) != null && ((EnergyNetworkComponent)net.getComponent(EnergyNetworkComponent.class)).getStored() > ((EnergyNetworkComponent)net.getComponent(EnergyNetworkComponent.class)).getCapacity() / 10L && this.getEnergyStorage().getStored() < this.getEnergyStorage().getCapacity()) {
                long powerToTake2 = this.getEnergyStorage().getCapacity() - this.getEnergyStorage().getStored();
                powerToTake2 = Math.min(powerToTake2, Platform.getConfig().getOmniGrid().omniNetworkChargeRate());
                this.getEnergyStorage().receive(((EnergyNetworkComponent)net.getComponent(EnergyNetworkComponent.class)).extract(powerToTake2), Action.EXECUTE);
            }
        }
        if (!this.getInWorldOmniGrid().isGridActive() || !validStorage) {
            return;
        }
        if (this.proxxy != null && (powerToTake2 = this.level) instanceof ServerLevel) {
            serverLevel = (ServerLevel)powerToTake2;
            if (this.proxxy.isDirty()) {
                this.setProxxy();
                return;
            }
            if (this.proxxy.diminishStress(this.energyStorage)) {
                return;
            }
            if (this.proxxy.attemptProcess()) {
                if (this.proxxy.dirtyUI) {
                    this.proxxy.dirtyUI = false;
                }
                boolean smeltingChange = false;
                if (this.proxxy.getCachedData().isCoreInstalled(CoreTypes.FURNACE)) {
                    smeltingChange = this.proxxy.attemptSmelt(this.level, null);
                }
                boolean craftingChange = false;
                if (this.proxxy.getCachedData().isCoreInstalled(CoreTypes.AUTOCRAFTING)) {
                    ServerPlayer placer = null;
                    placer = serverLevel.getServer().getPlayerList().getPlayer(this.placedBy);
                    craftingChange = this.proxxy.getTaskManager().tickCrafting(this.level, (Player)placer);
                } else if (!this.proxxy.getTaskManager().getTasks().isEmpty()) {
                    this.proxxy.getTaskManager().clearAll();
                }
                this.proxxy.stress += (float)this.proxxy.getOrCreateStorage().consumePrinterDrain();
                if (smeltingChange || craftingChange) {
                    for (ServerPlayer p : serverLevel.players()) {
                        InWorldOmniGrid iwo;
                        AbstractContainerMenu abstractContainerMenu = p.containerMenu;
                        if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
                        AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                        OmniGrid omniGrid = menu.omniGrid;
                        if (!(omniGrid instanceof InWorldOmniGrid) || (iwo = (InWorldOmniGrid)omniGrid) != this.inWorldOmniGrid) continue;
                        menu.flushDeltas();
                    }
                }
                if (this.proxxy.utilityTypes.contains((Object)UtilityType.CREATIVE)) {
                    this.proxxy.stress = 0.0f;
                    this.proxxy.fuel = 25000;
                    if (this.energyStorage.getStored() < this.energyStorage.getCapacity()) {
                        this.energyStorage.receive(this.energyStorage.getCapacity() - this.energyStorage.getStored(), Action.EXECUTE);
                    }
                }
                this.proxxy.updateTrackedBlock(serverLevel, this.getBlockPos(), this.storageReference);
            }
        }
        if (this.proxxy == null) {
            return;
        }
        int baseInterval = 9;
        if (this.proxxy.overclock > 0) {
            --this.proxxy.overclock;
            this.spawnOverclockSmoke(this.proxxy.utilityTypes.contains((Object)UtilityType.OVERCLOCKER));
            baseInterval = 6;
        }
        int tickInterval = this.proxxy.utilityTypes.contains((Object)UtilityType.CREATIVE) ? 1 : Math.max(1, baseInterval - this.proxxy.getSpeed() * 2);
        long now2 = this.level.getGameTime();
        if (now2 % (long)tickInterval == 0L && this.proxxy != null) {
            this.proxxy.doTasks(true, null);
        }
    }

    private void spawnOverclockSmoke(boolean blue) {
        ServerLevel server = (ServerLevel)this.level;
        if (server.random.nextFloat() >= 0.1f) {
            return;
        }
        SimpleParticleType particles = ParticleTypes.FLAME;
        if (blue) {
            particles = ParticleTypes.SOUL_FIRE_FLAME;
        }
        server.sendParticles((ParticleOptions)particles, (double)this.worldPosition.getX() + 0.5, (double)((float)this.worldPosition.getY() + 1.0f), (double)this.worldPosition.getZ() + 0.5, 2, 0.12, 0.02, 0.12, 0.01);
    }

    public void attemptAchievement(ServerLevel serverLevel) {
        int gridCounter = 0;
        for (Player player : AbstractOmniGridBlockEntity.getPlayersLookingAtBlock(serverLevel, this.getBlockPos(), 30.0)) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(sp, (CustomPacketPayload)new OmniClientBlockPacket(this.storageReference, this.proxxy.getCachedData().blockTargets));
            block1: for (OmniItemProxxy proxxy : OmniGridBlockItem.GLOBAL_STORAGES.values()) {
                if (proxxy.player != player.getUUID() || !proxxy.equipped) continue;
                for (int i = 0; i < 4; ++i) {
                    if (proxxy.getCachedData().tracked[i] == null) continue;
                    ++gridCounter;
                    continue block1;
                }
            }
            if (gridCounter < 4) continue;
            TransferUtils.giveAdvancement(sp, "omni_sights", "sights");
        }
    }

    public static List<Player> getPlayersLookingAtBlock(ServerLevel level, BlockPos target, double toleranceDegrees) {
        if (level == null) {
            return List.of();
        }
        ArrayList<Player> result = new ArrayList<Player>();
        double cosTolerance = Math.cos(Math.toRadians(toleranceDegrees));
        Vec3 center = Vec3.atCenterOf((Vec3i)target);
        double maxDistanceSq = 1024.0;
        for (Player player : level.players()) {
            Vec3 look;
            Vec3 eye;
            Vec3 toBlock;
            double distSq;
            if (!player.isAlive() || player.isSpectator() || player.level() != level || (distSq = player.distanceToSqr(center)) > maxDistanceSq || !((toBlock = center.subtract(eye = player.getEyePosition()).normalize()).dot(look = player.getLookAngle().normalize()) >= cosTolerance)) continue;
            result.add(player);
        }
        return result;
    }

    public Optional<Storage> resolve(int i) {
        if (OmniGridBlockItem.GLOBAL_STORAGES.containsKey(this.storageReference) && OmniGridBlockItem.GLOBAL_STORAGES.get(this.storageReference).getCachedData().isCoreInstalled(CoreTypes.DISK_DRIVE)) {
            return Optional.of(new OmniProxxyStorage(this.storageReference));
        }
        return Optional.empty();
    }

    public static ServerPlayer getSafePlayer(ServerLevel level, @Nullable UUID uuid) {
        ServerPlayer real;
        if (uuid != null && (real = level.getServer().getPlayerList().getPlayer(uuid)) != null) {
            return real;
        }
        return (ServerPlayer)FAKE_PLAYERS.computeIfAbsent(level, l -> FakePlayerFactory.get((ServerLevel)l, (GameProfile)OMNI_FAKE_PROFILE));
    }

    public static ServerPlayer getPlayerFromUUID(ServerLevel level, @Nullable UUID uuid) {
        return AbstractOmniGridBlockEntity.getSafePlayer(level, uuid);
    }

    public static Direction rotateDirection(Direction dir, Direction facing) {
        if (!dir.getAxis().isHorizontal() || !facing.getAxis().isHorizontal()) {
            return dir;
        }
        int rotationSteps = switch (facing) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        Direction rotated = dir;
        for (int i = 0; i < rotationSteps; ++i) {
            rotated = rotated.getClockWise();
        }
        return rotated;
    }

    public void initCache(Direction direction) {
    }

    InWorldOmniGrid getInWorldOmniGrid() {
        return this.inWorldOmniGrid;
    }

    public void updateOmniController(OmniCommandData data) {
        ModInitializer.SaveProxxyInfo(this.storageReference, this.getLevel());
        this.UpdateTransferCaches();
    }

    public void updateActivenessBlockState(BlockState state, boolean active) {
        if (this.level != null) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)OmniGridBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    public void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        PlatformUtil.sendBlockUpdateToClient((Level)this.level, (BlockPos)this.worldPosition);
    }

    public OmniUtilityInventory getOmniUtilityInventory() {
        if (this.proxxy != null) {
            return this.proxxy.getInventory();
        }
        return null;
    }

    public UpgradeableEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    protected abstract void setFilters(Set<ResourceKey> var1);

    protected abstract void setNormalizer(UnaryOperator<ResourceKey> var1);

    public UUID getStorageReference() {
        return this.storageReference;
    }

    public void setStorageReference(UUID storageReference) {
        this.storageReference = storageReference;
    }
}

