/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.omnigrid.StorageProxy.OmniProxyStorageLootFunction;
import com.omnigrid.StorageProxy.ProxyDepositBlock;
import com.omnigrid.StorageProxy.ProxyPortBlock;
import com.omnigrid.StorageProxy.ResourceChestBlock;
import com.omnigrid.StorageProxy.StorageProxyBlock;
import com.omnigrid.Utils.CurioStats;
import com.omnigrid.Utils.ModUtil;
import com.omnigrid.Utils.OmniBlockTargetPair;
import com.omnigrid.Utils.OmniFilterData;
import com.omnigrid.Utils.OmniPresetData;
import com.omnigrid.Utils.OmniProxyBucket;
import com.omnigrid.neoforge.BlockEntities;
import com.omnigrid.neoforge.BlockEntityProviders;
import com.omnigrid.neoforge.BlockEntityTypeFactory;
import com.omnigrid.neoforge.Blocks;
import com.omnigrid.neoforge.ContentIds;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.LootFunctions;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniCommand;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniGridBlock;
import com.omnigrid.neoforge.OmniGridLootItemFunction;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;

public abstract class AbstractModInitializer {
    public static final StreamCodec<RegistryFriendlyByteBuf, OmniCommandData> OMNI_STREAM_CODEC = StreamCodec.of((buf, value) -> value.toNetwork((RegistryFriendlyByteBuf)buf), OmniCommandData::fromNetwork);
    public static final StreamCodec<RegistryFriendlyByteBuf, OmniCommand> OMNI_COMMAND_STREAM_CODEC = StreamCodec.of((buf, value) -> value.toNetwork((RegistryFriendlyByteBuf)buf), OmniCommand::fromNetwork);
    public static final StreamCodec<RegistryFriendlyByteBuf, OmniBlockTarget> OMNI_BLOCK_STREAM_CODEC = StreamCodec.of((buf, value) -> value.toNetwork((RegistryFriendlyByteBuf)buf), OmniBlockTarget::fromNetwork);

    protected final void registerBlockEntities(RegistryCallback<BlockEntityType<?>> callback, BlockEntityTypeFactory typeFactory, BlockEntityProviders providers) {
        BlockEntities.INSTANCE.setOmniBlockEntity(callback.register(ContentIds.omni_grid, () -> typeFactory.create(providers.omniGrid(), new Block[]{Blocks.INSTANCE.getOmniGridBlock()})));
        BlockEntities.INSTANCE.setOmniStorageProxy(callback.register(ModUtil.OmniIdentifier("omni_storage_proxy"), () -> typeFactory.create(providers.omniStorageProxy(), new Block[]{Blocks.INSTANCE.getStorageProxyBlock(), Blocks.INSTANCE.getStorageProxyController()})));
        BlockEntities.INSTANCE.setProxyDeposit(callback.register(ModUtil.OmniIdentifier("omni_deposit_proxy"), () -> typeFactory.create(providers.proxyInterface(), new Block[]{Blocks.INSTANCE.getProxyDepositBlock()})));
        BlockEntities.INSTANCE.setOmniDispenser(callback.register(ModUtil.OmniIdentifier("omni_port_proxy"), () -> typeFactory.create(providers.proxyDispenser(), new Block[]{Blocks.INSTANCE.getOmniPort(), Blocks.INSTANCE.getOmniPortAdvanced(), Blocks.INSTANCE.getOmniHub(), Blocks.INSTANCE.getOmniHubAdvanced()})));
        BlockEntities.INSTANCE.setResourceChest(callback.register(ModUtil.OmniIdentifier("omni_resource_chest"), () -> typeFactory.create(providers.resourceChest(), new Block[]{Blocks.INSTANCE.getResourceChestBlock()})));
    }

    protected final void registerLootFunctions(RegistryCallback<LootItemFunctionType<?>> callback) {
        LootFunctions.INSTANCE.setPortableCraftingGridLoot(callback.register(ModUtil.OmniIdentifier("omni_grid_loot"), () -> new LootItemFunctionType(MapCodec.unit((Object)((Object)new OmniGridLootItemFunction())))));
        LootFunctions.INSTANCE.setOmniProxyLoot(callback.register(ModUtil.OmniIdentifier("omni_proxy_loot"), () -> new LootItemFunctionType(MapCodec.unit((Object)new OmniProxyStorageLootFunction()))));
    }

    protected final void registerDataComponents(RegistryCallback<DataComponentType<?>> callback) {
        DataComponents.INSTANCE.setRestrictionMode(callback.register(ModUtil.OmniIdentifier("omni_restriction_data"), () -> DataComponentType.builder().persistent(DataComponents.RESTRICTION_MODE_CODEC).networkSynchronized(DataComponents.RESTRICTION_MODE_STREAM_CODEC).build()));
        DataComponents.INSTANCE.setUpgradeCores(callback.register(ModUtil.OmniIdentifier("omni_cores"), () -> DataComponentType.builder().persistent(DataComponents.UPGRADE_CORES_CODEC).networkSynchronized(DataComponents.UPGRADE_CORES_STREAM_CODEC).build()));
        DataComponents.INSTANCE.setCuriosData(callback.register(ModUtil.OmniIdentifier("omni_curios_data"), () -> DataComponentType.builder().persistent(CurioStats.CODEC).networkSynchronized(CurioStats.STREAM_CODEC).build()));
        DataComponents.INSTANCE.setLinkPair(() -> DataComponentType.builder().persistent(OmniBlockTargetPair.CODEC).networkSynchronized(OmniBlockTargetPair.STREAM_CODEC).build());
        DataComponents.INSTANCE.setOmniData(callback.register(ModUtil.OmniIdentifier("omni_command_data"), () -> DataComponentType.builder().persistent(OmniCommandData.OMNI_CODEC).networkSynchronized(OMNI_STREAM_CODEC).build()));
        DataComponents.INSTANCE.setOmniMode(callback.register(ModUtil.OmniIdentifier("omni_resource_index"), () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build()));
        DataComponents.INSTANCE.setOmni(callback.register(ModUtil.OmniIdentifier("omni_command"), () -> DataComponentType.builder().persistent(OmniCommand.COMMAND_CODEC).networkSynchronized(OMNI_COMMAND_STREAM_CODEC).build()));
        DataComponents.INSTANCE.setLink(callback.register(ModUtil.OmniIdentifier("omni_block"), () -> DataComponentType.builder().persistent(OmniBlockTarget.OMNI_BLOCK_CODEC).networkSynchronized(OMNI_BLOCK_STREAM_CODEC).build()));
        DataComponents.INSTANCE.setPresetData(callback.register(ModUtil.OmniIdentifier("omni_preset"), () -> DataComponentType.builder().persistent(OmniPresetData.CODEC).networkSynchronized(OmniPresetData.STREAM_CODEC).build()));
        DataComponents.INSTANCE.setFilterData(callback.register(ModUtil.OmniIdentifier("omni_filter_data"), () -> DataComponentType.builder().persistent(OmniFilterData.CODEC).networkSynchronized(OmniFilterData.STREAM_CODEC).build()));
    }

    protected final void registerBlocks(RegistryCallback<Block> callback, BlockEntityProviders blockEntityProviders) {
        Blocks.INSTANCE.setOmniBlock(callback.register(ContentIds.omni_grid, () -> new OmniGridBlock(blockEntityProviders.omniGrid())));
        Blocks.INSTANCE.setStorageProxyBlock(callback.register(ModUtil.OmniIdentifier("omni_storage_proxy"), StorageProxyBlock::new));
        Blocks.INSTANCE.setStorageProxyController(callback.register(ModUtil.OmniIdentifier("omni_controller_proxy"), StorageProxyBlock::new));
        Blocks.INSTANCE.setProxyDepositBlock(callback.register(ModUtil.OmniIdentifier("omni_deposit_proxy"), ProxyDepositBlock::new));
        Blocks.INSTANCE.setOmniPort(callback.register(ModUtil.OmniIdentifier("omni_port_proxy"), ProxyPortBlock::new));
        Blocks.INSTANCE.setOmniPortAdvanced(callback.register(ModUtil.OmniIdentifier("omni_port_proxy_advanced"), ProxyPortBlock::new));
        Blocks.INSTANCE.setOmniHub(callback.register(ModUtil.OmniIdentifier("omni_hub_proxy"), ProxyPortBlock::new));
        Blocks.INSTANCE.setOmniHubAdvanced(callback.register(ModUtil.OmniIdentifier("omni_hub_proxy_advanced"), ProxyPortBlock::new));
        Blocks.INSTANCE.setResourceChestBlock(callback.register(ModUtil.OmniIdentifier("omni_resource_chest"), ResourceChestBlock::new));
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (!mc.player.isCrouching()) {
            return;
        }
        ItemStack stack = mc.player.getMainHandItem();
        if (!(stack.getItem() instanceof OmniProxyBucket)) {
            return;
        }
        double delta = event.getScrollDeltaY();
        if (delta == 0.0) {
            return;
        }
    }
}

