/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.customRender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.omnigrid.StorageProxy.OmniProxyRemoteItem;
import com.omnigrid.Utils.QuantityIndicator;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.ClientResourceTracker;
import com.omnigrid.neoforge.OmniTransferEffect;
import com.omnigrid.neoforge.UpdateTracker;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class OmniGridBlockEntityRenderer
implements BlockEntityRenderer<AbstractOmniGridBlockEntity> {
    public OmniGridBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(AbstractOmniGridBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffers, int light, int overlay) {
        UUID id = be.getStorageReference();
        Level level = be.getLevel();
        boolean glow = this.shouldGlow(be);
        if (glow && level.getGameTime() % 10L == 0L) {
            OmniTransferEffect.clientEffects.add(new OmniTransferEffect(be.getBlockPos(), (short)be.customModel, true));
        }
        if (id == null || !UpdateTracker.CLIENT_TRACKERS.containsKey(id)) {
            return;
        }
        ClientResourceTracker tracker = UpdateTracker.CLIENT_TRACKERS.get(id);
        if (tracker == null) {
            return;
        }
        if (level == null) {
            return;
        }
        Direction facing = Direction.NORTH;
        BlockState state = be.getBlockState();
        if (state.hasProperty((Property)BiDirectionType.INSTANCE.getProperty())) {
            facing = ((BiDirection)state.getValue((Property)BiDirectionType.INSTANCE.getProperty())).asDirection();
        }
        pose.pushPose();
        pose.translate(0.5, 0.65, 0.5);
        float dist = 0.25f;
        float dx = 0.0f;
        float dz = 0.0f;
        switch (facing) {
            case NORTH: {
                dz = -dist;
                break;
            }
            case SOUTH: {
                dz = dist;
                break;
            }
            case EAST: {
                dx = dist;
                break;
            }
            case WEST: {
                dx = -dist;
            }
        }
        pose.translate(-dx, 0.0f, -dz);
        float yRot = facing.toYRot();
        pose.mulPose(Axis.YP.rotationDegrees(yRot + 180.0f));
        if (facing == Direction.EAST || facing == Direction.WEST) {
            pose.mulPose(Axis.XP.rotationDegrees(180.0f));
        } else {
            pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
        float spacing = 0.5f;
        float startX = -0.75f;
        float scale = 0.33f;
        pose.scale(0.33f, 0.33f, 0.33f);
        float textScale = 0.017f;
        for (int i = 0; i < 4; ++i) {
            PlatformResourceKey key;
            if (!tracker.resource(i).isPresent() || (key = tracker.resource(i).get()) == null) continue;
            float x = -0.75f + (float)i * 0.5f;
            pose.pushPose();
            pose.translate(x, 0.0f, 0.0f);
            if (facing == Direction.EAST || facing == Direction.WEST) {
                pose.mulPose(Axis.XP.rotationDegrees(180.0f));
            } else {
                pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
                pose.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            OmniGridBlockEntityRenderer.renderResource(key, pose, buffers, level);
            pose.popPose();
            long amount = tracker.count(i);
            if (amount <= 0L) continue;
            String text = QuantityIndicator.formatQuantity(amount);
            pose.pushPose();
            pose.translate(x, 0.22f, 0.01f);
            pose.scale(0.017f, 0.017f, 0.017f);
            this.drawTextCentered(pose, buffers, text, light);
            pose.popPose();
        }
        pose.popPose();
    }

    private boolean shouldGlow(AbstractOmniGridBlockEntity be) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        ItemStack held = mc.player.getMainHandItem();
        if (held.isEmpty()) {
            return false;
        }
        if (!(held.getItem() instanceof OmniProxyRemoteItem)) {
            return false;
        }
        UUID ref = (UUID)held.get(DataComponents.INSTANCE.getStorageReference());
        if (ref == null) {
            return false;
        }
        return ref.equals(be.getStorageReference());
    }

    public static void renderResource(PlatformResourceKey resourceKey, PoseStack pose, MultiBufferSource multiBufferSource, Level level) {
        ResourceRendering renderer = RefinedStorageClientApi.INSTANCE.getResourceRendering(resourceKey.getClass());
        renderer.render((ResourceKey)resourceKey, pose, multiBufferSource, 0xF000F0, level);
    }

    private static void spawnLinkParticles(Level level, BlockPos pos) {
        double cx = (double)pos.getX() + 0.5;
        double cy = (double)pos.getY() + 0.8;
        double cz = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, cx, cy + 0.35, cz, 0.0, 0.02, 0.0);
    }

    private static void quad(VertexConsumer vc, PoseStack.Pose pose, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, int light) {
        int blockLight = LightTexture.block((int)light);
        int skyLight = LightTexture.sky((int)light);
        vc.addVertex(pose.pose(), x1, y1, z1).setColor(255, 255, 255, 120).setUv(0.0f, 0.0f).setUv2(blockLight, skyLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vc.addVertex(pose.pose(), x2, y2, z2).setColor(255, 255, 255, 120).setUv(1.0f, 0.0f).setUv2(blockLight, skyLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vc.addVertex(pose.pose(), x3, y3, z3).setColor(255, 255, 255, 120).setUv(1.0f, 1.0f).setUv2(blockLight, skyLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vc.addVertex(pose.pose(), x4, y4, z4).setColor(255, 255, 255, 120).setUv(0.0f, 1.0f).setUv2(blockLight, skyLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private void drawTextCentered(PoseStack pose, MultiBufferSource buffers, String text, int light) {
        Font font = Minecraft.getInstance().font;
        float width = font.width(text);
        pose.pushPose();
        pose.translate(-width / 2.0f, 0.0f, 0.0f);
        font.drawInBatch(text, 0.0f, 0.0f, 0xFFFFFF, false, pose.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        pose.popPose();
    }
}

