/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.customRender;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.omnigrid.neoforge.OmniGridBlock;
import com.omnigrid.neoforge.OmniGridGeometry;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.neoforge.support.render.RotationTranslationModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.TransformationBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.Nullable;

public class OmniGridBakedModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelProperty<PlatformResourceKey> DISPLAY_STACK = new ModelProperty();
    private final OmniGridGeometry geometry;
    private final ModelBaker baker;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelState;
    private final LoadingCache<CacheKey, List<BakedQuad>> quadCache;
    public static final Map<Integer, BakedModel> itemVariantModels = new HashMap<Integer, BakedModel>();
    private final LoadingCache<CacheKey, List<BakedQuad>> cache;
    private final ItemOverrides overrides = new ItemOverrides(){

        public BakedModel resolve(BakedModel original, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            int color = 0;
            if (stack.has(DataComponents.CUSTOM_MODEL_DATA)) {
                color = ((CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA)).value();
            }
            BakedModel baseVariant = OmniGridBakedModel.this.createItemVariant(color);
            itemVariantModels.put(color, baseVariant);
            return new BakedModelWrapper<BakedModel>(this, baseVariant){

                public boolean isCustomRenderer() {
                    return true;
                }
            };
        }
    };
    public static final ModelProperty<Integer> MODEL_COLOR = new ModelProperty();

    public OmniGridBakedModel(OmniGridGeometry geometry, IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        super(baker.bake(geometry.getBaseModels().values().iterator().next(), modelState));
        this.geometry = geometry;
        this.baker = baker;
        this.spriteGetter = spriteGetter;
        this.modelState = modelState;
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from(this::bakeBaseModel));
        this.quadCache = CacheBuilder.newBuilder().build(CacheLoader.from(this::bakeBaseModel));
    }

    private List<BakedQuad> bakeBaseModel(CacheKey key) {
        String keyStr = Integer.toString(key.color());
        ResourceLocation loc = this.geometry.getBaseModels().get(keyStr);
        if (loc == null) {
            return Collections.emptyList();
        }
        RotationTranslationModelBaker rt = new RotationTranslationModelBaker(this.modelState, this.baker, this.spriteGetter, loc);
        return rt.bake(TransformationBuilder.create().rotate(key.direction()).build(), key.side(), RandomSource.create());
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType layer) {
        if (state == null) {
            int color = 0;
            if (data.has(MODEL_COLOR)) {
                color = (Integer)data.get(MODEL_COLOR);
            }
            List itemQuads = (List)this.cache.getUnchecked((Object)new CacheKey(side, BiDirection.NORTH, color));
            if (side != null) {
                return Collections.emptyList();
            }
            return itemQuads;
        }
        Block itemQuads = state.getBlock();
        if (!(itemQuads instanceof OmniGridBlock)) {
            return super.getQuads(state, side, rand);
        }
        OmniGridBlock grid = (OmniGridBlock)itemQuads;
        BiDirection dir = (BiDirection)grid.getDirection(state);
        int color = (Integer)state.getValue((Property)OmniGridBlock.CUSTOM_MODEL_DATA);
        List base = (List)this.cache.getUnchecked((Object)new CacheKey(side, dir, color));
        if (side != null) {
            return base;
        }
        return new ArrayList<BakedQuad>(base);
    }

    public boolean usesBlockLight() {
        return false;
    }

    private static BakedQuad makeFlatQuad(TextureAtlasSprite sprite) {
        int[] data = new int[32];
        float z = 0.9995f;
        OmniGridBakedModel.putVertex(data, 0, 0.0f, 0.0f, z, sprite);
        OmniGridBakedModel.putVertex(data, 1, 0.0f, 1.0f, z, sprite);
        OmniGridBakedModel.putVertex(data, 2, 1.0f, 1.0f, z, sprite);
        OmniGridBakedModel.putVertex(data, 3, 1.0f, 0.0f, z, sprite);
        return new BakedQuad(data, -1, Direction.SOUTH, sprite, true);
    }

    private static void putVertex(int[] data, int idx, float x, float y, float z, TextureAtlasSprite spr) {
        int i = idx * 8;
        data[i] = Float.floatToRawIntBits(x);
        data[i + 1] = Float.floatToRawIntBits(y);
        data[i + 2] = Float.floatToRawIntBits(z);
        float u = spr.getU(x * 16.0f);
        float v = spr.getV(y * 16.0f);
        data[i + 4] = Float.floatToRawIntBits(u);
        data[i + 5] = Float.floatToRawIntBits(v);
        data[i + 6] = 0;
        data[i + 7] = 0;
    }

    public List<RenderType> getRenderTypes(ItemStack stack, boolean fabulous) {
        return List.of(RenderType.solid(), RenderType.cutout());
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.solid(), RenderType.cutout()});
    }

    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    public boolean isCustomRenderer() {
        return true;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData tileData) {
        return ModelData.builder().with(MODEL_COLOR, (Object)((Integer)state.getValue((Property)OmniGridBlock.CUSTOM_MODEL_DATA))).build();
    }

    private BakedModel createItemVariant(int color) {
        List quads = (List)this.quadCache.getUnchecked((Object)new CacheKey(null, BiDirection.NORTH, color));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(false, false, false, this.getTransforms(), this.overrides);
        for (BakedQuad q : quads) {
            builder.addUnculledFace(q);
        }
        builder.particle(this.getParticleIcon());
        builder.item();
        return builder.build(RenderTypeGroup.EMPTY);
    }

    private record CacheKey(@Nullable Direction side, BiDirection direction, int color) {
    }
}

