/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.customRender;

import com.omnigrid.Utils.ModUtil;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record OmniClientBlockPacket(UUID uuid, OmniBlockTarget[] targets) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OmniClientBlockPacket> PACKET_TYPE = new CustomPacketPayload.Type(ModUtil.OmniIdentifier("omni_block_target_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OmniClientBlockPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, OmniClientBlockPacket>(){

        public OmniClientBlockPacket decode(RegistryFriendlyByteBuf buf) {
            UUID id = buf.readUUID();
            OmniBlockTarget[] targets = new OmniBlockTarget[12];
            for (int i = 0; i < 12; ++i) {
                boolean hasTarget = buf.readBoolean();
                targets[i] = hasTarget ? (OmniBlockTarget)OmniBlockTarget.CODEC.decode((Object)buf) : null;
            }
            return new OmniClientBlockPacket(id, targets);
        }

        public void encode(RegistryFriendlyByteBuf buf, OmniClientBlockPacket msg) {
            buf.writeUUID(msg.uuid());
            OmniBlockTarget[] targets = msg.targets();
            for (int i = 0; i < 12; ++i) {
                OmniBlockTarget target;
                OmniBlockTarget omniBlockTarget = target = targets != null && i < targets.length ? targets[i] : null;
                if (target != null) {
                    buf.writeBoolean(true);
                    OmniBlockTarget.CODEC.encode((Object)buf, (Object)target);
                    continue;
                }
                buf.writeBoolean(false);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public static void handle(OmniClientBlockPacket packet, PacketContext ctx) {
        OmniGridBlockItem.CLIENT_BLOCK_TARGETS.put(packet.uuid, packet.targets);
    }
}

