/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.ResourcePrinter;
import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class WaterPrinterStorage
implements Storage,
ResourcePrinter {
    private static final FluidResource WATER = new FluidResource((Fluid)Fluids.WATER);
    private static final long VISIBLE_AMOUNT = Integer.MAX_VALUE;

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        FluidResource fluid;
        if (resource instanceof FluidResource && (fluid = (FluidResource)resource).fluid().isSame((Fluid)Fluids.WATER)) {
            return amount;
        }
        return 0L;
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        return 0L;
    }

    public Collection<ResourceAmount> getAll() {
        return Collections.singletonList(new ResourceAmount((ResourceKey)WATER, Integer.MAX_VALUE));
    }

    public long getStored() {
        return Integer.MAX_VALUE;
    }

    @Override
    public float getDrainForExtraction(long amount) {
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        double mbPerFE = cfg.waterPerFE();
        if (mbPerFE <= 0.0) {
            return 0.0f;
        }
        return (float)((double)amount / mbPerFE);
    }

    @Override
    public ResourceKey getPrintedResource() {
        return WATER;
    }
}

