/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.neoforge.CoreItem;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniUtilityInventory;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualContainerUtil {
    public static boolean disabledSaving = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualContainerUtil.class);

    public static boolean getVirtualInventory(OmniUtilityInventory targetInv, ItemStack carrier, Level level) {
        UUID id = (UUID)carrier.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference());
        return id != null && VirtualContainerUtil.getVirtualInventory(targetInv, id, level);
    }

    public static boolean getVirtualInventory(OmniUtilityInventory targetInv, UUID id, Level level) {
        if (targetInv == null) {
            return false;
        }
        StorageRepository repo = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        Optional opt = repo.get(id);
        if (opt.isEmpty()) {
            return false;
        }
        SerializableStorage storage = (SerializableStorage)opt.get();
        Optional first = storage.getAll().stream().findFirst();
        if (first.isEmpty()) {
            return false;
        }
        ItemResource res = (ItemResource)((ResourceAmount)first.get()).resource();
        ItemStack virtualContainer = res.toItemStack();
        return VirtualContainerUtil.loadContainerContentsFromItem(virtualContainer, (Container)targetInv);
    }

    public static void writeCoresFromOmniData(Container inventory, OmniCommandData data) {
        if (inventory == null) {
            LOGGER.error("[writeCoresFromOmniData] Inventory is null");
            return;
        }
        if (data == null) {
            LOGGER.error("[writeCoresFromOmniData] OmniCommandData is null");
            return;
        }
        LOGGER.debug("[writeCoresFromOmniData] Begin writing cores. Inventory size={}, data.hasCoreFlags={}", (Object)inventory.getContainerSize(), (Object)data.coresInstalled);
        Items items = Items.INSTANCE;
        for (int i = 0; i < 20; ++i) {
            boolean installed = data.isCoreInstalled(CoreTypes.fromId(i));
            int slot = 50 + i;
            ItemStack stack = ItemStack.EMPTY;
            if (installed) {
                switch (i) {
                    case 0: {
                        stack = new ItemStack((ItemLike)items.getOmniProvideCore());
                        break;
                    }
                    case 1: {
                        stack = new ItemStack((ItemLike)items.getOmniPullCore());
                        break;
                    }
                    case 2: {
                        stack = new ItemStack((ItemLike)items.getOmniCollectCore());
                        break;
                    }
                    case 3: {
                        stack = new ItemStack((ItemLike)items.getOmniPushCore());
                        break;
                    }
                    case 4: {
                        stack = new ItemStack((ItemLike)items.getOmniBlacklistCore());
                        break;
                    }
                    case 5: {
                        stack = new ItemStack((ItemLike)items.getOmniSearchCore());
                        break;
                    }
                    case 6: {
                        stack = new ItemStack((ItemLike)items.getOmniExternalCore());
                        break;
                    }
                    case 7: {
                        stack = new ItemStack((ItemLike)items.getOmniCraftCore());
                        break;
                    }
                    case 8: {
                        stack = new ItemStack((ItemLike)items.getOmniRegulateCore());
                        break;
                    }
                    case 9: {
                        stack = new ItemStack((ItemLike)items.getOmniLootingCore());
                        break;
                    }
                    case 10: {
                        stack = new ItemStack((ItemLike)items.getOmniPlayerCore());
                        break;
                    }
                    case 11: {
                        stack = new ItemStack((ItemLike)items.getLinkCore());
                        break;
                    }
                    case 12: {
                        stack = new ItemStack((ItemLike)items.getOmniPrecisionCore());
                        break;
                    }
                    case 13: {
                        stack = new ItemStack((ItemLike)items.getOmniMontitorCore());
                        break;
                    }
                    case 14: {
                        stack = new ItemStack((ItemLike)items.getOmniInterfacerCore());
                        break;
                    }
                    case 15: {
                        stack = new ItemStack((ItemLike)items.getInvertedCore());
                        break;
                    }
                    case 16: {
                        stack = new ItemStack((ItemLike)items.getOmniFurnaceCore());
                        break;
                    }
                    case 17: {
                        stack = new ItemStack((ItemLike)items.getOmniDiskDriveCore());
                        break;
                    }
                    case 18: {
                        stack = new ItemStack((ItemLike)items.getOmniRemoteCore());
                        break;
                    }
                    case 19: {
                        stack = new ItemStack((ItemLike)items.getOmniAutocraftingCore());
                    }
                }
            }
            if (slot >= 80) continue;
            inventory.setItem(slot, stack);
        }
        inventory.setChanged();
    }

    public static void debugContainer(String label, Container container) {
        if (container == null) {
            LOGGER.info("[{}] Container = null", (Object)label);
            return;
        }
        LOGGER.info("[{}] === Dumping {} slots ===", (Object)label, (Object)container.getContainerSize());
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            LOGGER.info("[{}] Slot {}: {} x {}", new Object[]{label, i, stack.getCount(), stack.getItem().toString()});
        }
        LOGGER.info("[{}] === End ===", (Object)label);
    }

    public static OmniCommandData readOmniDataFromInventory(Container inventory, OmniCommandData data) {
        if (inventory == null) {
            return data;
        }
        if (data == null) {
            data = new OmniCommandData();
        }
        for (int i = 0; i < 20; ++i) {
            data.setCoreInstalled(CoreTypes.fromId(i), false);
        }
        for (int slot = 50; slot < 70 && slot < inventory.getContainerSize(); ++slot) {
            CoreItem coreItem;
            CoreTypes type;
            Item item;
            ItemStack stack = inventory.getItem(slot);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof CoreItem) || (type = (coreItem = (CoreItem)item).getCoreType()) == null) continue;
            data.setCoreInstalled(type, true);
        }
        return data;
    }

    private static boolean loadContainerContentsFromItem(ItemStack stack, Container target) {
        ItemContainerContents contents = (ItemContainerContents)stack.get(net.minecraft.core.component.DataComponents.CONTAINER);
        if (contents == null) {
            for (int i = 0; i < target.getContainerSize(); ++i) {
                target.setItem(i, ItemStack.EMPTY);
            }
            return false;
        }
        for (int i = 0; i < contents.getSlots() && i < target.getContainerSize(); ++i) {
            target.setItem(i, contents.getStackInSlot(i).copy());
        }
        return true;
    }

    public static boolean saveOmniDataToVirtual(OmniCommandData data, ItemStack id, Player player) {
        return VirtualContainerUtil.saveOmniDataToVirtual(data, (UUID)id.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()), player.level());
    }

    public static boolean saveOmniDataToVirtual(OmniCommandData data, ItemStack id, Level level) {
        return VirtualContainerUtil.saveOmniDataToVirtual(data, (UUID)id.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()), level);
    }

    public static boolean saveOmniDataToVirtual(OmniCommandData data, UUID id, Level level) {
        ItemStack virtualContainer;
        StorageRepository repo = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        Optional opt = repo.get(id);
        if (opt.isEmpty()) {
            return false;
        }
        SerializableStorage storage = (SerializableStorage)opt.get();
        Optional first = storage.getAll().stream().findFirst();
        if (first.isEmpty()) {
            LOGGER.debug("[VirtualContainerUtil] Storage empty, creating dirt container");
            virtualContainer = new ItemStack((ItemLike)net.minecraft.world.item.Items.DIRT);
        } else {
            ItemResource res = (ItemResource)((ResourceAmount)first.get()).resource();
            virtualContainer = res.toItemStack();
            storage.extract((ResourceKey)res, ((ResourceAmount)first.get()).amount(), Action.EXECUTE, PlayerActor.EMPTY);
        }
        try {
            virtualContainer.set(DataComponents.INSTANCE.CData(), (Object)data);
        }
        catch (Exception e) {
            return false;
        }
        storage.insert((ResourceKey)ItemResource.ofItemStack((ItemStack)virtualContainer), 1L, Action.EXECUTE, PlayerActor.EMPTY);
        repo.markAsChanged();
        return true;
    }

    public static OmniCommandData loadOmniDataFromVirtual(ItemStack stack, Player player) {
        return VirtualContainerUtil.loadOmniDataFromVirtual((UUID)stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()), player.level());
    }

    public static OmniCommandData loadOmniDataFromVirtual(ItemStack stack, Level level) {
        return VirtualContainerUtil.loadOmniDataFromVirtual((UUID)stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()), level);
    }

    public static OmniCommandData loadOmniDataFromVirtual(UUID id, Level level) {
        OmniCommandData loaded;
        StorageRepository repo = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        Optional opt = repo.get(id);
        if (opt.isEmpty()) {
            return new OmniCommandData();
        }
        SerializableStorage storage = (SerializableStorage)opt.get();
        Optional first = storage.getAll().stream().findFirst();
        if (first.isEmpty()) {
            return new OmniCommandData();
        }
        ItemResource res = (ItemResource)((ResourceAmount)first.get()).resource();
        ItemStack virtualContainer = res.toItemStack();
        if (virtualContainer.has(DataComponents.INSTANCE.CData()) && (loaded = (OmniCommandData)virtualContainer.get(DataComponents.INSTANCE.CData())) != null) {
            loaded.sanitize();
            return loaded;
        }
        return new OmniCommandData();
    }

    public static boolean saveVirtualInventory(Container sourceInv, ItemStack stack, Level level) {
        UUID id = (UUID)stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference());
        return VirtualContainerUtil.saveVirtualInventory(sourceInv, id, level);
    }

    public static boolean saveVirtualInventory(Container sourceInv, UUID id, Level level) {
        ItemStack virtualContainer;
        StorageRepository repo = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        Optional opt = repo.get(id);
        if (opt.isEmpty() || disabledSaving) {
            return false;
        }
        SerializableStorage storage = (SerializableStorage)opt.get();
        Optional first = storage.getAll().stream().findFirst();
        if (first.isEmpty()) {
            virtualContainer = new ItemStack((ItemLike)net.minecraft.world.item.Items.DIRT);
        } else {
            ItemResource res = (ItemResource)((ResourceAmount)first.get()).resource();
            virtualContainer = res.toItemStack();
            storage.extract((ResourceKey)res, ((ResourceAmount)first.get()).amount(), Action.EXECUTE, PlayerActor.EMPTY);
        }
        VirtualContainerUtil.saveContainerContentsToItem(virtualContainer, sourceInv);
        storage.insert((ResourceKey)ItemResource.ofItemStack((ItemStack)virtualContainer), 1L, Action.EXECUTE, PlayerActor.EMPTY);
        repo.markAsChanged();
        return true;
    }

    public static OmniItemProxxy proxxyFromVirtualData(Level level, UUID uuid, EnergyStorage energyStorage) {
        return VirtualContainerUtil.proxxyFromVirtualData(level, uuid, null, null, energyStorage);
    }

    public static OmniItemProxxy proxxyFromVirtualData(Level level, UUID uuid, @Nullable BlockPos blockPos, @Nullable Direction blockDirection, EnergyStorage energyStorage) {
        OmniUtilityInventory inventory = new OmniUtilityInventory((inventory0, slot) -> new OmniGridBlockItem.DiskInventoryListenerImpl(level), 80);
        OmniCommandData data = VirtualContainerUtil.loadOmniDataFromVirtual(uuid, level);
        VirtualContainerUtil.getVirtualInventory(inventory, uuid, level);
        return new OmniItemProxxy(inventory, data, level, uuid, blockPos, blockDirection, energyStorage);
    }

    private static void saveContainerContentsToItem(ItemStack stack, Container container) {
        ItemContainerContents contents = ItemContainerContents.fromItems(VirtualContainerUtil.containerToList(container));
        stack.set(net.minecraft.core.component.DataComponents.CONTAINER, (Object)contents);
    }

    public static boolean saveVirtualInventoryAndOmniData(Container sourceInv, OmniCommandData data, UUID id, Level level) {
        ItemStack virtualContainer;
        if (id == null || level == null || disabledSaving) {
            return false;
        }
        StorageRepository repo = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        Optional opt = repo.get(id);
        if (opt.isEmpty()) {
            return false;
        }
        SerializableStorage storage = (SerializableStorage)opt.get();
        Optional first = storage.getAll().stream().findFirst();
        if (first.isEmpty()) {
            LOGGER.debug("[VirtualContainerUtil] Storage empty, creating dirt container");
            virtualContainer = new ItemStack((ItemLike)net.minecraft.world.item.Items.DIRT);
        } else {
            Optional second;
            ItemResource res = (ItemResource)((ResourceAmount)first.get()).resource();
            virtualContainer = res.toItemStack();
            storage.extract((ResourceKey)res, ((ResourceAmount)first.get()).amount(), Action.EXECUTE, PlayerActor.EMPTY);
            while ((second = storage.getAll().stream().findFirst()).isPresent()) {
                storage.extract(((ResourceAmount)second.get()).resource(), 1L, Action.EXECUTE, PlayerActor.EMPTY);
            }
        }
        if (sourceInv != null) {
            VirtualContainerUtil.saveContainerContentsToItem(virtualContainer, sourceInv);
        }
        if (data != null) {
            try {
                data.sanitize();
                virtualContainer.set(DataComponents.INSTANCE.CData(), (Object)data);
            }
            catch (Exception e) {
                LOGGER.error("[VirtualContainerUtil] Failed writing OmniCommandData", (Throwable)e);
                return false;
            }
        }
        storage.insert((ResourceKey)ItemResource.ofItemStack((ItemStack)virtualContainer), 1L, Action.EXECUTE, PlayerActor.EMPTY);
        repo.markAsChanged();
        return true;
    }

    public static List<ItemStack> containerToList(Container container) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(container.getContainerSize());
        int nonEmpty = 0;
        int empty = 0;
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack original = container.getItem(i);
            ItemStack stack = original.copy();
            boolean cleared = false;
            list.add(stack);
            if (stack.isEmpty()) {
                ++empty;
                continue;
            }
            ++nonEmpty;
        }
        return list;
    }

    private static void logExtract(String label, SerializableStorage storage, ResourceKey key, long amount, Action action, long extracted) {
        if (key instanceof ItemResource) {
            ItemResource ir = (ItemResource)key;
            ItemStack st = ir.toItemStack();
            LOGGER.info("[{}] EXTRACT request={} extracted={} {} action={} (empty? {} air? {})", new Object[]{label, amount, extracted, st.getItem(), action, st.isEmpty(), st.getItem() == net.minecraft.world.item.Items.AIR});
        } else {
            LOGGER.info("[{}] EXTRACT request={} extracted={} NON-ITEM {} action={}", new Object[]{label, amount, extracted, key, action});
        }
    }
}

