/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.MergedPattern;
import com.omnigrid.Utils.OmniUtilityItem;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilityBundle
extends BundleItem {
    public int capacity;
    private static final Logger LOGGER = LoggerFactory.getLogger(UtilityBundle.class);

    public UtilityBundle(int capacity) {
        super(new Item.Properties().stacksTo(1));
        this.capacity = capacity;
    }

    private boolean isAllowed(ItemStack stack, int stored) {
        return (stack.getItem() instanceof OmniUtilityItem || stack.getItem() instanceof PatternItem) && stored < this.capacity && stack.getCount() == 1;
    }

    public static List<UtilityType> getUtilityTypes(ItemStack bundleStack) {
        ArrayList<UtilityType> list = new ArrayList<UtilityType>();
        if (!bundleStack.has(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS)) {
            return list;
        }
        BundleContents contents = (BundleContents)bundleStack.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
        for (ItemStack s : contents.items()) {
            Item item = s.getItem();
            if (!(item instanceof OmniUtilityItem)) continue;
            OmniUtilityItem util = (OmniUtilityItem)item;
            list.add(util.getUtilityType());
        }
        return list;
    }

    public static List<MergedPattern> getMergedPatterns(ItemStack bundleStack, Level level, @Nullable OmniBlockTarget blockTarget) {
        ArrayList<MergedPattern> list = new ArrayList<MergedPattern>();
        if (!bundleStack.has(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS)) {
            return list;
        }
        BundleContents contents = (BundleContents)bundleStack.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
        for (ItemStack s : contents.items()) {
            Item item = s.getItem();
            if (!(item instanceof PatternItem)) continue;
            PatternItem util = (PatternItem)item;
            list.add(new MergedPattern(s, level, blockTarget));
        }
        return list;
    }

    public static List<Pattern> getRegularPatterns(ItemStack bundleStack, Level level) {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        if (!bundleStack.has(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS)) {
            return list;
        }
        BundleContents contents = (BundleContents)bundleStack.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
        for (ItemStack s : contents.items()) {
            PatternItem util;
            Item item = s.getItem();
            if (!(item instanceof PatternItem) || !(util = (PatternItem)item).getPattern(s, level).isPresent()) continue;
            list.add((Pattern)util.getPattern(s, level).get());
        }
        return list;
    }

    public static List<ResourceKey> getPatternOutputs(ItemStack bundleStack, Level level) {
        ArrayList<ResourceKey> list = new ArrayList<ResourceKey>();
        if (!bundleStack.has(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS)) {
            return list;
        }
        BundleContents contents = (BundleContents)bundleStack.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
        for (ItemStack s : contents.items()) {
            Optional pattern;
            PatternItem util;
            Item item = s.getItem();
            if (!(item instanceof PatternItem) || !(util = (PatternItem)item).getPattern(s, level).isPresent() || !(pattern = util.getPattern(s, level)).isPresent()) continue;
            for (ResourceAmount res : ((Pattern)pattern.get()).layout().outputs()) {
                list.add(res.resource());
            }
        }
        return list;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        BundleContents contents = (BundleContents)stack.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
        if (Screen.hasControlDown() && contents != null && !contents.isEmpty()) {
            return Optional.of(new BundleTooltip(contents));
        }
        OmniBlockTarget target = UtilityBundle.getTarget(stack);
        MutableComponent text = Component.literal((String)("Stores up to " + this.capacity + " utility cores and crafting patterns. Hold ctrl to view contents")).withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"Drag onto or drop utility cores and patterns onto this to store them.\n").withStyle(ChatFormatting.YELLOW));
        text = target == null ? text.append((Component)Component.literal((String)"Shift left-click a block to store a block target. Stored processing patterns send their inputs to this location if in block target range")) : text.append((Component)Component.literal((String)(target.getTarget().getDescription().getString() + " at " + String.valueOf(target.getPosition()) + " " + String.valueOf(target.getDirection())))).withStyle(ChatFormatting.WHITE);
        return Optional.of(new HelpTooltipComponent((Component)text));
    }

    private boolean canInsertUtility(ItemStack bundleStack, ItemStack stackToInsert) {
        if (stackToInsert.getItem() instanceof PatternItem) {
            return true;
        }
        Item item = stackToInsert.getItem();
        if (!(item instanceof OmniUtilityItem)) {
            return false;
        }
        OmniUtilityItem util = (OmniUtilityItem)item;
        UtilityType newType = util.getUtilityType();
        List<UtilityType> existing = UtilityBundle.getUtilityTypes(bundleStack);
        if (existing.contains((Object)newType)) {
            return false;
        }
        return !this.isCurio(newType) || !this.hasCurioType(existing);
    }

    private boolean isCurio(UtilityType t) {
        return switch (t) {
            case UtilityType.CURIOS_1, UtilityType.CURIOS_2, UtilityType.CURIOS_3, UtilityType.CURIOS_4, UtilityType.CURIOS_5 -> true;
            default -> false;
        };
    }

    private boolean hasCurioType(List<UtilityType> types) {
        for (UtilityType t : types) {
            switch (t) {
                case CURIOS_1: 
                case CURIOS_2: 
                case CURIOS_3: 
                case CURIOS_4: 
                case CURIOS_5: {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private static OmniBlockTarget getTarget(ItemStack stack) {
        return (OmniBlockTarget)stack.get(DataComponents.INSTANCE.getLink());
    }

    public boolean overrideStackedOnOther(ItemStack bundle, Slot slot, ClickAction action, Player player) {
        ItemStack slotStack = slot.getItem();
        if (action == ClickAction.SECONDARY && slotStack.isEmpty()) {
            BundleContents contents = (BundleContents)bundle.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
            if (contents == null || contents.isEmpty()) {
                return false;
            }
            BundleContents.Mutable mutable = new BundleContents.Mutable(contents);
            ItemStack removed = mutable.removeOne();
            if (removed == null || removed.isEmpty()) {
                return false;
            }
            removed.setCount(1);
            slot.safeInsert(removed);
            bundle.set(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS, (Object)mutable.toImmutable());
            return true;
        }
        if (action == ClickAction.SECONDARY && !slotStack.isEmpty()) {
            int stored = UtilityBundle.getStoredCount(bundle);
            if (!this.isAllowed(slotStack, stored)) {
                return false;
            }
            if (!this.canInsertUtility(bundle, slotStack)) {
                return false;
            }
            BundleContents.Mutable mutable = new BundleContents.Mutable((BundleContents)bundle.getOrDefault(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY));
            int inserted = mutable.tryInsert(slotStack);
            if (inserted > 0) {
                bundle.set(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS, (Object)mutable.toImmutable());
                return true;
            }
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack bundle, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && other.isEmpty()) {
            BundleContents contents = (BundleContents)bundle.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
            if (contents == null || contents.isEmpty()) {
                return false;
            }
            BundleContents.Mutable mutable = new BundleContents.Mutable(contents);
            ItemStack removed = mutable.removeOne();
            if (removed == null || removed.isEmpty()) {
                return false;
            }
            removed.setCount(1);
            if (!player.getInventory().add(removed)) {
                player.drop(removed, false);
            }
            bundle.set(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS, (Object)mutable.toImmutable());
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        int stored = UtilityBundle.getStoredCount(bundle);
        if (!this.isAllowed(other, stored)) {
            return false;
        }
        if (!this.canInsertUtility(bundle, other)) {
            return false;
        }
        BundleContents.Mutable mutable = new BundleContents.Mutable((BundleContents)bundle.getOrDefault(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY));
        int inserted = mutable.tryInsert(other);
        if (inserted > 0) {
            bundle.set(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS, (Object)mutable.toImmutable());
            return true;
        }
        return false;
    }

    public static int getStoredCount(ItemStack bundleStack) {
        BundleContents contents = (BundleContents)bundleStack.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
        return contents == null ? 0 : contents.size();
    }

    public ItemStack getDefaultInstance() {
        ItemStack itemStack = this.capacity == 6 ? new ItemStack((ItemLike)Items.INSTANCE.getUtilityBundleTier2()) : (this.capacity == 10 ? new ItemStack((ItemLike)Items.INSTANCE.getUtilityBundleTier3()) : (this.capacity == 15 ? new ItemStack((ItemLike)Items.INSTANCE.getUtilityBundleTier4()) : (this.capacity == 30 ? new ItemStack((ItemLike)Items.INSTANCE.getUtilityBundleTier5()) : new ItemStack((ItemLike)Items.INSTANCE.getUtilityBundleTier1()))));
        itemStack.set(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        return itemStack;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (!stack.has(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS)) {
            stack.set(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        }
    }

    public int getBarWidth(ItemStack stack) {
        int count = UtilityBundle.getStoredCount(stack);
        if (this.capacity <= 0) {
            return 0;
        }
        float fill = (float)count / (float)this.capacity;
        fill = Mth.clamp((float)fill, (float)0.0f, (float)1.0f);
        return (int)(fill * 13.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        BundleContents bundlecontents = (BundleContents)stack.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
        if (bundlecontents != null) {
            int i = UtilityBundle.getStoredCount(stack);
            tooltipComponents.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{i, this.capacity}).withStyle(ChatFormatting.GRAY));
        }
    }
}

