/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.StorageProxy.OmniPortHandler;
import com.omnigrid.StorageProxy.StorageProxy;
import com.omnigrid.Utils.CurioStats;
import com.omnigrid.Utils.ModUtil;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.Utils.VirtualContainerUtil;
import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.LootNotification;
import com.omnigrid.neoforge.ModInitializer;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniCraftTask;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridResourceHandler;
import com.omnigrid.neoforge.OmniGridTask;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniRootStorage;
import com.omnigrid.neoforge.OmniUtilityInventory;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class TransferUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferUtils.class);
    public static final Map<String, ItemStack> CRAFTING_CACHE_1x1 = new HashMap<String, ItemStack>();
    public static final Map<String, ItemStack> CRAFTING_CACHE_2x2 = new HashMap<String, ItemStack>();
    public static final Map<String, ItemStack> CRAFTING_CACHE_3x3 = new HashMap<String, ItemStack>();
    public static final Map<String, ItemStack> CRAFTING_CACHE_3x1 = new HashMap<String, ItemStack>();
    public static final Map<String, ItemStack> CRAFTING_CACHE_1x3 = new HashMap<String, ItemStack>();
    public static final TagKey<Fluid> XP_TAG = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"experience"));

    public static String stackKey(ItemStack stack) {
        return stack.getItem().toString() + stack.getComponents().toString();
    }

    public static int takeFromContainerMenu(OmniGridTask task, OmniRootStorage storage, Player player) {
        if (player.level().isClientSide()) {
            return 0;
        }
        if (player.containerMenu == null || player.containerMenu == player.inventoryMenu) {
            return 0;
        }
        int transferred = 0;
        boolean allowAny = task.any;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Slot slot : player.containerMenu.slots) {
            boolean newItem;
            if (slot.container instanceof Inventory) continue;
            ItemStack stackInSlot = slot.getItem();
            if (!slot.hasItem() || !OmniGridResourceHandler.matchesTask(stackInSlot, task) || !slot.mayPickup(player) || slot.isFake() || slot instanceof ResourceSlot) continue;
            ItemResource key = ItemResource.ofItemStack((ItemStack)stackInSlot);
            boolean bl = newItem = storage.get((com.refinedmods.refinedstorage.api.resource.ResourceKey)key) == 0L;
            long moved = storage.insert((com.refinedmods.refinedstorage.api.resource.ResourceKey)key, stackInSlot.getCount(), Action.EXECUTE, (Actor)new PlayerActor("Auto-Loot"));
            if (moved <= 0L) continue;
            if (newItem && (task.notification == LootNotification.BOTH || task.notification == LootNotification.NEW_LOOT)) {
                stacks.add(stackInSlot.copy());
            }
            stackInSlot.shrink((int)moved);
            slot.set(stackInSlot.isEmpty() ? ItemStack.EMPTY : stackInSlot);
            slot.setChanged();
            transferred = (int)((long)transferred + moved);
        }
        if (transferred > 0) {
            player.containerMenu.broadcastChanges();
            if (!stacks.isEmpty()) {
                TransferUtils.notify(player, stacks);
            }
        }
        return transferred;
    }

    public static void notify(Player player, List<ItemStack> stacks) {
        if (stacks == null || stacks.isEmpty()) {
            return;
        }
        MutableComponent msg = Component.literal((String)"New Loot:").withStyle(ChatFormatting.GREEN);
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            msg.append((Component)Component.literal((String)"\n- ").withStyle(ChatFormatting.DARK_GRAY));
            ChatFormatting nameColor = stack.getMaxStackSize() == 1 ? ChatFormatting.AQUA : ChatFormatting.YELLOW;
            MutableComponent name = stack.getHoverName().copy().withStyle(nameColor);
            msg.append((Component)name);
            msg.append((Component)Component.literal((String)(" \u00d7" + stack.getCount())).withStyle(ChatFormatting.GRAY));
        }
        player.displayClientMessage((Component)msg, false);
    }

    public static List<OmniBlockTarget> discoverLinkedBlockTargets(Level level, OmniBlockTarget root) {
        if (root == null) {
            return new ArrayList<OmniBlockTarget>();
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        ArrayList<OmniBlockTarget> results = new ArrayList<OmniBlockTarget>();
        BlockState rootState = level.getBlockState(root.getPosition());
        if (rootState.isAir()) {
            return List.of(root);
        }
        queue.add(root.getPosition());
        visited.add(root.getPosition());
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            BlockState state = level.getBlockState(current);
            if (!state.is(rootState.getBlock())) continue;
            results.add(new OmniBlockTarget(root.getTarget(), current, root.getDirection()));
            for (Direction dir : Direction.values()) {
                BlockState neighborState;
                BlockPos neighbor = current.relative(dir);
                if (visited.contains(neighbor) || !(neighborState = level.getBlockState(neighbor)).is(rootState.getBlock())) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return results;
    }

    private static ItemResource irOf(ItemStack stack) {
        return ItemResource.ofItemStack((ItemStack)stack);
    }

    private static com.refinedmods.refinedstorage.api.resource.ResourceKey keyOf(ItemStack stack) {
        return TransferUtils.irOf(stack);
    }

    public static void giveAdvancement(ServerPlayer sp, String name, String criteria) {
        ResourceLocation res = ModUtil.OmniIdentifier(name);
        AdvancementHolder holder = sp.server.getAdvancements().get(res);
        if (holder != null) {
            sp.getAdvancements().award(holder, criteria);
        }
    }

    public static boolean isThisStackEquipped(Player player, ItemStack target) {
        if (!ModList.get().isLoaded("curios")) {
            return false;
        }
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> {
            IItemHandlerModifiable curios = inv.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack eq = curios.getStackInSlot(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)eq, (ItemStack)target)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static boolean isSameItemIgnoringComponents(ItemStack a, ItemStack b) {
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        if (!ItemStack.isSameItem((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        ItemStack aCopy = a.copy();
        ItemStack bCopy = b.copy();
        Set<DataComponentType> ignore = Set.of(net.minecraft.core.component.DataComponents.CONTAINER, net.minecraft.core.component.DataComponents.ENCHANTMENTS, net.minecraft.core.component.DataComponents.POTION_CONTENTS, net.minecraft.core.component.DataComponents.ATTRIBUTE_MODIFIERS, net.minecraft.core.component.DataComponents.DAMAGE, net.minecraft.core.component.DataComponents.CUSTOM_NAME, net.minecraft.core.component.DataComponents.LORE, net.minecraft.core.component.DataComponents.MAX_STACK_SIZE);
        for (DataComponentType comp : ignore) {
            if (aCopy.has(comp)) {
                aCopy.remove(comp);
            }
            if (!bCopy.has(comp)) continue;
            bCopy.remove(comp);
        }
        return ItemStack.isSameItemSameComponents((ItemStack)aCopy, (ItemStack)bCopy);
    }

    private static boolean isProtectedStack(ItemStack stack, List<ItemStack> protectedStacks) {
        if (stack.isEmpty() || protectedStacks == null) {
            return false;
        }
        for (ItemStack c : protectedStacks) {
            if (stack.getItem() != c.getItem()) continue;
            return true;
        }
        return false;
    }

    public static int countMatchingItems(IItemHandler handler, OmniGridTask task) {
        int total = 0;
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || !OmniGridResourceHandler.matchesTask(stack, task)) continue;
            total += stack.getCount();
        }
        return total;
    }

    public static IItemHandler resolveBlockHandler(Level level, BlockPos pos, Direction side) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be == null) {
            return null;
        }
        return (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(level, pos, be.getBlockState(), be, (Object)side);
    }

    public static void addIfNotPresent(List<ItemStack> list, ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        for (ItemStack existing : list) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) continue;
            return;
        }
        list.add(stack.copy());
    }

    public static void transferProxxyData(OmniItemProxxy oldProxxy, OmniItemProxxy newProxxy) {
        if (oldProxxy == null || newProxxy == null) {
            return;
        }
        newProxxy.fuel = oldProxxy.fuel;
        newProxxy.smeltingProgress = oldProxxy.smeltingProgress;
        newProxxy.stress = oldProxxy.stress;
        newProxxy.accumulatedXp = oldProxxy.accumulatedXp;
        newProxxy.overclock = oldProxxy.overclock;
        List<OmniCraftTask> oldTasks = oldProxxy.getTaskManager().getTasks();
        newProxxy.getTaskManager().addAllTasks(oldTasks);
    }

    public static List<ItemStack> depositToPlayerOmniGrids(Player player, List<ItemStack> toDeposit, UtilityType utilityType) {
        UUID playerId = player.getUUID();
        ArrayList<OmniItemProxxy> proxxies = new ArrayList<OmniItemProxxy>();
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        int feCostPerItem = switch (utilityType) {
            case UtilityType.MOB_DEPOSIT -> cfg.mobDepositFE();
            case UtilityType.ORE_DEPOSIT -> cfg.quarryDepositFE();
            default -> 0;
        };
        for (UUID key : OmniGridBlockItem.GLOBAL_STORAGES.keySet()) {
            OmniItemProxxy p = OmniGridBlockItem.GLOBAL_STORAGES.get(key);
            if (p == null || p.player == null || !playerId.equals(p.player) || p.isDirty() || !TransferUtils.checkifOwned(player, p.uuid) || !p.getOrCreateStorage().utilityTypes.contains((Object)utilityType)) continue;
            proxxies.add(p);
        }
        if (proxxies.isEmpty()) {
            return toDeposit;
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack item : toDeposit) {
            if (item.isEmpty() || item.getItem() instanceof OmniGridBlockItem) continue;
            for (OmniItemProxxy proxxy : proxxies) {
                if (item.isEmpty()) break;
                long inserted = proxxy.getOrCreateStorage().insert((com.refinedmods.refinedstorage.api.resource.ResourceKey)ItemResource.ofItemStack((ItemStack)item), item.getCount(), Action.EXECUTE, (Actor)new PlayerActor("Depositor"));
                if (inserted <= 0L) continue;
                proxxy.stress += (float)((long)feCostPerItem * inserted);
                item.shrink((int)inserted);
            }
            if (item.isEmpty()) continue;
            leftovers.add(item);
        }
        return leftovers;
    }

    public static void tryOverclockAchievement(Player player, OmniItemProxxy proxxy) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (proxxy.getSpeed() >= 3) {
                TransferUtils.giveAdvancement(sp, "omni_overclock", "none");
            }
        }
    }

    public static List<BlockPos> discoverLinkedPositions(Level level, OmniBlockTarget start) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (start == null) {
            return result;
        }
        BlockPos root = start.getPosition();
        Item targetItem = start.getTarget();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        result.add(root);
        visited.add(root);
        queue.add(root);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            if (!TransferUtils.matchesBlockItem(level, pos, targetItem)) continue;
            result.add(pos);
            for (Direction dir : Direction.values()) {
                BlockPos next = pos.relative(dir);
                if (visited.contains(next) || !TransferUtils.matchesBlockItem(level, next, targetItem)) continue;
                visited.add(next);
                queue.add(next);
            }
        }
        return result;
    }

    private static boolean matchesBlockItem(Level level, BlockPos pos, Item targetBlockItem) {
        BlockState state = level.getBlockState(pos);
        Item blockItem = state.getBlock().asItem();
        return blockItem == targetBlockItem;
    }

    public static ItemStack findOmniGridInInventory(UUID uuid, Player player) {
        Optional opt;
        if (player == null) {
            return ItemStack.EMPTY;
        }
        ItemStack fallback = ItemStack.EMPTY;
        for (ItemStack stack : player.getInventory().items) {
            if (!TransferUtils.isAnyGrid(stack)) continue;
            if (fallback.isEmpty()) {
                fallback = stack;
            }
            if (uuid == null || !TransferUtils.isMatchingGrid(stack, uuid)) continue;
            return stack;
        }
        for (ItemStack stack : player.getInventory().armor) {
            if (!TransferUtils.isAnyGrid(stack)) continue;
            if (fallback.isEmpty()) {
                fallback = stack;
            }
            if (uuid == null || !TransferUtils.isMatchingGrid(stack, uuid)) continue;
            return stack;
        }
        ItemStack off = player.getOffhandItem();
        if (TransferUtils.isAnyGrid(off)) {
            if (uuid != null && TransferUtils.isMatchingGrid(off, uuid)) {
                return off;
            }
            if (fallback.isEmpty()) {
                fallback = off;
            }
        }
        if (ModList.get().isLoaded("curios") && (opt = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent()) {
            ICuriosItemHandler inv = (ICuriosItemHandler)opt.get();
            for (ICurioStacksHandler handler : inv.getCurios().values()) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStacks().getStackInSlot(i);
                    if (!TransferUtils.isAnyGrid(stack)) continue;
                    if (uuid != null && TransferUtils.isMatchingGrid(stack, uuid)) {
                        return stack;
                    }
                    if (!fallback.isEmpty()) continue;
                    fallback = stack;
                }
            }
        }
        return fallback;
    }

    public static boolean checkifOwned(Player player, UUID uuid) {
        for (ItemStack candidate : player.getInventory().items) {
            if (candidate.isEmpty() || !(candidate.getItem() instanceof OmniGridBlockItem) || !candidate.has(DataComponents.INSTANCE.getStorageReference()) || candidate.get(DataComponents.INSTANCE.getStorageReference()) != uuid) continue;
            return true;
        }
        if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosInventory((LivingEntity)player).isPresent()) {
            ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get();
            IItemHandlerModifiable equipped = curios.getEquippedCurios();
            for (int i = 0; i < equipped.getSlots(); ++i) {
                ItemStack candidate = equipped.getStackInSlot(i);
                if (candidate.isEmpty() || !(candidate.getItem() instanceof OmniGridBlockItem) || !candidate.has(DataComponents.INSTANCE.getStorageReference()) || candidate.get(DataComponents.INSTANCE.getStorageReference()) != uuid) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAnyGrid(ItemStack stack) {
        return stack != null && !stack.isEmpty() && stack.getItem() instanceof OmniGridBlockItem;
    }

    private static boolean isMatchingGrid(ItemStack stack, UUID uuid) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (!(stack.getItem() instanceof OmniGridBlockItem)) {
            return false;
        }
        UUID ref = (UUID)stack.get(DataComponents.INSTANCE.getStorageReference());
        if (ref == null) {
            return false;
        }
        return ref.equals(uuid);
    }

    public static OmniItemProxxy UpdatePlayerTransferCache(ItemStack stack, Level level, UUID providedId, OmniCommandData providedData) {
        OmniUtilityInventory inv;
        UUID id = providedId != null ? providedId : OmniGridBlockItem.getOrCreate(stack);
        OmniItemProxxy old = OmniGridBlockItem.GLOBAL_STORAGES.get(id);
        if (old == null) {
            OmniGridBlockItem.DiskInventoryListenerImpl listener = new OmniGridBlockItem.DiskInventoryListenerImpl(level);
            inv = OmniGridBlockItem.createDiskInventory(stack, listener, level);
        } else {
            inv = old.getInventory();
        }
        OmniCommandData omniData = VirtualContainerUtil.loadOmniDataFromVirtual(stack, level);
        if (omniData == null) {
            omniData = new OmniCommandData();
        }
        if (providedData != null) {
            TransferUtils.mergeCommandsInto(omniData, providedData);
        } else if (omniData == null) {
            omniData = new OmniCommandData();
            VirtualContainerUtil.saveOmniDataToVirtual(omniData, stack, level);
        }
        OmniItemProxxy newProxxy = new OmniItemProxxy(inv, omniData, level, id, null, null, OmniGridBlockItem.createEnergyStorage(stack));
        if (newProxxy.utilityTypes.contains((Object)UtilityType.DURABLE)) {
            if (!stack.has(net.minecraft.core.component.DataComponents.UNBREAKABLE)) {
                stack.set(net.minecraft.core.component.DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
            }
        } else {
            stack.remove(net.minecraft.core.component.DataComponents.UNBREAKABLE);
        }
        if (old != null) {
            TransferUtils.transferProxxyData(old, newProxxy);
        } else {
            newProxxy.accumulatedXp = omniData.getFurnaceData().accumulatedXp;
            newProxxy.fuel = omniData.getFurnaceData().fuel;
        }
        if (ModList.get().isLoaded("curios")) {
            short type = ModInitializer.getHighestCuriosTier(newProxxy.utilityTypes);
            if (type > 0) {
                stack.set(com.omnigrid.neoforge.DataComponents.INSTANCE.getCuriosData(), (Object)new CurioStats(type, omniData.getNormalCoresInstalled(), omniData.getStrongCoresInstalled(), omniData.getTotalUpgradesInstalled()));
            } else if (stack.has(com.omnigrid.neoforge.DataComponents.INSTANCE.getCuriosData())) {
                stack.remove(com.omnigrid.neoforge.DataComponents.INSTANCE.getCuriosData());
            }
        }
        newProxxy.setUpdatedData(omniData);
        OmniGridBlockItem.GLOBAL_STORAGES.put(id, newProxxy);
        VirtualContainerUtil.saveOmniDataToVirtual(omniData, stack, level);
        return newProxxy;
    }

    private static void mergeCommandsInto(OmniCommandData existing, OmniCommandData incoming) {
        int i;
        for (i = 0; i < existing.commands.length; ++i) {
            if (incoming.commands[i] == null) continue;
            existing.commands[i] = incoming.commands[i];
        }
        for (i = 0; i < existing.disabledCommands.length; ++i) {
            existing.disabledCommands[i] = incoming.disabledCommands[i];
        }
    }

    public static ItemStack insertIntoHandlerRange(IItemHandler handler, ItemStack stack, int start, int end, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remaining = stack.copy();
        for (int slot = start; slot <= end && !(remaining = handler.insertItem(slot, remaining, simulate)).isEmpty(); ++slot) {
        }
        return remaining;
    }

    public static ItemStack extractMatchingRange(IItemHandler handler, Predicate<ItemStack> filter, int limit, int slotStart, int slotEnd, boolean simulate) {
        ItemStack extracted = ItemStack.EMPTY;
        int remaining = limit;
        for (int slot = slotStart; slot <= slotEnd && remaining > 0; ++slot) {
            int toExtract;
            ItemStack part;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.isEmpty() || !filter.test(stack) || (part = handler.extractItem(slot, toExtract = Math.min(stack.getCount(), remaining), simulate)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = part.copy();
            } else {
                extracted.grow(part.getCount());
            }
            remaining -= part.getCount();
        }
        return extracted;
    }

    public static List<String> getItemIdWordsNoNamespace(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return List.of();
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (id == null) {
            return List.of();
        }
        String path = id.getPath();
        String processedPath = path.replace('_', ' ').replaceAll("([a-z])([A-Z])", "$1 $2");
        String[] tokens = processedPath.split("[^A-Za-z0-9]+");
        return Arrays.stream(tokens).filter(s -> !s.isBlank()).map(String::toLowerCase).toList();
    }

    public static List<String> getItemComponentsAsStringList(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return List.of();
        }
        ArrayList<String> components = new ArrayList<String>();
        components.add("maxStackSize=" + stack.getMaxStackSize());
        if (EnchantmentHelper.hasAnyEnchantments((ItemStack)stack)) {
            components.add("Enchanted");
        }
        stack.getComponents().forEach(type -> {
            String key = type.toString();
            if (key.contains("minecraft:durability")) {
                return;
            }
            if (key.contains("minecraft:enchantments") || key.contains("stored_enchantments")) {
                return;
            }
            if (key.contains(":")) {
                components.add(key.substring(key.indexOf(":") + 1));
            } else {
                components.add(key);
            }
        });
        return components;
    }

    public static List<String> getFluidTagStrings(FluidStack stack) {
        if (stack.isEmpty()) {
            return List.of();
        }
        return stack.getTags().map(TagKey::location).map(ResourceLocation::toString).toList();
    }

    public static List<String> getItemTagsAsStringList(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return List.of();
        }
        return stack.getTags().map(tagKey -> tagKey.location().toString()).toList();
    }

    public static int countMatchingRange(IItemHandler handler, Predicate<ItemStack> filter, int slotStart, int slotEnd) {
        int total = 0;
        for (int slot = slotStart; slot <= slotEnd; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.isEmpty() || !filter.test(stack)) continue;
            total += stack.getCount();
        }
        return total;
    }

    public static ItemInteractionResult handleStorageProxyUse(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit, StorageProxy proxy) {
        if (stack.getItem() instanceof OmniGridBlockItem) {
            UUID uuid = (UUID)stack.get(DataComponents.INSTANCE.getStorageReference());
            if (uuid == null) {
                TransferUtils.send(player, "No Omni Grid linked", ChatFormatting.RED);
                return ItemInteractionResult.SUCCESS;
            }
            OmniItemProxxy storage = OmniGridBlockItem.GLOBAL_STORAGES.get(uuid);
            if (storage == null) {
                TransferUtils.send(player, "Omni Grid not loaded", ChatFormatting.RED);
                return ItemInteractionResult.SUCCESS;
            }
            if (!storage.getCachedData().isCoreInstalled(CoreTypes.DISK_DRIVE)) {
                TransferUtils.send(player, "Missing Omni Storage Core!", ChatFormatting.RED);
                return ItemInteractionResult.SUCCESS;
            }
            if (!uuid.equals(proxy.getStorageReference())) {
                proxy.setStorageReference(uuid);
                TransferUtils.send(player, "Linked Omni Grid " + String.valueOf(uuid), ChatFormatting.GREEN);
            } else {
                proxy.setStorageReference(null);
                TransferUtils.send(player, "Unlinked Omni Grid", ChatFormatting.RED);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (proxy.getStorageReference() == null) {
            TransferUtils.send(player, "No Omni Grid linked", ChatFormatting.RED);
            return ItemInteractionResult.SUCCESS;
        }
        OmniItemProxxy targetProxy = OmniGridBlockItem.GLOBAL_STORAGES.get(proxy.getStorageReference());
        if (targetProxy == null) {
            TransferUtils.send(player, "Linked Omni Grid out of range", ChatFormatting.RED);
            return ItemInteractionResult.SUCCESS;
        }
        if (!targetProxy.getCachedData().isCoreInstalled(CoreTypes.DISK_DRIVE)) {
            TransferUtils.send(player, "Linked Omni Grid is missing Storage Core", ChatFormatting.RED);
            return ItemInteractionResult.SUCCESS;
        }
        if (targetProxy.utilityTypes.contains((Object)UtilityType.PROXY_ACCESSOR)) {
            TransferUtils.send(player, "Linked (Range: Unlimited)", ChatFormatting.AQUA);
            return ItemInteractionResult.SUCCESS;
        }
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        int range = cfg.getProxyBaseRange() + cfg.getProxyExtraRangePerUpgrade() * targetProxy.getRange();
        boolean inRange = false;
        if (targetProxy.taskCenterPosition != null) {
            inRange = OmniPortHandler.withinRange(targetProxy.taskCenterPosition, targetProxy.taskCenterPosition, range);
        }
        TransferUtils.send(player, "Linked (Range: " + range + ")", inRange ? ChatFormatting.GREEN : ChatFormatting.RED);
        return ItemInteractionResult.SUCCESS;
    }

    private static void send(Player player, String msg, ChatFormatting color) {
        player.displayClientMessage((Component)Component.literal((String)msg).withStyle(color), true);
    }

    public class UtilityTypeHelpers {
        public UtilityTypeHelpers(TransferUtils this$0) {
        }

        public static boolean isCurios(UtilityType t) {
            return switch (t) {
                case UtilityType.CURIOS_1, UtilityType.CURIOS_2, UtilityType.CURIOS_3, UtilityType.CURIOS_4, UtilityType.CURIOS_5 -> true;
                default -> false;
            };
        }
    }
}

