/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.ToggleableSlot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleableQuickCraftingSlot
extends ToggleableSlot {
    private ResourceKey resourceKey = new ItemResource((Item)Items.INSTANCE.getPattern());
    private static final Logger LOGGER = LoggerFactory.getLogger(ToggleableQuickCraftingSlot.class);

    public ToggleableQuickCraftingSlot(Container container, int slot, int x, int y, int page, AbstractOmniGridContainerMenu menu) {
        super(container, slot, x, y, page, menu);
    }

    @Override
    public boolean isValid() {
        if (this.menu.gridPlayer.level().isClientSide() && !this.menu.getCarried().isEmpty() || this.menu.result.hasItem() && this.menu.cachedAutocraftables.contains(ItemResource.ofItemStack((ItemStack)this.menu.result.getItem()))) {
            return false;
        }
        if (!this.menu.gridPlayer.level().isClientSide() || this.menu.getRepository().getAmount(this.resourceKey) > 0L && !this.menu.result.container.isEmpty()) {
            boolean val;
            boolean bl = val = this.menu.tabPage == this.page && !this.menu.screenIsTransferPanel;
            if (this.getItem().isEmpty()) {
                this.set(new ItemStack((ItemLike)Items.INSTANCE.getPattern()));
            }
            return val;
        }
        if (!this.getItem().isEmpty()) {
            this.set(ItemStack.EMPTY);
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.isValid();
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    @Override
    public void onTake(Player player, ItemStack stack) {
        if (this.menu.omniGrid != null) {
            this.menu.omniGrid.getItemStorage().extract(this.resourceKey, 1L, Action.EXECUTE, Actor.EMPTY);
        }
        if (this.menu.omniGrid != null) {
            this.menu.createPattern(stack);
            super.onTake(player, stack);
        }
        this.set(this.menu.getPattern());
    }

    @Override
    public boolean mayPickup(Player player) {
        return true;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }
}

