/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.ModUtil;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.OmniGridScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class TabButtonColumn
extends AbstractWidget {
    private static final int TAB_HEIGHT = 25;
    public int configOption = 0;
    public String[] sprites = new String[]{"craftpanel", "furnace", "core", "main", "pick", "target", "filter", ""};
    public OmniGridScreen screen;

    public TabButtonColumn(int x, int y, int width, int height, Component message, OmniGridScreen screen) {
        super(x, y, width, height, message);
        this.screen = screen;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        for (int o = 0; o < 4; ++o) {
            if (o == 3 && this.screen.isTransferPanel()) {
                return;
            }
            int y = this.getY() + 25 * o;
            if (o == this.screen.screenConfig) {
                guiGraphics.blitSprite(ModUtil.OmniIdentifier("tab"), this.getX(), y, this.width, this.height);
            } else {
                guiGraphics.blitSprite(ModUtil.OmniIdentifier("tab_unactive"), this.getX(), y, this.width, this.height);
            }
            int p = o;
            if (this.screen.isTransferPanel()) {
                p += 4;
            }
            Object sprite = "widget/" + this.sprites[p];
            if (p == 1 && !((AbstractOmniGridContainerMenu)this.screen.getMenu()).getDataClient().isCoreInstalled(CoreTypes.FURNACE)) {
                sprite = "widget/locked_icon";
            }
            guiGraphics.blitSprite(ModUtil.OmniIdentifier((String)sprite), this.getX() + 3, y + 5, 12, 12);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || !this.active) {
            return false;
        }
        if (mouseX < (double)this.getX() || mouseX > (double)(this.getX() + 18)) {
            return false;
        }
        if (mouseY < (double)this.getY()) {
            return false;
        }
        double localY = mouseY - (double)this.getY();
        int tabIndex = (int)(localY / 25.0);
        if (tabIndex >= 0 && tabIndex < 4) {
            if (this.screen.screenConfig != tabIndex) {
                if (tabIndex == 1 && !((AbstractOmniGridContainerMenu)this.screen.getMenu()).getDataClient().isCoreInstalled(CoreTypes.FURNACE) && !this.screen.isTransferPanel()) {
                    return true;
                }
                if (tabIndex == 3 && this.screen.isTransferPanel()) {
                    return true;
                }
                this.screen.screenConfig = tabIndex;
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.screen.handleTabClick(tabIndex);
            }
            return true;
        }
        return false;
    }
}

