/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.ResourceTrackerTooltipComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

public class ResourceTooltipRenderer
implements ClientTooltipComponent {
    private final ResourceTrackerTooltipComponent data;

    public ResourceTooltipRenderer(ResourceTrackerTooltipComponent data) {
        this.data = data;
    }

    private int nonNullCount() {
        int c = 0;
        for (PlatformResourceKey key : this.data.resources) {
            if (key == null) continue;
            ++c;
        }
        return c;
    }

    private boolean horizontalOnly() {
        return this.data.counts == null;
    }

    public int getHeight() {
        int count = this.nonNullCount();
        if (this.horizontalOnly()) {
            return count > 0 ? 23 : 0;
        }
        return count * 20;
    }

    public int getWidth(Font font) {
        int count = this.nonNullCount();
        if (this.horizontalOnly()) {
            return count * 18;
        }
        return 120;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics gg) {
        if (this.horizontalOnly()) {
            int offsetX = 0;
            for (PlatformResourceKey key : this.data.resources) {
                if (key == null) continue;
                int boxX = x + offsetX;
                int boxY = y;
                ResourceRendering renderer = RefinedStorageClientApi.INSTANCE.getResourceRendering(key.getClass());
                renderer.render((ResourceKey)key, gg, boxX + 1, boxY);
                offsetX += 18;
            }
            return;
        }
        int offsetY = 0;
        for (int i = 0; i < this.data.resources.length; ++i) {
            PlatformResourceKey key = this.data.resources[i];
            if (key == null) continue;
            long amount = this.data.counts[i];
            int boxX = x;
            int boxY = y + offsetY;
            gg.fill(boxX, boxY, boxX + 18, boxY + 18, -11184811);
            gg.fill(boxX + 1, boxY + 1, boxX + 17, boxY + 17, -14540254);
            ResourceRendering renderer = RefinedStorageClientApi.INSTANCE.getResourceRendering(key.getClass());
            renderer.render((ResourceKey)key, gg, boxX + 1, boxY + 1);
            gg.drawString(font, String.valueOf(amount), boxX + 22, boxY + 5, 0xFFFFFF, false);
            offsetY += 20;
        }
    }
}

