/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class RangedInvHandler
implements IItemHandler {
    private final IItemHandler base;
    private final int start;
    private final int end;

    public RangedInvHandler(IItemHandler base, int start, int end) {
        this.base = base;
        this.start = start;
        this.end = end;
    }

    public int getSlots() {
        return this.end - this.start;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.base.getStackInSlot(this.start + slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.base.insertItem(this.start + slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.base.extractItem(this.start + slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.base.getSlotLimit(this.start + slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.base.isItemValid(this.start + slot, stack);
    }
}

