/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.omnigrid.neoforge.Items;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantityIndicator
extends BlockEntityWithoutLevelRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuantityIndicator.class);
    public static Vector2f mhPos;
    public static Vector2f ohPos;
    @Nullable
    private static QuantityIndicator INSTANCE;

    public QuantityIndicator(BlockEntityRenderDispatcher dispatcher, EntityModelSet entityModels) {
        super(dispatcher, entityModels);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext mode, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        pose.pushPose();
        ItemStack displayStack = new ItemStack((ItemLike)Items.INSTANCE.getFakeOmniGrid());
        if (stack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            displayStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)((CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA)));
        }
        if (mode == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            pose.translate(0.65, 0.35, 0.3);
            pose.scale(1.3f, 1.3f, 1.3f);
        } else if (mode == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            pose.translate(0.27, 0.35, 0.4);
            pose.scale(1.3f, 1.3f, 1.3f);
            pose.mulPose(Axis.ZP.rotationDegrees(15.0f));
            pose.mulPose(Axis.YP.rotationDegrees(100.0f));
        } else if (mode == ItemDisplayContext.GROUND) {
            pose.translate(0.5, 0.25, 0.5);
        } else if (mode == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || mode == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            pose.translate(0.5, 0.5, 0.25);
        } else {
            pose.translate(0.5, 0.5, 0.0);
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(displayStack, mode, light, overlay, pose, buffer, null, 0);
        if (mode == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            mhPos = QuantityIndicator.projectToScreen(pose);
        } else if (mode == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            ohPos = QuantityIndicator.projectToScreen(pose);
        }
        pose.popPose();
        if (mode != ItemDisplayContext.GROUND) {
            pose.pushPose();
            ItemRenderer ir = Minecraft.getInstance().getItemRenderer();
            BakedModel handModel = ir.getModel(stack, null, null, 0);
            ClientHooks.handleCameraTransforms((PoseStack)pose, (BakedModel)handModel, (ItemDisplayContext)mode, (boolean)false);
            pose.translate(-0.5, -0.5, -0.5);
            pose.translate(0.0, 0.0, -0.25);
            pose.popPose();
        }
    }

    public static Vector2f projectToScreen(PoseStack pose) {
        Matrix4f local = new Matrix4f((Matrix4fc)pose.last().pose());
        Matrix4f mv = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        Matrix4f proj = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvLocal = mv.mul((Matrix4fc)local, new Matrix4f());
        Matrix4f mvp = proj.mul((Matrix4fc)mvLocal, new Matrix4f());
        Vector4f clip = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)mvp);
        if (clip.w == 0.0f) {
            clip.w = 1.0E-5f;
        }
        float ndcX = clip.x / clip.w;
        float ndcY = clip.y / clip.w;
        Minecraft mc = Minecraft.getInstance();
        float screenX = (ndcX * 0.5f + 0.5f) * (float)mc.getWindow().getGuiScaledWidth();
        float screenY = (1.0f - (ndcY * 0.5f + 0.5f)) * (float)mc.getWindow().getGuiScaledHeight();
        return new Vector2f(screenX, screenY);
    }

    public static String formatQuantity(long value) {
        if (value < 1000L) {
            return Long.toString(value);
        }
        if (value < 1000000L) {
            return String.format("%.1fK", (double)value / 1000.0);
        }
        if (value < 1000000000L) {
            return String.format("%.1fM", (double)value / 1000000.0);
        }
        if (value < 1000000000000L) {
            return String.format("%.1fB", (double)value / 1.0E9);
        }
        return String.format("%.1fT", (double)value / 1.0E12);
    }

    public static QuantityIndicator getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new QuantityIndicator(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        }
        return INSTANCE;
    }
}

