/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.OmniPresetData;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.ModInitializer;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PresetItem
extends Item {
    public PresetItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack preset = player.getItemInHand(hand);
        if (level.isClientSide() || !preset.has(DataComponents.INSTANCE.getPresetData())) {
            return InteractionResultHolder.pass((Object)preset);
        }
        preset.remove(DataComponents.INSTANCE.CData());
        UUID id = (UUID)preset.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference());
        OmniPresetData presetData = (OmniPresetData)preset.get(DataComponents.INSTANCE.getPresetData());
        ItemStack item = TransferUtils.findOmniGridInInventory(id, player);
        if (item == ItemStack.EMPTY) {
            player.displayClientMessage((Component)Component.literal((String)"Omni Grid not found!").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.pass((Object)preset);
        }
        OmniItemProxxy proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(item.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()));
        OmniCommandData cached = proxy.getCachedData();
        cached.commands = presetData.commands;
        cached.disabledCommands = presetData.disabled;
        TransferUtils.UpdatePlayerTransferCache(item, level, id, cached);
        player.swing(hand);
        player.displayClientMessage((Component)Component.literal((String)"Successfully loaded preset").withStyle(ChatFormatting.AQUA), true);
        ModInitializer.SaveProxxyInfo(proxy.uuid, level);
        return InteractionResultHolder.pass((Object)preset);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.getLevel();
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = ctx.getClickedPos();
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof AbstractOmniGridBlockEntity)) {
            return InteractionResult.PASS;
        }
        AbstractOmniGridBlockEntity omni = (AbstractOmniGridBlockEntity)be;
        ItemStack preset = ctx.getItemInHand();
        if (!level.isClientSide) {
            this.applyPresetToBlockEntity(preset, omni, player, level);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyPresetToBlockEntity(ItemStack preset, AbstractOmniGridBlockEntity<?> omni, Player player, Level level) {
        OmniPresetData presetData = (OmniPresetData)preset.get(DataComponents.INSTANCE.getPresetData());
        if (presetData == null) {
            player.displayClientMessage((Component)Component.literal((String)"Preset contains no Omni data"), true);
            return;
        }
        OmniItemProxxy proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(omni.getStorageReference());
        OmniCommandData cached = proxy.getCachedData();
        cached.commands = presetData.commands;
        cached.disabledCommands = presetData.disabled;
        proxy.setUpdatedData(cached);
        proxy.setDirty(true);
        omni.markDataDirty();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)omni.getBlockPos().getX() + 0.5, (double)omni.getBlockPos().getY() + 1.0, (double)omni.getBlockPos().getZ() + 0.5, 6, 0.2, 0.2, 0.2, 0.01);
        }
        player.displayClientMessage((Component)Component.literal((String)"Preset applied to OmniGrid"), true);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        MutableComponent text = Component.literal((String)"Saves/Loads an Omni Grids configuration").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"Place in an Omni Grids utility slot to save its current command configuration").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"Use this to load configuration to the Omni Grid in your inventory").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" or shift-click one placed in world").withStyle(ChatFormatting.GREEN));
        return Optional.of(new HelpTooltipComponent((Component)text));
    }
}

