/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OverclockerUtils {
    public static InteractionResultHolder<ItemStack> handleOverclockUse(Player player, Level level, ItemStack stack, boolean consume, int activationCost) {
        if (player.getUsedItemHand() != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ItemStack offhand = player.getOffhandItem();
        if (!(offhand.getItem() instanceof OmniGridBlockItem)) {
            player.displayClientMessage((Component)Component.literal((String)"Hold an Omni Grid in your offhand."), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        UUID storageRef = (UUID)offhand.get(DataComponents.INSTANCE.getStorageReference());
        if (storageRef == null) {
            player.displayClientMessage((Component)Component.literal((String)"Invalid Omni Grid storage reference."), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(storageRef);
        if (proxxy == null) {
            player.displayClientMessage((Component)Component.literal((String)"No Omni Grid linked to this item."), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        proxxy.overclock += 1200;
        proxxy.stress += (float)activationCost;
        if (consume) {
            stack.shrink(1);
        }
        TransferUtils.tryOverclockAchievement(player, proxxy);
        return InteractionResultHolder.success((Object)stack);
    }

    public static InteractionResult handleOverclockUseOn(UseOnContext ctx, boolean consume, int activationCost) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        if (player == null || level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = ctx.getClickedPos();
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof AbstractOmniGridBlockEntity)) {
            player.displayClientMessage((Component)Component.literal((String)"This block is not an Omni Grid."), true);
            return InteractionResult.FAIL;
        }
        AbstractOmniGridBlockEntity omniBE = (AbstractOmniGridBlockEntity)be;
        UUID storageRef = omniBE.getStorageReference();
        if (storageRef == null) {
            player.displayClientMessage((Component)Component.literal((String)"Omni Grid has no valid storage reference."), true);
            return InteractionResult.FAIL;
        }
        OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(storageRef);
        if (proxxy == null) {
            player.displayClientMessage((Component)Component.literal((String)"No proxxy linked to this Omni Grid."), true);
            return InteractionResult.FAIL;
        }
        proxxy.overclock += 1200;
        proxxy.stress += (float)activationCost;
        if (consume) {
            stack.shrink(1);
        }
        TransferUtils.tryOverclockAchievement(player, proxxy);
        return InteractionResult.SUCCESS;
    }
}

