/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.StorageProxy.AbstractResourceFilterContainerMenu;
import com.omnigrid.Utils.OmniFilterData;
import com.omnigrid.Utils.ResourceFilterExtendedMenu;
import com.omnigrid.Utils.ResourceTrackerTooltipComponent;
import com.omnigrid.neoforge.DataComponents;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceHandlerItem;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniVoider
extends Item
implements SlotReferenceHandlerItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniVoider.class);

    public OmniVoider() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.getServer() != null) {
                SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand);
                slotReference.resolve(player).ifPresent(s -> this.use(serverPlayer, (ItemStack)s, slotReference));
            }
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.literal((String)"Voids resources in an Omni Grids storage").withStyle(ChatFormatting.RED));
        lines.add((Component)Component.literal((String)""));
        lines.add((Component)Component.literal((String)"Right-click to configure up to 9 resources to void, then put this in an Omni Grids utility slot").withStyle(ChatFormatting.YELLOW));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        OmniFilterData data = (OmniFilterData)stack.get(DataComponents.INSTANCE.getFilterData());
        if (data != null) {
            return Optional.of(new ResourceTrackerTooltipComponent(data.keys));
        }
        return Optional.empty();
    }

    public void use(ServerPlayer serverPlayer, ItemStack itemStack, SlotReference slotReference) {
        ResourceContainer container = ResourceContainerImpl.createForFilter((int)9);
        OmniFilterData filterData = (OmniFilterData)itemStack.get(DataComponents.INSTANCE.getFilterData());
        if (filterData != null) {
            for (int i = 0; i < 9; ++i) {
                PlatformResourceKey key = filterData.get(i);
                if (key == null) continue;
                container.set(i, new ResourceAmount((ResourceKey)key, 1L));
            }
        }
        Platform.INSTANCE.getMenuOpener().openMenu(serverPlayer, (MenuProvider)new ResourceFilterExtendedMenu(container));
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (abstractContainerMenu instanceof AbstractResourceFilterContainerMenu) {
            AbstractResourceFilterContainerMenu menu = (AbstractResourceFilterContainerMenu)abstractContainerMenu;
            menu.setDisabledSlot(slotReference);
        }
    }
}

