/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class OmniTransferManager {
    private final AbstractOmniGridContainerMenu menu;
    private final List<Rule> rules = new ArrayList<Rule>();

    public OmniTransferManager(AbstractOmniGridContainerMenu menu) {
        this.menu = menu;
    }

    public void addRule(Class<? extends Slot> slotClass) {
        this.rules.add(new Rule(slotClass));
    }

    public ItemStack move(int clickedIndex) {
        Slot clicked = this.menu.getSlot(clickedIndex);
        ItemStack initial = clicked.getItem();
        if (initial.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = initial.copy();
        boolean clickedIsSpecial = this.isSpecialSlot(clicked);
        remainder = clickedIsSpecial ? this.moveToPlayer(remainder) : this.moveToSpecialSlots(remainder);
        clicked.set(remainder);
        clicked.setChanged();
        return initial.getCount() == remainder.getCount() ? ItemStack.EMPTY : initial;
    }

    private boolean isSpecialSlot(Slot slot) {
        for (Rule rule : this.rules) {
            if (!rule.slotClass.isInstance(slot)) continue;
            return true;
        }
        return false;
    }

    private ItemStack moveToSpecialSlots(ItemStack remainder) {
        for (Rule rule : this.rules) {
            for (Slot slot : this.menu.slots) {
                if (!rule.slotClass.isInstance(slot) || !slot.mayPlace(remainder) || !(remainder = slot.safeInsert(remainder)).isEmpty()) continue;
                return remainder;
            }
        }
        return remainder;
    }

    private ItemStack moveToPlayer(ItemStack remainder) {
        for (Slot slot : this.menu.slots) {
            if (!(slot instanceof Slot) || slot.container != this.menu.gridPlayer.getInventory() || !slot.mayPlace(remainder) || !(remainder = slot.safeInsert(remainder)).isEmpty()) continue;
            return remainder;
        }
        return remainder;
    }

    private static class Rule {
        final Class<? extends Slot> slotClass;

        Rule(Class<? extends Slot> slotClass) {
            this.slotClass = slotClass;
        }
    }
}

