/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class OmniProxyDisk
extends Item {
    public OmniProxyDisk() {
        super(new Item.Properties().stacksTo(1));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        int baseRange = cfg.getProxyBaseRange();
        int extraPerUpgrade = cfg.getProxyExtraRangePerUpgrade();
        MutableComponent text = Component.literal((String)"Grants an Omni Grid access to another Omni Grid's storage").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"\u2022 Place in an Omni Grid utility slot to link").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"\u2022 Place in another Omni Grid disk slot to access the linked storage").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n\n")).append((Component)Component.literal((String)"Range:").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"\u2022 Base range: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(baseRange)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" blocks").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"\u2022 +").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(extraPerUpgrade)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" blocks per Range Upgrade in linked Omni Grid").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n\n")).append((Component)Component.literal((String)"Requires the linked Omni Grid to be loaded and within range").withStyle(ChatFormatting.DARK_GREEN));
        return Optional.of(new HelpTooltipComponent((Component)text));
    }

    private static void giveOrDrop(Player player, ItemStack stack) {
        if (!player.getInventory().add(stack)) {
            player.drop(stack, false);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (!level.isClientSide) {
            OmniProxyDisk.giveOrDrop(player, new ItemStack((ItemLike)Items.INSTANCE.getOmniProxyBlock()));
            OmniProxyDisk.giveOrDrop(player, new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStorageHousing()));
            held.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)held, (boolean)level.isClientSide);
    }
}

