/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.StorageProxy.AbstractResourceFilterContainerMenu;
import com.omnigrid.Utils.OmniFilterData;
import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.ResourceFilterExtendedMenu;
import com.omnigrid.Utils.ResourceTrackerTooltipComponent;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniRootStorage;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceHandlerItem;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniProxyBucket
extends Item
implements SlotReferenceHandlerItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniProxyBucket.class);

    public OmniProxyBucket() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.getServer() != null) {
                if (!serverPlayer.isCrouching()) {
                    SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand);
                    slotReference.resolve(player).ifPresent(s -> this.use(serverPlayer, (ItemStack)s, slotReference));
                } else {
                    UUID sr = (UUID)stack.get(DataComponents.INSTANCE.getStorageReference());
                    if (sr == null) {
                        serverPlayer.displayClientMessage((Component)Component.literal((String)"No Omni Grid linked").withStyle(ChatFormatting.RED), true);
                        serverPlayer.displayClientMessage((Component)Component.literal((String)"No Omni Grid linked, place in an Omni Grids utility slot to link"), false);
                        return InteractionResultHolder.consume((Object)stack);
                    }
                    OmniItemProxxy proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(sr);
                    if (proxy == null) {
                        serverPlayer.displayClientMessage((Component)Component.literal((String)"Linked Omni Grid not loaded").withStyle(ChatFormatting.RED), true);
                        return InteractionResultHolder.consume((Object)stack);
                    }
                    OmniRootStorage storage = proxy.getOrCreateStorage();
                    int idx = (Integer)stack.getOrDefault(com.omnigrid.neoforge.DataComponents.INSTANCE.getOmniMode(), (Object)0);
                    OmniFilterData filterData = (OmniFilterData)stack.get(com.omnigrid.neoforge.DataComponents.INSTANCE.getFilterData());
                    if (filterData == null || filterData.keys == null) {
                        this.error(serverPlayer, "No resources configured");
                        return InteractionResultHolder.consume((Object)stack);
                    }
                    int realIdx = this.findNextValidIndex(filterData, idx);
                    if (realIdx < 0) {
                        this.error(serverPlayer, "No resources configured");
                        return InteractionResultHolder.consume((Object)stack);
                    }
                    PlatformResourceKey rpk = filterData.keys[realIdx];
                    stack.set(com.omnigrid.neoforge.DataComponents.INSTANCE.getOmniMode(), (Object)realIdx);
                    long stored = storage.get((ResourceKey)rpk);
                    if (stored <= 0L) {
                        this.error(serverPlayer, "Resource not in storage");
                        return InteractionResultHolder.consume((Object)stack);
                    }
                    if (filterData != null) {
                        boolean success = false;
                        if (rpk instanceof ItemResource) {
                            ItemResource itemRes = (ItemResource)rpk;
                            Item item = itemRes.item();
                            if (item instanceof BlockItem) {
                                BlockItem block = (BlockItem)item;
                                success = this.placeBlock(serverPlayer, block, storage, rpk);
                            } else {
                                success = item instanceof BoneMealItem ? this.applyBonemeal(serverPlayer, storage, rpk) : this.launchItem(serverPlayer, itemRes, storage, rpk);
                            }
                        } else if (rpk instanceof FluidResource) {
                            FluidResource fluidRes = (FluidResource)rpk;
                            success = this.placeFluid(serverPlayer, fluidRes, storage, rpk);
                        } else if (RefinedTypesUtil.rtInstalled() && rpk instanceof EnergyResource) {
                            EnergyResource energyRes = (EnergyResource)rpk;
                            success = this.chargeTarget(serverPlayer, energyRes, storage, rpk);
                        }
                        if (!success) {
                            this.error(serverPlayer, "Action failed");
                        }
                    }
                    stack.set(com.omnigrid.neoforge.DataComponents.INSTANCE.getOmniMode(), (Object)idx);
                }
            }
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    private int findNextValidIndex(OmniFilterData data, int start) {
        if (data == null || data.keys == null) {
            return -1;
        }
        int size = data.keys.length;
        for (int i = 0; i < size; ++i) {
            int idx = (start + i) % size;
            if (data.keys[idx] == null) continue;
            return idx;
        }
        return -1;
    }

    private void error(ServerPlayer player, String msg) {
        player.displayClientMessage((Component)Component.literal((String)msg).withStyle(ChatFormatting.RED), true);
    }

    private boolean placeBlock(ServerPlayer player, BlockItem block, OmniRootStorage storage, PlatformResourceKey key) {
        HitResult hit = player.pick(5.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult bhr = (BlockHitResult)hit;
        ItemStack placeStack = new ItemStack((ItemLike)block);
        UseOnContext ctx = new UseOnContext((Player)player, InteractionHand.MAIN_HAND, bhr);
        InteractionResult result = placeStack.useOn(ctx);
        if (!result.consumesAction()) {
            return false;
        }
        storage.extract((ResourceKey)key, 1L, Action.EXECUTE, Actor.EMPTY);
        return true;
    }

    private boolean applyBonemeal(ServerPlayer player, OmniRootStorage storage, PlatformResourceKey key) {
        HitResult hit = player.pick(5.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult bhr = (BlockHitResult)hit;
        if (!BoneMealItem.applyBonemeal((ItemStack)ItemStack.EMPTY, (Level)player.level(), (BlockPos)bhr.getBlockPos(), (Player)player)) {
            return false;
        }
        storage.extract((ResourceKey)key, 1L, Action.EXECUTE, Actor.EMPTY);
        return true;
    }

    private boolean launchItem(ServerPlayer player, ItemResource res, OmniRootStorage storage, PlatformResourceKey key) {
        ItemStack stack = new ItemStack((ItemLike)res.item());
        ItemEntity ent = player.drop(stack, false);
        if (ent == null) {
            return false;
        }
        ent.setDeltaMovement(player.getLookAngle().scale(0.5));
        storage.extract((ResourceKey)key, 1L, Action.EXECUTE, Actor.EMPTY);
        return true;
    }

    private boolean placeFluid(ServerPlayer player, FluidResource fluid, OmniRootStorage storage, PlatformResourceKey key) {
        int filled;
        int sim;
        HitResult hit = player.pick(5.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult bhr = (BlockHitResult)hit;
        Level level = player.level();
        BlockPos pos = bhr.getBlockPos();
        Direction face = bhr.getDirection();
        BlockPos targetPos = pos.relative(face);
        FluidStack stack = new FluidStack(fluid.fluid(), 1000);
        IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)face);
        if (handler == null) {
            handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, targetPos, (Object)face.getOpposite());
        }
        if (handler != null && (sim = handler.fill(stack, IFluidHandler.FluidAction.SIMULATE)) > 0 && (filled = handler.fill(stack, IFluidHandler.FluidAction.EXECUTE)) > 0) {
            storage.extract((ResourceKey)key, filled, Action.EXECUTE, Actor.EMPTY);
            return true;
        }
        ItemStack bucket = new ItemStack((ItemLike)fluid.fluid().getBucket());
        if (bucket.isEmpty()) {
            return false;
        }
        UseOnContext ctx = new UseOnContext((Player)player, InteractionHand.MAIN_HAND, bhr);
        InteractionResult result = bucket.useOn(ctx);
        if (result.consumesAction()) {
            storage.extract((ResourceKey)key, 1000L, Action.EXECUTE, Actor.EMPTY);
            return true;
        }
        return false;
    }

    private boolean chargeTarget(ServerPlayer player, EnergyResource res, OmniRootStorage storage, PlatformResourceKey key) {
        HitResult hit = player.pick(5.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult bhr = (BlockHitResult)hit;
        BlockPos pos = bhr.getBlockPos();
        IEnergyStorage cap = (IEnergyStorage)player.level().getCapability(Capabilities.EnergyStorage.BLOCK, pos, null);
        if (cap == null) {
            return false;
        }
        long toSend = Math.min(1000L, storage.get((ResourceKey)key));
        long accepted = cap.receiveEnergy((int)toSend, false);
        if (accepted > 0L) {
            storage.extract((ResourceKey)key, accepted, Action.EXECUTE, Actor.EMPTY);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.literal((String)"Dispenses a resource from a linked Omni Grids storage. Place in an Omni Grids utility slot to link").withStyle(ChatFormatting.RED));
        lines.add((Component)Component.literal((String)""));
        lines.add((Component)Component.literal((String)"Shift right-click to configure a resource. Shift-Scroll to pick between configured resources").withStyle(ChatFormatting.YELLOW));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        OmniFilterData data = (OmniFilterData)stack.get(com.omnigrid.neoforge.DataComponents.INSTANCE.getFilterData());
        if (data != null) {
            return Optional.of(new ResourceTrackerTooltipComponent(data.keys));
        }
        return Optional.empty();
    }

    public void use(ServerPlayer serverPlayer, ItemStack itemStack, SlotReference slotReference) {
        ResourceContainer container = ResourceContainerImpl.createForFilter((int)9);
        OmniFilterData filterData = (OmniFilterData)itemStack.get(com.omnigrid.neoforge.DataComponents.INSTANCE.getFilterData());
        if (filterData != null) {
            for (int i = 0; i < 9; ++i) {
                PlatformResourceKey key = filterData.get(i);
                if (key == null) continue;
                container.set(i, new ResourceAmount((ResourceKey)key, 1L));
            }
        }
        Platform.INSTANCE.getMenuOpener().openMenu(serverPlayer, (MenuProvider)new ResourceFilterExtendedMenu(container));
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (abstractContainerMenu instanceof AbstractResourceFilterContainerMenu) {
            AbstractResourceFilterContainerMenu menu = (AbstractResourceFilterContainerMenu)abstractContainerMenu;
            menu.setDisabledSlot(slotReference);
        }
    }
}

