/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.StorageProxy.OmniPortHandler;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniRootStorage;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.api.storage.root.RootStorageListener;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniProxxyStorage
implements RootStorage,
Storage {
    public final UUID id;
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniItemProxxy.class);
    public BlockPos thisPosition;
    public boolean doingJei = false;

    public OmniProxxyStorage(UUID uuid) {
        this.id = uuid;
    }

    @Nullable
    public OmniRootStorage resolveStorage() {
        OmniItemProxxy proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(this.id);
        if (proxy == null || proxy.stress > (float)proxy.getMaxStress()) {
            return null;
        }
        if (this.thisPosition != null && !proxy.utilityTypes.contains((Object)UtilityType.PROXY_ACCESSOR)) {
            Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
            int range = cfg.getProxyBaseRange() + cfg.getProxyExtraRangePerUpgrade() * proxy.getRange();
            if (proxy.taskCenterPosition == null || !OmniPortHandler.withinRange(this.thisPosition, proxy.taskCenterPosition, range)) {
                return null;
            }
        }
        return proxy.getOrCreateStorage();
    }

    @Nullable
    public OmniItemProxxy getProxxy() {
        OmniItemProxxy proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(this.id);
        if (proxy == null) {
            return null;
        }
        return proxy;
    }

    public long extract(ResourceKey resourceKey, long amount, Action action, Actor actor) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        long extracted = storage.extract(resourceKey, amount, action, actor);
        long remaining = amount - extracted;
        if (remaining > 0L && this.doingJei && resourceKey instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resourceKey;
            if (this.getProxxy() != null) {
                long crafted = this.getProxxy().tryForceCraft(itemResource.toItemStack().copyWithCount((int)remaining), action == Action.SIMULATE);
                return extracted + crafted;
            }
        }
        return extracted;
    }

    public long insert(ResourceKey resourceKey, long amount, Action action, Actor actor) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null || amount == 0L) {
            return 0L;
        }
        return storage.insert(resourceKey, amount, action, actor);
    }

    public Collection<ResourceAmount> getAll() {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return List.of();
        }
        return storage.getAll();
    }

    public long getStored() {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        return storage.getStored();
    }

    public long insert(ItemStack stack, int count, boolean simulate) {
        if (stack.isEmpty() || count <= 0) {
            return 0L;
        }
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        ItemStack copy = stack.copy();
        copy.setCount(count);
        ItemResource key = ItemResource.ofItemStack((ItemStack)copy);
        return storage.insert((ResourceKey)key, count, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
    }

    public long extract(ItemStack filter, int count, boolean simulate) {
        if (filter.isEmpty() || count <= 0) {
            return 0L;
        }
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        ItemResource key = ItemResource.ofItemStack((ItemStack)filter);
        return storage.extract((ResourceKey)key, count, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
    }

    public long extract(ItemResource key, int count, boolean simulate) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        return storage.extract((ResourceKey)key, count, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
    }

    public boolean has(ItemStack filter) {
        return this.getCount(filter) > 0L;
    }

    public long getCount(ItemStack filter) {
        if (filter.isEmpty()) {
            return 0L;
        }
        ItemResource key = ItemResource.ofItemStack((ItemStack)filter);
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        for (ResourceAmount entry : storage.getAll()) {
            if (!entry.resource().equals((Object)key)) continue;
            return entry.amount();
        }
        return 0L;
    }

    public long insert(FluidStack fluid, int amount, boolean simulate) {
        if (fluid.isEmpty() || amount <= 0) {
            return 0L;
        }
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        FluidResource key = new FluidResource(fluid.getFluid());
        return storage.insert((ResourceKey)key, amount, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
    }

    public long extract(FluidStack fluid, int amount, boolean simulate) {
        if (fluid.isEmpty() || amount <= 0) {
            return 0L;
        }
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        FluidResource key = new FluidResource(fluid.getFluid());
        return storage.extract((ResourceKey)key, amount, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
    }

    public boolean has(FluidStack fluid) {
        return this.getAmount(fluid) > 0L;
    }

    public long getAmount(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return 0L;
        }
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        FluidResource key = new FluidResource(fluid.getFluid());
        for (ResourceAmount res : storage.getAll()) {
            if (!res.resource().equals((Object)key)) continue;
            return res.amount();
        }
        return 0L;
    }

    public long insert(Fluid fluid, int amount, boolean simulate) {
        if (fluid == null || amount <= 0) {
            return 0L;
        }
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        FluidResource key = new FluidResource(fluid);
        return storage.insert((ResourceKey)key, amount, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
    }

    public long extract(Fluid fluid, int amount, boolean simulate) {
        if (fluid == null || amount <= 0) {
            return 0L;
        }
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        FluidResource key = new FluidResource(fluid);
        return storage.extract((ResourceKey)key, amount, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
    }

    public boolean has(Fluid fluid) {
        return this.getAmount(fluid) > 0L;
    }

    public long getAmount(Fluid fluid) {
        if (fluid == null) {
            return 0L;
        }
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        FluidResource key = new FluidResource(fluid);
        for (ResourceAmount r : storage.getAll()) {
            if (!r.resource().equals((Object)key)) continue;
            return r.amount();
        }
        return 0L;
    }

    public void addListener(RootStorageListener rootStorageListener) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return;
        }
        storage.addListener(rootStorageListener);
    }

    public void removeListener(RootStorageListener rootStorageListener) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return;
        }
        storage.removeListener(rootStorageListener);
    }

    public long get(ResourceKey resourceKey) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return 0L;
        }
        return storage.get(resourceKey);
    }

    public boolean contains(ResourceKey resourceKey) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return false;
        }
        return storage.contains(resourceKey);
    }

    public void sortSources() {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return;
        }
        storage.sortSources();
    }

    public void addSource(Storage source) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return;
        }
        storage.addSource(source);
    }

    public void removeSource(Storage source) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return;
        }
        storage.removeSource(source);
    }

    public boolean hasSource(Predicate<Storage> predicate) {
        OmniRootStorage storage = this.resolveStorage();
        if (storage == null) {
            return false;
        }
        return storage.hasSource(predicate);
    }

    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey key, Class<? extends Actor> actorType) {
        OmniRootStorage storage = this.getProxxy().getOrCreateStorage();
        if (storage == null) {
            return Optional.empty();
        }
        return storage.findTrackedResourceByActorType(key, actorType);
    }
}

