/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.google.common.primitives.Booleans;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.omnigrid.neoforge.OmniCommand;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public final class OmniPresetData {
    public final OmniCommand[] commands;
    public final boolean[] disabled;
    public static final Codec<OmniPresetData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)OmniCommand.COMMAND_CODEC.listOf().fieldOf("commands").forGetter(d -> List.of(d.commands)), (App)Codec.BOOL.listOf().fieldOf("disabled").forGetter(d -> Booleans.asList((boolean[])d.disabled))).apply((Applicative)inst, (cmds, dis) -> {
        OmniCommand[] c = cmds.toArray(new OmniCommand[0]);
        boolean[] d = new boolean[dis.size()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = (Boolean)dis.get(i);
        }
        return new OmniPresetData(c, d);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, OmniPresetData> STREAM_CODEC = StreamCodec.of(OmniPresetData::write, OmniPresetData::read);
    private transient int cachedHash;
    private transient boolean hashDirty = true;

    public OmniPresetData(OmniCommand[] commands, boolean[] disabled) {
        this.commands = commands;
        this.disabled = disabled;
    }

    private static void write(RegistryFriendlyByteBuf buf, OmniPresetData data) {
        buf.writeVarInt(data.commands.length);
        for (OmniCommand cmd : data.commands) {
            cmd.toNetwork(buf);
        }
        buf.writeVarInt(data.disabled.length);
        for (boolean b : data.disabled) {
            buf.writeBoolean(b);
        }
    }

    private static OmniPresetData read(RegistryFriendlyByteBuf buf) {
        int cmdCount = buf.readVarInt();
        OmniCommand[] cmds = new OmniCommand[cmdCount];
        for (int i = 0; i < cmdCount; ++i) {
            cmds[i] = OmniCommand.fromNetwork(buf);
        }
        int disCount = buf.readVarInt();
        boolean[] dis = new boolean[disCount];
        for (int i = 0; i < disCount; ++i) {
            dis[i] = buf.readBoolean();
        }
        return new OmniPresetData(cmds, dis);
    }

    public int hashCode() {
        if (!this.hashDirty) {
            return this.cachedHash;
        }
        int h = 1;
        for (OmniCommand cmd : this.commands) {
            h = 31 * h + (cmd == null ? 0 : cmd.hashCode());
        }
        for (boolean b : this.disabled) {
            h = 31 * h + (b ? 1 : 0);
        }
        this.cachedHash = h;
        this.hashDirty = false;
        return h;
    }

    public boolean equals(Object o) {
        int i;
        if (this == o) {
            return true;
        }
        if (!(o instanceof OmniPresetData)) {
            return false;
        }
        OmniPresetData other = (OmniPresetData)o;
        if (this.commands.length != other.commands.length) {
            return false;
        }
        if (this.disabled.length != other.disabled.length) {
            return false;
        }
        for (i = 0; i < this.commands.length; ++i) {
            if (Objects.equals(this.commands[i], other.commands[i])) continue;
            return false;
        }
        for (i = 0; i < this.disabled.length; ++i) {
            if (this.disabled[i] == other.disabled[i]) continue;
            return false;
        }
        return true;
    }
}

