/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.OverclockerUtils;
import com.omnigrid.neoforge.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class OmniOverclockerPlusItem
extends Item {
    public OmniOverclockerPlusItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        int cost = Platform.getConfig().getOmniGrid().overclockActivationCost();
        return OverclockerUtils.handleOverclockUse(player, level, player.getItemInHand(hand), false, cost);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        int cost = Platform.getConfig().getOmniGrid().overclockActivationCost();
        return OverclockerUtils.handleOverclockUseOn(ctx, false, cost);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"Not consumed on use").withStyle(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)Component.literal((String)"Greatly boosts processing speed for 1 minute").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)"Duration stacks with multiple activations").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)"Energy consumption greatly increased during boost").withStyle(ChatFormatting.GRAY));
        tooltip.add(CommonComponents.EMPTY);
        tooltip.add((Component)Component.literal((String)"Use while holding an Omni Grid in your offhand").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.literal((String)"Or shift-click a placed Omni Grid").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.literal((String)"Can be placed in an Omni Grids utility slot to make it constantly active").withStyle(ChatFormatting.GREEN));
    }
}

