/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.OverclockerUtils;
import com.omnigrid.neoforge.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class OmniOverclockerItem
extends Item {
    public OmniOverclockerItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        int cost = Platform.getConfig().getOmniGrid().overclockActivationCost();
        return OverclockerUtils.handleOverclockUse(player, level, player.getItemInHand(hand), true, cost);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        int cost = Platform.getConfig().getOmniGrid().overclockActivationCost();
        return OverclockerUtils.handleOverclockUseOn(ctx, true, cost);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"Overclocks an Omni Grid").withStyle(ChatFormatting.AQUA));
        tooltip.add((Component)Component.literal((String)"Greatly boosts processing speed for 1 minute. Duration stacks with multiple overclocks").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)"Energy consumption greatly increased during boost").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)"Consumed on use").withStyle(ChatFormatting.DARK_RED));
        tooltip.add(CommonComponents.EMPTY);
        tooltip.add((Component)Component.literal((String)"Use while holding an Omni Grid in your offhand").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.literal((String)"Or shift-click a placed Omni Grid").withStyle(ChatFormatting.YELLOW));
    }
}

