/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public final class OmniFilterData {
    public static final int SIZE = 9;
    public final PlatformResourceKey[] keys = new PlatformResourceKey[9];
    public static final StreamCodec<RegistryFriendlyByteBuf, OmniFilterData> STREAM_CODEC = StreamCodec.of((buf, grid) -> grid.toNetwork((RegistryFriendlyByteBuf)buf), OmniFilterData::fromNetwork);
    public static final Codec<OmniFilterData> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceCodecs.CODEC.optionalFieldOf("k0").forGetter(d -> Optional.ofNullable(d.keys[0])), (App)ResourceCodecs.CODEC.optionalFieldOf("k1").forGetter(d -> Optional.ofNullable(d.keys[1])), (App)ResourceCodecs.CODEC.optionalFieldOf("k2").forGetter(d -> Optional.ofNullable(d.keys[2])), (App)ResourceCodecs.CODEC.optionalFieldOf("k3").forGetter(d -> Optional.ofNullable(d.keys[3])), (App)ResourceCodecs.CODEC.optionalFieldOf("k4").forGetter(d -> Optional.ofNullable(d.keys[4])), (App)ResourceCodecs.CODEC.optionalFieldOf("k5").forGetter(d -> Optional.ofNullable(d.keys[5])), (App)ResourceCodecs.CODEC.optionalFieldOf("k6").forGetter(d -> Optional.ofNullable(d.keys[6])), (App)ResourceCodecs.CODEC.optionalFieldOf("k7").forGetter(d -> Optional.ofNullable(d.keys[7])), (App)ResourceCodecs.CODEC.optionalFieldOf("k8").forGetter(d -> Optional.ofNullable(d.keys[8]))).apply((Applicative)i, (k0, k1, k2, k3, k4, k5, k6, k7, k8) -> new OmniFilterData(k0.orElse(null), k1.orElse(null), k2.orElse(null), k3.orElse(null), k4.orElse(null), k5.orElse(null), k6.orElse(null), k7.orElse(null), k8.orElse(null))));

    public OmniFilterData() {
    }

    public OmniFilterData(@Nullable PlatformResourceKey k0, @Nullable PlatformResourceKey k1, @Nullable PlatformResourceKey k2, @Nullable PlatformResourceKey k3, @Nullable PlatformResourceKey k4, @Nullable PlatformResourceKey k5, @Nullable PlatformResourceKey k6, @Nullable PlatformResourceKey k7, @Nullable PlatformResourceKey k8) {
        this.keys[0] = k0;
        this.keys[1] = k1;
        this.keys[2] = k2;
        this.keys[3] = k3;
        this.keys[4] = k4;
        this.keys[5] = k5;
        this.keys[6] = k6;
        this.keys[7] = k7;
        this.keys[8] = k8;
    }

    public OmniFilterData(ResourceContainer container) {
        int i;
        int inSize = container.size();
        int max = Math.min(inSize, 9);
        for (i = 0; i < max; ++i) {
            ResourceAmount amount = container.get(i);
            this.keys[i] = amount != null ? (PlatformResourceKey)amount.resource() : null;
        }
        for (i = max; i < 9; ++i) {
            this.keys[i] = null;
        }
    }

    @Nullable
    public PlatformResourceKey get(int slot) {
        return this.keys[slot];
    }

    public void set(int slot, @Nullable PlatformResourceKey key) {
        this.keys[slot] = key;
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        for (int i = 0; i < 9; ++i) {
            PlatformResourceKey key = this.keys[i];
            buf.writeBoolean(key != null);
            if (key == null) continue;
            ResourceCodecs.STREAM_CODEC.encode((Object)buf, (Object)key);
        }
    }

    public static OmniFilterData fromNetwork(RegistryFriendlyByteBuf buf) {
        PlatformResourceKey[] arr = new PlatformResourceKey[9];
        for (int i = 0; i < 9; ++i) {
            arr[i] = buf.readBoolean() ? (PlatformResourceKey)ResourceCodecs.STREAM_CODEC.decode((Object)buf) : null;
        }
        return new OmniFilterData(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], arr[8]);
    }
}

