/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.OmniSelfNetwork;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class OmniExporterStrategy
implements ExporterTransferStrategy {
    private final Map<Class<? extends ResourceKey>, ExporterTransferStrategy> strategies;
    private final ExporterTransferStrategy fastItemStrategy;
    private final ExporterTransferStrategy fastFluidStrategy;
    private final OmniSelfNetwork selfNetwork;

    public OmniExporterStrategy(Map<Class<? extends ResourceKey>, ExporterTransferStrategy> strategies, UUID uuid) {
        this.strategies = strategies;
        this.fastItemStrategy = Objects.requireNonNull(strategies.get(ItemResource.class));
        this.fastFluidStrategy = Objects.requireNonNull(strategies.get(FluidResource.class));
        this.selfNetwork = new OmniSelfNetwork(uuid);
    }

    public ExporterTransferStrategy.Result transfer(ResourceKey resource, Actor actor, Network network) {
        PlayerActor pushActor = new PlayerActor("Push");
        Class resourceClass = resource.getClass();
        if (resourceClass == ItemResource.class) {
            return this.fastItemStrategy.transfer(resource, (Actor)pushActor, (Network)this.selfNetwork);
        }
        if (resourceClass == FluidResource.class) {
            return this.fastFluidStrategy.transfer(resource, (Actor)pushActor, (Network)this.selfNetwork);
        }
        ExporterTransferStrategy strategy = this.strategies.get(resourceClass);
        return strategy == null ? ExporterTransferStrategy.Result.DESTINATION_DOES_NOT_ACCEPT : strategy.transfer(resource, (Actor)pushActor, (Network)this.selfNetwork);
    }
}

