/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.ResourcePrinter;
import com.omnigrid.neoforge.OmniRootStorage;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeStorageImpl;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniCompositeStorage
extends CompositeStorageImpl {
    public static final Logger LOGGER = LoggerFactory.getLogger(OmniCompositeStorage.class);
    public OmniRootStorage rootStorage;

    public OmniCompositeStorage(MutableResourceList list, OmniRootStorage storage) {
        super(list);
        this.rootStorage = storage;
    }

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        long extracted = super.extract(resource, amount, action, actor);
        if (extracted > 0L && action == Action.EXECUTE) {
            for (Storage source : this.getSources()) {
                ResourcePrinter printer;
                if (!(source instanceof ResourcePrinter) || !Objects.equals((printer = (ResourcePrinter)source).getPrintedResource(), resource)) continue;
                long cost = (long)printer.getDrainForExtraction(extracted);
                this.rootStorage.addPrinterDrain(cost);
                break;
            }
        }
        return extracted;
    }
}

