/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.google.common.collect.Iterators;
import com.omnigrid.neoforge.OmniGridResourceHandler;
import com.omnigrid.neoforge.OmniGridTask;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniCompositePositionedExternalStorage
implements ExternalStorageProvider {
    private final List<ExternalStorageProvider> providers;
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniCompositePositionedExternalStorage.class);
    private Supplier<BlockPos> supplier;
    private BlockPos blockPos;
    private int range;
    private OmniGridTask task;

    public OmniCompositePositionedExternalStorage(List<ExternalStorageProvider> providers, BlockPos blockPos, Supplier<BlockPos> supplier, int range, OmniGridTask task) {
        this.providers = providers;
        this.supplier = supplier;
        this.blockPos = blockPos;
        this.range = range;
        this.task = task;
    }

    public Iterator<ResourceAmount> iterator() {
        if (!this.isInRange()) {
            return Collections.emptyIterator();
        }
        List<Iterator> filtered = this.providers.stream().map(provider -> Iterators.filter((Iterator)provider.iterator(), ra -> ra != null && OmniGridResourceHandler.matchesTask(ra.resource(), this.task))).toList();
        return Iterators.concat(filtered.iterator());
    }

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!this.isInRange() || !OmniGridResourceHandler.matchesTask(resource, this.task)) {
            return 0L;
        }
        for (ExternalStorageProvider provider : this.providers) {
            long extracted = provider.extract(resource, amount, action, actor);
            if (extracted <= 0L) continue;
            return extracted;
        }
        return 0L;
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!this.isInRange() || this.task.any || !OmniGridResourceHandler.matchesTask(resource, this.task)) {
            return 0L;
        }
        for (ExternalStorageProvider provider : this.providers) {
            long inserted = provider.insert(resource, amount, action, actor);
            if (inserted <= 0L) continue;
            return inserted;
        }
        return 0L;
    }

    private boolean isInRange() {
        if (this.supplier == null) {
            return false;
        }
        BlockPos pos = this.supplier.get();
        if (pos == null) {
            return false;
        }
        return pos.distManhattan((Vec3i)this.blockPos) <= this.range;
    }
}

