/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.neoforge.OmniGridBlockItem;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class OmniBackupKey
extends Item {
    public OmniBackupKey() {
        super(new Item.Properties());
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        MutableComponent text = stack.has(DataComponents.INSTANCE.getStorageReference()) ? Component.literal((String)"Right-click with an Omni Grid in your off-hand to load the back up") : Component.literal((String)"Right-click with an Omni Grid in your off-hand to backup its storage reference");
        return Optional.of(new HelpTooltipComponent((Component)text));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack offhand = player.getOffhandItem();
        if (offhand.getItem() instanceof OmniGridBlockItem && offhand.has(DataComponents.INSTANCE.getStorageReference())) {
            UUID data = (UUID)offhand.get(DataComponents.INSTANCE.getStorageReference());
            if (stack.has(DataComponents.INSTANCE.getStorageReference())) {
                UUID backup = (UUID)stack.get(DataComponents.INSTANCE.getStorageReference());
                if (backup == data) {
                    return InteractionResultHolder.success((Object)stack);
                }
                if (!player.level().isClientSide()) {
                    this.transferData(offhand, stack, player);
                    player.displayClientMessage((Component)Component.literal((String)"Data transferred!").withStyle(ChatFormatting.GREEN), true);
                    player.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    return InteractionResultHolder.consume((Object)stack);
                }
            } else {
                player.displayClientMessage((Component)Component.literal((String)"Backup Created!").withStyle(ChatFormatting.GREEN), true);
                stack.set(DataComponents.INSTANCE.getStorageReference(), (Object)((UUID)offhand.get(DataComponents.INSTANCE.getStorageReference())));
                stack.set(net.minecraft.core.component.DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public ItemStack transferData(ItemStack grid, ItemStack card, Player player) {
        DataComponents rsData = DataComponents.INSTANCE;
        if (!card.has(rsData.getStorageReference())) {
            return grid;
        }
        ItemStack virtualDisk = new ItemStack((ItemLike)Items.INSTANCE.getItemStorageDisk(ItemStorageVariant.ONE_K));
        Level level = player.level();
        StorageRepository repo = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        SerializableStorage optStorage = (SerializableStorage)repo.get((UUID)card.get(rsData.getStorageReference())).get();
        virtualDisk.inventoryTick(level, (Entity)player, 0, false);
        UUID newRef = (UUID)virtualDisk.get(rsData.getStorageReference());
        repo.get(newRef);
        ResourceKey virtual = ((ResourceAmount)optStorage.getAll().toArray()[0]).resource();
        optStorage.extract(virtual, 1L, Action.EXECUTE, Actor.EMPTY);
        Optional rep = repo.get(newRef);
        ((SerializableStorage)rep.get()).insert(virtual, 1L, Action.EXECUTE, Actor.EMPTY);
        grid.set(rsData.getStorageReference(), (Object)newRef);
        card.set(rsData.getStorageReference(), (Object)newRef);
        return grid;
    }
}

