/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniFurnaceSlot;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedPattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergedPattern.class);
    private final List<ItemStack> inputs = new ArrayList<ItemStack>();
    private final List<ItemStack> leftovers = new ArrayList<ItemStack>();
    private ItemStack output = ItemStack.EMPTY;
    private boolean valid = false;
    private String label = "";
    public PatternType type;
    @javax.annotation.Nullable
    public OmniBlockTarget processingPoint;
    public List<ResourceAmount> processingInputs = new ArrayList<ResourceAmount>();
    public List<ResourceAmount> processingOutputs = new ArrayList<ResourceAmount>();

    public MergedPattern(ItemStack patternStack, Level level, @Nullable OmniBlockTarget processingPoint) {
        this.processingPoint = processingPoint;
        Item item = patternStack.getItem();
        if (!(item instanceof PatternItem)) {
            this.type = PatternType.CRAFTING;
            return;
        }
        PatternItem patternItem = (PatternItem)item;
        Optional opt = patternItem.getPattern(patternStack, level);
        if (opt.isEmpty()) {
            this.type = PatternType.CRAFTING;
            return;
        }
        Pattern pattern = (Pattern)opt.get();
        PatternState state = (PatternState)patternStack.get(DataComponents.INSTANCE.getPatternState());
        this.type = state != null && state.type() != null ? state.type() : PatternType.CRAFTING;
        switch (this.type) {
            case CRAFTING: {
                this.handleCraftingPattern(pattern, level);
                break;
            }
            case STONECUTTER: {
                this.handleStonecutterPattern(pattern);
                break;
            }
            case PROCESSING: {
                this.handleProcessingPattern(patternStack, pattern, level);
                break;
            }
            default: {
                this.handleCraftingPattern(pattern, level);
            }
        }
        if (!this.processingInputs.isEmpty() && !this.processingOutputs.isEmpty()) {
            this.valid = true;
            this.label = "Processing";
        } else {
            this.label = this.output.isEmpty() ? "invalid" : this.output.getHoverName().getString();
            this.valid = !this.inputs.isEmpty() && !this.output.isEmpty();
        }
    }

    private void handleCraftingPattern(Pattern pattern, Level level) {
        pattern.layout().ingredients().forEach(ing -> {
            if (ing.inputs().isEmpty()) {
                return;
            }
            ResourceKey inputKey = (ResourceKey)ing.inputs().get(0);
            if (inputKey instanceof ItemResource) {
                ItemResource res = (ItemResource)inputKey;
                ItemStack stack = res.toItemStack();
                stack.setCount((int)ing.amount());
                this.inputs.add(stack);
            }
        });
        for (ResourceAmount outAmt : pattern.layout().outputs()) {
            ResourceKey resourceKey = outAmt.resource();
            if (!(resourceKey instanceof ItemResource)) continue;
            ItemResource res = (ItemResource)resourceKey;
            ItemStack stack = res.toItemStack();
            stack.setCount((int)outAmt.amount());
            this.output = stack;
            break;
        }
        if (!this.inputs.isEmpty() && !this.output.isEmpty()) {
            CraftingInput craftingInput = this.buildCraftingInput(level);
            Optional optRecipe = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingInput, level);
            optRecipe.ifPresent(recipe -> {
                NonNullList remain = ((CraftingRecipe)recipe.value()).getRemainingItems((RecipeInput)craftingInput);
                for (ItemStack stack : remain) {
                    if (stack.isEmpty()) continue;
                    this.leftovers.add(stack.copy());
                }
            });
        }
    }

    private void handleStonecutterPattern(Pattern pattern) {
        pattern.layout().ingredients().forEach(ing -> {
            if (ing.inputs().isEmpty()) {
                return;
            }
            ResourceKey inputKey = (ResourceKey)ing.inputs().get(0);
            if (inputKey instanceof ItemResource) {
                ItemResource res = (ItemResource)inputKey;
                ItemStack stack = res.toItemStack();
                stack.setCount((int)ing.amount());
                this.inputs.add(stack);
            }
        });
        for (ResourceAmount outAmt : pattern.layout().outputs()) {
            ResourceKey resourceKey = outAmt.resource();
            if (!(resourceKey instanceof ItemResource)) continue;
            ItemResource res = (ItemResource)resourceKey;
            ItemStack stack = res.toItemStack();
            stack.setCount((int)outAmt.amount());
            this.output = stack;
            break;
        }
    }

    private void handleProcessingPattern(ItemStack patternStack, Pattern pattern, Level level) {
        if (this.type == PatternType.PROCESSING) {
            if (patternStack.getItem() instanceof PatternItem && patternStack.has(DataComponents.INSTANCE.getProcessingPatternState()) && this.processingPoint != null) {
                List inputs = ((ProcessingPatternState)patternStack.get(DataComponents.INSTANCE.getProcessingPatternState())).ingredients();
                List outputs = ((ProcessingPatternState)patternStack.get(DataComponents.INSTANCE.getProcessingPatternState())).outputs();
                this.processingInputs = new ArrayList<ResourceAmount>();
                for (Optional ingredient : inputs) {
                    ingredient.ifPresent(proc -> this.processingInputs.add(proc.input()));
                }
                for (Optional output : outputs) {
                    output.ifPresent(proc -> this.processingOutputs.add((ResourceAmount)output.get()));
                }
            }
            if (this.processingPoint == null) {
                if (this.inputs.size() == 1 && !this.output.isEmpty()) {
                    ItemStack in = this.inputs.getFirst();
                    ItemStack validSmelt = OmniFurnaceSlot.getSmeltingResult(level, in).output();
                    if (validSmelt.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)validSmelt, (ItemStack)this.output)) {
                        this.type = PatternType.CRAFTING;
                    }
                } else {
                    this.type = PatternType.CRAFTING;
                }
            }
        }
    }

    private CraftingInput buildCraftingInput(Level level) {
        TransientCraftingContainer dummy = new TransientCraftingContainer(new AbstractContainerMenu(this, null, -1){

            public ItemStack quickMoveStack(Player p, int i) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player p) {
                return true;
            }
        }, 3, 3);
        for (int i = 0; i < Math.min(this.inputs.size(), 9); ++i) {
            dummy.setItem(i, this.inputs.get(i).copy());
        }
        return dummy.asCraftInput();
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public ItemStack getPrimaryOutput() {
        return this.output;
    }

    public List<ItemStack> getLeftovers() {
        return this.leftovers;
    }

    public boolean isValid() {
        return this.valid;
    }

    public PatternType getType() {
        return this.type;
    }

    public String toString() {
        return "SimplifiedPattern{inputs=" + String.valueOf(this.processingInputs) + ", output=" + String.valueOf(this.processingOutputs) + ", leftovers=" + String.valueOf(this.leftovers) + ", label='" + this.label + "', type=" + String.valueOf(this.type) + "}";
    }
}

